/* common-status.h
 *      Copyright (C) 2004, 2005 Timo Schulz
 *
 * This file is part of MyGPGME.
 *
 * MyGPGME is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MyGPGME is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */
#ifndef COMMON_STATUS_H
#define COMMON_STATUS_H 1

enum {
    GPG_NODATA_ARMOR        = 1,
    GPG_NODATA_EXPPKTNOTFND = 2,
    GPG_NODATA_INVPKT       = 3
};

enum {
    GPG_UNPEXTED = 1
};


gpgme_error_t _gpgme_nodata_status_handler (gpg_status_code_t code,
                                            const char * args, int * ret);
gpgme_error_t _gpgme_pass_status_handler (gpg_status_code_t code,
                                          const char * args,
                                          int * r_bad_pass, int * r_no_pass,
                                          char ** r_info);

gpgme_error_t _gpgme_sigtrust_status_handler (gpg_status_code_t code,
                                              const char * args,
                                              int * retval);

void _gpgme_genkey_status_handler (gpgme_ctx_t ctx, gpg_status_code_t code,
                                   char * args);

#endif /*COMMON_STATUS_H */
