//---------------------------------------------------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGeeVerifyDecrypt.cpp - Verification form code header
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------
#ifndef GPGeeVerifyDecryptH
#define GPGeeVerifyDecryptH
//---------------------------------------------------------------------------
#include "gpgme/gpgme.h"
#include "GPGeeUtility.h"
#include <Classes.hpp>
#include <Controls.hpp>
#include <StdCtrls.hpp>
#include <Forms.hpp>
#include <ComCtrls.hpp>
#include <ExtCtrls.hpp>
#include <ImgList.hpp>
//---------------------------------------------------------------------------
class TformGPGeeVerifyDecrypt : public TForm
{
__published:	// IDE-managed Components
  TPanel *pnlSplitView;
  TListView *lvFileList;
  TSplitter *Splitter;
  TButton *btnOkCancel;
  TButton *btnHelp;
  TImageList *StateImages;
  TTimer *StartTimer;
        TRichEdit *richResults;

  void __fastcall FormShow(TObject *Sender);
  void __fastcall FormResize(TObject *Sender);
  void __fastcall StartTimerTimer(TObject *Sender);
  void __fastcall lvFileListChange(TObject *Sender, TListItem *Item, TItemChange Change);
  void __fastcall btnOkCancelClick(TObject *Sender);
  void __fastcall btnHelpClick(TObject *Sender);

public:		// User declarations
  __fastcall TformGPGeeVerifyDecrypt(TComponent* Owner);
  __fastcall ~TformGPGeeVerifyDecrypt();

  int __fastcall ShowModalWithDefaults(TStringList *FileNames);
  const char * __fastcall GetPassphrase(const char *desc);

private:	// User declarations
  gpgme_ctx_t       ctxGPG;                           // GPGME context
  gpgme_keycache_t  cachePublic;                      // Public key cache
  gpgme_keycache_t  cacheSecret;                      // Secret key cache
  TStringList      *FileNames;
  TStringList      *PassphraseCache;
  int               nOpNumber;                        // ID number of the current operation - increments by one for each file processed
  AnsiString        sCurrentOpFileName;               // Full filename of each file as it is being worked on - used for the symmetrical-decryption passphrase dialog
  bool              bCancel;                          // Flag to tell that the user wants to cancel.

  void __fastcall Cleanup(void);
  void __fastcall VerifyDecryptFiles(void);
  int  __fastcall InterpretSignatures(gpgme_sig_t sig, AnsiString &ResultString, gpgme_error_t err = GPGME_No_Error);
  int  __fastcall InterpretSignatureResult(gpgme_sig_t sig, AnsiString &ResultString, gpgme_error_t err = GPGME_No_Error);

  // This is a structure used to hold the data for each file that will be worked on.
  // The "data" property of each TListItem points to one of these structures.
  typedef struct {
    AnsiString FileName;
    gpg_file_type FileType;
    AnsiString ResultString;
  } VerifyDecryptInfo_t;

};
//---------------------------------------------------------------------------
static const char * PassphraseCallback(void *hook, const char *desc, void *dummy);
//---------------------------------------------------------------------------
#define GPGEE_STATE_PENDING    0
#define GPGEE_STATE_INPROGRESS 1
#define GPGEE_STATE_SUCCESS    2
#define GPGEE_STATE_FAILURE    3
#define GPGEE_STATE_INVALID    4
#define GPGEE_STATE_PARTIAL    5
//---------------------------------------------------------------------------
extern PACKAGE TformGPGeeVerifyDecrypt *formGPGeeVerifyDecrypt;
//---------------------------------------------------------------------------
#endif
