//---------------------------------------------------------------------------
// GPGee - GNU Privacy Guard Explorer Extension
// GPGeeUtility.cpp - Miscelaneous utility functions header file
// Copyright 2005, Kurt Fitzner <kfitzner@excelcia.org>
//---------------------------------------------------------------------------
// This file is part of GPGee.
//
// GPGee is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License (Version 2) as
// published by the Free Software Foundation.
//
// GPGee is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
//---------------------------------------------------------------------------
#ifndef GPGeeUtilityH
#define GPGeeUtilityH
//---------------------------------------------------------------------------
#include "gpgme/gpgme.h"
//---------------------------------------------------------------------------
typedef enum { GPG_UNKNOWN, GPG_MESSAGE, GPG_SIGNATURE, GPG_CLEARSIGNED } gpg_file_type;
//---------------------------------------------------------------------------
AnsiString __fastcall MinimizeName(AnsiString FileName, TEdit *Edit);
AnsiString __fastcall MinimizeName(AnsiString FileName, TFont *Font, int Width);
gpg_file_type __fastcall IdentifyFile(AnsiString FileName);
TDateTime __fastcall GPGToDateTime(unsigned long GPGDate, bool LocalTime = true);
AnsiString __fastcall KeyTypeToString(gpgme_pk_cipher_t KeyType);
AnsiString __fastcall TrustToString(gpgme_validity_t Trust);
AnsiString __fastcall DigestToString(gpgme_md_t Digest);
AnsiString __fastcall GetMessage(int ident);
AnsiString FormMessage(int ident, ...);
gpgme_keycache_t __fastcall GetKeyCache(bool GetSecretKeys, bool Cleanup = false);
AnsiString GetLastErrorMessage(void);
void CheckVersion(void);
void CleanupPassphraseCache(TStringList *Cache);
void Upgrade(void);
//---------------------------------------------------------------------------
#define CleanupKeyCaches() GetKeyCache(false,true)
#define NOEXCEPT(a) try { a; } catch (...) { }
//---------------------------------------------------------------------------
// Message id numbers for the language modules
//---------------------------------------------------------------------------
#define MSG_MENU_VERIFYDECRYPT            100
#define MSG_MENU_CONFIGURE                101
#define MSG_MENU_SIGNENCRYPT              102
#define MSG_MENU_SIGN                     103
#define MSG_MENU_ENCRYPT                  104

#define MSG_GPGME_VALIDITY_UNKNOWN        200
#define MSG_GPGME_VALIDITY_UNDEFINED      201
#define MSG_GPGME_VALIDITY_NEVER          202
#define MSG_GPGME_VALIDITY_MARGINAL       203
#define MSG_GPGME_VALIDITY_FULL           204
#define MSG_GPGME_VALIDITY_ULTIMATE       205
#define MSG_GPGME_VALIDITY_ERROR          206

#define MSG_GPGME_TRUST_UNKNOWN           300
#define MSG_GPGME_TRUST_UNDEFINED         301
#define MSG_GPGME_TRUST_NEVER             302
#define MSG_GPGME_TRUST_MARGINAL          303
#define MSG_GPGME_TRUST_FUL               304
#define MSG_GPGME_TRUST_ULTIMATE          305
#define MSG_GPGME_TRUST_ERROR             306

#define MSG_GPGME_MD_UNKNOWN              310
#define MSG_GPGME_MD_MD5                  311
#define MSG_GPGME_MD_SHA1                 312
#define MSG_GPGME_MD_RMD160	          313
#define MSG_GPGME_MD_TIGER                316
#define MSG_GPGME_MD_SHA256               318
#define MSG_GPGME_MD_SHA384               319
#define MSG_GPGME_MD_SHA512               320

#define MSG_GPGEE_TYPE_SIGNATURE          330
#define MSG_GPGEE_TYPE_MESSAGE            331
#define MSG_GPGEE_TYPE_UNKNOWN            332

#define MSG_CAPTION_GPGEE_BUTTON_OK       400

#define MSG_ERROR_GPGME_LIB_INIT          1000
#define MSG_ERROR_GPGME_KEYCACHE_INIT_PUB 1001
#define MSG_ERROR_GPGME_KEYCACHE_INIT_SEC 1002
#define MSG_ERROR_GPGME_KEYCACHE_LOAD_PUB 1003
#define MSG_ERROR_GPGME_KEYCACHE_LOAD_SEC 1004

#define MSG_ERROR_GPGEE_FIND_SECRETKEY    1100
#define MSG_ERROR_GPGEE_SET_SIGNINGKEY    1101
#define MSG_ERROR_GPGEE_ADD_RECIPIENT     1102
#define MSG_ERROR_GPGEE_FAILED_OPERATION  1103
#define MSG_ERROR_GPGEE_KEYGROUPCREATE    1104
#define MSG_ERROR_GPGEE_KEYGROUPOPEN      1105
#define MSG_ERROR_GPGEE_KEYGROUPLOAD      1106
#define MSG_CONFIRM_GPGEE_KEYGROUPDELETE  1107

#define MSG_ERROR_GPGEE_IDENTIFY          1200
#define MSG_ERROR_GPGEE_CANCELED          1201
#define MSG_QUERY_GPGEE_OVERWRITE_MSG     1202
#define MSG_QUERY_GPGEE_OVERWRITE_CAPTION 1203
#define MSG_ERROR_GPGEE_FILE_EXISTS       1204
#define MSG_RESULT_GPGEE_DECRYPT_SUCCESS  1205
#define MSG_RESULT_GPGEE_NO_SECRET_KEY    1206
#define MSG_RESULT_GPGEE_BAD_ARMOR        1207
#define MSG_RESULT_GPGEE_BAD_MDC          1208
#define MSG_RESULT_GPGEE_NO_VERIFY_FILE   1209
#define MSG_RESULT_GPGEE_PREFIXGOOD       1210
#define MSG_RESULT_GPGEE_PREFIXEGOOD      1211
#define MSG_RESULT_GPGEE_PREFIXRGOOD      1212
#define MSG_RESULT_GPGEE_BODYNONE         1213
#define MSG_RESULT_GPGEE_BODYNOKEY        1214
#define MSG_RESULT_GPGEE_BODYNOSIG        1215
#define MSG_RESULT_GPGEE_BODYERROR        1216
#define MSG_RESULT_GPGEE_BODYBAD          1217
#define MSG_RESULT_GPGEE_BODYSTANDARD     1218
#define MSG_RESULT_GPGEE_POSTEXPIREDOK    1219
#define MSG_RESULT_GPGEE_POSTEXPIREDBAD   1220
#define MSG_RESULT_GPGEE_POSTEXPIREDUNK   1221
#define MSG_RESULT_GPGEE_POSTREVOKED      1222
#define MSG_RESULT_GPGEE_POSTDODGYTRUST   1223
#define MSG_QUERY_GPGEE_SYMPASSPHRASE     1224

#define MSG_QUERY_GPGEE_SYMENCRYPT        1300
//---------------------------------------------------------------------------
#endif
