/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;

public class DERGeneralizedTime
extends DERObject {
    String time;

    public static DERGeneralizedTime getInstance(Object obj) {
        if (obj == null || obj instanceof DERGeneralizedTime) {
            return (DERGeneralizedTime)obj;
        }
        if (obj instanceof ASN1OctetString) {
            return new DERGeneralizedTime(((ASN1OctetString)obj).getOctets());
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static DERGeneralizedTime getInstance(ASN1TaggedObject obj, boolean explicit) {
        return DERGeneralizedTime.getInstance(obj.getObject());
    }

    public String getTime() {
        if (this.time.length() == 15) {
            return this.time.substring(0, 14) + "GMT+00:00";
        }
        if (this.time.length() == 17) {
            return this.time.substring(0, 14) + "GMT" + this.time.substring(15, 17) + ':' + this.time.substring(17, 19);
        }
        return this.time;
    }

    private final byte[] getOctets() {
        char[] cs = this.time.toCharArray();
        byte[] bs = new byte[cs.length];
        int i = 0;
        while (i != cs.length) {
            bs[i] = (byte)cs[i];
            ++i;
        }
        return bs;
    }

    void encode(DEROutputStream out) throws IOException {
        out.writeEncoded(24, this.getOctets());
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof DERGeneralizedTime)) {
            return false;
        }
        return this.time.equals(((DERGeneralizedTime)o).time);
    }

    public DERGeneralizedTime(String time) {
        this.time = time;
    }

    public DERGeneralizedTime(Date time) {
        SimpleDateFormat dateF = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        dateF.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.time = dateF.format(time);
    }

    DERGeneralizedTime(byte[] bytes) {
        char[] dateC = new char[bytes.length];
        int i = 0;
        while (i != dateC.length) {
            dateC[i] = (char)(bytes[i] & 0xFF);
            ++i;
        }
        this.time = new String(dateC);
    }
}

