/*
 * Decompiled with CFR 0.152.
 */
package gnu.crypto.sig;

import gnu.crypto.hash.IMessageDigest;
import gnu.crypto.sig.ISignature;
import gnu.crypto.util.PRNG;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Map;

public abstract class BaseSignature
implements ISignature {
    public static final String VERIFIER_KEY = "gnu.crypto.sig.public.key";
    public static final String SIGNER_KEY = "gnu.crypto.sig.private.key";
    public static final String SOURCE_OF_RANDOMNESS = "gnu.crypto.sig.prng";
    protected String schemeName;
    protected IMessageDigest md;
    protected PublicKey publicKey;
    protected PrivateKey privateKey;
    private SecureRandom rnd;

    protected BaseSignature(String schemeName, IMessageDigest md) {
        this.schemeName = schemeName;
        this.md = md;
    }

    public String name() {
        return this.schemeName;
    }

    public void setupVerify(Map attributes) throws IllegalArgumentException {
        this.init();
        this.rnd = (SecureRandom)attributes.get(SOURCE_OF_RANDOMNESS);
        PublicKey key = (PublicKey)attributes.get(VERIFIER_KEY);
        if (key != null) {
            this.setupForVerification(key);
        }
    }

    public void setupSign(Map attributes) throws IllegalArgumentException {
        this.init();
        this.rnd = (SecureRandom)attributes.get(SOURCE_OF_RANDOMNESS);
        PrivateKey key = (PrivateKey)attributes.get(SIGNER_KEY);
        if (key != null) {
            this.setupForSigning(key);
        }
    }

    public void update(byte b) {
        if (this.md == null) {
            throw new IllegalStateException();
        }
        this.md.update(b);
    }

    public void update(byte[] b, int off, int len) {
        if (this.md == null) {
            throw new IllegalStateException();
        }
        this.md.update(b, off, len);
    }

    public Object sign() {
        if (this.md == null || this.privateKey == null) {
            throw new IllegalStateException();
        }
        return this.generateSignature();
    }

    public boolean verify(Object sig) {
        if (this.md == null || this.publicKey == null) {
            throw new IllegalStateException();
        }
        return this.verifySignature(sig);
    }

    public abstract Object clone();

    protected abstract void setupForVerification(PublicKey var1) throws IllegalArgumentException;

    protected abstract void setupForSigning(PrivateKey var1) throws IllegalArgumentException;

    protected abstract Object generateSignature() throws IllegalStateException;

    protected abstract boolean verifySignature(Object var1) throws IllegalStateException;

    protected void init() {
        this.md.reset();
        this.rnd = null;
        this.publicKey = null;
        this.privateKey = null;
    }

    protected void nextRandomBytes(byte[] buffer) {
        if (this.rnd != null) {
            this.rnd.nextBytes(buffer);
        } else {
            PRNG.nextBytes(buffer);
        }
    }
}

