/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet.gnu.crypto.sig.dss;

import gnu.crypto.sig.dss.DSSKeyPairGenerator;
import gnu.crypto.sig.dss.DSSKeyPairRawCodec;
import gnu.crypto.sig.dss.DSSPrivateKey;
import gnu.crypto.sig.dss.DSSPublicKey;
import gnu.crypto.sig.dss.DSSSignature;
import gnu.crypto.sig.dss.DSSSignatureRawCodec;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import java.lang.constant.Constable;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.util.HashMap;

public class TestOfDSSCodec
implements Testlet {
    private DSSKeyPairGenerator kpg = new DSSKeyPairGenerator();
    private KeyPair kp;

    public void test(TestHarness harness) {
        this.testKeyPairRawCodec(harness);
        this.testSignatureRawCodec(harness);
        this.testPublicKeyValueOf(harness);
        this.testPrivateKeyValueOf(harness);
    }

    public void testKeyPairRawCodec(TestHarness harness) {
        byte[] pk1;
        harness.checkPoint("TestOfDSSCodec.testKeyPairRawCodec");
        this.setUp();
        DSAPublicKey pubK = (DSAPublicKey)this.kp.getPublic();
        DSAPrivateKey secK = (DSAPrivateKey)this.kp.getPrivate();
        try {
            pk1 = ((DSSPublicKey)pubK).getEncoded(0);
            harness.fail("Succeeded with unknown format ID");
        }
        catch (IllegalArgumentException x) {
            harness.check(true, "Recognised unknown format ID");
        }
        pk1 = ((DSSPublicKey)pubK).getEncoded(1);
        byte[] pk2 = ((DSSPrivateKey)secK).getEncoded(1);
        DSSKeyPairRawCodec codec = new DSSKeyPairRawCodec();
        PublicKey newPubK = codec.decodePublicKey(pk1);
        PrivateKey newSecK = codec.decodePrivateKey(pk2);
        harness.check(pubK.equals(newPubK), "DSS public key Raw encoder/decoder test");
        harness.check(secK.equals(newSecK), "DSS private key Raw encoder/decoder test");
    }

    public void testSignatureRawCodec(TestHarness harness) {
        harness.checkPoint("TestOfDSSCodec.testSignatureRawCodec");
        this.setUp();
        DSAPublicKey publicK = (DSAPublicKey)this.kp.getPublic();
        DSAPrivateKey privateK = (DSAPrivateKey)this.kp.getPrivate();
        DSSSignature alice = new DSSSignature();
        DSSSignature bob = (DSSSignature)alice.clone();
        byte[] message = "1 if by land, 2 if by sea...".getBytes();
        HashMap<String, DSAKey> map = new HashMap<String, DSAKey>();
        map.put("gnu.crypto.sig.private.key", privateK);
        alice.setupSign(map);
        alice.update(message, 0, message.length);
        Object signature = alice.sign();
        DSSSignatureRawCodec codec = new DSSSignatureRawCodec();
        byte[] encodedSignature = codec.encodeSignature(signature);
        Object decodedSignature = codec.decodeSignature(encodedSignature);
        map.put("gnu.crypto.sig.public.key", publicK);
        bob.setupVerify(map);
        bob.update(message, 0, message.length);
        harness.check(bob.verify(decodedSignature), "Signature Raw encoder/decoder test");
    }

    public void testPublicKeyValueOf(TestHarness harness) {
        harness.checkPoint("TestOfDSSCodec.testPublicKeyValueOf");
        this.setUp();
        DSAPublicKey pubK = (DSAPublicKey)this.kp.getPublic();
        byte[] pk = ((DSSPublicKey)pubK).getEncoded(1);
        DSSPublicKey newPubK = DSSPublicKey.valueOf((byte[])pk);
        harness.check(pubK.equals(newPubK), "DSS public key valueOf(<raw-value>) test");
    }

    public void testPrivateKeyValueOf(TestHarness harness) {
        harness.checkPoint("TestOfDSSCodec.testPrivateKeyValueOf");
        this.setUp();
        DSAPrivateKey privateK = (DSAPrivateKey)this.kp.getPrivate();
        byte[] pk = ((DSSPrivateKey)privateK).getEncoded(1);
        DSSPrivateKey newSecK = DSSPrivateKey.valueOf((byte[])pk);
        harness.check(privateK.equals(newSecK), "DSS public key valueOf(<raw-value>) test");
    }

    private void setUp() {
        HashMap<String, Constable> map = new HashMap<String, Constable>();
        map.put("gnu.crypto.dss.L", new Integer(512));
        map.put("gnu.crypto.dss.use.defaults", new Boolean(false));
        this.kpg.setup(map);
        this.kp = this.kpg.generate();
    }
}

