/*
 * Decompiled with CFR 0.152.
 */
package gnu.testlet;

import gnu.testlet.ResourceNotFoundException;
import gnu.testlet.TestHarness;
import gnu.testlet.Testlet;
import gnu.testlet.config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Vector;

public class SimpleTestHarness
extends TestHarness
implements config {
    private int count = 0;
    private int failures = 0;
    private static Vector expected_xfails = new Vector();
    private int xfailures = 0;
    private int xpasses = 0;
    private int total = 0;
    private boolean verbose = false;
    private boolean debug = false;
    private boolean results_only = false;
    private String description;
    private String last_check;

    private final String getDescription(String pf) {
        return pf + ": " + this.description + (this.last_check == null ? "" : ": " + this.last_check) + " (number " + (this.count + 1) + ")";
    }

    public void check(boolean result) {
        if (!result) {
            String desc = this.getDescription("FAIL");
            if (!expected_xfails.contains(desc)) {
                System.out.println(desc);
                ++this.failures;
            } else if (this.verbose || this.results_only) {
                System.out.println("X" + desc);
                ++this.xfailures;
            }
        } else if (this.verbose || this.results_only) {
            if (expected_xfails.contains(this.getDescription("FAIL"))) {
                System.out.println(this.getDescription("XPASS"));
                ++this.xpasses;
            } else {
                System.out.println(this.getDescription("PASS"));
            }
        }
        ++this.count;
        ++this.total;
    }

    public String getSourceDirectory() {
        return "/data/workspace/cvs/gnu-crypto/source";
    }

    public String getTempDirectory() {
        return "classes";
    }

    public String getPathSeparator() {
        return ":";
    }

    public String getSeparator() {
        return "/";
    }

    public Reader getResourceReader(String name) throws ResourceNotFoundException {
        return new BufferedReader(new InputStreamReader(this.getResourceStream(name)));
    }

    public InputStream getResourceStream(String name) throws ResourceNotFoundException {
        if (File.separator.length() > 1) {
            throw new Error("File.separator length is greater than 1");
        }
        String realName = name.replace('#', File.separator.charAt(0));
        try {
            return new FileInputStream(this.getSourceDirectory() + File.separator + realName);
        }
        catch (FileNotFoundException ex) {
            throw new ResourceNotFoundException(ex.getLocalizedMessage() + ": " + this.getSourceDirectory() + File.separator + realName);
        }
    }

    public void checkPoint(String name) {
        this.last_check = name;
        this.count = 0;
    }

    public void verbose(String message) {
        if (this.verbose) {
            System.out.println(message);
        }
    }

    public void debug(String message) {
        this.debug(message, true);
    }

    public void debug(String message, boolean newline) {
        if (this.debug) {
            if (newline) {
                System.out.println(message);
            } else {
                System.out.print(message);
            }
        }
    }

    public void debug(Throwable ex) {
        if (this.debug) {
            ex.printStackTrace(System.out);
        }
    }

    public void debug(Object[] o, String desc) {
        this.debug("Dumping Object Array: " + desc);
        if (o == null) {
            this.debug("null");
            return;
        }
        int i = 0;
        while (i < o.length) {
            if (o[i] instanceof Object[]) {
                this.debug((Object[])o[i], desc + " element " + i);
            } else {
                this.debug("  Element " + i + ": " + o[i]);
            }
            ++i;
        }
    }

    protected void runtest(String name) {
        block7: {
            String d;
            System.gc();
            System.runFinalization();
            this.checkPoint(null);
            Testlet t = null;
            try {
                Class<?> k = Class.forName(name);
                Object o = k.newInstance();
                if (!(o instanceof Testlet)) {
                    return;
                }
                t = (Testlet)o;
            }
            catch (Throwable ex) {
                d = "FAIL: uncaught exception loading " + name;
                if (this.verbose) {
                    d = d + ": " + ex.toString();
                }
                System.out.println(d);
                this.debug(ex);
                ++this.failures;
                ++this.total;
            }
            if (t == null) break block7;
            this.description = name;
            try {
                t.test(this);
            }
            catch (Throwable ex) {
                d = "FAIL: " + this.description + ": uncaught exception at " + (this.last_check == null ? "" : "\"" + this.last_check + "\"") + " number " + (this.count + 1);
                if (this.verbose) {
                    d = d + ": " + ex.toString();
                }
                System.out.println(d);
                this.debug(ex);
                ++this.failures;
                ++this.total;
            }
        }
    }

    protected int done() {
        if (!this.results_only) {
            System.out.println(this.failures + " of " + this.total + " tests failed");
            if (this.xpasses > 0) {
                System.out.println(this.xpasses + " of " + this.total + " tests unexpectedly passed");
            }
            if (this.xfailures > 0) {
                System.out.println(this.xfailures + " of " + this.total + " tests expectedly failed");
            }
        }
        return this.failures > 0 ? 1 : 0;
    }

    protected SimpleTestHarness(boolean verbose, boolean debug) {
        this(verbose, debug, false);
    }

    /*
     * WARNING - void declaration
     */
    protected SimpleTestHarness(boolean verbose, boolean debug, boolean results_only) {
        this.verbose = verbose;
        this.debug = debug;
        this.results_only = results_only;
        try {
            String str;
            BufferedReader xfile = new BufferedReader(new FileReader("xfails"));
            while ((str = xfile.readLine()) != null) {
                void var5_6;
                expected_xfails.addElement(var5_6);
            }
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException ex) {}
    }

    public static void main(String[] args) {
        boolean verbose = false;
        boolean debug = false;
        boolean results_only = false;
        String file = null;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-verbose")) {
                verbose = true;
            } else if (args[i].equals("-debug")) {
                debug = true;
            } else if (args[i].equals("-resultsonly")) {
                results_only = true;
                verbose = false;
                debug = false;
            } else {
                if (!args[i].equalsIgnoreCase("-file")) break;
                try {
                    file = args[++i];
                }
                catch (Exception x) {
                    throw new RuntimeException("Missing file path after '-file'. Exit");
                }
            }
            ++i;
        }
        SimpleTestHarness harness = new SimpleTestHarness(verbose, debug, results_only);
        BufferedReader r = null;
        if (file != null) {
            try {
                r = new BufferedReader(new FileReader(file));
            }
            catch (FileNotFoundException x) {
                throw new RuntimeException("Unable to find \"" + file + "\". Exit");
            }
        } else {
            r = new BufferedReader(new InputStreamReader(System.in));
        }
        while (true) {
            String cname = null;
            try {
                cname = r.readLine();
                if (cname == null) break;
                if (verbose) {
                    System.out.println(cname);
                }
            }
            catch (IOException x) {
                // empty catch block
            }
            if (verbose) {
                System.out.println("----");
            }
            harness.runtest(cname);
        }
        System.exit(harness.done());
    }
}

