/*
 * gaia - opensource 3D interface to the planet
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "gefetch_internal.h"

/**
 * Internal function to decrypt data received from Google
 *
 * Decrypts file stored in handle->currentdata with key from
 * handle->dbrootdata.
 */
gefetch_error gefetch_decipher_current_file(gefetch *handle) {
	unsigned int i, j;
	unsigned int keystart = 16;
	unsigned int keylen = 0x3f8;

	/* check if dbroot holds whole key */
	if (handle->dbrootsize < keylen + 8)
		return GEFETCH_CORRUPT_DATA;

	/* decipher */
	for (i = 0, j = 16; i < handle->currentsize; i++) {
		handle->currentdata[i] ^= handle->dbrootdata[j + 8];
		j++;
		if (j % 8 == 0)
			j += 16;
		if (j >= keylen) {
			keystart = (keystart + 8) % 24;
			j = keystart;
		}
	}

	return GEFETCH_OK;
}
