unit NewDisk;

{
  Inno Setup
  Copyright (C) 1998-99 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  New Disk form
}

interface

uses
  WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, SysUtils, Dialogs,
  SelDir;

type
  TNewDiskForm = class(TForm)
    DiskPaintBox: TPaintBox;
    SelectDiskLabel: TLabel;
    PathLabel: TLabel;
    PathEdit: TEdit;
    BrowseButton: TButton;
    CancelButton: TButton;
    OKButton: TButton;
    procedure DiskPaintBoxPaint(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BrowseButtonClick(Sender: TObject);
  private
    { Private declarations }
    Filename: string;
    DiskImage: TBitmap;
  public
    { Public declarations }
    constructor Create (AOwner: TComponent); override;
    destructor Destroy; override;
  end;

function SelectDisk (const DiskNumber: Integer; const AFilename: String; var Path: String): Boolean;

implementation

uses
  Msgs, MsgIDs, CmnFunc, CmnFunc2,
  Main;

{$R *.DFM}

const
  idDirectories: array[Boolean] of TSetupMessageID =
    (msgDirectoryOld, msgDirectoryNew);

function SelectDisk (const DiskNumber: Integer; const AFilename: String;
  var Path: String): Boolean;
begin
  with TNewDiskForm.Create(Application) do
    try
      Filename := AFilename;
      SelectDiskLabel.Caption := FmtSetupMessage(msgSelectDiskLabel, [IntToStr(DiskNumber),
        SetupMessages[idDirectories[NewGUI]]]);
      PathEdit.Text := Path;
      MessageBeep (0);
      Result := ShowModal = mrOK;
      if Result then
        Path := ExtractFilePath(ExpandFilename(AddBackslash(PathEdit.Text) + Filename));
    finally
      Free;
    end;
end;


{ TNewDiskForm }

constructor TNewDiskForm.Create (AOwner: TComponent);
var
  OldTextHeight, NewTextHeight: Integer;
begin
  inherited;

  SetFormFont (Self, OldTextHeight, NewTextHeight);

  Caption := SetupMessages[msgChangeDiskTitle];
  PathLabel.Caption := SetupMessages[msgPathLabel];
  BrowseButton.Caption := SetupMessages[msgButtonBrowse];
  OKButton.Caption := SetupMessages[msgButtonOK];
  CancelButton.Caption := SetupMessages[msgButtonCancel];

  DiskImage := TBitmap.Create;
  DiskImage.Handle := LoadBitmap(HInstance, 'DISKIMAGE');  {don't localize}
end;

destructor TNewDiskForm.Destroy;
begin
  inherited;
  DiskImage.Free;
end;

procedure TNewDiskForm.DiskPaintBoxPaint(Sender: TObject);
begin
  with DiskPaintBox, Canvas do
    BrushCopy (ClientRect, DiskImage, ClientRect, clBlue);
end;

procedure TNewDiskForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  FN: String;
begin
  case ModalResult of
    mrOK: begin
        FN := ExpandFilename(AddBackslash(Trim(PathEdit.Text)) + Filename);
        if not FileExists(FN) then begin
          CanClose := False;
          MsgBox (FmtSetupMessage(msgFileNotInDir, [Filename,
              RemoveBackslashUnlessRoot(ExtractFilePath(FN)),
              SetupMessages[idDirectories[NewGUI]]]),
            '', mbError, MB_OK);
        end;
      end;
    mrCancel: CanClose := ExitSetupMsgBox;
  end;
end;

procedure TNewDiskForm.BrowseButtonClick(Sender: TObject);
var
  Dir: String;
begin
  Dir := Trim(PathEdit.Text);
  if SelectDir(Dir, Handle) then
    PathEdit.Text := Dir;
end;

end.
