unit CompMsgs;

{
  Inno Setup
  Copyright (C) 1998-2000 Jordan Russell
  For conditions of distribution and use, see LICENSE.TXT.

  Compiler Messages

  $Id: CompMsgs.pas,v 1.2 2000/12/28 01:22:44 jr Exp $

  All language-specific text used by the compiler is in here. If you want to
  translate it into another language, all you need to change is this unit.
}

interface

const
  SNewLine = #13#10;  { line break }
  SNewLine2 = #13#10#13#10;  { double line break }

  { Compiler form labels }
  SCompilerFormCaption = 'Inno Setup Compiler';
  SCompilerScriptFileLabel = 'Script &File:';
  SCompilerStatusLabel = 'Status &Messages:';
  SCompilerScriptBrowseButton = '&Browse...';
  SCompilerStartButton = '&Start';
  SCompilerExitButton = 'E&xit';
  SCompilerOpenFilter = 'Inno Setup Scripts (*.iss)|*.iss|All Files|*.*';

  { Compiler-specific messages }
  SCompilerVersion = 'version %s';

  SCompilerNotOnWin32s = 'The 32-bit compiler will not run on Win32s.';
  SCompilerCommandLineHelp2 = 'Command line usage:' + SNewLine +
    SNewLine +
    'compil32 /cc <script file>' + SNewLine +
    SNewLine +
    'Examples:' + SNewLine +
    'compil32 /cc c:\isetup\sample32\sample1.iss' + SNewLine +
    'compil32 /cc "C:\Inno Setup\Sample32\My script.iss"';

  { Status messages }
  SCompilerStatusStarting = '*** Starting compile.';
  SCompilerStatusDeletingPrevious = 'Deleting %s from output directory';
  SCompilerStatusReadSectionLine = 'Reading [%s] section, line %d';
  SCompilerStatusFilesVerInfo = '   Reading version info: %s';
  SCompilerStatusFilesCompressing = '   Compressing: %s';
  SCompilerStatusReadingFile = 'Reading file (%s)';
  SCompilerStatusReadingMessages = 'Reading [Messages] section';
  SCompilerStatusReadingInFile = '   File: %s';
  SCompilerStatusReadingInScriptMsgs = '   Messages in script file';
  SCompilerStatusCreateSetupFiles = 'Creating setup files';
  SCompilerStatusCreatingDisk = '   Creating disk %d';
  SCompilerStatusFinished = '*** Finished.';
  SCompilerStatusError = 'ERROR:';
  SCompilerStatusErrorAborted = '*** Compile aborted.';
  SCompilerStatusReset = '*** Log size limit reached, list reset.';
  SCompilerStatusWarning = 'Warning: ';

  SCompilerSuccessfulMessage2 = 'The setup images were successfully created ' +
    'in the output directory:' + SNewLine +
    '%s' + SNewLine +
    SNewLine +
    'Would you like to test the installation now?';
  SCompilerSuccessfulTitle = 'Compile Successful';
  SCompilerExecuteSetupError = 'Error executing SETUP.EXE in output directory';

  SCompilerAborted = 'Compile aborted. Please correct the problem and try again.';

  { Fatal errors }
  SCompilerScriptMissing2 = 'Specified script file does not exist';
  SCompilerOutputNotEmpty2 = 'Output directory must be empty prior to ' +
    'compilation of any non-Setup files. Files named SETUP.* are ' +
    'automatically deleted at the start of compilation.';
  SCompilerSourceFileDoesntExist = 'Source file "%s" does not exist';
  SCompilerCopyError2 = 'Could not copy "%s" to "%s"';
  SCompilerCompressError2 = 'An internal error occurred while trying to compress "%s"';
  SCompilerNotEnoughSpaceOnFirstDisk = 'There is not enough space on the first disk to copy all of the required files';
  SCompilerSetup0Mismatch = 'Internal error SC1';

  { [Setup] }
  SCompilerUnknownDirective = 'Unrecognized [%s] section directive "%s"';
  SCompilerBitsNot16or32_2 = '[Setup] section directive "Bits" must be either 16 or 32';
  SCompilerNeedToUse16 = 'You need to use the 16-bit compiler to compile a 16-bit installation';
  SCompilerEntryObsolete = 'The [%s] section directive "%s" is obsolete and ignored in this version of Inno Setup.';
  SCompilerEntrySuperseded2 = 'The [%s] section directive "%s" has been superseded by "%s" in this version of Inno Setup.';
  SCompilerEntryMissing2 = 'Required [%s] section directive "%s" not specified';
  SCompilerEntryInvalid2 = 'Value of [%s] section directive "%s" is invalid';
  SCompilerEntryTooLong = 'Value of [%s] section directive "%s" cannot be more than %d characters';
  SCompilerEntryAlreadySpecified = '[%s] section directive "%s" already specified';
  SCompilerMinVersionWinTooLow = 'Minimum Windows version specified by MinVersion must be at least %s';
  SCompilerMinVersionNTTooLow = 'Minimum NT version specified by MinVersion must be at least %s';
  SCompilerBadCharInDefaultDirName32 = 'DefaultDirName cannot include ' +
    'any of these characters:' + SNewLine +
    SNewLine +
    ', ( ) [ ]' + SNewLine +
    SNewLine +
    'unless support for Windows NT 3.x is disabled by using the ' +
    'MinVersion [Setup] section option, i.e. "MinVersion=4,4"';
  SCompilerDiskSpaceTooSmall = 'DiskSize must be at least %d';
  SCompilerDiskClusterSizeInvalid = 'DiskClusterSize must be between 1 and 32768';

  { External file parsing }
  SCompilerFileTooBig = 'Text file cannot be larger than 32000 bytes';

  { Line parsing }
  SCompilerError = 'Line %d:' + SNewLine +
    SNewLine +
    '%s';
  SCompilerLineTooLong = 'Line too long';
  SCompilerSectionTagInvalid = 'Invalid section tag';
  SCompilerSectionBadEndTag = 'Not inside "%s" section, but an end tag for ' +
    'it was encountered';

  { Constant checks }
  SCompilerTwoBraces = 'Use two consecutive "{" characters if you are trying ' +
    'to embed a single "{" and not a constant';
  SCompilerUnknownConst = 'Unknown constant "%s".' +
    SNewLine + SNewLine + SCompilerTwoBraces;
  SCompilerUnterminatedConst = 'A "}" is missing at the end of the constant "%s".' +
    SNewLine + SNewLine + SCompilerTwoBraces;
  SCompilerConstCannotUse = 'The constant "%s" cannot be used here';
  SCompilerConstUsed =
    'The constant "%s" is used.';
  SCompilerMinVersionError =
    'This is not permitted unless the minimum Windows and Windows NT ' +
    'versions for the installation are at least %s and %s respectively. This ' +
    'can be set by adding a "MinVersion=%s,%s" setting to the [Setup] ' +
    'section of the script';
  SCompilerMinVersionErrorParam =
    'This is not permitted unless the minimum Windows and Windows NT ' +
    'versions for the entry are at least %s and %s respectively. This can ' +
    'be set by adding a "MinVersion: %s,%s" parameter to it. Alternatively, ' +
    'you can set the minimum versions globally by adding a "MinVersion=%s,%s" ' +
    'setting to the [Setup] section of the script';
  SCompilerBadRegConst = 'Invalid registry constant "%s"';
  SCompilerBadIniConst = 'Invalid INI constant "%s"';

  { Parameter parsing }
  SCompilerParamHasNoValue = 'Specified parameter "%s" has no value';
  SCompilerParamQuoteError = 'Mismatched or misplaced quotes on parameter "%s"';
  SCompilerParamMissingClosingQuote = 'Missing closing quote on parameter "%s"';
  SCompilerParamDataTooLong = 'Data on parameter "%s" is too long';
  SCompilerParamUnknownParam = 'Unrecognized parameter name "%s"';
  SCompilerParamDuplicated = 'Cannot have multiple "%s" parameters';
  SCompilerParamEmpty2 = 'Parameter "%s" is empty';
  SCompilerParamNotSpecified = 'Required parameter "%s" not specified';
  SCompilerParamNoQuotes2 = 'Parameter "%s" cannot include quotes (")';
  SCompilerParamNoBackslash = 'Parameter "%s" cannot include backslashes (\)';
  SCompilerParamNoPrecedingBackslash = 'Parameter "%s" cannot begin with a backslash (\)';
  SCompilerParamInvalid2 = 'Parameter "%s" is not a valid value';
  SCompilerParamIncludesQuotes = 'Parameter "%s" includes a quote character (").';

  { Flags }
  SCompilerParamUnknownFlag2 = 'Parameter "%s" includes an unknown flag';
  SCompilerParamErrorComboUsed = 'Parameter "%s" has both the "%s" and "%s" flags.';
  SCompilerParamErrorBadCombo2 = 'Parameter "%s" cannot have both the "%s" and "%s" flags';

  { [Messages] }
  SCompilerMessagesMissingEquals = 'Missing "=" separator between message name and text';
  SCompilerMessagesNotRecognized = 'Message name "%s" not recognized by this version of Inno Setup';
  SCompilerMessagesMissingMessage = 'A message named "%s" has not been defined. It is required by this version of Inno Setup';

  { [Files] }
  SCompilerFilesTmpBadFlag = 'Parameter "Flags" cannot have the "%s" flag on ' +
    'a file copied to the {tmp} directory, or when the "deleteafterinstall" ' +
    'flag is used';
  SCompilerFilesWildcardNotMatched = 'No files found matching "%s"';
  SCompilerFilesDestNameCantBeSpecified = 'Parameter "DestName" cannot be specified if ' +
    'the "Source" parameter contains wildcards';
  SCompilerFilesSourceCantHaveWildcards = 'Parameter "Source" can''t include wildcards when ' +
    'the flag "external" is used';
  SCompilerFilesSourcePathNotSpecified = 'Parameter "Source" must include a path for the filename when ' +
    'the flag "external" is used';

  { [Icons] }
  SCompilerIconsIconNamePathNotSpecified = 'Parameter "IconName" must include a path for the icon, ' +
    'for example, "{group}\My Icon"';
  SCompilerIconsIconNameNoFolderConsts = 'Parameter "IconName" must begin with "{group}\" and cannot ' +
    'include any further occurances of these characters:' + SNewLine +
    SNewLine +
    '\ { }' + SNewLine +
    SNewLine +
    'unless support for Windows NT 3.x is disabled by using the MinVersion [Setup] ' +
    'section directive, i.e. "MinVersion=4,4"';
  SCompilerIconsParametersBadChar = 'Parameter "Parameters" cannot include ' +
    'any of these characters:' + SNewLine +
    SNewLine +
    ', ( ) [ ]' + SNewLine +
    SNewLine +
    'unless support for Windows NT 3.x is disabled by using the MinVersion [Setup] ' +
    'section directive, i.e. "MinVersion=4,4"';
  SCompilerIconsIconIndexInvalid = 'Parameter "IconIndex" is not a valid integer';

  { [Run] }
  SCompilerRunCantUseRunOnceId = 'Parameter "RunOnceId" can only be used in ' +
    'an [UninstallRun] section';

implementation

end.
