/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Array;
import gnu.lists.Consumer;
import gnu.lists.Convert;
import gnu.lists.GeneralArray;
import gnu.lists.Sequence;
import java.util.Collection;
import java.util.Iterator;

public abstract class SimpleVector
extends AbstractSequence
implements Sequence,
Array {
    public int size;

    public final int size() {
        return this.size;
    }

    public void setSize(int n) {
        int n2 = this.size;
        this.size = n;
        if (n < n2) {
            this.clearBuffer(n, n2 - n);
        } else {
            int n3 = this.getBufferLength();
            if (n > n3) {
                int n4 = n3 < 16 ? 16 : 2 * n3;
                this.setBufferLength(n > n4 ? n : n4);
            }
        }
    }

    public abstract int getBufferLength();

    public abstract void setBufferLength(int var1);

    protected boolean isAfterPos(int n) {
        return (n & 1) != 0;
    }

    protected int nextIndex(int n) {
        return n == -1 ? this.size : n >>> 1;
    }

    public int createPos(int n, boolean bl) {
        return n << 1 | (bl ? 1 : 0);
    }

    public int nextPos(int n) {
        if (n == -1) {
            return 0;
        }
        int n2 = n >>> 1;
        if (n2 == this.size) {
            return 0;
        }
        return (n2 << 1) + 3;
    }

    protected abstract Object getBuffer();

    public Object get(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.getBuffer(n);
    }

    public Object getPosNext(int n) {
        int n2 = n >>> 1;
        return n2 >= this.size ? Sequence.eofValue : this.getBuffer(n2);
    }

    public int intAtBuffer(int n) {
        return Convert.toInt(this.getBuffer(n));
    }

    public int intAt(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.intAtBuffer(n);
    }

    public long longAt(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.longAtBuffer(n);
    }

    public long longAtBuffer(int n) {
        return Convert.toLong(this.getBuffer(n));
    }

    public Object getRowMajor(int n) {
        return this.get(n);
    }

    protected abstract Object getBuffer(int var1);

    public Object set(int n, Object object2) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object object3 = this.getBuffer(n);
        this.setBuffer(n, object2);
        return object3;
    }

    protected abstract Object setBuffer(int var1, Object var2);

    public void fill(Object object2) {
        int n = this.size;
        while (--n >= 0) {
            this.setBuffer(n, object2);
        }
    }

    public void fillPosRange(int n, int n2, Object object2) {
        int n3;
        int n4 = n3 = n2 == -1 ? this.size : n2 >>> 1;
        for (int i = n == -1 ? this.size : n >>> 1; i < n3; ++i) {
            this.setBuffer(i, object2);
        }
    }

    public void fill(int n, int n2, Object object2) {
        if (n < 0 || n2 > this.size) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = n; i < n2; ++i) {
            this.setBuffer(i, object2);
        }
    }

    public void shift(int n, int n2, int n3) {
        Object object2 = this.getBuffer();
        System.arraycopy(object2, n, object2, n2, n3);
    }

    public boolean add(Object object2) {
        this.add(this.size, object2);
        return true;
    }

    protected int addPos(int n, Object object2) {
        int n2 = n >>> 1;
        this.add(n2, object2);
        return (n2 << 1) + 3;
    }

    public void add(int n, Object object2) {
        int n2;
        this.size = n2 = this.size + 1;
        int n3 = this.getBufferLength();
        if (n2 > n3) {
            this.setBufferLength(n3 < 16 ? 16 : 2 * n3);
        }
        this.size = n2;
        if (this.size != n) {
            this.shift(n, n + 1, this.size - n);
        }
        this.set(n, object2);
    }

    public boolean addAll(int n, Collection collection) {
        boolean bl = false;
        int n2 = collection.size();
        this.setSize(this.size + n2);
        this.shift(n, n + n2, this.size - n2 - n);
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.set(n++, iterator.next());
            bl = true;
        }
        return bl;
    }

    protected abstract void clearBuffer(int var1, int var2);

    protected void removePosRange(int n, int n2) {
        if ((n >>>= 1) >= (n2 >>>= 1)) {
            return;
        }
        if (n2 > this.size) {
            n2 = this.size;
        }
        this.shift(n2, n, this.size - n2);
        int n3 = n2 - n;
        this.size -= n3;
        this.clearBuffer(this.size, n3);
    }

    public void removePos(int n, int n2) {
        int n3;
        int n4;
        int n5 = n >>> 1;
        if (n5 > this.size) {
            n5 = this.size;
        }
        if (n2 >= 0) {
            n4 = n5;
            n3 = n5 + n2;
        } else {
            n4 = n5 + n2;
            n3 = n5;
            n2 = -n2;
        }
        if (n4 < 0 || n3 >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        this.shift(n3, n4, this.size - n3);
        this.size -= n2;
        this.clearBuffer(this.size, n2);
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        Object object2 = this.get(n);
        this.shift(n + 1, n, 1);
        --this.size;
        this.clearBuffer(this.size, 1);
        return object2;
    }

    public boolean remove(Object object2) {
        int n = this.indexOf(object2);
        if (n < 0) {
            return false;
        }
        Object object3 = this.get(n);
        this.shift(n + 1, n, 1);
        --this.size;
        this.clearBuffer(this.size, 1);
        return true;
    }

    public boolean removeAll(Collection collection) {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            Object object2 = this.get(i);
            if (collection.contains(object2)) {
                bl = true;
                continue;
            }
            if (bl) {
                this.set(n, object2);
            }
            ++n;
        }
        this.setSize(n);
        return bl;
    }

    public boolean retainAll(Collection collection) {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            Object object2 = this.get(i);
            if (!collection.contains(object2)) {
                bl = true;
                continue;
            }
            if (bl) {
                this.set(n, object2);
            }
            ++n;
        }
        this.setSize(n);
        return bl;
    }

    public void clear() {
        this.setSize(0);
    }

    public String getTag() {
        return null;
    }

    public void consume(int n, int n2, Consumer consumer) {
        this.consumePosRange(n << 1, n + n2 << 1, consumer);
    }

    public boolean consumeNext(int n, Consumer consumer) {
        int n2 = n >>> 1;
        if (n2 >= this.size) {
            return false;
        }
        consumer.writeObject(this.getBuffer(n2));
        return true;
    }

    public void consumePosRange(int n, int n2, Consumer consumer) {
        if (consumer.ignoring()) {
            return;
        }
        int n3 = n >>> 1;
        int n4 = n2 >>> 1;
        if (n4 > this.size) {
            n4 = this.size;
        }
        while (n3 < n4) {
            consumer.writeObject(this.getBuffer(n3));
            ++n3;
        }
    }

    public int getNextKind(int n) {
        return this.hasNext(n) ? this.getElementKind() : 0;
    }

    public int getElementKind() {
        return 32;
    }

    public Array transpose(int[] nArray, int[] nArray2, int n, int[] nArray3) {
        GeneralArray generalArray = new GeneralArray();
        generalArray.strides = nArray3;
        generalArray.dimensions = nArray2;
        generalArray.lowBounds = nArray;
        generalArray.offset = n;
        generalArray.base = this;
        generalArray.simple = false;
        return generalArray;
    }
}

