;; Scheduling description for z990 (cpu 2084).
;;   Copyright (C) 2003, 2004, 2005, 2006, 2007, 2008
;;   Free Software Foundation, Inc.
;;   Contributed by Hartmut Penner (hpenner@de.ibm.com) and
;;                  Ulrich Weigand (uweigand@de.ibm.com).

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it under
;; the terms of the GNU General Public License as published by the Free
;; Software Foundation; either version 3, or (at your option) any later
;; version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT ANY
;; WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

(define_automaton "x_ipu")

(define_cpu_unit "x_e1_r,x_e1_s,x_e1_t"  "x_ipu")
(define_cpu_unit "x_wr_r,x_wr_s,x_wr_t,x_wr_fp" "x_ipu")
(define_cpu_unit "x_s1,x_s2,x_s3,x_s4"   "x_ipu")
(define_cpu_unit "x_t1,x_t2,x_t3,x_t4"   "x_ipu")
(define_cpu_unit "x_f1,x_f2,x_f3,x_f4,x_f5,x_f6"   "x_ipu")
(define_cpu_unit "x_store_tok"   "x_ipu")
(define_cpu_unit "x_ms,x_mt"   "x_ipu")

(define_reservation "x-e1-st" "(x_e1_s | x_e1_t)")

(define_reservation "x-e1-np" "(x_e1_r + x_e1_s + x_e1_t)")

(absence_set "x_e1_r" "x_e1_s,x_e1_t")
(absence_set "x_e1_s" "x_e1_t")

;; Try to avoid int <-> fp transitions.

(define_reservation "x-x" "x_s1|x_t1,x_s2|x_t2,x_s3|x_t3,x_s4|x_t4")
(define_reservation "x-f" "x_f1,x_f2,x_f3,x_f4,x_f5,x_f6")
(define_reservation "x-wr-st" "((x_wr_s | x_wr_t),x-x)")
(define_reservation "x-wr-np" "((x_wr_r + x_wr_s + x_wr_t),x-x)")
(define_reservation "x-wr-fp" "x_wr_fp,x-f")
(define_reservation "x-mem"   "x_ms|x_mt")

(absence_set "x_wr_fp"
             "x_s1,x_s2,x_s3,x_s4,x_t1,x_t2,x_t3,x_t4,x_wr_s,x_wr_t")

(absence_set "x_e1_r,x_wr_r,x_wr_s,x_wr_t"
             "x_f1,x_f2,x_f3,x_f4,x_f5,x_f6,x_wr_fp")

;; Don't have any load type insn in same group as store

(absence_set "x_ms,x_mt" "x_store_tok")


;;
;; Simple insns
;;

(define_insn_reservation "x_int" 1
  (and (eq_attr "cpu" "z990,z9_109")
       (and (eq_attr "type" "integer")
            (eq_attr "atype" "reg")))
  "x-e1-st,x-wr-st")

(define_insn_reservation "x_agen" 1
  (and (eq_attr "cpu" "z990,z9_109")
       (and (eq_attr "type" "integer")
            (eq_attr "atype" "agen")))
  "x-e1-st,x-wr-st")

(define_insn_reservation "x_lr" 1
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "lr"))
  "x-e1-st,x-wr-st") 

(define_insn_reservation "x_la" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "la"))
  "x-e1-st,x-wr-st") 

(define_insn_reservation "x_larl" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "larl"))
  "x-e1-st,x-wr-st") 

(define_insn_reservation "x_load" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "load"))
  "x-e1-st+x-mem,x-wr-st") 

(define_insn_reservation "x_store" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "store"))
  "x-e1-st+x_store_tok,x-wr-st") 

(define_insn_reservation "x_branch" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "branch"))
  "x_e1_r,x_wr_r") 

(define_insn_reservation "x_call" 5 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "jsr"))
  "x-e1-np*5,x-wr-np")
 
(define_insn_reservation "x_mul_hi" 2
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "imulhi"))
  "x-e1-np*2,x-wr-np")

(define_insn_reservation "x_mul_sidi" 4
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "imulsi,imuldi"))
  "x-e1-np*4,x-wr-np")

(define_insn_reservation "x_div" 10
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "idiv"))
  "x-e1-np*10,x-wr-np")

(define_insn_reservation "x_sem" 17 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "sem"))
  "x-e1-np+x-mem,x-e1-np*16,x-wr-st") 

;;
;; Multicycle insns
;;

(define_insn_reservation "x_cs" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "cs"))
  "x-e1-np,x-wr-np") 

(define_insn_reservation "x_vs" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "vs"))
  "x-e1-np*10,x-wr-np") 

(define_insn_reservation "x_stm" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "stm"))
  "(x-e1-np+x_store_tok)*10,x-wr-np") 

(define_insn_reservation "x_lm" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "lm"))
  "x-e1-np*10,x-wr-np") 

(define_insn_reservation "x_other" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "other"))
  "x-e1-np,x-wr-np") 

;;
;; Floating point insns
;;

(define_insn_reservation "x_fsimptf" 7 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "fsimptf"))
  "x_e1_t*2,x-wr-fp") 

(define_insn_reservation "x_fsimpdf" 6 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "fsimpdf,fmuldf"))
  "x_e1_t,x-wr-fp") 

(define_insn_reservation "x_fsimpsf" 6 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "fsimpsf,fmulsf"))
  "x_e1_t,x-wr-fp") 


(define_insn_reservation "x_fmultf" 33
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "fmultf"))
  "x_e1_t*27,x-wr-fp") 


(define_insn_reservation "x_fdivtf" 82
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "fdivtf,fsqrttf"))
  "x_e1_t*76,x-wr-fp") 

(define_insn_reservation "x_fdivdf" 36
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "fdivdf,fsqrtdf"))
  "x_e1_t*30,x-wr-fp") 

(define_insn_reservation "x_fdivsf" 36 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "fdivsf,fsqrtsf"))
  "x_e1_t*30,x-wr-fp") 


(define_insn_reservation "x_floadtf" 6 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "floadtf"))
  "x_e1_t,x-wr-fp") 

(define_insn_reservation "x_floaddf" 6 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "floaddf"))
  "x_e1_t,x-wr-fp") 

(define_insn_reservation "x_floadsf" 6 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "floadsf"))
  "x_e1_t,x-wr-fp") 


(define_insn_reservation "x_fstoredf" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "fstoredf"))
  "x_e1_t,x-wr-fp") 

(define_insn_reservation "x_fstoresf" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "fstoresf"))
  "x_e1_t,x-wr-fp") 


(define_insn_reservation "x_ftrunctf" 16
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "ftrunctf"))
  "x_e1_t*10,x-wr-fp") 

(define_insn_reservation "x_ftruncdf" 11
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "ftruncdf"))
  "x_e1_t*5,x-wr-fp") 


(define_insn_reservation "x_ftoi" 1 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "ftoi"))
  "x_e1_t*3,x-wr-fp") 

(define_insn_reservation "x_itof" 7 
  (and (eq_attr "cpu" "z990,z9_109")
       (eq_attr "type" "itoftf,itofdf,itofsf"))
  "x_e1_t*3,x-wr-fp") 

(define_bypass 1 "x_fsimpdf" "x_fstoredf")

(define_bypass 1 "x_fsimpsf" "x_fstoresf")

(define_bypass 1 "x_floaddf" "x_fsimpdf,x_fstoredf,x_floaddf")
	         
(define_bypass 1 "x_floadsf" "x_fsimpsf,x_fstoresf,x_floadsf")

;;
;; s390_agen_dep_p returns 1, if a register is set in the 
;; first insn and used in the dependent insn to form a address.
;;

;;
;; If an instruction uses a register to address memory, it needs
;; to be set 5 cycles in advance.
;; 

(define_bypass 5 "x_int,x_agen,x_lr" 
                 "x_agen,x_la,x_branch,x_call,x_load,x_store,x_cs,x_stm,x_lm,x_other"
	         "s390_agen_dep_p")

(define_bypass 9 "x_int,x_agen,x_lr" 
                 "x_floadtf, x_floaddf, x_floadsf, x_fstoredf, x_fstoresf,\
		  x_fsimpdf, x_fsimpsf, x_fdivdf, x_fdivsf"
	         "s390_agen_dep_p")
;;
;; A load type instruction uses a bypass to feed the result back	
;; to the address generation pipeline stage. 
;;

(define_bypass 4 "x_load"    
                 "x_agen,x_la,x_branch,x_call,x_load,x_store,x_cs,x_stm,x_lm,x_other"
	         "s390_agen_dep_p")

(define_bypass 5 "x_load"
                 "x_floadtf, x_floaddf, x_floadsf, x_fstoredf, x_fstoresf,\
		  x_fsimpdf, x_fsimpsf, x_fdivdf, x_fdivsf"
	         "s390_agen_dep_p")

;;
;; A load address type instruction uses a bypass to feed the 
;; result back to the address generation pipeline stage. 
;;

(define_bypass 3 "x_larl,x_la" 
                 "x_agen,x_la,x_branch,x_call,x_load,x_store,x_cs,x_stm,x_lm,x_other"
	         "s390_agen_dep_p")

(define_bypass 5 "x_larl, x_la"
                 "x_floadtf, x_floaddf, x_floadsf, x_fstoredf, x_fstoresf,\
		  x_fsimpdf, x_fsimpsf, x_fdivdf, x_fdivsf"
	         "s390_agen_dep_p")

;;
;; Operand forwarding
;;

(define_bypass 0 "x_lr,x_la,x_load" "x_int,x_lr")


