/**
 * Graphical functions

 * Copyright (C) 2003  Shawn Betts
 * Copyright (C) 2004  Sylvain Beucler
 * Copyright (C) 1997, 1998, 1999, 2002, 2003  Seth A. Robinson

 * This file is part of GNU FreeDink

 * GNU FreeDink is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.

 * GNU FreeDink is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with program; see the file COPYING. If not, write to the Free
 * Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.

 * $Header: /cvsroot/dink/dink/src/draw.c,v 1.3 2004/01/16 19:55:45 Beuc Exp $
 */

#include "SDL.h"
#include "dink.h"

void
text_draw (int h)
{

  char crap[200];
  char *cr;
  struct rect rcRect;
  int color = 0;


  if (spr[h].damage == -1)

    {
      sprintf (crap, "%s", spr[h].text);
      cr = &crap[0];
      color = 14;
      while (cr[0] == '`')
	{

	  /* color code at top */

	  if (cr[1] == '#')
	    color = 13;
	  if (cr[1] == '1')
	    color = 1;
	  if (cr[1] == '2')
	    color = 2;
	  if (cr[1] == '3')
	    color = 3;
	  if (cr[1] == '4')
	    color = 4;
	  if (cr[1] == '5')
	    color = 5;
	  if (cr[1] == '6')
	    color = 6;
	  if (cr[1] == '7')
	    color = 7;
	  if (cr[1] == '8')
	    color = 8;
	  if (cr[1] == '9')
	    color = 9;
	  if (cr[1] == '0')
	    color = 10;
	  if (cr[1] == '$')
	    color = 14;
	  if (cr[1] == '%')
	    color = 15;

	  cr = &cr[2];

	}



      /* Msg("Final is %s.",cr); */

      if (spr[h].owner == 1000)

	{

	  SetRect (&rcRect, spr[h].x, spr[h].y, spr[h].x + 620,
		   spr[h].y + 400);

	}
      else

	{

	  SetRect (&rcRect, spr[h].x, spr[h].y, spr[h].x + 150,
		   spr[h].y + 150);


	  if (spr[h].x + 150 > 620)

	    OffsetRect (&rcRect,
			((spr[h].x + 150) - 620) -
			(((spr[h].x + 150) - 620) * 2), 0);


	}


    }
  else

    {

      sprintf (crap, "%d", spr[h].damage);

      cr = &crap[0];

      if (spr[h].brain_parm == 5000)

	color = 14;

      if (spr[h].y < 0)
	spr[h].y = 0;

      SetRect (&rcRect, spr[h].x, spr[h].y, spr[h].x + 50, spr[h].y + 50);


    }



  /* SetTextColor(hdc,RGB(8,14,21)); */

  SetTextColor (8, 14, 21);

  if (spr[h].owner == 1200)

    {

      /* this text has no sprite, and doesn't want to be centered. */

      print_text_wrap (hfont_small, cr, &rcRect, GetTextColor (), 0, 0);

      OffsetRect (&rcRect, -2, 0);
      print_text_wrap (hfont_small, cr, &rcRect, GetTextColor (), 0, 0);

      OffsetRect (&rcRect, 1, 1);

      print_text_wrap (hfont_small, cr, &rcRect, GetTextColor (), 0, 0);
      OffsetRect (&rcRect, 0, -2);

      print_text_wrap (hfont_small, cr, &rcRect, GetTextColor (), 0, 0);
    }
  else
    {
      print_text_wrap (hfont_small, cr, &rcRect, GetTextColor (), 1, 0);
      OffsetRect (&rcRect, -2, 0);
      print_text_wrap (hfont_small, cr, &rcRect, GetTextColor (), 1, 0);

      OffsetRect (&rcRect, 1, 1);
      print_text_wrap (hfont_small, cr, &rcRect, GetTextColor (), 1, 0);
      OffsetRect (&rcRect, 0, -2);
      print_text_wrap (hfont_small, cr, &rcRect, GetTextColor (), 1, 0);
    }
  OffsetRect (&rcRect, 0, 1);


  if (color == 1)
    SetTextColor (255, 198, 255);
  else if (color == 2)
    SetTextColor (131, 181, 74);
  else if (color == 3)
    SetTextColor (99, 242, 247);

  else if (color == 4)
    SetTextColor (255, 156, 74);	/* right */

  else if (color == 5)
    SetTextColor (222, 173, 255);
  else if (color == 6)
    SetTextColor (244, 188, 73);	/* right */
  else if (color == 7)
    SetTextColor (173, 173, 173);	/* right */
  else if (color == 8)
    SetTextColor (85, 85, 85);	/* right */
  else if (color == 9)
    SetTextColor (148, 198, 255);	/* right */


  else if (color == 10)
    SetTextColor (0, 255, 0);
  else if (color == 13)
    SetTextColor (255, 132, 132);
  else if (color == 14)
    SetTextColor (255, 255, 2);
  else if (color == 15)
    SetTextColor (255, 255, 255);

  else
    SetTextColor (255, 255, 255);
  if (spr[h].owner == 1200)
    print_text_wrap (hfont_small, cr, &rcRect, GetTextColor (), 0, 0);
  else
    print_text_wrap (hfont_small, cr, &rcRect, GetTextColor (), 1, 0);
}



void
draw_damage (int h)
{
  int crap2 = add_sprite (spr[h].x, spr[h].y, 8, 0, 0);

  spr[crap2].y -= k[seq[spr[h].pseq].frame[spr[h].pframe]].yoffset;
  spr[crap2].x -= k[seq[spr[h].pseq].frame[spr[h].pframe]].xoffset;
  spr[crap2].y -= k[seq[spr[h].pseq].frame[spr[h].pframe]].box.bottom / 3;
  spr[crap2].x += k[seq[spr[h].pseq].frame[spr[h].pframe]].box.right / 5;

  spr[crap2].speed = 1;
  spr[crap2].hard = 1;
  spr[crap2].brain_parm = h;
  spr[crap2].my = -1;
  spr[crap2].kill = 1000;
  spr[crap2].dir = 8;
  spr[crap2].damage = spr[h].damage;

}


void
process_talk ()
{
  int px = 48, py = 44;
  int sx = 184;
  int sy = 94, sy_hold, sy_ho;
  /*   int spacing = 12; */
  int curxl = 126;
  int curxr = 462;
  int curyr = 200;
  int curyl = 200;

  int y_last = 0, y_hold = 0, y_ho;

  struct rect rcRect;

  int i;
  int x_depth = 335;
  int fake_page;
  int talk_hold;

  if (talk.newy != -5000)
    sy = talk.newy;

  sy_hold = sy;
  sy_ho = sy;

  check_seq_status (30);
  /* UNREFERENCED again: */

  BltFast (lpDDSBack, px, py, k[seq[30].frame[2]].k,
	   &k[seq[30].frame[2]].box);

  /* UNREFERENCED again2: */
  BltFast (lpDDSBack, px + 169, py + 42, k[seq[30].frame[3]].k,
	   &k[seq[30].frame[3]].box);

  /* UNREFERENCED again3: */
  BltFast (lpDDSBack, px + 169 + 180, py + 1, k[seq[30].frame[4]].k,
	   &k[seq[30].frame[4]].box);

  talk_hold = talk.cur;

  if (sjoy.rightd)
    talk.cur++;

  if (sjoy.downd)
    talk.cur++;

  if (sjoy.upd)
    talk.cur--;

  if (sjoy.leftd)
    talk.cur--;

  if (play.mouse > 20)
    {
      talk.cur++;
      play.mouse = 0;
    }
  if (play.mouse < -20)
    {
      talk.cur--;
      play.mouse = 0;
    }

  if (talk_hold != talk.cur)
    {
      if (talk.cur >= talk.cur_view)
	if (talk.cur <= talk.cur_view_end)
	  SoundPlayEffect (11, 22050, 0, 0, 0);
    }

  if (strlen (talk.buffer) > 0)
    {
      SetRect (&rcRect, sx, 94, 463, 400);

      if (talk.newy != -5000)
	rcRect.bottom = talk.newy + 15;

      SetTextColor (8, 14, 21);

      print_text_wrap (hfont_small, talk.buffer, &rcRect, GetTextColor (),
		       1, 1);

      if (talk.color == 1)
	SetTextColor (49, 90, 140);

      else if (talk.color == 2)
	SetTextColor (131, 181, 74);

      else if (talk.color == 3)
	SetTextColor (99, 242, 247);

      else if (talk.color == 4)
	SetTextColor (255, 156, 74);	/* right */

      else if (talk.color == 5)
	SetTextColor (222, 173, 255);

      else if (talk.color == 6)
	SetTextColor (244, 188, 73);	/* right */

      else if (talk.color == 7)
	SetTextColor (173, 173, 173);	/* right */

      else if (talk.color == 8)
	SetTextColor (85, 85, 85);	/* right */

      else if (talk.color == 9)
	SetTextColor (148, 198, 255);	/* right */

      else if (talk.color == 10)
	SetTextColor (0, 255, 0);

      else if (talk.color == 13)
	SetTextColor (255, 132, 132);

      else if (talk.color == 14)
	SetTextColor (255, 255, 2);

      else if (talk.color == 15)
	SetTextColor (255, 255, 255);

      else
	SetTextColor (255, 255, 2);

      OffsetRect (&rcRect, 1, 1);

      print_text_wrap (hfont_small, talk.buffer, &rcRect, GetTextColor (),
		       1, 1);

      SetTextColor (8, 14, 21);
    }

  /* tabulate distance needed by text, LORDII experience helped here */
  /* UNREFERENCED recal: */

  for (i = talk.cur_view; i < talk.last; i++)
    {
      SetRect (&rcRect, sx, y_hold, 463, x_depth + 100);
      y_hold = TTF_FontLineSkip (hfont_small);
      sy_hold += y_hold;

      /* Msg(("Sy_hold = %d (%d)", sy_hold,i)); */
      if (sy_hold > x_depth)
	{
	  talk.cur_view_end = i - 1;
	  /* Msg(("Sy is over, sp cur_view is %d ", talk.cur_view_end)); */
	  goto death;
	}
    }
  talk.cur_view_end = i;

  if (talk.cur_view == 1)
    if (talk.cur_view_end == talk.last)
      {
	/* Msg(("Small enough to fit on one screen, lets center it!")); */
	sy += ((x_depth - sy_hold) / 2) - 20;
      }
 death:

  if (talk.cur > talk.last)
    {
      SoundPlayEffect (11, 22050, 0, 0, 0);
      talk.cur = 1;
    }
  if (talk.cur < 1)
    {
      SoundPlayEffect (11, 22050, 0, 0, 0);
      talk.cur = talk.last;
    }
  /* if (talk.cur_view_end != talk.last) */
  {
    /* Msg(("Talkcur is %d, talk cur view is %d", talk.cur, talk.cur_view)); */
    /* total options too large for page, lets scroll */
    if (talk.cur > talk.cur_view_end)
      {
	/* Msg(("advancing page:  talkcur is %d, changing cur_view to same", talk.cur, talk.cur_view)); */
	talk.cur_view = talk.cur;
	talk.page++;

	/* Msg(("Page advanced to %d. (cur_end is %d, cur is %d)", talk.page,talk.cur_view_end, talk.cur)); */
	goto fin;
      }
    if (talk.cur < talk.cur_view)
      {
	/* Msg(("Turning back the clock from page %d..", talk.page)); */
	talk.cur_view = 1;
	/* talk.cur = 1; */
	talk.page--;
	Msg (("Page backed to %d.", talk.page));
	fake_page = 1;
	for (i = 1; i < talk.last; i++)
	  {
	    SetRect (&rcRect, sx, sy_ho, 463, x_depth);
	    y_ho =
	      process_text_for_wrapping (hfont_small, talk.line[i], &rcRect);
	    y_ho *= TTF_FontLineSkip (hfont_small);
	    sy_ho += y_ho;
	    /* Msg(("adding y_yo %d.. (on %d)", y_ho,i)); */
	    if (sy_ho > x_depth)
	      {
		/*if (fake_page == talk.page)
		  {
		  goto fin;
		  }
		*/
		fake_page++;
		sy_ho = sy + y_ho;
		/* Msg(("Does fake page (%d) match desired page (%d) %d", fake_page, talk.page, i)); */
	      }
	    if (fake_page == talk.page)
	      {
		talk.cur_view = i;
		talk.cur_view_end = talk.cur;
		/* Msg(("Going to fin with end being %d, and.cur being %d.  View is %d.", */
		/* talk.cur_view_end, talk.cur, talk.cur_view); */
		goto fin;
	      }
	    /* Msg(("Second: Sy is over, sp cur_view is %d", talk.cur_view_end)); */
	  }
	talk.cur_view_end = i;
      }
  }
  /* Msg(("talk last is %d.  cur_view_end is %d, Cur is %d", talk.last, talk.cur_view_end, talk.cur)); */
  /* talk.cur_view_end = talk.last; */

  for (i = talk.cur_view; i <= talk.cur_view_end; i++)
    {
      /* lets figure out where to draw this line */
      SetRect (&rcRect, sx, sy, 463, x_depth + 100);
      SetTextColor (8, 14, 21);
      print_text_wrap (hfont_small, talk.line[i], &rcRect, GetTextColor (),
		       1, 0);
      OffsetRect (&rcRect, -2, -2);
      print_text_wrap (hfont_small, talk.line[i], &rcRect, GetTextColor (),
		       1, 0);

      OffsetRect (&rcRect, 1, 1);
      if (i == talk.cur)
	{
	  curyl = sy - 4;
	  curyr = sy - 4;
	  SetTextColor (255, 255, 255);
	}
      else
	SetTextColor (255, 255, 2);

      y_last =
	print_text_wrap (hfont_small, talk.line[i], &rcRect, GetTextColor (),
			 1, 0);
      sy += y_last;
    }

 fin:
  if (talk.timer < thisTickCount)
    {
      talk.curf++;
      talk.timer = thisTickCount + 100;
    }

  if (talk.curf == 0)
    talk.curf = 1;

  if (talk.curf > 7)
    talk.curf = 1;

  /* UNREFERENCED again4: */

  BltFast (lpDDSBack, curxl, curyl, k[seq[456].frame[talk.curf]].k,
	   &k[seq[456].frame[talk.curf]].box);

  /* UNREFERENCED again5: */

  BltFast (lpDDSBack, curxr, curyr, k[seq[457].frame[talk.curf]].k,
	   &k[seq[456].frame[talk.curf]].box);


  if ((sjoy.button[1]) | (mouse1))

    {

      mouse1 = 0;

      talk.active = 0;

      *presult = talk.line_return[talk.cur];

      SoundPlayEffect (17, 22050, 0, 0, 0);

      if (talk.script != 0)

	{

	  /* we need to continue a script */

	  run_script (talk.script);

	}

    }



}




void
draw_item (int num, /*bool*/int magic, int mseq, int mframe)
{

  int mx = 20;
  int my = 0;
  int vert = 0;

  if (magic == 0)
    {

      mx = 260;
      my = 83;

      vert = ((num - 1) / 4);
      mx += (((num - 1) - (vert * 4)) * (18 + 65));
      my += (vert * (20 + 55));

    }
  else

    {
      mx = 45;
      my = 83;

      vert = ((num - 1) / 2);
      mx += (((num - 1) - (vert * 2)) * (18 + 65));
      my += (vert * (20 + 55));

    }

  /* UNREFERENCED again: */
  check_seq_status (mseq);

  if (k[seq[mseq].frame[mframe]].k == NULL)

    {



      if (!magic)

	{

	  Msg (("Whups, item %d seq %d frame %d not loaded, killed it", num,
		mseq, mframe));

	  play.item[num].active = 0;

	}
      else

	{

	  Msg (("Whups, magic %d seq %d frame %d not loaded, killed it", num,
		mseq, mframe));

	  play.mitem[num].active = 0;

	}

      return;

    }

  BltFast (lpDDSBack, mx, my, k[seq[mseq].frame[mframe]].k,
	   &k[seq[mseq].frame[mframe]].box);

}



void
process_show_bmp (void)
{
  struct rect rcRect;

  SetRect (&rcRect, 0, 0, x, y);

  /* UNREFERENCED again: */

  BltFast (lpDDSBack, 0, 0, lpDDSTrick, &rcRect);

  if (showb.showdot)

    {
      /* let's display a nice dot to mark where they are on the map */
      int x = play.last_map;

      int mseq = 165;
      int mframe;

      showb.picframe++;
      if (showb.picframe > sequence_index[mseq].last)
	showb.picframe = 1;

      mframe = showb.picframe;

      BltFast (lpDDSBack, ((x) * 20 - ((x / 32) * 640)) - 20, (x / 32) * 20,
	       k[seq[mseq].frame[mframe]].k, &k[seq[mseq].frame[mframe]].box);
    }

  if ((sjoy.button[1]) || (sjoy.button[2]) || (sjoy.button[3])
      || (sjoy.button[4]) || (sjoy.button[5]) || (sjoy.button[6])
      || ((GetKeyboard (SDLK_m)) && (but_timer < thisTickCount)))
    {
      int sprite;
      showb.active = 0;

      if (showb.script != 0)
	run_script (showb.script);

      showb.stime = thisTickCount + 2000;
      but_timer = thisTickCount + 200;

      sprite = say_text_xy ("", 1, 440, 0);
      spr[sprite].noclip = 1;
    }
}


void
drawscreenlock (void)
{
  /* UNREFERENCED loop: */
  /* draw the screenlock icon */
  BltFast (lpDDSBack, 0, 0, k[seq[423].frame[9]].k,
	   &k[seq[423].frame[9]].box);
  /* UNREFERENCED loop2: */
  /* draw the screenlock icon */
  BltFast (lpDDSBack, 620, 0, k[seq[423].frame[10]].k,
	   &k[seq[423].frame[10]].box);
}


void
move (int u, int amount, char kind, char kindy)
{
  int mx = 0;
  int my = 0;
  int i;
  /*bool*/int clearx;
  /*bool*/int cleary;
  clearx = 0;
  cleary = 0;

  for (i = 1; i <= amount; i++)
    {
      spr[u].moveman++;
      if (mx >= spr[u].mx)
	clearx = 1;

      if (my >= spr[u].my)
	clearx = 1;

      if ((clearx) & (cleary))
	{
	  mx = 0;
	  my = 0;
	  clearx = 0;
	  cleary = 0;
	}

      if (kind == '+')
	{
	  if (mx < spr[u].mx)
	    spr[u].x++;
	  mx++;
	}

      if (kind == '-')
	{
	  if (mx < (spr[u].mx - (spr[u].mx * 2)))
	    spr[u].x--;
	  mx++;
	}

      if (kindy == '+')
	{
	  if (my < spr[u].my)
	    spr[u].y++;
	  my++;
	}

      if (kindy == '-')
	{
	  if (my < (spr[u].my - (spr[u].my * 2)))
	    spr[u].y--;
	  my++;
	}

      spr[u].lpx[spr[u].moveman] = spr[u].x;
      spr[u].lpy[spr[u].moveman] = spr[u].y;
    }
}


void
make_missile (int x1, int y1, int dir, int speed, int seq, int frame,
	      int strength)
{
  int crap = add_sprite (x1, y1, 11, seq, frame);

  spr[crap].speed = speed;
  spr[crap].seq = seq;
  spr[crap].timer = 0;
  spr[crap].strength = strength;
  spr[crap].flying = 1;

  changedir (dir, crap, 430);
}


/*bool*/int
transition (void)
{
  struct rect rcRect;
  /* we need to do our fancy screen transition */
  int dumb = 5;
  dumb = fps_final * 2;
  move_counter += dumb;
  if (no_transition)
    {
      total_trigger = 0;
      move_screen = 0;
      move_counter = 0;
      trig_man = 0;
      return (0);
    }

  if (move_screen == 4)
    {
      if (move_counter > 598)
	move_counter = 598;
      rcRect.left = 0;
      rcRect.right = 600 - move_counter;
      rcRect.top = 0;
      rcRect.bottom = 400;
      BltFast (lpDDSBack, move_counter + 20, 0, lpDDSTrick, &rcRect);
      rcRect.left = 600 - move_counter;;
      rcRect.right = 600;
      rcRect.top = 0;
      rcRect.bottom = 400;
      BltFast (lpDDSBack, 20, 0, lpDDSTrick2, &rcRect);

      if (move_counter >= 595)
	{
	  total_trigger = 0;
	  move_screen = 0;
	  move_counter = 0;
	  trig_man = 0;
	  return (0);
	}
      return (1);
    }

  if (move_screen == 6)
    {
      if (move_counter > 598)
	move_counter = 598;

      rcRect.left = move_counter;
      rcRect.right = 599;
      rcRect.top = 0;
      rcRect.bottom = 399;
      BltFast (lpDDSBack, 20, 0, lpDDSTrick, &rcRect);

      rcRect.left = 0;
      rcRect.right = move_counter;
      rcRect.top = 0;
      rcRect.bottom = 399;
      BltFast (lpDDSBack, 620 - move_counter, 0, lpDDSTrick2, &rcRect);

      if (move_counter >= 595)
	{
	  total_trigger = 0;
	  move_screen = 0;
	  move_counter = 0;
	  trig_man = 0;
	  return (0);
	}
      return (1);
    }

  if (move_screen == 8)
    {
      if (move_counter > 398)
	move_counter = 398;
      rcRect.left = 0;
      rcRect.right = 599;

      rcRect.top = 0;
      rcRect.bottom = 399 - move_counter;
      BltFast (lpDDSBack, 20, move_counter, lpDDSTrick, &rcRect);

      rcRect.left = 0;
      rcRect.right = 599;
      rcRect.top = 399 - move_counter;;
      rcRect.bottom = 399;
      BltFast (lpDDSBack, 20, 0, lpDDSTrick2, &rcRect);

      if (move_counter >= 398)
	{
	  total_trigger = 0;
	  move_screen = 0;
	  move_counter = 0;
	  trig_man = 0;
	  return (0);
	}
      return (1);
    }

  if (move_screen == 2)

    {

      if (move_counter > 398)
	move_counter = 398;

      rcRect.left = 0;



      rcRect.right = 599;

      rcRect.top = move_counter;

      rcRect.bottom = 399;


      BltFast (lpDDSBack, 20, 0, lpDDSTrick, &rcRect);



      rcRect.left = 0;

      rcRect.right = 599;



      rcRect.top = 0;

      rcRect.bottom = move_counter;


      BltFast (lpDDSBack, 20, 399 - move_counter, lpDDSTrick2, &rcRect);


      if (move_counter >= 398)

	{

	  total_trigger = 0;

	  move_screen = 0;

	  move_counter = 0;

	  trig_man = 0;

	  return (0);

	}


      return (1);

    }


  return (0);

}


void
CyclePalette ()
{
  /* UNREFERENCED   int reg[15]; */
  /* UNREFERENCED   int k; */
  /*bool*/int done_this_time = 1;
  int kk;

  for (kk = 1; kk < 256; kk++)
    {
      if (pe[kk].b != 0)
	{
	  done_this_time = 0;
	  if (pe[kk].b > 10)
	    pe[kk].b -= 10;
	  else
	    pe[kk].b--;
	}
      if (pe[kk].g != 0)
	{
	  done_this_time = 0;
	  if (pe[kk].g > 10)
	    pe[kk].g -= 10;
	  else
	    pe[kk].g--;
	}
      if (pe[kk].r != 0)
	{
	  done_this_time = 0;
	  if (pe[kk].r > 10)

	    pe[kk].r -= 10;
	  else
	    pe[kk].r--;
	}
    }
  SDL_SetPalette (lpDDSBack, SDL_PHYSPAL, pe, 0, 256);

  if (process_downcycle)
    {
      if (thisTickCount > cycle_clock)
	{
	  process_downcycle = 0;

	  if (cycle_script != 0)
	    {
	      int junk = cycle_script;
	      Msg (("Downcycle script"));
	      cycle_script = 0;
	      run_script (junk);
	    }
	}
    }
}


void
up_cycle (void)
{
  /*bool*/int donethistime = 1;
  int kk;
  for (kk = 1; kk < 255; kk++)
    {
      if (pe[kk].b != real_pal[kk].b)
	{
	  if (pe[kk].b > 246)
	    pe[kk].b++;
	  else
	    pe[kk].b += 10;
	  donethistime = 0;
	}
      if (pe[kk].b > real_pal[kk].b)
	pe[kk].b = real_pal[kk].b;
      if (pe[kk].g != real_pal[kk].g)
	{
	  if (pe[kk].g > 246)
	    pe[kk].g++;
	  else
	    pe[kk].g += 10;
	  donethistime = 0;
	}
      if (pe[kk].g > real_pal[kk].g)
	pe[kk].g = real_pal[kk].g;
      if (pe[kk].r != real_pal[kk].r)
	{
	  if (pe[kk].r > 246)
	    pe[kk].r++;
	  else
	    pe[kk].r += 10;
	  donethistime = 0;
	}
      if (pe[kk].r > real_pal[kk].r)
	pe[kk].r = real_pal[kk].r;
    }

  SDL_SetPalette (lpDDSBack, SDL_PHYSPAL, pe, 0, 256);

  if (process_upcycle)
    if (donethistime)
      {
	/* Restore the palette completely since the fade doesn't quite */
	/* do it. - sabetts */
	SDL_SetPalette (lpDDSBack, SDL_PHYSPAL, real_pal, 0, 256);
	process_upcycle = 0;

	if (cycle_script != 0)
	  {
	    int junk = cycle_script;
	    Msg (("Upcycle script"));
	    cycle_script = 0;
	    run_script (junk);
	  }
      }
}


void
flip_it (void)
{
  SDL_Flip (lpDDSPrimary);
}




void
draw_box (struct rect box, int color)
{
  fill_rect (lpDDSBack, &box, color);
}




void
updateFrame (void)
{
  byte state[256];
  struct rect rcRect, box_crap, box_real;
  char msg[100];

  /*   int sz = 0; */
  int move_result;
  /*   int sy = 0; */
  /*bool*/int get_frame = 0;
  int h, max_s, j;

  BOOL bs[MAX_SPRITES_AT_ONCE];

  int rank[MAX_SPRITES_AT_ONCE];
  int highest_sprite;
  int junk3;

  abort_this_flip = 0;

  if (5 > 9)
    {
    trigger_start:
      trig_man = 0;
      get_frame = 1;
    }
  check_joystick ();

  if ((GetKeyboard (SDLK_m)) && (GetKeyboard (SDLK_LALT)))
    {
      /* shutdown music */
      StopMidi ();
      return;
    }
  if ((GetKeyboard (SDLK_d)) && (GetKeyboard (SDLK_LALT)))
    {
      if (debug_mode)
	{
	  debug_mode = 0;
	}
      else
	{
	  strcpy (last_debug, "");
	  debug_mode = 1;
	}
    }
  if ((GetKeyboard (SDLK_q)) && (GetKeyboard (SDLK_LALT)))
    {
      /* shutdown game */
      finiObjects ();
      return;
    }
  if (mode == 1)
    Scrawl_OnMouseInput ();
  else
    {
      if (keep_mouse)
	{
	  if ((talk.active) || (spr[1].brain == 13))
	    Scrawl_OnMouseInput ();
	}
    }

  /* UNREFERENCED demon: */
  lastTickCount = thisTickCount;
  thisTickCount = SDL_GetTicks ();

  fps_final = thisTickCount - lastTickCount;

  if (fps_final < 10)
    fps_final = 15;

  if (fps_final > 68)
    fps_final = 68;

  base_timing = fps_final / 3;

  if (base_timing < 4)
    base_timing = 4;

  if (fps_final > 1)
    {
      fps_show = (1000 / fps_final);
      fps_average = ((fps_average + fps_final) / 2);
    }

  junk3 = (fps_average / dinkspeed) - (fps_average / 8);
  spr[1].speed = junk3;

  if (debug_mode)
    if (!no_cheat)
      {
	spr[1].speed = 20;
      }
  /* junk3; */

#ifdef __DEMO
  /* cd_inserted = true; */
  regcode = mycode;
#endif

  /* force free mode */
  /* if (!no_cheat)  */
  {
    /* cd_inserted = true; */
    regcode = mycode;
    sound_support = mcc;
  }

  if (showb.active)
    {
      /* grab main loop and divert it to show a bmp instead */
      process_show_bmp ();
      flip_it ();
      return;
    }

  mbase_count++;

  if (thisTickCount > mold + 100)
    {
      mbase_timing = (mbase_count / 100);
      mold = thisTickCount;
      if (bow.active)
	bow.hitme = 1;

      if (*pupdate_status == 1)
	update_status_all ();

      update_sound ();
      process_animated_tiles ();
    }

  state[1] = 0;

  /* figure out frame rate */
  drawthistime = 1;

  if (item_screen)
    {
      process_item ();
      return;
    }

  if (total_trigger)
    {
      if (transition ())
	goto flip;
      else
	return;
    }

  if (process_upcycle)
    up_cycle ();

  if (process_warp > 0)
    process_warp_man ();

  if (process_downcycle)
    CyclePalette ();

  if (plane_process)
    {
      int height;
      int r1;
      memset (&bs, 0, sizeof (bs));
      max_s = last_sprite_created;
      for (r1 = 1; r1 < max_s + 1; r1++)
	{
	  int h1;
	  highest_sprite = 22024;	/* more than it could ever be */
	  rank[r1] = 0;
	  for (h1 = 1; h1 < max_s + 1; h1++)
	    {
	      if (spr[h1].active)
		if (spr[h1].disabled == 0)
		  {
		    if (bs[h1] == 0)
		      {
			/* Msg( "Ok,  %d is %d", h1,(spr[h1].y + k[spr[h1].pic].yoffset) ); */

			if (spr[h1].que != 0)
			  height = spr[h1].que;
			else
			  height = spr[h1].y;

			if (height < highest_sprite)
			  {
			    highest_sprite = height;
			    rank[r1] = h1;
			  }
		      }
		  }
	    }

	  if (rank[r1] != 0)
	    bs[rank[r1]] = 1;
	}
    }
  else
    {
      /* not processing planes */
      max_s = MAX_SPRITES_AT_ONCE;
    }

  rcRect.left = 0;
  rcRect.top = 0;
  rcRect.right = x;
  rcRect.bottom = y;

  /* Blit from Two, which holds the base scene. */
  BltFast (lpDDSBack, 0, 0, lpDDSTwo, &rcRect);

  if (stop_entire_game == 1)
    {
      if (talk.active)
	process_talk ();
      else
	{
	  stop_entire_game = 0;
	  draw_map_game_background ();
	  draw_status_all ();
	}
      goto flip;
    }

  for (j = 1; j < max_s + 1; j++)
    {
      /* h  = 1; */
      if (plane_process)
	h = rank[j];
      else
	h = j;

      /* Msg( "Ok, rank %d is %d", j,h); */
      if (h > 0)
	if (spr[h].active)
	  {
	    /* check_sprite_status_full(h); */
	    spr[h].moveman = 0;	/* init thing that keeps track of moving path         */
	    spr[h].lpx[0] = spr[h].x;
	    spr[h].lpy[0] = spr[h].y;	/* last known legal cords */

	    spr[h].skiptimer++;
	    /* inc delay, used by "skip" by all sprites */
	    box_crap = k[getpic (h)].box;

	    if (spr[h].kill > 0)
	      {
		if (spr[h].kill_timer == 0)
		  spr[h].kill_timer = thisTickCount;
		if (spr[h].kill_timer + spr[h].kill < thisTickCount)
		  {
		    spr[h].active = 0;
		    /* Msg("Killing sprite %d.", h); */
		    get_last_sprite ();
		    if (spr[h].callback > 0)
		      {
			/* Msg("Callback running script %d.", spr[h].script); */
			run_script (spr[h].callback);
		      }
		  }
	      }

	    if (spr[h].timer > 0)
	      {
		if (thisTickCount > spr[h].wait)
		  {
		    spr[h].wait = thisTickCount + spr[h].timer;
		  }
		else
		  {
		    goto animate;
		  }
	      }

	    /* brains - predefined bahavior patterns available to any sprite */
	    if (spr[h].notouch)
	      if (thisTickCount > spr[h].notouch_timer)
		spr[h].notouch = 0;

	    if (get_frame == 0)
	      {
		if ((spr[h].brain ==
		     1) /* || (spr[h].brain == 9) || (spr[h].brain == 3) */ )
		  {
		    run_through_touch_damage_list (h);
		  }
		if (spr[h].brain == 1)
		  {
		    if (process_warp == 0)
		      human_brain (h);
		  }

		if (spr[h].brain == 2)
		  bounce_brain (h);

		if (spr[h].brain == 0)
		  no_brain (h);

		if (spr[h].brain == 3)
		  duck_brain (h);

		if (spr[h].brain == 4)
		  pig_brain (h);

		if (spr[h].brain == 5)
		  one_time_brain (h);

		if (spr[h].brain == 6)
		  repeat_brain (h);

		if (spr[h].brain == 7)
		  one_time_brain_for_real (h);

		if (spr[h].brain == 8)
		  text_brain (h);

		if (spr[h].brain == 9)
		  pill_brain (h);

		if (spr[h].brain == 10)
		  dragon_brain (h);

		if (spr[h].brain == 11)
		  missile_brain (h, 1);

		if (spr[h].brain == 12)
		  scale_brain (h);

		if (spr[h].brain == 13)
		  mouse_brain (h);

		if (spr[h].brain == 14)
		  button_brain (h);

		if (spr[h].brain == 15)
		  shadow_brain (h);

		if (spr[h].brain == 16)
		  people_brain (h);

		if (spr[h].brain == 17)
		  missile_brain_expire (h);
	      }
	    else
	      {
		goto past;
	      }
	    if (g_b_kill_app)
	      return;

	  animate:
	    move_result = check_if_move_is_legal (h);

	    if (flub_mode != -500)
	      {
		Msg (("move result is %d", flub_mode));
		move_result = flub_mode;
		flub_mode = -500;
	      }

	    if ((spr[h].brain == 1) && (move_result > 100)
		&& (pam.sprite[move_result - 100].prop == 1))
	      special_block (move_result - 100, h);

	    if (spr[h].reverse)
	      {
		/* reverse instructions */
		if (spr[h].seq > 0)
		  {
		    if (spr[h].frame < 1)
		      {
			/* new anim */
			spr[h].pseq = spr[h].seq;
			spr[h].pframe = sequence_index[spr[h].seq].last;
			spr[h].frame = sequence_index[spr[h].seq].last;

			if (spr[h].frame_delay != 0)
			  spr[h].delay = (thisTickCount + spr[h].frame_delay);
			else
			  spr[h].delay =
			    (thisTickCount +
			     seq[spr[h].seq].delay[sequence_index[spr[h].seq].
						   last]);
		      }
		    else
		      {
			/* not new anim */
			/* is it time? */
			if (thisTickCount > spr[h].delay)
			  {
			    spr[h].frame--;

			    if (spr[h].frame_delay != 0)
			      spr[h].delay =
				(thisTickCount + spr[h].frame_delay);
			    else
			      spr[h].delay =
				(thisTickCount +
				 seq[spr[h].seq].delay[spr[h].frame]);

			    spr[h].pseq = spr[h].seq;
			    spr[h].pframe = spr[h].frame;

			    if (seq[spr[h].seq].frame[spr[h].frame] < 2)
			      {
				spr[h].pseq = spr[h].seq;
				spr[h].pframe = spr[h].frame + 1;

				spr[h].frame = 0;
				spr[h].seq_orig = spr[h].seq;
				spr[h].seq = 0;
				spr[h].nocontrol = 0;

				if (h == 1)
				  if (in_this_base (spr[h].seq_orig, 310))
				    {
				      play.push_active = 0;

				      if (play.push_dir == 2)
					if (sjoy.down)
					  play.push_active = 1;

				      if (play.push_dir == 4)
					if (sjoy.left)
					  play.push_active = 1;

				      if (play.push_dir == 6)
					if (sjoy.right)
					  play.push_active = 1;

				      if (play.push_dir == 8)
					if (sjoy.up)
					  play.push_active = 1;

				      goto past;
				    }
			      }

			    if (spr[h].seq > 0)
			      if (seq[spr[h].seq].special[spr[h].frame] == 1)
				{
				  /* this sprite can damage others right now! */
				  /* lets run through the list and tag sprites who were hit with their damage */
				  run_through_tag_list (h, spr[h].strength);
				}
			  }

		      }

		  }
	      }
	    else
	      {
		if (spr[h].seq > 0)
		  if (spr[h].picfreeze == 0)
		    {
		      if (spr[h].frame < 1)
			{
			  /* new anim */
			  spr[h].pseq = spr[h].seq;
			  spr[h].pframe = 1;
			  spr[h].frame = 1;

			  if (spr[h].frame_delay != 0)
			    spr[h].delay = thisTickCount + spr[h].frame_delay;
			  else
			    spr[h].delay =
			      (thisTickCount + seq[spr[h].seq].delay[1]);
			}
		      else
			{
			  /* not new anim */
			  /* is it time? */
			  if (thisTickCount > spr[h].delay)
			    {
			      spr[h].frame++;
			      if (spr[h].frame_delay != 0)
				spr[h].delay =
				  thisTickCount + spr[h].frame_delay;
			      else
				spr[h].delay =
				  (thisTickCount +
				   seq[spr[h].seq].delay[spr[h].frame]);

			      spr[h].pseq = spr[h].seq;
			      spr[h].pframe = spr[h].frame;

			      if (seq[spr[h].seq].frame[spr[h].frame] == -1)
				{
				  spr[h].frame = 1;
				  spr[h].pseq = spr[h].seq;
				  spr[h].pframe = spr[h].frame;
				  if (spr[h].frame_delay != 0)
				    spr[h].delay =
				      thisTickCount + spr[h].frame_delay;
				  else
				    spr[h].delay =
				      (thisTickCount +
				       seq[spr[h].seq].delay[spr[h].frame]);
				}

			      if (seq[spr[h].seq].frame[spr[h].frame] < 1)
				{
				  spr[h].pseq = spr[h].seq;
				  spr[h].pframe = spr[h].frame - 1;

				  spr[h].frame = 0;
				  spr[h].seq_orig = spr[h].seq;
				  spr[h].seq = 0;
				  spr[h].nocontrol = 0;

				  if (h == 1)
				    if (in_this_base (spr[h].seq_orig, 310))
				      {
					play.push_active = 0;

					if (play.push_dir == 2)
					  if (sjoy.down)
					    play.push_active = 1;

					if (play.push_dir == 4)
					  if (sjoy.left)
					    play.push_active = 1;

					if (play.push_dir == 6)
					  if (sjoy.right)
					    play.push_active = 1;

					if (play.push_dir == 8)
					  if (sjoy.up)
					    play.push_active = 1;

					goto past;
				      }
				}

			      if (spr[h].seq > 0)
				if (seq[spr[h].seq].special[spr[h].frame] ==
				    1)
				  {
				    /* this sprite can damage others right now! */
				    /* lets run through the list and tag sprites who were hit with their damage */
				    run_through_tag_list (h, spr[h].strength);
				  }
			    }
			}
		    }
	      }

	    if (spr[h].active)
	      if (spr[h].brain == 1)
		{
		  did_player_cross_screen (1, h);
		  /* if (move_gonna) goto past;  */
		}
	  past:
	    check_seq_status (spr[h].seq);
	    if (mcc == sound_support)
	      draw_sprite_game (lpDDSBack, h);

	    move_gonna = 0;
	    /* draw a dot to show where the computer is guessing the start of the shadow is    */
	    if (show_dot)
	      {
		if (drawthistime)
		  {
		    int oo;
		    /* MERLIN: HARDBOX PROBLEM? */
		    box_crap = k[getpic (h)].hardbox;
		    /* box_crap.bottom = spr[h].y + k[spr[h].pic].hardbox.bottom; */
		    /* box_crap.left = spr[h].x + k[spr[h].pic].hardbox.left; */
		    /* box_crap.right = spr[h].x + k[spr[h].pic].hardbox.right; */

		    /* OffsetRect(&box_crap, spr[h].x, spr[h].y); */

		    /* ddrval = lpDDSBack->Blt(&box_crap ,NULL, &box_real, DDBLT_COLORFILL| DDBLT_WAIT, &ddbltfx); */

		    /* to show center pixel */
		    /* ddbltfx.dwFillColor = 100; */
		    box_crap.top = spr[h].y;
		    box_crap.bottom = spr[h].y + 1;
		    box_crap.left = spr[h].x;
		    box_crap.right = spr[h].x + 1;

		    fill_rect (lpDDSBack, &box_real, 100);

		    for (oo = 0; oo < spr[h].moveman + 1; oo++)
		      {
			box_crap.top = spr[h].lpy[oo];
			box_crap.bottom = box_crap.top + 1;
			box_crap.left = spr[h].lpx[oo];
			box_crap.right = box_crap.left + 1;

			fill_rect (lpDDSBack, &box_crap, 50);
		      }

		    box_crap.top = spr[h].lpy[0];
		    box_crap.bottom = box_crap.top + 1;
		    box_crap.left = spr[h].lpx[0];
		    box_crap.right = box_crap.left + 1;

		    fill_rect (lpDDSBack, &box_crap, 1);
		  }
	      }
	  }
    }

  if ((sjoy.joybit[7] == 1))
    {
      /* space is pressed, lets draw the hitmap, why not? */
      if (!no_cheat)
	drawallhard ();
    }

  /* /copy protection check */
  if (regcode != mycode)
    {
      if (no_cheat)
	if (((rand () % 9000) + 1) == 1)
	  {
	    initFail ("Error 49 with CD, contact RTsoft, Inc.");
	    return;
	  }
    }

  if (mode == 0)
    {
      int crap2, scr;
      memset (&spr[1], 0, sizeof (spr[1]));
      spr[1].speed = 3;
      spr[1].timer = 0;
      spr[1].brain = 1;
      spr[1].hard = 1;
      spr[1].pseq = 2;
      spr[1].pframe = 1;
      spr[1].seq = 2;
      spr[1].dir = 2;
      spr[1].damage = 0;
      spr[1].strength = 10;
      spr[1].defense = 0;
      spr[1].skip = 0;
      SetRect (&spr[1].alt, 0, 0, 0, 0);
      spr[1].base_idle = 10;
      spr[1].base_walk = -1;
      spr[1].size = 100;
      spr[1].base_hit = 100;
      spr[1].active = 1;

      crap2 = add_sprite (0, 450, 8, 0, 0);
      spr[crap2].hard = 1;
      spr[crap2].noclip = 1;
      strcpy (spr[crap2].text, dversion_string);
      spr[crap2].damage = -1;
      spr[crap2].owner = 1000;

      scr = load_script ("start", 1000, 1);
      if (locate (scr, "main") == 0)
	{
	  Msg (("Error: Can't locate MAIN in script START!"));
	}
      run_script (scr);
      mode = 1;
    }

  if (mode == 2)
    {
      {
	mode = 3;
	load_map (map.loc[*pmap]);
	draw_map_game ();
	flife = *plife;
	/* 	if (keep_mouse == 0) */
	/* 	  { */
	/* 	  } */
	/* draw_status_all(); */
      }
    }

  if (spr[1].active)
    if (spr[1].brain == 1)
      did_player_cross_screen (0, 1);

  if (trig_man)
    {
      goto trigger_start;
    }
  if (get_frame)
    {
      struct rect rcRect1;
      total_trigger = 1;
      get_frame = 0;
      rcRect1.left = playl;
      rcRect1.top = 0;
      rcRect1.right = 620;
      rcRect1.bottom = 400;
      if (no_transition)
	return;
      /* return; */

      /* ddrval = lpDDSTrick2->BltFast( 0, 0, lpDDSBack, */
      /* &rcRect1, DDBLTFAST_NOCOLORKEY | DDBLTFAST_WAIT); */
      /* if (ddrval != DD_OK) dderror(ddrval); */
      BltFast (lpDDSTrick2, 0, 0, lpDDSBack, &rcRect1);
      return;
    }

  if (screenlock == 1)
    {
      /* Msg("Drawing screenlock."); */
      drawscreenlock ();
    }
  /* if (lpDDSBack->GetDC(&hdc) == DD_OK) */
  /* {       */

  if (debug_mode)
    {
      /* SetBkMode(hdc, OPAQUE);  */
      /* TextOut(hdc,0,0, msg,lstrlen(msg)); */
      if (mode == 0)
	strcpy (msg, "");
      if (mode == 1)
	{
	  int x;
	  sprintf (msg, "X is %d y is %d", spr[1].x, spr[1].y);
	  /* let's add the key info to it. */
	  for (x = 0; x < 256; x++)
	    {
	      if (GetKeyboard (/* SDLKey ( */x/* ) */))
		{
		  sprintf (msg, "%s (Key %i)", msg, x);
		}
	    }
	}
      if (mode == 3)
	{
	  sprintf (msg,
		   "Sprites: %d  FPS: %d  Show_dot: %d Plane_process: %d Moveman X%d X%d: %d Y%d Y%d Map %d",
		   last_sprite_created, fps_show, show_dot, plane_process,
		   spr[1].lpx[0], spr[1].lpy[0], spr[1].moveman,
		   spr[1].lpx[1], spr[1].lpy[1], *pmap);
	}
      rcRect.left = 0;
      rcRect.top = 0;
      rcRect.right = playx;
      rcRect.bottom = playy;
      SetTextColor (200, 200, 200);
      /* DrawText(hdc,msg,lstrlen(msg),&rcRect,DT_WORDBREAK); */
      print_text_wrap (hfont_small, msg, &rcRect, GetTextColor (), 0, 0);

      if (strlen (last_debug) > 0)
	{
	  /* let's also draw this...       */
	  strcpy (msg, last_debug);
	  rcRect.left = 0;
	  rcRect.top = 20;
	  rcRect.right = playx;
	  rcRect.bottom = playy;
	  SetTextColor (200, 200, 200);
	  /* DrawText(hdc,msg,lstrlen(msg),&rcRect,DT_WORDBREAK); */
	  print_text_wrap (hfont_small, msg, &rcRect, GetTextColor (), 0, 0);
	}
    }
  /* SelectObject (hdc, hfont_small); */
  /* SetBkMode(hdc, TRANSPARENT);  */
  for (j = 1; j < max_s + 1; j++)
    {
      if (plane_process)
	h = rank[j];
      else
	h = j;
      if (h > 0)
	if (spr[h].active)
	  {
	    if (spr[h].brain == 8)
	      {
		/* Msg("Drawing text %d..", h); */
		text_draw (h);
	      }
	  }
    }
  /* lpDDSBack->ReleaseDC(hdc); */
  /* } */
  if (talk.active)
    process_talk ();

  process_callbacks ();

 flip:
  if (g_b_kill_app)
    return;
  if (!abort_this_flip)
    flip_it ();
  if (turn_on_plane)
    plane_process = 1;
}				/* updateFrame */


void
SaySmall (char thing[500], int px, int py, int r, int g, int b)
{
  SetTextColor (r, g, b);
  print_text (hfont_small, thing, px, py, GetTextColor (), 0);
}


void
Say (char thing[500], int px, int py)
{
  print_text (hfont, thing, px, py, GetTextColor (), 0);
}

void
Saytiny (char thing[2000], int px, int py, int r, int g, int b)
{
  SetTextColor (r, g, b);
  print_text (hfont_small, thing, px, py, GetTextColor (), 0);
}


void
flip_it_second (void)
{
  /* SDL_BlitSurface (lpDDSBack, NULL, lpDDSPrimary, NULL); */
  /* SDL_UpdateRect (lpDDSPrimary, 0, 0, 0, 0); */
  SDL_Flip (lpDDSPrimary);
}

int
getpic (int h)
{
  if (spr[h].pseq == 0)
    return (0);
  if (spr[h].pseq > MAX_SEQUENCES)
    {

      Msg (("Sequence %d?  But max is %d!", spr[h].pseq, MAX_SEQUENCES));
      return (0);
    }
  return (seq[spr[h].pseq].frame[spr[h].pframe]);

}


void
add_hardness (int sprite, int num)
{
  int xx;
  for (xx = spr[sprite].x + k[getpic (sprite)].hardbox.left;
       xx < spr[sprite].x + k[getpic (sprite)].hardbox.right; xx++)
    {
      int yy;
      for (yy = spr[sprite].y + k[getpic (sprite)].hardbox.top;
	   yy < spr[sprite].y + k[getpic (sprite)].hardbox.bottom; yy++)
	{
	  if ((xx - 20 > 600) | (xx - 20 < 0) | (yy > 400) | (yy < 0))
	    {
	    }
	  else

	    hm.x[xx - 20].y[yy] = num;
	}
    }

}

void
setup_anim (int fr, int start, int delay)
{
  /* ** start is sprite sequence #, don't know why it is called start */
  int o;
  for (o = 1; o <= sequence_index[start].last; o++)
    {
      seq[fr].frame[o] = sequence_index[start].s + o;
      seq[fr].delay[o] = delay;
    }

  seq[fr].frame[sequence_index[start].last + 1] = 0;
}

SDL_Surface *
DDTileLoad (char *szBitmap, int dx, int dy, int sprite)
{
  return NULL;
}

/*BOOL*/int
DSDisable (void)
{
  return 1;
}

void
drawallhard (void)
{
  struct rect box_crap;
  /* UNREFERENCED   int ddrval; */
  int x1;

  for (x1 = 0; x1 < 600; x1++) {
    int y1; 
    for (y1 = 0; y1 < 400; y1++)
      {
	if (hm.x[x1].y[y1] == 1)
	  {
	    box_crap.top = y1;
	    box_crap.bottom = y1 + 1;
	    box_crap.left = x1 + playl;	/* 20 is to compensate for the border */
	    box_crap.right = x1 + 1 + playl;
	    fill_rect (lpDDSBack, &box_crap, 1);
	  }

	if (hm.x[x1].y[y1] == 2)
	  {
	    box_crap.top = y1;
	    box_crap.bottom = y1 + 1;
	    box_crap.left = x1 + playl;	/* 20 is to compensate for the border */
	    box_crap.right = x1 + 1 + playl;
	    fill_rect (lpDDSBack, &box_crap, 128);
	  }
	if (hm.x[x1].y[y1] == 3)
	  {
	    box_crap.top = y1;
	    box_crap.bottom = y1 + 1;
	    box_crap.left = x1 + playl;	/* 20 is to compensate for the border */
	    box_crap.right = x1 + 1 + playl;
	    fill_rect (lpDDSBack, &box_crap, 45);
	  }

	if (hm.x[x1].y[y1] > 100)
	  {
	    if (pam.sprite[(hm.x[x1].y[y1]) - 100].prop == 1)
	      {
		box_crap.top = y1;
		box_crap.bottom = y1 + 1;
		box_crap.left = x1 + playl;	/* 20 is to compensate for the border */
		box_crap.right = x1 + 1 + playl;
		fill_rect (lpDDSBack, &box_crap, 20);
	      }
	    else
	      {
		box_crap.top = y1;
		box_crap.bottom = y1 + 1;
		box_crap.left = x1 + playl;	/* 20 is to compensate for the border */
		box_crap.right = x1 + 1 + playl;
		fill_rect (lpDDSBack, &box_crap, 23);
	      }
	  }
      }
  }
}


void
blit_background (void)
{
  struct rect rcRect;

  SetRect (&rcRect, 0, 0, 640, 480);

  /* lpDDSBack->BltFast (0, 0, lpDDSTwo, &rcRect, DDBLTFAST_NOCOLORKEY); */
  BltFast (lpDDSBack, 0, 0, lpDDSTwo, &rcRect);


}

void
draw_wait ()
{

  if (seq[423].frame[8] != 0)
    {

      if (please_wait)
	{
	  BltFast (lpDDSPrimary, 232, 0, k[seq[423].frame[7]].k,
		   &k[seq[423].frame[7]].box);
	  please_wait = 0;
	}
      else
	{
	  BltFast (lpDDSPrimary, 232, 0, k[seq[423].frame[8]].k,
		   &k[seq[423].frame[7]].box);
	  please_wait = 1;

	}
    }

}


int
draw_num (int mseq, char nums[50], int mx, int my)
{
  int length = 0;

  /* HRESULT ddrval; */
  int rnum = 0;
  int  i;
  for (i = 0; i < strlen (nums); i++)
    {

      if (nums[i] == '0')
	rnum = 10;
      else if (nums[i] == '1')
	rnum = 1;
      else if (nums[i] == '2')
	rnum = 2;
      else if (nums[i] == '3')
	rnum = 3;
      else if (nums[i] == '4')
	rnum = 4;
      else if (nums[i] == '5')
	rnum = 5;
      else if (nums[i] == '6')
	rnum = 6;
      else if (nums[i] == '7')
	rnum = 7;
      else if (nums[i] == '8')
	rnum = 8;
      else if (nums[i] == '9')
	rnum = 9;
      else if (nums[i] == '/')
	rnum = 11;
      /* UNREFERENCED     again: */
      if ((rnum != 11) && (!(mseq == 442)))

	BltFast (lpDDSTwo, mx + length, my, k[seq[mseq].frame[rnum]].k,
		 &k[seq[mseq].frame[rnum]].box);

      else

	BltFast (lpDDSTwo, mx + length, my, k[seq[mseq].frame[rnum]].k,
		 &k[seq[mseq].frame[rnum]].box);


      length += k[seq[mseq].frame[rnum]].box.right;
    }
  return (length);
}



void
draw_exp ()
{
  char buffer[30];
  char nums[30];
  /* UNREFERENCED   char buf[30]; */
  char final[30];

  /* Msg(("Drawing exp.. which is %d and %d",fexp, *pexp)); */
  strcpy (final, "");
  strcpy (nums, ltoa (fexp, buffer, 10));
  if (strlen (nums) < 5) {
    int i;
    for (i = 1; i < (6 - strlen (nums)); i++)
      strcat (final, "0");
  }
  strcat (final, nums);
  strcat (final, "/");

  strcpy (nums, ltoa (fraise, buffer, 10));
  if (strlen (nums) < 5) {
    int i;
    for (i = 1; i < (6 - strlen (nums)); i++)
      strcat (final, "0");
  }
  strcat (final, nums);
  draw_num (181, final, 404, 459);

}


void
draw_strength ()
{
  char final[30];
  char buffer[30];
  char nums[30];

  /* Msg(("Drawing exp.. which is %d and %d",fexp, *pexp)); */
  strcpy (final, "");

  strcpy (nums, ltoa (fstrength, buffer, 10));
  if (strlen (nums) < 3) {
    int  i;
    for (i = 1; i < (4 - strlen (nums)); i++)
      strcat (final, "0");
  }
  strcat (final, nums);
  /* Msg(("Drawing %s..",final)); */
  draw_num (182, final, 81, 415);
}


void
draw_defense ()
{
  char final[30];
  char buffer[30];
  char nums[30];

  /* Msg(("Drawing exp.. which is %d and %d",fexp, *pexp)); */
  strcpy (final, "");
  strcpy (nums, ltoa (fdefense, buffer, 10));
  if (strlen (nums) < 3) {
    int  i;
    for (i = 1; i < (4 - strlen (nums)); i++)
      strcat (final, "0");
  }
  strcat (final, nums);
  draw_num (183, final, 81, 437);
}


void
draw_magic ()
{
  char final[30];
  char buffer[30];
  char nums[30];

  /* Msg(("Drawing exp.. which is %d and %d",fexp, *pexp)); */
  strcpy (final, "");
  strcpy (nums, ltoa (fmagic, buffer, 10));
  if (strlen (nums) < 3) {
    int i;
    for (i = 1; i < (4 - strlen (nums)); i++)
      strcat (final, "0");
  }
  strcat (final, nums);
  draw_num (184, final, 81, 459);
}


void
draw_level ()
{
  char final[30];
  char buffer[30];
  /* UNREFERENCED   char nums[30]; */

  /* *plevel = 15; */
  /* Msg(("Drawing level.. which is %d ",*plevel)); */
  strcpy (final, ltoa (*plevel, buffer, 10));

  if (strlen (final) == 1)

    draw_num (442, final, 528, 456);
  else
    draw_num (442, final, 523, 456);

}


void
draw_gold ()
{
  char final[30];
  char buffer[30];
  char nums[30];

  /* Msg(("Drawing exp.. which is %d and %d",fexp, *pexp)); */
  strcpy (final, "");
  strcpy (nums, ltoa (fgold, buffer, 10));
  if (strlen (nums) < 5) {
    int i;
    for (i = 1; i < (6 - strlen (nums)); i++)
      strcat (final, "0");
  }
  strcat (final, nums);
  draw_num (185, final, 298, 457);
}


void
draw_bar (int life, int seqman)
{

  int cur = 0;
  int curx = 284;
  int cury = 412;
  int rnum = 3;
  int curx_start = curx;

  struct rect box;

  while (1)
    {
      cur++;
      if (cur > life)
	{
	  int rem;
	  cur--;
	  rem = (cur) - (cur / 10) * 10;

	  if (rem != 0)
	    {
	      CopyRect (&box, &k[seq[seqman].frame[rnum]].box);
	      /* Msg(("Drawing part bar . cur is %d", rem)); */
	      box.right = (box.right * ((rem) * 10) / 100);
	      /* woah, there is part of a bar remaining.  Lets do it. */
	      /* UNREFERENCED 	    again: */

	      BltFast (lpDDSTwo, curx, cury, k[seq[seqman].frame[rnum]].k,
		       &box);
	    }
	  /* are we done? */
	  return;
	}

      rnum = 2;
      if (cur < 11)
	rnum = 1;
      if (cur == *plifemax)
	rnum = 3;

      if ((cur / 10) * 10 == cur)
	{

	  /* UNREFERENCED 	again2: */

	  BltFast (lpDDSTwo, curx, cury, k[seq[seqman].frame[rnum]].k,
		   &k[seq[seqman].frame[rnum]].box);

	  /* if (ddrval != DD_OK) dderror(ddrval); */
	  curx += k[seq[seqman].frame[rnum]].box.right;
	  if (cur == 110)
	    {
	      cury += k[seq[seqman].frame[rnum]].box.bottom + 5;
	      curx = curx_start;

	    }

	  if (cur == 220)
	    return;
	}
    }
}


void
draw_health (void)
{
  flifemax = *plifemax;
  draw_bar (flifemax, 190);
  flife = *plife;
  draw_bar (flife, 451);
}

void
draw_icons (void)
{

  if (*pcur_weapon != 0)
    if (play.item[*pcur_weapon].active)
      {
	/* UNREFERENCED       again: */

	check_seq_status (play.item[*pcur_weapon].seq);


	BltFast (lpDDSTwo, 557, 413,
		 k[seq[play.item[*pcur_weapon].seq].
		   frame[play.item[*pcur_weapon].frame]].k,
		 &k[seq[play.item[*pcur_weapon].seq].
		    frame[play.item[*pcur_weapon].frame]].box);


      }

  if (*pcur_magic != 0)
    if (play.mitem[*pcur_magic].active)
      {

	check_seq_status (play.mitem[*pcur_magic].seq);


	/* UNREFERENCED       again2: */

	BltFast (lpDDSTwo, 153, 413,
		 k[seq[play.mitem[*pcur_magic].seq].
		   frame[play.mitem[*pcur_magic].frame]].k,
		 &k[seq[play.mitem[*pcur_magic].seq].
		    frame[play.mitem[*pcur_magic].frame]].box);

      }



}


void
draw_virtical (int percent, int mx, int my, int mseq, int mframe)
{
  int cut, full;
  struct rect myrect;

  if (percent > 25)
    percent = 25;
  percent = (percent * 4);

  CopyRect (&myrect, &k[seq[mseq].frame[mframe]].box);
  full = myrect.bottom;

  cut = (full * percent) / 100;

  myrect.bottom = cut;
  my += (full - cut);

  BltFast (lpDDSTwo, mx, my, k[seq[mseq].frame[mframe]].k, &myrect);


}

void
draw_virt2 (int percent, int mx, int my, int mseq, int mframe)
{
  int cut, full;
  struct rect myrect;

  if (percent > 25)
    percent = 25;
  percent = (percent * 4);


  CopyRect (&myrect, &k[seq[mseq].frame[mframe]].box);
  full = myrect.bottom;

  cut = (full * percent) / 100;
  myrect.bottom = cut;


  /* UNREFERENCED again: */

  BltFast (lpDDSTwo, mx, my, k[seq[mseq].frame[mframe]].k, &myrect);

}


void
draw_hor (int percent, int mx, int my, int mseq, int mframe)
{
  int cut, full;
  struct rect myrect;

  if (percent > 25)
    percent = 25;
  percent = (percent * 4);


  CopyRect (&myrect, &k[seq[mseq].frame[mframe]].box);
  full = myrect.right;

  cut = (full * percent) / 100;
  full = cut;
  myrect.right = full;
  /* UNREFERENCED again: */

  BltFast (lpDDSTwo, mx, my, k[seq[mseq].frame[mframe]].k, &myrect);

}


void
draw_hor2 (int percent, int mx, int my, int mseq, int mframe)
{
  int cut, full;
  struct rect myrect;

  if (percent > 25)
    percent = 25;
  percent = (percent * 4);

  CopyRect (&myrect, &k[seq[mseq].frame[mframe]].box);
  full = myrect.right;

  cut = (full * percent) / 100;

  myrect.right = cut;
  mx += (full - cut);


  /* UNREFERENCED again: */

  BltFast (lpDDSTwo, mx, my, k[seq[mseq].frame[mframe]].k, &myrect);

}


void
draw_mlevel (int percent)
{

  /* if (*pmagic_level < 1) return; */

  int mseq = 180;
  int bary = 6;
  int barx = 7;



  if (percent > 0)
    draw_virtical (percent, 149, 411, mseq, bary);
  percent -= 25;
  if (percent > 0)
    draw_hor (percent, 149, 409, mseq, barx);
  percent -= 25;
  if (percent > 0)
    draw_virt2 (percent, 215, 411, mseq, bary);
  percent -= 25;
  if (percent > 0)
    draw_hor2 (percent, 149, 466, mseq, barx);


}


void
draw_status_all (void)
{
  struct rect rcRect;

  rcRect.left = 0;
  rcRect.top = 0;
  rcRect.right = 640;
  rcRect.bottom = 80;

  /* UNREFERENCED again: */

  BltFast (lpDDSTwo, 0, 400, k[seq[180].frame[3]].k, &rcRect);

  rcRect.left = 0;
  rcRect.top = 0;
  rcRect.right = 20;
  rcRect.bottom = 400;
  /* UNREFERENCED again2: */

  BltFast (lpDDSTwo, 0, 0, k[seq[180].frame[1]].k, &rcRect);


  /* UNREFERENCED again3: */

  BltFast (lpDDSTwo, 620, 0, k[seq[180].frame[2]].k, &rcRect);

  fraise = next_raise ();
  fexp = *pexper;
  fstrength = *pstrength;
  fmagic = *pmagic;
  fgold = *pgold;
  fdefense = *pdefense;
  last_magic_draw = 0;
  draw_exp ();
  draw_health ();
  draw_strength ();
  draw_defense ();
  draw_magic ();
  draw_gold ();
  draw_level ();
  draw_icons ();
  if (*pmagic_cost > 0)
    if (*pmagic_level > 0)
      draw_mlevel (*pmagic_level / (*pmagic_cost / 100));
}

int
say_text (char text[200], int h, int script)
{
  int crap2;

  /* Msg(("Creating new sprite with %s connect to %d.",text, h)); */
  if (h == 1000)
    crap2 = add_sprite (100, 100, 8, 0, 0);
  else
    crap2 = add_sprite (spr[h].x, spr[h].y, 8, 0, 0);

  if (crap2 == 0)
    {
      Msg (("Couldn't say something, out of sprites."));
      return (0);

    }
  *plast_text = crap2;
  strcpy (spr[crap2].text, text);
  spr[crap2].kill = strlen (text) * TEXT_TIMER;
  if (spr[crap2].kill < TEXT_MIN)
    spr[crap2].kill = TEXT_MIN;
  spr[crap2].damage = -1;
  spr[crap2].owner = h;
  spr[crap2].hard = 1;
  spr[crap2].script = script;
  /* set X offset for text, using strength var since it's unused */
  spr[crap2].strength = 75;
  /* spr[h].x - spr[crap2; */
  spr[crap2].nohit = 1;
  check_seq_status (spr[spr[crap2].owner].seq);
  spr[crap2].defense =
    (((k[getpic (spr[crap2].owner)].box.bottom) -
      k[getpic (spr[crap2].owner)].yoffset) + 100);

  spr[crap2].x = spr[spr[crap2].owner].x - spr[crap2].strength;
  spr[crap2].y = spr[spr[crap2].owner].y - spr[crap2].defense;

  return (crap2);
}


int
say_text_xy (char text[200], int mx, int my, int script)
{
  int crap2;

  /* Msg(("Creating new sprite with %s connect to %d.",text, h)); */
  crap2 = add_sprite (mx, my, 8, 0, 0);

  if (crap2 == 0)
    {
      Msg (("Couldn't say something, out of sprites."));
      return (0);

    }
  *plast_text = crap2;
  strcpy (spr[crap2].text, text);
  spr[crap2].kill = strlen (text) * TEXT_TIMER;
  if (spr[crap2].kill < TEXT_MIN)
    spr[crap2].kill = TEXT_MIN;
  spr[crap2].damage = -1;
  spr[crap2].nohit = 1;
  spr[crap2].owner = 1000;
  spr[crap2].hard = 1;
  spr[crap2].script = script;
  return (crap2);
}

void
draw_sprite_game (SDL_Surface * lpdest, int h)
{
  struct rect box_crap, box_real;

  if (g_b_kill_app)
    return;			/* don't try, we're quitting */
  if (spr[h].brain == 8)
    return;

  if (spr[h].nodraw == 1)
    return;


  if (get_box (h, &box_crap, &box_real))

    Blt (lpdest, &box_crap, k[getpic (h)].k, &box_real);
}

void
show_bmp (char name[80], int showdot, int reserved, int script)
{
  struct rect rcRect;

  process_string (name);
  if (!exist (name))
    {
      Msg (("Error: Can't find bitmap at %s.", name));
      return;
    }

  lpDDSTrick = load_image (name, 0, 0, 0, 0);
  lpDDSTrick = load_image (name, 0, 0, 0, 0);
  showb.active = 1;
  showb.showdot = showdot;
  showb.script = script;
  abort_this_flip = 1;
  
  SetRect (&rcRect, 0, 0, 640, 480);
  /* UNREFERENCED   char msg[200]; */
  /* UNREFERENCED again: */
  BltFast (lpDDSBack, 0, 0, lpDDSTrick, &rcRect);
  flip_it_second ();
}


void
copy_bmp (char name[80])
{
  struct rect rcRect;

  if (!exist (name))
    {
      Msg (("Error: Can't find bitmap at %s.", name));
      return;
    }
  
  lpDDSTrick = load_image (name, 0, 0, 0, 0);

  lpDDSTrick = load_image (name, 0, 0, 0, 0);
  abort_this_flip = 1;

  SetRect (&rcRect, 0, 0, 640, 480);
  /* UNREFERENCED   char msg[200]; */
  /* UNREFERENCED vagain: */
  BltFast (lpDDSBack, 0, 0, lpDDSTrick, &rcRect);
  /* UNREFERENCED again1: */
  BltFast (lpDDSTwo, 0, 0, lpDDSTrick, &rcRect);
  flip_it_second ();
}

void
draw_map_game (void)
{
  struct rect rcRect;
  int pa, cool, x;
  /* UNREFERENCED int crap; */
  *pvision = 0;

  while (kill_last_sprite ());
  kill_repeat_sounds ();
  kill_all_scripts ();

  for (x = 0; x < 96; x++)
    {
      cool = pam.t[x].num / 128;
      pa = pam.t[x].num - (cool * 128);
      rcRect.left = (pa * 50 - (pa / 12) * 600);
      rcRect.top = (pa / 12) * 50;
      rcRect.right = rcRect.left + 50;
      rcRect.bottom = rcRect.top + 50;

      BltFast (lpDDSTwo, (x * 50 - ((x / 12) * 600)) + playl, (x / 12) * 50,
	       tiles[cool + 1], &rcRect);
    }

  if (strlen (pam.script) > 1)
    {
      int ms = load_script (pam.script, 0, 1);
      if (ms > 0)
	{
	  locate (ms, "main");
	  no_running_main = 1;
	  run_script (ms);
	  no_running_main = 0;
	}
    }
  place_sprites_game ();

  /* lets add the sprites hardness to the real hardness, adding it's own uniqueness to our collective. */
  /* if script for overall screen, run it */
  /* Msg(("Done loading screen.")); */
  /* thisTickCount = GetTickCount (); */
  thisTickCount = SDL_GetTicks ();
  init_scripts ();
}


void
draw_map_game_background (void)
{
  struct rect rcRect;
  int pa, cool, x;
  /* UNREFERENCED int crap; */

  for (x = 0; x < 96; x++)
    {
      cool = pam.t[x].num / 128;
      pa = pam.t[x].num - (cool * 128);
      rcRect.left = (pa * 50 - (pa / 12) * 600);
      rcRect.top = (pa / 12) * 50;
      rcRect.right = rcRect.left + 50;
      rcRect.bottom = rcRect.top + 50;

      BltFast (lpDDSTwo, (x * 50 - ((x / 12) * 600)) + playl, (x / 12) * 50,
	       tiles[cool + 1], &rcRect);
    }
  place_sprites_game_background ();
}

void
fill_screen (int num)
{
  fill_rect (lpDDSTwo, NULL, num);
}

void
fill_hard_sprites (void)
{
  /* UNREFERENCED   int sprite; */
  BOOL bs[MAX_SPRITES_AT_ONCE];
  int rank[MAX_SPRITES_AT_ONCE];
  int highest_sprite;
  int h;
  int r1, j;

  /* UNREFERENCED   int hs; */
  /* Msg(("filling sprite hardness...")); */

  int max_s = last_sprite_created;
  int height;
  memset (&bs, 0, sizeof (bs));

  for (r1 = 1; r1 <= max_s; r1++)
    {
      int h1;
      highest_sprite = 22024;	/* more than it could ever be */
      rank[r1] = 0;
      for (h1 = 1; h1 < max_s + 1; h1++)
	{
	  if (spr[h1].active)
	    {
	      if (bs[h1] == 0)
		{
		  /* Msg(( "Ok,  %d is %d", h1,(spr[h1].y + k[spr[h1].pic].yoffset) )); */
		  if (spr[h1].que != 0)
		    height = spr[h1].que;
		  else
		    height = spr[h1].y;
		  if (height < highest_sprite)
		    {
		      highest_sprite = height;
		      rank[r1] = h1;
		    }
		}
	    }
	}
      if (rank[r1] != 0)
	bs[rank[r1]] = 1;
    }

  for (j = 1; j <= max_s; j++)
    {
      h = rank[j];
      if (h > 0)
	if (spr[h].active)
	  {
	    /* Msg(("proccesing sprite %d", h)); */
	    if (spr[h].sp_index != 0)
	      {
		/* Msg(("has spindex of %d prop is %d",spr[h].sp_index,pam.sprite[spr[h].sp_index].prop)); */
		if (pam.sprite[spr[h].sp_index].hard == 0)
		  {

		    add_hardness (h, 100 + spr[h].sp_index);
		    /* Msg(("added warp hardness for %d", spr[h].sp_index)); */
		  }
	      }
	    else
	      {
		if (spr[h].hard == 0)
		  {
		    /* Msg(("adding a new sprite hardness %d (not from editor)", h)); */
		    add_hardness (h, 1);
		  }
	      }
	  }
    }
}
