/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class PSpiceOut
extends Input<Stimuli> {
    PSpiceOut() {
        super(null);
    }

    @Override
    protected Stimuli processInput(URL fileURL, Cell cell, Stimuli sd) throws IOException {
        sd.setNetDelimiter(" ");
        if (this.openTextInput(fileURL)) {
            return sd;
        }
        System.out.println("Reading PSpice output file: " + fileURL.getFile());
        PSpiceOut.startProgressDialog("PSpice output", fileURL.getFile());
        this.readPSpiceFile(cell, sd);
        PSpiceOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private void readPSpiceFile(Cell cell, Stimuli sd) throws IOException {
        int i;
        String line;
        boolean first = true;
        SignalCollection sc = Stimuli.newSignalCollection(sd, "SIGNALS");
        sd.setCell(cell);
        ArrayList<String> signalNames = new ArrayList<String>();
        List[] values = null;
        int numSignals = 0;
        while ((line = this.getLine()) != null) {
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a SPICE3/PSPICE file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return;
                }
                int ptr = 0;
                while (true) {
                    if (ptr < line.length() && Character.isWhitespace(line.charAt(ptr))) {
                        ++ptr;
                        continue;
                    }
                    if (ptr >= line.length()) break;
                    int start = ptr;
                    while (ptr < line.length() && !Character.isWhitespace(line.charAt(ptr))) {
                        ++ptr;
                    }
                    signalNames.add(line.substring(start, ptr));
                }
                numSignals = signalNames.size();
                values = new List[numSignals];
                for (i = 0; i < numSignals; ++i) {
                    values[i] = new ArrayList();
                }
                continue;
            }
            int equalPos = line.indexOf("=");
            if (equalPos >= 0) {
                if (line.length() > equalPos + 3) {
                    line = line.substring(equalPos + 3);
                } else {
                    System.out.println("Missing value after '='.  This may not be a PSpice output file.");
                    return;
                }
            }
            int ptr = 0;
            int position = 0;
            while (true) {
                if (ptr < line.length() && Character.isWhitespace(line.charAt(ptr))) {
                    ++ptr;
                    continue;
                }
                if (ptr >= line.length() || line.charAt(ptr) == ')') break;
                int start = ptr;
                while (ptr < line.length() && !Character.isWhitespace(line.charAt(ptr))) {
                    ++ptr;
                }
                double value = TextUtils.atof(line.substring(start, ptr));
                values[position++].add(new Double(value));
            }
            if (position == numSignals) continue;
            System.out.println("Line of data has " + position + " values, but expect " + numSignals + ". Unable to recover from error.  This may not be a PSpice output file.");
            return;
        }
        if (numSignals == 0) {
            System.out.println("No data found in the file.  This may not be a PSpice output file.");
            return;
        }
        int numEvents = values[0].size();
        double[] time = new double[numEvents];
        for (i = 0; i < numEvents; ++i) {
            time[i] = (Double)values[0].get(i);
        }
        for (int j = 1; j < numSignals; ++j) {
            double[] doubleValues = new double[numEvents];
            for (int i2 = 0; i2 < numEvents; ++i2) {
                doubleValues[i2] = (Double)values[j].get(i2);
            }
            ScalarSample.createSignal(sc, sd, (String)signalNames.get(j), null, time, doubleValues);
        }
    }
}

