/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output;

import com.sun.electric.Main;
import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.LibraryBackup;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.constraint.Constraints;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.LibId;
import com.sun.electric.database.text.Version;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.Listener;
import com.sun.electric.tool.Tool;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.io.IOTool;
import com.sun.electric.tool.io.output.CIF;
import com.sun.electric.tool.io.output.DELIB;
import com.sun.electric.tool.io.output.DFTM;
import com.sun.electric.tool.io.output.DXF;
import com.sun.electric.tool.io.output.ECAD;
import com.sun.electric.tool.io.output.EDIF;
import com.sun.electric.tool.io.output.ELIB;
import com.sun.electric.tool.io.output.Eagle;
import com.sun.electric.tool.io.output.FastHenry;
import com.sun.electric.tool.io.output.GDS;
import com.sun.electric.tool.io.output.Gerber;
import com.sun.electric.tool.io.output.HPGL;
import com.sun.electric.tool.io.output.IRSIM;
import com.sun.electric.tool.io.output.JELIB;
import com.sun.electric.tool.io.output.L;
import com.sun.electric.tool.io.output.LEF;
import com.sun.electric.tool.io.output.MOSSIM;
import com.sun.electric.tool.io.output.Maxwell;
import com.sun.electric.tool.io.output.PAL;
import com.sun.electric.tool.io.output.Pads;
import com.sun.electric.tool.io.output.PostScript;
import com.sun.electric.tool.io.output.ReadableDump;
import com.sun.electric.tool.io.output.STL;
import com.sun.electric.tool.io.output.SVG;
import com.sun.electric.tool.io.output.Silos;
import com.sun.electric.tool.io.output.Sim;
import com.sun.electric.tool.io.output.Spice;
import com.sun.electric.tool.io.output.Tegas;
import com.sun.electric.tool.io.output.Telesis;
import com.sun.electric.tool.io.output.Verilog;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutput;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.User;
import com.sun.electric.util.TextUtils;
import java.awt.geom.Rectangle2D;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.SwingUtilities;

public class Output {
    protected String filePath;
    protected PrintWriter printWriter;
    protected StringWriter stringWriter;
    protected DataOutputStream dataOutputStream;
    protected boolean quiet;
    protected ErrorLogger errorLogger;
    private int lineCharCount = 0;
    private int maxWidth = 80;
    private boolean strictWidthLimit = false;
    private String continuationString = "";

    public static void exportCellCommand(Cell cell, VarContext context, String fileP, FileType type, List<PolyBase> override) {
        new OutputCellInfo(cell, context, fileP, type, override);
    }

    public static OutputPreferences getOutputPreferences(FileType type, Cell cell, boolean factory, List<PolyBase> override) {
        if (!(factory || SwingUtilities.isEventDispatchThread() || Main.isBatch())) {
            throw new IllegalStateException("Current default Prefs can be accessed only from client thread");
        }
        if (type == FileType.CDL) {
            return new Spice.SpicePreferences(factory, true);
        }
        if (type == FileType.CIF) {
            return new CIF.CIFPreferences(factory, cell);
        }
        if (type == FileType.COSMOS || type == FileType.ESIM || type == FileType.RSIM) {
            return new Sim.SimPreferences(factory, type);
        }
        if (type == FileType.DFTM) {
            return new DFTM.DFTMPreferences(factory);
        }
        if (type == FileType.DXF) {
            return new DXF.DXFPreferences(factory);
        }
        if (type == FileType.STL) {
            return new STL.STLPreferences(factory);
        }
        if (type == FileType.EAGLE) {
            return new Eagle.EaglePreferences(factory);
        }
        if (type == FileType.ECAD) {
            return new ECAD.ECADPreferences(factory);
        }
        if (type == FileType.EDIF) {
            return new EDIF.EDIFPreferences(factory);
        }
        if (type == FileType.FASTHENRY) {
            return new FastHenry.FastHenryPreferences(factory);
        }
        if (type == FileType.GERBER) {
            return new Gerber.GerberPreferences(factory);
        }
        if (type == FileType.HPGL) {
            return new HPGL.HPGLPreferences(factory, cell);
        }
        if (type == FileType.GDS) {
            return new GDS.GDSPreferences(factory);
        }
        if (type == FileType.IRSIM) {
            return new IRSIM.IRSIMPreferences(factory);
        }
        if (type == FileType.L) {
            return new L.LPreferences(factory);
        }
        if (type == FileType.LEF) {
            return new LEF.LEFPreferences(factory);
        }
        if (type == FileType.MAXWELL) {
            return new Maxwell.MaxwellPreferences(factory);
        }
        if (type == FileType.MOSSIM) {
            return new MOSSIM.MOSSIMPreferences(factory);
        }
        if (type == FileType.PADS) {
            return new Pads.PadsPreferences(factory);
        }
        if (type == FileType.PAL) {
            return new PAL.PALPreferences(factory);
        }
        if (type == FileType.POSTSCRIPT || type == FileType.EPS) {
            return new PostScript.PostScriptPreferences(factory, override, cell);
        }
        if (type == FileType.SILOS) {
            return new Silos.SilosPreferences(factory);
        }
        if (type == FileType.SKILL) {
            return new IOTool.SkillPreferences(factory, false, cell);
        }
        if (type == FileType.SKILLEXPORTSONLY) {
            return new IOTool.SkillPreferences(factory, true, cell);
        }
        if (type == FileType.SPICE) {
            return new Spice.SpicePreferences(factory, false);
        }
        if (type == FileType.SVG) {
            return new SVG.SVGPreferences(factory, cell);
        }
        if (type == FileType.TEGAS) {
            return new Tegas.TegasPreferences(factory);
        }
        if (type == FileType.VERILOG) {
            return new Verilog.VerilogPreferences(factory, false);
        }
        if (type == FileType.VERILOGA) {
            return new Verilog.VerilogPreferences(factory, true);
        }
        if (type == FileType.BOOKSHELF) {
            return new BookshelfOutput.BookshelfOutputPreferences(factory);
        }
        if (type == FileType.TELESIS) {
            return new Telesis.TelesisPreferences(factory);
        }
        return null;
    }

    public Output() {
        String classPath = this.getClass().getName();
        int lastDot = classPath.lastIndexOf(46);
        if (lastDot >= 0) {
            classPath = classPath.substring(lastDot + 1);
        }
        this.errorLogger = ErrorLogger.newInstance(classPath + " Output");
    }

    public int getNumErrors() {
        return this.errorLogger.getNumErrors();
    }

    public int getNumWarnings() {
        return this.errorLogger.getNumWarnings();
    }

    protected boolean writeCell(Cell cell, VarContext context) {
        return true;
    }

    public static boolean writePanicSnapshot(Snapshot panicSnapshot, File panicDir, boolean oldRevision) {
        FileType type = FileType.JELIB;
        HashMap<LibId, URL> libFiles = new HashMap<LibId, URL>();
        TreeMap<String, LibId> sortedLibs = new TreeMap<String, LibId>(TextUtils.STRING_NUMBER_ORDER);
        for (LibraryBackup libBackup : panicSnapshot.libBackups) {
            File newLibFile;
            if (libBackup == null || (libBackup.d.flags & 0x80) != 0) continue;
            LibId libId = libBackup.d.libId;
            String libName = libBackup.d.libId.libName;
            URL libURL = libBackup.d.libFile;
            if (libURL == null || libURL.getPath() == null) {
                newLibFile = new File(panicDir.getAbsolutePath(), libName + "." + type.getFirstExtension());
            } else {
                File libFile = new File(libURL.getPath());
                String fileName = libFile.getName();
                if (fileName == null) {
                    fileName = libName + "." + type.getFirstExtension();
                }
                newLibFile = new File(panicDir.getAbsolutePath(), fileName);
            }
            URL newLibURL = TextUtils.makeURLToFile(newLibFile.getAbsolutePath());
            libFiles.put(libId, newLibURL);
            sortedLibs.put(libName, libId);
        }
        boolean error = false;
        if (oldRevision) {
            IdMapper idMapper = IdMapper.consolidateExportIds(panicSnapshot);
            panicSnapshot = panicSnapshot.withRenamedIds(idMapper, null, null);
        }
        for (LibId libId : sortedLibs.values()) {
            System.out.print(".");
            System.out.flush();
            JELIB jelib = new JELIB();
            URL libURL = (URL)libFiles.get(libId);
            String properOutputName = TextUtils.getFilePath(libURL) + TextUtils.getFileNameWithoutExtension(libURL) + ".jelib";
            if (!jelib.openTextOutputStream(properOutputName) && !jelib.writeLib(panicSnapshot, libId, libFiles, oldRevision) && !jelib.closeTextOutputStream()) continue;
            System.out.println("Error saving " + panicSnapshot.getLib((LibId)libId).d.libId.libName);
            error = true;
        }
        System.out.println(" Libraries saved");
        return error;
    }

    public static boolean saveJelib(String newName, Library lib) {
        HashMap<LibId, URL> libFiles = new HashMap<LibId, URL>();
        URL libURL = lib.getLibFile();
        if (newName != null) {
            libURL = TextUtils.makeURLToFile(newName);
            libFiles.put(lib.getId(), libURL);
        }
        boolean error = false;
        JELIB jelib = new JELIB();
        String properOutputName = TextUtils.getFilePath(libURL) + TextUtils.getFileNameWithoutExtension(libURL) + ".jelib";
        if (jelib.openTextOutputStream(properOutputName) || jelib.writeLib(lib.getDatabase().backup(), lib.getId(), libFiles, false) || jelib.closeTextOutputStream()) {
            System.out.println("Error saving " + lib.getName());
            error = true;
        }
        return error;
    }

    public static void writeLibrary(Library lib, FileType type, boolean compatibleWith6, boolean thisQuiet, boolean delibHeaderOnly, int backupScheme) throws JobException {
        Output.writeLibrary(lib, type, compatibleWith6, thisQuiet, delibHeaderOnly, backupScheme, null, null);
    }

    public static void writeLibrary(Library lib, FileType type, boolean compatibleWith6, boolean thisQuiet, boolean delibHeaderOnly, int backupScheme, List<String> deletedCellFiles, List<String> writtenCellFiles) throws JobException {
        String properOutputName;
        LibId libId;
        Snapshot snapshot;
        block36: {
            File newFile;
            String properOutputNameWithoutExtension;
            block37: {
                Iterator<Listener> it = Tool.getListeners();
                while (it.hasNext()) {
                    Listener listener = it.next();
                    listener.writeLibrary(lib);
                }
                snapshot = lib.getDatabase().backup();
                libId = lib.getId();
                URL libFile = lib.getLibFile();
                if (libFile == null) {
                    libFile = TextUtils.makeURLToFile(lib.getName());
                }
                File f2 = new File(libFile.getPath());
                String fullOutputName = TextUtils.decodeString(f2.getAbsolutePath());
                properOutputNameWithoutExtension = TextUtils.getFilePath(libFile) + TextUtils.getFileNameWithoutExtension(libFile);
                properOutputName = fullOutputName;
                if (properOutputNameWithoutExtension.equals(fullOutputName)) {
                    if (type == FileType.ELIB) {
                        properOutputName = properOutputNameWithoutExtension + ".elib";
                    }
                    if (type == FileType.JELIB) {
                        properOutputName = properOutputNameWithoutExtension + ".jelib";
                    }
                    if (type == FileType.DELIB) {
                        properOutputName = properOutputNameWithoutExtension + ".delib";
                    }
                    if (type == FileType.READABLEDUMP) {
                        properOutputName = properOutputNameWithoutExtension + ".txt";
                    }
                }
                if (type != FileType.ELIB && type != FileType.JELIB && type != FileType.DELIB) break block36;
                if (backupScheme != 1) break block37;
                newFile = new File(properOutputName);
                if (!newFile.exists()) break block36;
                String backupFileName = properOutputName + "~";
                File oldFile = new File(backupFileName);
                boolean canRename = true;
                if (oldFile.exists() && !oldFile.delete()) {
                    System.out.println("Unable to delete former library file " + oldFile);
                    canRename = false;
                }
                if (canRename && !newFile.renameTo(oldFile)) {
                    System.out.println("Unable to rename " + newFile + " to " + oldFile);
                }
                break block36;
            }
            if (backupScheme == 2 && (newFile = new File(properOutputName)).exists()) {
                long modified = newFile.lastModified();
                Date modifiedDate = new Date(modified);
                SimpleDateFormat sdf = new SimpleDateFormat("-yyyy-MM-dd");
                for (int i = 0; i < 1000; ++i) {
                    File oldFile;
                    String backupFileName = properOutputNameWithoutExtension + sdf.format(modifiedDate);
                    if (i != 0) {
                        backupFileName = backupFileName + "--" + i;
                    }
                    if ((oldFile = new File(backupFileName = backupFileName + "." + type.getFirstExtension())).exists()) continue;
                    if (newFile.renameTo(oldFile)) break;
                    System.out.println("Unable to rename " + newFile + " to " + oldFile);
                    break;
                }
            }
        }
        if (type == FileType.ELIB || type == FileType.JELIB) {
            if (type == FileType.ELIB) {
                ELIB elib = new ELIB();
                elib.quiet = thisQuiet;
                if (compatibleWith6) {
                    elib.write6Compatible();
                }
                if (elib.openBinaryOutputStream(properOutputName)) {
                    throw new JobException("elib.openBinaryOutputStream() failed");
                }
                if (elib.writeLib(snapshot, libId)) {
                    throw new JobException("elib.writeLib() failed");
                }
                if (elib.closeBinaryOutputStream()) {
                    throw new JobException("elib.closeBinaryOutputStream() failed");
                }
            } else {
                JELIB jelib = new JELIB();
                jelib.quiet = thisQuiet;
                if (jelib.openTextOutputStream(properOutputName)) {
                    throw new JobException("jelib.openTextOutputStream() failed");
                }
                if (jelib.writeLib(snapshot, libId, null, false)) {
                    throw new JobException("jelib.writeLib() failed");
                }
                if (jelib.closeTextOutputStream()) {
                    throw new JobException("jelib.closeTextOutputStream() failed");
                }
            }
        } else if (type == FileType.READABLEDUMP) {
            ReadableDump readableDump = new ReadableDump();
            readableDump.quiet = thisQuiet;
            if (readableDump.openTextOutputStream(properOutputName)) {
                throw new JobException("readableDump.openTextOutputStream() failed");
            }
            if (readableDump.writeLib(snapshot, libId)) {
                throw new JobException("readableDump.writeLib() failed");
            }
            if (readableDump.closeTextOutputStream()) {
                throw new JobException("readableDump.closeTextOutputStream() failed");
            }
        } else if (type == FileType.DELIB) {
            DELIB delib = new DELIB(delibHeaderOnly);
            delib.quiet = thisQuiet;
            if (delib.openTextOutputStream(properOutputName)) {
                throw new JobException("delib.openTextOutputStream() failed");
            }
            Set<CellId> oldCells = lib.getDelibCells();
            if (delib.writeLib(snapshot, libId, oldCells)) {
                throw new JobException("delib.writeLib() failed");
            }
            lib.setDelibCells();
            if (delib.closeTextOutputStream()) {
                throw new JobException("delib.closeTextOutputStream() failed");
            }
            if (deletedCellFiles != null) {
                deletedCellFiles.addAll(delib.getDeletedCellFiles());
            }
            if (writtenCellFiles != null) {
                writtenCellFiles.addAll(delib.getWrittenCellFiles());
            }
        } else {
            throw new JobException("Unknown export type: " + type);
        }
        lib.setFromDisk();
        if (!thisQuiet) {
            System.out.println(properOutputName + " written");
        }
        lib.setVersion(Version.getVersion());
        lib.clearChanged();
        Constraints.getCurrent().writeLibrary(lib);
    }

    String diskName(ElectricObject owner, Variable var) {
        String portName = null;
        if (owner instanceof PortInst) {
            PortInst pi = (PortInst)owner;
            portName = pi.getPortProto().getName();
        }
        return this.diskName(portName, var);
    }

    String diskName(String portName, Variable var) {
        if (portName == null) {
            return var.getKey().getName();
        }
        StringBuffer sb = new StringBuffer("ATTRP_");
        for (int i = 0; i < portName.length(); ++i) {
            char ch = portName.charAt(i);
            if (ch == '\\' || ch == '_') {
                sb.append('\\');
            }
            sb.append(ch);
        }
        sb.append('_');
        sb.append(var.getKey().getName());
        return sb.toString();
    }

    protected boolean openBinaryOutputStream(String filePath) {
        FileOutputStream fileOutputStream;
        this.filePath = filePath;
        try {
            fileOutputStream = new FileOutputStream(filePath);
        }
        catch (FileNotFoundException e) {
            System.out.println("Could not write file " + filePath);
            System.out.println("Reason: " + e.getMessage());
            return true;
        }
        BufferedOutputStream bufStrm = new BufferedOutputStream(fileOutputStream);
        this.dataOutputStream = new DataOutputStream(bufStrm);
        return false;
    }

    protected boolean closeBinaryOutputStream() {
        try {
            this.dataOutputStream.close();
        }
        catch (IOException e) {
            System.out.println("Error closing " + this.filePath);
            return true;
        }
        return false;
    }

    protected boolean openTextOutputStream(String fileP) {
        this.filePath = fileP;
        try {
            URL fileURL = TextUtils.makeURLToFile(fileP);
            this.printWriter = new PrintWriter(new BufferedWriter(new FileWriter(TextUtils.getFile(fileURL))));
        }
        catch (IOException e) {
            this.reportError("Error opening " + fileP + ": " + e.getMessage());
            return true;
        }
        return false;
    }

    protected boolean closeTextOutputStream() {
        this.printWriter.close();
        return false;
    }

    protected void openStringsOutputStream() {
        this.stringWriter = new StringWriter();
    }

    protected List<String> closeStringsOutputStream() {
        StringBuffer sb = this.stringWriter.getBuffer();
        String[] lines2 = sb.toString().split("\n");
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < lines2.length; ++i) {
            strings.add(lines2[i]);
        }
        return strings;
    }

    protected Output finishWrite() {
        this.errorLogger.termLogging(true);
        return this;
    }

    protected void reportWarning(String msg) {
        this.errorLogger.logWarning(msg, null, -1);
        System.out.println(msg);
    }

    public void reportError(String msg) {
        this.errorLogger.logError(msg, -1);
        System.out.println(msg);
    }

    protected void emitCopyright(String prefix, String postfix) {
        if (!IOTool.isUseCopyrightMessage()) {
            return;
        }
        String str = IOTool.getCopyrightMessage();
        int start = 0;
        while (start < str.length()) {
            int endPos = str.indexOf(10, start);
            if (endPos < 0) {
                endPos = str.length();
            }
            String oneLine = str.substring(start, endPos);
            this.writeChunk(prefix + oneLine + postfix + "\n");
            start = endPos + 1;
        }
    }

    protected void setOutputWidth(int width, boolean strict) {
        this.maxWidth = width;
        this.strictWidthLimit = strict;
    }

    protected void setContinuationString(String str) {
        this.continuationString = str;
    }

    private void writeChunk(String str) {
        int len = str.length();
        if (len <= 0) {
            return;
        }
        if (this.printWriter != null) {
            this.printWriter.print(str);
        } else if (this.stringWriter != null) {
            this.stringWriter.write(str);
        }
        this.lineCharCount += len;
        if (str.charAt(len - 1) == '\n') {
            this.lineCharCount = 0;
        }
    }

    protected void writeWidthLimited(String str) {
        int len;
        while ((len = str.length()) > 0) {
            int i = str.indexOf(10);
            i = i < 0 ? len : ++i;
            if (this.lineCharCount + i < this.maxWidth) {
                String chunk = str;
                if (i < len) {
                    chunk = str.substring(0, i);
                }
                this.writeChunk(chunk);
                if ((str = str.substring(i)).length() != 0) continue;
                break;
            }
            String exact = str.substring(0, this.maxWidth - this.lineCharCount);
            int splitPos = exact.lastIndexOf(32);
            if (splitPos < 0) {
                int semiPos;
                int closePos;
                int openPos;
                int commaPos = exact.lastIndexOf(44);
                if (commaPos > splitPos) {
                    splitPos = commaPos;
                }
                if ((openPos = exact.lastIndexOf(40)) > splitPos) {
                    splitPos = openPos;
                }
                if ((closePos = exact.lastIndexOf(41)) > splitPos) {
                    splitPos = closePos;
                }
                if ((semiPos = exact.lastIndexOf(59)) > splitPos) {
                    splitPos = semiPos;
                }
                if (splitPos < 0) {
                    splitPos = exact.length() - 1;
                    if (!this.strictWidthLimit) {
                        splitPos = str.length() - 1;
                        int spacePos = str.indexOf(32);
                        if (spacePos >= 0 && spacePos < splitPos) {
                            splitPos = spacePos;
                        }
                        if ((commaPos = str.indexOf(44)) >= 0 && commaPos < splitPos) {
                            splitPos = commaPos;
                        }
                        if ((openPos = str.indexOf(40)) >= 0 && openPos < splitPos) {
                            splitPos = openPos;
                        }
                        if ((closePos = str.indexOf(41)) >= 0 && closePos < splitPos) {
                            splitPos = closePos;
                        }
                        if ((semiPos = str.indexOf(59)) >= 0 && semiPos < splitPos) {
                            splitPos = semiPos;
                        }
                    }
                }
            }
            while (splitPos + 1 < str.length() && str.charAt(splitPos + 1) == '\n') {
                ++splitPos;
            }
            exact = str.substring(0, splitPos + 1);
            this.writeChunk(exact);
            if (!exact.endsWith("\n")) {
                this.writeChunk("\n");
                if (this.continuationString.length() > 0) {
                    this.writeChunk(this.continuationString);
                }
            }
            str = str.substring(exact.length());
        }
    }

    public static Rectangle2D getAreaToPrint(Cell cell, boolean reduce2, EditWindow_ wnd) {
        ERectangle cb = cell.getBounds();
        Rectangle2D bounds = new Rectangle2D.Double(cb.getMinX(), cb.getMinY(), cb.getWidth(), cb.getHeight());
        if (wnd != null) {
            bounds = wnd.getBoundsInWindow();
        }
        if (reduce2) {
            double wid = bounds.getWidth() * 0.75;
            double hei = bounds.getHeight() * 0.75;
            bounds.setRect(bounds.getCenterX(), bounds.getCenterY(), wid, hei);
        }
        if (IOTool.getPlotArea() != 0) {
            if (wnd == null) {
                System.out.println("No current window: printing entire cell");
            } else if (IOTool.getPlotArea() == 2) {
                bounds = wnd.getDisplayedBounds();
            } else {
                Rectangle2D hBounds = wnd.getHighlightedArea();
                if (hBounds == null || hBounds.getWidth() == 0.0 || hBounds.getHeight() == 0.0) {
                    System.out.println("Warning: no highlighted area; printing entire cell");
                } else {
                    bounds = hBounds;
                }
            }
        }
        return bounds;
    }

    public static class WriteJELIB
    extends Job {
        private Library lib;
        private String newName;
        private IdMapper idMapper;
        private int backupScheme;

        public WriteJELIB(Library lib, String newName) {
            super("Write " + lib, User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.lib = lib;
            this.newName = newName;
            this.backupScheme = IOTool.getBackupRedundancy();
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            try {
                if (this.newName != null) {
                    URL libURL = TextUtils.makeURLToFile(this.newName);
                    this.lib.setLibFile(libURL);
                    this.idMapper = this.lib.setName(TextUtils.getFileNameWithoutExtension(libURL));
                    if (this.idMapper != null) {
                        this.lib = EDatabase.serverDatabase().getLib(this.idMapper.get(this.lib.getId()));
                    }
                }
                this.fieldVariableChanged("idMapper");
            }
            catch (Exception e) {
                throw new JobException("Exception caught when saving library: " + e.getMessage());
            }
            Output.writeLibrary(this.lib, FileType.JELIB, false, false, false, this.backupScheme);
            return false;
        }

        @Override
        public void terminateOK() {
            User.fixStaleCellReferences(this.idMapper);
        }
    }

    public static abstract class OutputPreferences
    implements Serializable {
        public boolean useCopyrightMessage = IOTool.isUseCopyrightMessage();
        public boolean includeDateAndVersionInOutput = User.isIncludeDateAndVersionInOutput();

        protected OutputPreferences() {
            this(false);
        }

        protected OutputPreferences(boolean factory) {
            if (!(factory || SwingUtilities.isEventDispatchThread() || Main.isBatch())) {
                throw new IllegalStateException("Current default Prefs can be accessed only from client thread");
            }
        }

        public Output doOutput(Cell cell, VarContext context, String filePath, EditingPreferences ep) {
            return this.doOutput(cell, context, filePath);
        }

        public abstract Output doOutput(Cell var1, VarContext var2, String var3);
    }

    private static class OutputCellInfo
    extends Job {
        private Cell cell;
        private VarContext context;
        private String filePath;
        private OutputPreferences prefs;

        public OutputCellInfo(Cell cell, VarContext context, String filePath, FileType type, List<PolyBase> override) {
            super("Export " + cell + " (" + type + ")", IOTool.getIOTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.context = context;
            this.filePath = filePath;
            this.prefs = Output.getOutputPreferences(type, cell, false, override);
            if (this.prefs != null) {
                this.startJob();
            }
        }

        @Override
        public boolean doIt() throws JobException {
            this.prefs.doOutput(this.cell, this.context, this.filePath, this.getEditingPreferences());
            return true;
        }
    }

    static class NetNamesSort
    implements Comparator<NetNames> {
        NetNamesSort() {
        }

        @Override
        public int compare(NetNames nn1, NetNames nn2) {
            String name1 = nn1.netName;
            String name2 = nn2.netName;
            return name1.compareToIgnoreCase(name2);
        }
    }

    static class NetNames {
        String nodeName;
        String netName;
        String portName;

        NetNames() {
        }
    }
}

