/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;

public class LibDirs {
    private static String libDirsFile = "LIBDIRS";
    private static ArrayList<String> dirs = new ArrayList();
    private static ArrayList<String> libDirsFiles = new ArrayList();

    LibDirs() {
    }

    public static synchronized Iterator<String> getLibDirs() {
        ArrayList<String> list2 = new ArrayList<String>(dirs);
        return list2.iterator();
    }

    public static synchronized boolean readLibDirs(String dir) {
        if (dir == null) {
            return true;
        }
        String libDirFile = dir + File.separator + libDirsFile;
        boolean error = false;
        dirs.clear();
        libDirsFiles.clear();
        if (LibDirs.parseFile(libDirFile)) {
            error = true;
        }
        return error;
    }

    private static boolean parseFile(String fileName) {
        if (fileName == null) {
            return true;
        }
        BufferedReader in = null;
        File file = new File(fileName);
        try {
            FileReader fr = new FileReader(file);
            in = new BufferedReader(fr);
        }
        catch (FileNotFoundException e) {
            return true;
        }
        libDirsFiles.add(file.getAbsolutePath());
        boolean error = false;
        int lineNumber = 0;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (!LibDirs.parseLine(line, file)) continue;
                System.out.println("Parse error: " + fileName + ":" + lineNumber);
                error = true;
                ++lineNumber;
            }
            in.close();
        }
        catch (IOException e) {
            error = true;
        }
        return error;
    }

    private static boolean parseLine(String line, File libdirFile) {
        String[] words = (line = line.trim()).split("\\s+");
        if (words.length <= 0) {
            return false;
        }
        if (words[0].equals("*")) {
            return false;
        }
        if (words[0].equals("include")) {
            if (words.length != 2) {
                return true;
            }
            File f2 = new File(words[1]);
            if (libDirsFiles.contains(f2.getAbsolutePath())) {
                return true;
            }
            return LibDirs.parseFile(words[1]);
        }
        String dir = words[0];
        if (dir.startsWith(".")) {
            dir = libdirFile.getParentFile().getAbsolutePath() + File.separator + dir;
        }
        dirs.add(dir);
        return false;
    }

    public static LibDirFileSystemView newLibDirFileSystemView(FileSystemView osView) {
        return new LibDirFileSystemView(osView);
    }

    public static class LibDirFileView
    extends FileView {
        private LibDirFileSystemView view;

        public LibDirFileView(LibDirFileSystemView view) {
            this.view = view;
        }

        @Override
        public String getName(File f2) {
            if (f2 == null) {
                return null;
            }
            if (this.view.isLibFile(f2)) {
                return f2.getName() + " [REF]";
            }
            return null;
        }
    }

    public static class LibDirFileSystemView
    extends FileSystemView {
        private final FileSystemView osView;
        private final HashMap<String, File> libFiles;

        public LibDirFileSystemView(FileSystemView osView) {
            this.osView = osView;
            this.libFiles = new HashMap();
        }

        @Override
        public File createFileObject(File dir, String filename) {
            return this.osView.createFileObject(dir, filename);
        }

        @Override
        public File createFileObject(String path) {
            return this.osView.createFileObject(path);
        }

        @Override
        protected File createFileSystemRoot(File f2) {
            throw new Error("Unsupported operation");
        }

        @Override
        public File createNewFolder(File containingDir) throws IOException {
            return this.osView.createNewFolder(containingDir);
        }

        @Override
        public File getChild(File parent, String fileName) {
            return this.osView.getChild(parent, fileName);
        }

        @Override
        public File getDefaultDirectory() {
            return this.osView.getDefaultDirectory();
        }

        @Override
        public synchronized File[] getFiles(File dir, boolean useFileHiding) {
            File[] usual = this.osView.getFiles(dir, useFileHiding);
            this.libFiles.clear();
            if (LibDirs.readLibDirs(dir.getPath())) {
                return usual;
            }
            ArrayList<File> alllibfiles = new ArrayList<File>();
            if (usual.length != 0) {
                alllibfiles.addAll(Arrays.asList(usual));
            }
            Iterator<String> it = LibDirs.getLibDirs();
            while (it.hasNext()) {
                File[] files;
                String str = it.next();
                File libdir = new File(str);
                if (!libdir.exists() || !libdir.isDirectory() || (files = this.osView.getFiles(libdir, useFileHiding)).length == 0) continue;
                alllibfiles.addAll(Arrays.asList(files));
                for (int i = 0; i < files.length; ++i) {
                    this.libFiles.put(files[i].getAbsolutePath(), files[i]);
                }
            }
            File[] all = new File[alllibfiles.size()];
            for (int i = 0; i < alllibfiles.size(); ++i) {
                File f2;
                all[i] = f2 = (File)alllibfiles.get(i);
            }
            return all;
        }

        public synchronized boolean isLibFile(File f2) {
            if (f2 == null) {
                return false;
            }
            return this.libFiles.containsKey(f2.getAbsolutePath());
        }

        @Override
        public File getHomeDirectory() {
            return this.osView.getHomeDirectory();
        }

        @Override
        public File getParentDirectory(File dir) {
            return this.osView.getParentDirectory(dir);
        }

        @Override
        public File[] getRoots() {
            return this.osView.getRoots();
        }

        @Override
        public String getSystemDisplayName(File f2) {
            return this.osView.getSystemDisplayName(f2);
        }

        @Override
        public Icon getSystemIcon(File f2) {
            return this.osView.getSystemIcon(f2);
        }

        @Override
        public String getSystemTypeDescription(File f2) {
            return this.osView.getSystemTypeDescription(f2);
        }

        @Override
        public boolean isComputerNode(File dir) {
            return this.osView.isComputerNode(dir);
        }

        @Override
        public boolean isDrive(File dir) {
            return this.osView.isDrive(dir);
        }

        @Override
        public boolean isFileSystem(File f2) {
            return this.osView.isFileSystem(f2);
        }

        @Override
        public boolean isFileSystemRoot(File dir) {
            return this.osView.isFileSystemRoot(dir);
        }

        @Override
        public boolean isFloppyDrive(File dir) {
            return this.osView.isFloppyDrive(dir);
        }

        @Override
        public boolean isHiddenFile(File f2) {
            return this.osView.isHiddenFile(f2);
        }

        @Override
        public boolean isParent(File folder, File file) {
            if (this.isLibFile(file)) {
                return true;
            }
            return this.osView.isParent(folder, file);
        }

        @Override
        public boolean isRoot(File f2) {
            return this.osView.isRoot(f2);
        }

        @Override
        public Boolean isTraversable(File f2) {
            return this.osView.isTraversable(f2);
        }
    }
}

