/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.layout.gates;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.generator.layout.FoldedMos;
import com.sun.electric.tool.generator.layout.FoldedNmos;
import com.sun.electric.tool.generator.layout.FoldedPmos;
import com.sun.electric.tool.generator.layout.FoldsAndWidth;
import com.sun.electric.tool.generator.layout.LayoutLib;
import com.sun.electric.tool.generator.layout.StdCellParams;
import com.sun.electric.tool.generator.layout.TechType;
import com.sun.electric.tool.generator.layout.TrackRouter;
import com.sun.electric.tool.generator.layout.TrackRouterH;

class Nand3_star_en_star {
    private static final double nmosTop = -11.5;
    private static final double pmosBot = 9.0;
    private static final double inbY = -4.0;
    private static final double incY = 4.0;
    private static final double outHiY = 11.0;
    private static final double outLoY = -11.0;

    Nand3_star_en_star() {
    }

    private static void error(boolean pred, String msg) {
        LayoutLib.error(pred, msg);
    }

    private static void connectIncSymmetric(TrackRouter incLo, FoldedMos nmos, FoldedMos[] pmoss, TechType tech) {
        double dx;
        int i;
        for (i = 0; i < nmos.nbGates() / 3; ++i) {
            int dPort = 0;
            dx = 0.0;
            switch (i % 4) {
                case 0: {
                    dPort = 2;
                    dx = -tech.getPolyLShapeOffset();
                    break;
                }
                case 1: {
                    dPort = 1;
                    dx = -0.5;
                    break;
                }
                case 2: {
                    dPort = 1;
                    dx = -tech.getPolyLShapeOffset();
                    break;
                }
                case 3: {
                    dPort = 0;
                    dx = 0.5;
                }
            }
            incLo.connect(nmos.getGate(i * 3 + dPort, 'T'), dx);
        }
        for (i = 0; i < pmoss.length; ++i) {
            for (int j = 0; j < pmoss[i].nbGates(); ++j) {
                dx = 0.0;
                boolean con = true;
                switch (j) {
                    case 1: {
                        dx = 0.5;
                        break;
                    }
                    case 3: {
                        dx = -tech.getPolyLShapeOffset();
                        break;
                    }
                    case 5: {
                        dx = -0.5;
                        break;
                    }
                    case 7: {
                        dx = -tech.getPolyLShapeOffset();
                        break;
                    }
                    default: {
                        con = false;
                    }
                }
                if (!con) continue;
                incLo.connect(pmoss[i].getGate(j, 'B'), dx);
            }
        }
    }

    private static void connectIncAsymmetric(TrackRouter incLo, FoldedMos nmos, FoldedMos[] pmoss, TechType tech) {
        double dx;
        int i;
        for (i = 0; i < nmos.nbGates() / 3; ++i) {
            int dPort = 0;
            dx = 0.0;
            double dy = 0.0;
            switch (i % 4) {
                case 0: {
                    dPort = 2;
                    dx = -tech.getPolyLShapeOffset();
                    dy = 0.0;
                    break;
                }
                case 1: {
                    dPort = 0;
                    dx = -tech.getPolyLShapeOffset();
                    dy = 0.0;
                    break;
                }
                case 2: {
                    dPort = 2;
                    dx = tech.getPolyTShapeOffset();
                    dy = -tech.getPolyTShapeOffset();
                    break;
                }
                case 3: {
                    dPort = 0;
                    dx = -4.5;
                    dy = -tech.getPolyTShapeOffset();
                }
            }
            incLo.connect(nmos.getGate(i * 3 + dPort, 'T'), dx, dy);
        }
        for (i = 0; i < pmoss.length; ++i) {
            for (int j = 0; j < pmoss[i].nbGates(); ++j) {
                dx = 0.0;
                boolean con = true;
                switch (j) {
                    case 1: {
                        dx = 0.5;
                        break;
                    }
                    case 2: {
                        dx = 0.5;
                        break;
                    }
                    case 4: {
                        dx = 0.0;
                        break;
                    }
                    case 6: {
                        dx = tech.getPolyLShapeOffset();
                        break;
                    }
                    default: {
                        con = false;
                    }
                }
                if (!con) continue;
                incLo.connect(pmoss[i].getGate(j, 'B'), dx);
            }
        }
    }

    private static void connectInbSymmetric(TrackRouter inb, FoldedMos nmos, FoldedMos[] pmoss, TechType tech) {
        double dx;
        int i;
        for (i = 0; i < nmos.nbGates() / 3; ++i) {
            int dPort = 0;
            dx = 0.0;
            switch (i % 4) {
                case 0: {
                    dPort = 1;
                    dx = -tech.getPolyLShapeOffset();
                    break;
                }
                case 1: {
                    dPort = 0;
                    dx = -tech.getPolyLShapeOffset();
                    break;
                }
                case 2: {
                    dPort = 2;
                    dx = tech.getPolyLShapeOffset();
                    break;
                }
                case 3: {
                    dPort = 1;
                    dx = tech.getPolyLShapeOffset();
                }
            }
            inb.connect(nmos.getGate(i * 3 + dPort, 'T'), dx);
        }
        for (i = 0; i < pmoss.length; ++i) {
            for (int j = 0; j < pmoss[i].nbGates(); ++j) {
                dx = 0.0;
                boolean con = true;
                switch (j) {
                    case 0: {
                        dx = tech.getPolyTShapeOffset();
                        break;
                    }
                    case 2: {
                        dx = 0.5;
                        break;
                    }
                    case 4: {
                        dx = 0.0;
                        break;
                    }
                    case 6: {
                        dx = -0.5;
                        break;
                    }
                    default: {
                        con = false;
                    }
                }
                if (!con) continue;
                inb.connect(pmoss[i].getGate(j, 'B'), dx, tech.getPolyLShapeOffset());
            }
        }
    }

    private static void connectInbAsymmetric(TrackRouter inb, FoldedMos nmos, FoldedMos[] pmoss, TechType tech) {
        double dx;
        int i;
        for (i = 0; i < nmos.nbGates() / 3; ++i) {
            int dPort = 0;
            dx = 0.0;
            switch (i % 4) {
                case 0: {
                    dPort = 1;
                    dx = -tech.getPolyLShapeOffset();
                    break;
                }
                case 1: {
                    dPort = 1;
                    dx = tech.getPolyLShapeOffset();
                    break;
                }
                case 2: {
                    dPort = 1;
                    dx = -tech.getPolyLShapeOffset();
                    break;
                }
                case 3: {
                    dPort = 1;
                    dx = tech.getPolyLShapeOffset();
                }
            }
            inb.connect(nmos.getGate(i * 3 + dPort, 'T'), dx);
        }
        for (i = 0; i < pmoss.length; ++i) {
            for (int j = 0; j < pmoss[i].nbGates(); ++j) {
                dx = 0.0;
                double dy = 0.0;
                boolean con = true;
                switch (j) {
                    case 0: {
                        dx = tech.getPolyTShapeOffset();
                        dy = 0.0;
                        break;
                    }
                    case 3: {
                        dx = 0.5;
                        dy = 0.0;
                        break;
                    }
                    case 5: {
                        dx = -0.5;
                        dy = 0.0;
                        break;
                    }
                    case 7: {
                        dx = 4.5;
                        dy = 9.5;
                        break;
                    }
                    default: {
                        con = false;
                    }
                }
                if (!con) continue;
                inb.connect(pmoss[i].getGate(j, 'B'), dx, dy);
            }
        }
    }

    static Cell makePart(double sz, String threshold, String symmetry, StdCellParams stdCell) {
        TechType tech = stdCell.getTechType();
        sz = stdCell.roundSize(sz);
        Nand3_star_en_star.error(!threshold.equals("") && !threshold.equals("LT"), "Nand3en: threshold not \"\" or \"LT\": " + threshold);
        Nand3_star_en_star.error(!symmetry.equals("") && !symmetry.equals("SY"), "Nand3en: symmetry not \"\" or \"SY\": " + symmetry);
        String nm = "nand3" + threshold + "en" + (symmetry.equals("SY") ? "_sy" : "");
        double nmosMinSz = 0.3333333333333333 * (double)(symmetry.equals("SY") ? 2 : 1);
        double pmosMinSz = threshold.equals("LT") ? 1.0 : 0.5;
        sz = stdCell.checkMinStrength(sz, Math.max(nmosMinSz, pmosMinSz), nm);
        double spaceAvail = stdCell.getCellTop() - 6.0 - 9.0;
        double lamPerSz = threshold.equals("LT") ? 3.0 : 6.0;
        double totWid = sz * lamPerSz * 2.0;
        FoldsAndWidth fwP = stdCell.calcFoldsAndWidth(spaceAvail, totWid, 2);
        Nand3_star_en_star.error(fwP == null, "can't make " + nm + " this small: " + sz);
        int nbStackedN = 3;
        spaceAvail = -11.5 - (stdCell.getCellBot() + 2.0 + 5.0 + 1.5);
        totWid = sz * 3.0 * (double)nbStackedN;
        int grpSz = symmetry.equals("SY") ? 2 : 1;
        FoldsAndWidth fwN = stdCell.calcFoldsAndWidth(spaceAvail, totWid, grpSz);
        Nand3_star_en_star.error(fwN == null, "can't make " + nm + " this small: " + sz);
        Cell nand = stdCell.findPart(nm, sz);
        if (nand != null) {
            return nand;
        }
        nand = stdCell.newPart(nm, sz);
        double incX = 3.5;
        double inbX = incX + 2.0 + 3.0 + 2.0;
        double jogcX = inbX + 2.0 + 3.0 + 2.0;
        double mosX = jogcX + 2.0 + 3.0 + 2.0;
        FoldedNmos nmos = new FoldedNmos(mosX, -11.5 - fwN.physWid / 2.0, fwN.nbFolds, nbStackedN, fwN.gateWid, nand, tech);
        double pmosY = 9.0 + fwP.physWid / 2.0;
        FoldedMos[] pmoss = new FoldedMos[(int)Math.ceil((double)fwP.nbFolds / 8.0)];
        for (int i = 0; i < pmoss.length; ++i) {
            double pmosPitch = 72.0;
            int nbFolds = Math.min(8, fwP.nbFolds - i * 8);
            pmoss[i] = new FoldedPmos(mosX + (double)i * pmosPitch, pmosY, nbFolds, 1, fwP.gateWid, nand, tech);
        }
        stdCell.fillDiffAndSelectNotches(pmoss, false);
        double rightPdiffX = StdCellParams.getRightDiffX(pmoss);
        double rightNdiffX = StdCellParams.getRightDiffX(nmos);
        double pmosaFromPmos = rightPdiffX + 2.5 + 2.0 + 2.0 + 2.0 + 2.5;
        double pmosaFromNmos = rightNdiffX - 8.0;
        double pmosaX = Math.max(pmosaFromPmos, pmosaFromNmos);
        FoldedPmos pmosa = new FoldedPmos(pmosaX, stdCell.getVddY(), 1, 1, 5.0, nand, tech);
        stdCell.fillDiffAndSelectNotches(new FoldedMos[]{pmoss[pmoss.length - 1], pmosa}, false);
        stdCell.wireVddGnd(nmos, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(pmoss, StdCellParams.EVEN, nand);
        stdCell.wireVddGnd(new FoldedMos[]{pmoss[0], pmosa}, StdCellParams.EVEN, nand);
        double incHiY = 11.0;
        LayoutLib.newExport(nand, "inc", PortCharacteristic.IN, tech.m1(), 4.0, incX, incHiY);
        TrackRouterH incHi = new TrackRouterH(tech.m2(), 3.0, incHiY, tech, nand);
        incHi.connect(nand.findExport("inc"));
        PortInst jogc = LayoutLib.newNodeInst(tech.m1pin(), jogcX, incHiY, 3.0, 3.0, 0.0, nand).getOnlyPortInst();
        incHi.connect(jogc);
        TrackRouterH incLo = new TrackRouterH(tech.m1(), 3.0, 4.0, tech, nand);
        incLo.connect(jogc);
        if (symmetry.equals("SY")) {
            Nand3_star_en_star.connectIncSymmetric(incLo, nmos, pmoss, tech);
        } else {
            Nand3_star_en_star.connectIncAsymmetric(incLo, nmos, pmoss, tech);
        }
        TrackRouterH inb = new TrackRouterH(tech.m1(), 3.0, -4.0, tech, nand);
        LayoutLib.newExport(nand, "inb", PortCharacteristic.IN, tech.m1(), 4.0, inbX, -4.0);
        inb.connect(nand.findExport("inb"));
        if (symmetry.equals("SY")) {
            Nand3_star_en_star.connectInbSymmetric(inb, nmos, pmoss, tech);
        } else {
            Nand3_star_en_star.connectInbAsymmetric(inb, nmos, pmoss, tech);
        }
        double inaX = LayoutLib.roundCenterX(pmosa.getSrcDrn(1)) + 2.0 + 3.0 + 2.0;
        double inaHiY = stdCell.getVddY() + stdCell.getVddWidth() / 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "ina", PortCharacteristic.IN, tech.m1(), 4.0, inaX, inaHiY);
        TrackRouterH inaHi = new TrackRouterH(tech.m1(), 3.0, inaHiY, tech, nand);
        inaHi.connect(nand.findExport("ina"));
        inaHi.connect(pmosa.getGate(0, 'T'), tech.getPolyLShapeOffset());
        double gndBot = stdCell.getGndY() - stdCell.getGndWidth() / 2.0;
        double inaFromGnd = gndBot - 3.0 - 2.0;
        double nmosBot = -11.5 - fwN.physWid;
        double inaFromMos = nmosBot - 2.0 - 2.5;
        double inaLoY = Math.min(inaFromGnd, inaFromMos);
        TrackRouterH inaLo = new TrackRouterH(tech.m1(), 3.0, inaLoY, tech, nand);
        for (int i = 0; i < fwN.nbFolds; ++i) {
            int dPort = 0;
            double dx = 0.0;
            switch (i % 2) {
                case 0: {
                    dPort = 0;
                    dx = -4.0;
                    break;
                }
                case 1: {
                    dPort = 2;
                    dx = 4.0;
                }
            }
            ((TrackRouter)inaLo).connect(nmos.getGate(i * 3 + dPort, 'B'), dx, tech.getPolyLShapeOffset());
        }
        inaLo.connect(nand.findExport("ina"));
        double outX = inaX + 2.0 + 3.0 + 2.0;
        LayoutLib.newExport(nand, "out", PortCharacteristic.OUT, tech.m1(), 4.0, outX, 11.0);
        TrackRouterH outHi = new TrackRouterH(tech.m2(), 4.0, 11.0, tech, nand);
        outHi.connect(nand.findExport("out"));
        for (int i = 0; i < pmoss.length; ++i) {
            for (int j = 1; j < pmoss[i].nbSrcDrns(); j += 2) {
                outHi.connect(pmoss[i].getSrcDrn(j));
            }
        }
        outHi.connect(pmosa.getSrcDrn(1));
        TrackRouterH outLo = new TrackRouterH(tech.m2(), 4.0, -11.0, tech, nand);
        outLo.connect(nand.findExport("out"));
        for (int i = 1; i < nmos.nbSrcDrns(); i += 2) {
            outLo.connect(nmos.getSrcDrn(i));
        }
        double wellMinX = 0.0;
        double wellMaxX = outX + 2.0 + 1.5;
        stdCell.addNmosWell(wellMinX, wellMaxX, nand);
        stdCell.addPmosWell(wellMinX, wellMaxX, nand);
        stdCell.addEssentialBounds(wellMinX, wellMaxX, nand);
        stdCell.doNCC(nand, nm + "{sch}");
        return nand;
    }
}

