/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.extract;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.Dimension2D;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Orientation;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.UserInterface;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.extract.Extract;
import com.sun.electric.tool.routing.AutoStitch;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.dialogs.EDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JButton;
import javax.swing.JLabel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Connectivity {
    private static final boolean ENFORCEMINIMUMSIZE = false;
    private static final double SCALEFACTOR = 400.0;
    private static final boolean DEBUGCENTERLINES = false;
    private static final boolean DEBUGSTEPS = false;
    private Technology tech;
    private Map<Layer.Function, Layer> layerForFunction;
    private Layer polyLayer;
    private Layer tempLayer1;
    private Layer pActiveLayer;
    private Layer nActiveLayer;
    private Map<Layer, ArcProto> arcsForLayer;
    private Map<Cell, Cell> convertedCells;
    private Map<Layer, List<PolyBase>> allCutLayers;
    private Set<PrimitiveNode> ignoreNodes;
    private Set<PrimitiveNode> bogusContacts;
    private List<Export> exportsToRestore;
    private boolean pWellProcess;
    private boolean nWellProcess;
    private boolean unifyActive;
    private boolean ignoreActiveSelectWell;
    private double smallestPoly;
    private List<ERectangle> addedRectangles;
    private List<ERectangle> addedLines;
    private List<ExportedPin> pinsForLater;
    private ErrorLogger errorLogger;
    private Job job;
    private static final double CLOSEDIST = 8.0;

    public static void extractCurCell(boolean recursive) {
        Cell curCell = Job.getUserInterface().needCurrentCell();
        if (curCell == null) {
            System.out.println("Must be editing a cell with pure layer nodes.");
            return;
        }
        new ExtractJob(curCell, recursive);
    }

    private Connectivity(Cell cell, Job j, ErrorLogger eLog) {
        this.tech = cell.getTechnology();
        this.convertedCells = new HashMap<Cell, Cell>();
        this.smallestPoly = 160000.0 * Extract.getSmallestPolygonSize();
        this.bogusContacts = new HashSet<PrimitiveNode>();
        this.errorLogger = eLog;
        this.job = j;
        this.ignoreNodes = new HashSet<PrimitiveNode>();
        Iterator<PrimitiveNode> pIt = this.tech.getNodes();
        while (pIt.hasNext()) {
            PrimitiveNode np = pIt.next();
            if (np.getFunction() != PrimitiveNode.Function.NODE) continue;
            Technology.NodeLayer[] nLays = np.getLayers();
            boolean validLayers = false;
            for (int i = 0; i < nLays.length; ++i) {
                Technology.NodeLayer nLay = nLays[i];
                Layer.Function fun = nLay.getLayer().getFunction();
                if (fun == Layer.Function.UNKNOWN || fun == Layer.Function.OVERGLASS || fun == Layer.Function.GUARD || fun == Layer.Function.ISOLATION || fun == Layer.Function.BUS || fun == Layer.Function.ART || fun == Layer.Function.CONTROL || fun == Layer.Function.TILENOT) continue;
                validLayers = true;
            }
            if (validLayers) continue;
            this.ignoreNodes.add(np);
        }
        int activeHandling = Extract.getActiveHandling();
        this.unifyActive = activeHandling == 1;
        boolean bl = this.ignoreActiveSelectWell = activeHandling == 2;
        if (!this.unifyActive) {
            boolean haveNActive = false;
            boolean havePActive = false;
            Iterator<NodeInst> it = cell.getNodes();
            while (it.hasNext()) {
                NodeInst ni = it.next();
                if (ni.isCellInstance()) continue;
                Poly[] polys = ni.getProto().getTechnology().getShapeOfNode(ni);
                for (int i = 0; i < polys.length; ++i) {
                    Layer layer = polys[i].getLayer();
                    if (layer == null || !layer.getFunction().isDiff()) continue;
                    if (layer.getFunction() == Layer.Function.DIFFN) {
                        haveNActive = true;
                    }
                    if (layer.getFunction() != Layer.Function.DIFFP) continue;
                    havePActive = true;
                }
                if (!haveNActive || !havePActive) continue;
                break;
            }
            if (!haveNActive || !havePActive) {
                System.out.println("Found only one type of active layer...unifying all active layers");
                this.unifyActive = true;
            }
        }
        this.polyLayer = null;
        this.nActiveLayer = null;
        this.pActiveLayer = null;
        Iterator<Layer> it = this.tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            Layer.Function fun = layer.getFunction();
            if (this.polyLayer == null && fun == Layer.Function.POLY1) {
                this.polyLayer = layer;
            }
            if (this.unifyActive) {
                if (this.pActiveLayer != null || !fun.isDiff()) continue;
                this.pActiveLayer = layer;
                continue;
            }
            if (this.pActiveLayer == null && fun == Layer.Function.DIFFP) {
                this.pActiveLayer = layer;
            }
            if (this.nActiveLayer != null || fun != Layer.Function.DIFFN) continue;
            this.nActiveLayer = layer;
        }
        this.polyLayer = this.polyLayer.getNonPseudoLayer();
        if (this.polyLayer != null) {
            this.tempLayer1 = this.polyLayer.getPseudoLayer();
        }
        this.pActiveLayer = this.pActiveLayer.getNonPseudoLayer();
        this.nActiveLayer = this.unifyActive ? this.pActiveLayer : this.nActiveLayer.getNonPseudoLayer();
        this.arcsForLayer = new HashMap<Layer, ArcProto>();
        it = this.tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            Layer.Function fun = layer.getFunction();
            if (!fun.isDiff() && !fun.isPoly() && !fun.isMetal()) continue;
            ArcProto.Function oFun = null;
            if (fun.isMetal()) {
                oFun = ArcProto.Function.getMetal(fun.getLevel());
            }
            if (fun.isPoly()) {
                oFun = ArcProto.Function.getPoly(fun.getLevel());
            }
            if (oFun == null) continue;
            ArcProto type = null;
            Iterator<ArcProto> aIt = this.tech.getArcs();
            while (aIt.hasNext()) {
                ArcProto ap = aIt.next();
                if (ap.getFunction() != oFun) continue;
                type = ap;
                break;
            }
            if (type == null) continue;
            this.arcsForLayer.put(layer, type);
        }
        this.layerForFunction = new HashMap<Layer.Function, Layer>();
        it = this.tech.getLayers();
        while (it.hasNext()) {
            Layer layer = it.next();
            Layer.Function fun = layer.getFunction();
            if (this.unifyActive && (fun == Layer.Function.DIFFP || fun == Layer.Function.DIFFN)) {
                fun = Layer.Function.DIFF;
            }
            if (this.layerForFunction.get((Object)fun) != null) continue;
            this.layerForFunction.put(fun, layer);
        }
    }

    private void addErrorLog(Cell cell, String msg, EPoint ... pList) {
        ArrayList<EPoint> pointList = new ArrayList<EPoint>();
        for (EPoint p : pList) {
            pointList.add(p);
        }
        this.errorLogger.logError(msg, null, null, null, pointList, null, cell, -1);
        System.out.println(msg);
    }

    private Cell doExtract(Cell oldCell, boolean recursive, Pattern pat, boolean top, Job job, List<List<ERectangle>> addedBatchRectangles, List<List<ERectangle>> addedBatchLines, List<String> addedBatchNames) {
        if (recursive) {
            Iterator<NodeInst> it = oldCell.getNodes();
            while (it.hasNext()) {
                Cell convertedCell;
                Matcher mat;
                NodeInst ni = it.next();
                if (!ni.isCellInstance()) continue;
                Cell subCell = (Cell)ni.getProto();
                if (pat != null && (mat = pat.matcher(subCell.noLibDescribe())).find() || (convertedCell = this.convertedCells.get(subCell)) != null) continue;
                this.doExtract(subCell, recursive, pat, false, job, addedBatchRectangles, addedBatchLines, addedBatchNames);
            }
        }
        String newCellName = oldCell.getName() + oldCell.getView().getAbbreviationExtension();
        Cell newCell = Cell.makeInstance(oldCell.getLibrary(), newCellName);
        if (newCell == null) {
            System.out.println("Cannot create new cell: " + newCellName);
            return null;
        }
        this.convertedCells.put(oldCell, newCell);
        PolyMerge merge = new PolyMerge();
        if (!this.startSection("Gathering geometry in " + oldCell + "...")) {
            return null;
        }
        HashSet<Cell> expandedCells = new HashSet<Cell>();
        this.exportsToRestore = new ArrayList<Export>();
        this.pinsForLater = new ArrayList<ExportedPin>();
        this.allCutLayers = new HashMap<Layer, List<PolyBase>>();
        this.extractCell(oldCell, newCell, pat, expandedCells, merge, GenMath.MATID);
        if (expandedCells.size() > 0) {
            System.out.print("These cells were expanded:");
            for (Cell c : expandedCells) {
                System.out.print(" " + c.describe(false));
            }
            System.out.println();
        }
        this.findMissingWells(merge);
        PolyMerge originalMerge = new PolyMerge();
        originalMerge.addMerge(merge, new AffineTransform());
        this.initDebugging();
        if (!this.startSection("Extracting vias...")) {
            return null;
        }
        if (!this.extractVias(merge, originalMerge, newCell)) {
            return null;
        }
        this.termDebugging(addedBatchRectangles, addedBatchLines, addedBatchNames, "Vias");
        this.initDebugging();
        if (!this.startSection("Extracting transistors...")) {
            return null;
        }
        this.extractTransistors(merge, originalMerge, newCell);
        this.termDebugging(addedBatchRectangles, addedBatchLines, addedBatchNames, "Transistors");
        this.initDebugging();
        if (!this.startSection("Extracting extensions...")) {
            return null;
        }
        this.extendGeometry(merge, originalMerge, newCell, true);
        this.termDebugging(addedBatchRectangles, addedBatchLines, addedBatchNames, "StickOuts");
        this.initDebugging();
        if (!this.startSection("Extracting wires...")) {
            return null;
        }
        if (this.makeWires(merge, originalMerge, newCell)) {
            return newCell;
        }
        this.termDebugging(addedBatchRectangles, addedBatchLines, addedBatchNames, "Wires");
        this.initDebugging();
        if (!this.startSection("Extracting connections...")) {
            return null;
        }
        this.extendGeometry(merge, originalMerge, newCell, false);
        this.termDebugging(addedBatchRectangles, addedBatchLines, addedBatchNames, "Bridges");
        this.initDebugging();
        if (!this.startSection("Extracting leftover geometry...")) {
            return null;
        }
        this.convertAllGeometry(merge, originalMerge, newCell);
        this.termDebugging(addedBatchRectangles, addedBatchLines, addedBatchNames, "Pures");
        if (!this.startSection("Adding connecting wires...")) {
            return null;
        }
        this.restoreExports(oldCell, newCell);
        PolyMerge originalUnscaledMerge = new PolyMerge();
        double shrinkage = 0.0025;
        AffineTransform shrink = new AffineTransform(shrinkage, 0.0, 0.0, shrinkage, 0.0, 0.0);
        originalUnscaledMerge.addMerge(originalMerge, shrink);
        Object allArcs = null;
        AutoStitch.runAutoStitch(newCell, null, null, job, originalUnscaledMerge, null, false, true, true);
        System.out.println("Extraction done.");
        return newCell;
    }

    private boolean startSection(String msg) {
        System.out.println(msg);
        if (this.job.checkAbort()) {
            return false;
        }
        Job.getUserInterface().setProgressNote(msg);
        Job.getUserInterface().setProgressValue(0L);
        return true;
    }

    private void initDebugging() {
    }

    private void termDebugging(List<List<ERectangle>> addedBatchRectangles, List<List<ERectangle>> addedBatchLines, List<String> addedBatchNames, String descr) {
    }

    private void extractCell(Cell oldCell, Cell newCell, Pattern pat, Set<Cell> expandedCells, PolyMerge merge, AffineTransform prevTrans) {
        HashMap<NodeInst, NodeInst> newNodes = new HashMap<NodeInst, NodeInst>();
        int totalNodes = oldCell.getNumNodes();
        int soFar = 0;
        Iterator<NodeInst> nIt = oldCell.getNodes();
        while (nIt.hasNext()) {
            NodeInst ni = nIt.next();
            if (++soFar % 100 == 0) {
                Job.getUserInterface().setProgressValue(soFar * 100 / totalNodes);
            }
            if (ni.getProto() == Generic.tech().cellCenterNode) continue;
            NodeProto copyType = null;
            if (ni.isCellInstance()) {
                Matcher mat;
                Cell subCell = (Cell)ni.getProto();
                if (pat != null && (mat = pat.matcher(subCell.noLibDescribe())).find()) {
                    expandedCells.add(subCell);
                    AffineTransform subTrans = ni.translateOut(ni.rotateOut(prevTrans));
                    this.extractCell(subCell, newCell, pat, expandedCells, merge, subTrans);
                    continue;
                }
                copyType = this.convertedCells.get(subCell);
                if (copyType == null) {
                    copyType = subCell;
                }
            } else {
                PrimitiveNode np = (PrimitiveNode)ni.getProto();
                if (np.getFunction() == PrimitiveNode.Function.PIN && ni.hasExports() && !ni.hasConnections()) {
                    ExportedPin ep = new ExportedPin(ni, ni.getTrueCenter(), prevTrans);
                    this.pinsForLater.add(ep);
                    continue;
                }
                if (np.getFunction() != PrimitiveNode.Function.NODE) {
                    copyType = ni.getProto();
                } else if (this.ignoreNodes.contains(np)) {
                    copyType = ni.getProto();
                }
            }
            if (copyType != null) {
                double sX = ni.getXSize();
                double sY = ni.getYSize();
                if (copyType instanceof Cell) {
                    ERectangle cellBounds = ((Cell)copyType).getBounds();
                    sX = ((RectangularShape)cellBounds).getWidth();
                    sY = ((RectangularShape)cellBounds).getHeight();
                }
                Point2D.Double instanceAnchor = new Point2D.Double(0.0, 0.0);
                prevTrans.transform(ni.getAnchorCenter(), instanceAnchor);
                NodeInst newNi = NodeInst.makeInstance(copyType, instanceAnchor, sX, sY, newCell, ni.getOrient(), ni.getName(), ni.getTechSpecific());
                if (newNi == null) {
                    this.addErrorLog(newCell, "Problem creating new instance of " + ni.getProto(), new EPoint(sX, sY));
                    return;
                }
                newNodes.put(ni, newNi);
                Iterator<Export> it = ni.getExports();
                while (it.hasNext()) {
                    Export e = it.next();
                    PortInst pi = newNi.findPortInstFromProto(e.getOriginalPort().getPortProto());
                    Export.newInstance(newCell, pi, e.getName());
                }
                continue;
            }
            boolean growABit = false;
            if ((int)(ni.getXSize() * 400.0) % 2 != 0 || (int)(ni.getYSize() * 400.0) % 2 != 0) {
                growABit = true;
            }
            AffineTransform trans = ni.rotateOut(prevTrans);
            Poly[] polys = this.tech.getShapeOfNode(ni);
            for (int j = 0; j < polys.length; ++j) {
                Poly poly = polys[j];
                Layer layer = poly.getLayer();
                if (layer == null) continue;
                layer = this.geometricLayer(layer);
                poly.transform(trans);
                Point2D[] points = poly.getPoints();
                if (Extract.isGridAlignExtraction()) {
                    Point2D.Double hold = new Point2D.Double();
                    for (int i = 0; i < points.length; ++i) {
                        hold.setLocation(points[i]);
                        Job.getUserInterface().alignToGrid(hold);
                        poly.setPoint(i, ((Point2D)hold).getX(), ((Point2D)hold).getY());
                    }
                } else if (growABit) {
                    double growth = DBMath.getEpsilon() / 2.0;
                    EPoint polyCtr = poly.getCenter();
                    for (int i = 0; i < points.length; ++i) {
                        double x = points[i].getX();
                        double y = points[i].getY();
                        x = x < ((Point2D)polyCtr).getX() ? (x -= growth) : (x += growth);
                        y = y < ((Point2D)polyCtr).getY() ? (y -= growth) : (y += growth);
                        poly.setPoint(i, x, y);
                    }
                }
                for (int i = 0; i < points.length; ++i) {
                    poly.setPoint(i, this.scaleUp(points[i].getX()), this.scaleUp(points[i].getY()));
                }
                if (layer.getFunction().isContact()) {
                    List<PolyBase> cutsOnLayer = this.allCutLayers.get(layer);
                    if (cutsOnLayer == null) {
                        cutsOnLayer = new ArrayList<PolyBase>();
                        this.allCutLayers.put(layer, cutsOnLayer);
                    }
                    cutsOnLayer.add(poly);
                    continue;
                }
                Rectangle2D box = poly.getBox();
                if (box != null) {
                    merge.addRectangle(layer, box);
                    continue;
                }
                merge.addPolygon(layer, poly);
            }
            Iterator<Export> it = ni.getExports();
            while (it.hasNext()) {
                Export e = it.next();
                this.exportsToRestore.add(e);
            }
        }
        Iterator<ArcInst> aIt = oldCell.getArcs();
        while (aIt.hasNext()) {
            ArcInst ai = aIt.next();
            NodeInst end1 = (NodeInst)newNodes.get(ai.getHeadPortInst().getNodeInst());
            NodeInst end2 = (NodeInst)newNodes.get(ai.getTailPortInst().getNodeInst());
            if (end1 == null || end2 == null) continue;
            PortInst pi1 = end1.findPortInstFromProto(ai.getHeadPortInst().getPortProto());
            PortInst pi2 = end2.findPortInstFromProto(ai.getTailPortInst().getPortProto());
            Point2D.Double headLocation = new Point2D.Double(0.0, 0.0);
            Point2D.Double tailLocation = new Point2D.Double(0.0, 0.0);
            prevTrans.transform(ai.getHeadLocation(), headLocation);
            prevTrans.transform(ai.getTailLocation(), tailLocation);
            ArcInst.makeInstanceBase(ai.getProto(), ai.getLambdaBaseWidth(), pi1, pi2, headLocation, tailLocation, ai.getName());
        }
    }

    private void findMissingWells(PolyMerge merge) {
        boolean hasPWell = false;
        boolean hasNWell = false;
        boolean hasWell = false;
        for (Layer layer : merge.getKeySet()) {
            Layer.Function fun = layer.getFunction();
            if (fun == Layer.Function.WELL) {
                hasWell = true;
            }
            if (fun == Layer.Function.WELLP) {
                hasPWell = true;
            }
            if (fun != Layer.Function.WELLN) continue;
            hasNWell = true;
        }
        if (!hasPWell) {
            this.pWellProcess = true;
            System.out.println("Presuming a P-well process");
            return;
        }
        if (!hasNWell && !hasWell) {
            this.nWellProcess = true;
            System.out.println("Presuming an N-well process");
        }
    }

    private boolean makeWires(PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        PortInst pi1;
        List<PolyBase> polyList;
        int totPolys = 0;
        HashMap<Layer, List<PolyBase>> geomToWire = new HashMap<Layer, List<PolyBase>>();
        for (Layer layer : merge.getKeySet()) {
            Layer.Function fun = layer.getFunction();
            if (!fun.isDiff() && !fun.isPoly() && !fun.isMetal()) continue;
            List<PolyBase> polyList2 = this.getMergePolys(merge, layer);
            totPolys += polyList2.size();
            geomToWire.put(layer, polyList2);
        }
        int soFar = 0;
        Set allLayers = geomToWire.keySet();
        for (Layer layer : allLayers) {
            polyList = (List<PolyBase>)geomToWire.get(layer);
            for (PolyBase poly : polyList) {
                Job.getUserInterface().setProgressValue(soFar * 100 / totPolys);
                ++soFar;
                ArcProto ap = this.findArcProtoForPoly(layer, poly, originalMerge);
                if (ap == null) continue;
                double minWidth = 1.0;
                List<Centerline> lines = this.findCenterlines(poly, layer, minWidth, merge, originalMerge);
                for (Centerline cl : lines) {
                    ArcInst ai;
                    GenMath.MutableBoolean tailExtend;
                    GenMath.MutableBoolean headExtend;
                    Point2D.Double loc2;
                    Point2D.Double loc1Unscaled = new Point2D.Double();
                    pi1 = this.locatePortOnCenterline(cl, loc1Unscaled, layer, ap, true, newCell);
                    Point2D.Double loc2Unscaled = new Point2D.Double();
                    PortInst pi2 = this.locatePortOnCenterline(cl, loc2Unscaled, layer, ap, false, newCell);
                    Point2D.Double loc1 = new Point2D.Double(this.scaleUp(((Point2D)loc1Unscaled).getX()), this.scaleUp(((Point2D)loc1Unscaled).getY()));
                    boolean fits = originalMerge.arcPolyFits(layer, loc1, loc2 = new Point2D.Double(this.scaleUp(((Point2D)loc2Unscaled).getX()), this.scaleUp(((Point2D)loc2Unscaled).getY())), cl.width, headExtend = new GenMath.MutableBoolean(true), tailExtend = new GenMath.MutableBoolean(true));
                    if (!fits) {
                        double wid = cl.width / 400.0;
                        Dimension2D alignment = Job.getUserInterface().getGridAlignment();
                        long x = Math.round(wid / alignment.getWidth());
                        double gridWid = (double)x * alignment.getWidth();
                        if (gridWid < wid) {
                            cl.width = this.scaleUp(gridWid);
                            fits = originalMerge.arcPolyFits(layer, loc1, loc2, cl.width, headExtend, tailExtend);
                        } else {
                            cl.width -= 1.0;
                            fits = originalMerge.arcPolyFits(layer, loc1, loc2, cl.width, headExtend, tailExtend);
                        }
                    }
                    if (!fits) {
                        cl.width = 0.0;
                        fits = originalMerge.arcPolyFits(layer, loc1, loc2, cl.width, headExtend, tailExtend);
                    }
                    if (!fits || (ai = this.realizeArc(ap, pi1, pi2, loc1Unscaled, loc2Unscaled, cl.width / 400.0, !headExtend.booleanValue(), !tailExtend.booleanValue(), merge)) != null) continue;
                    String msg = "  Failed to run arc " + ap.getName() + " from (" + ((Point2D)loc1Unscaled).getX() + "," + ((Point2D)loc1Unscaled).getY() + ") on node " + pi1.getNodeInst().describe(false) + " to (" + ((Point2D)loc2Unscaled).getX() + "," + ((Point2D)loc2Unscaled).getY() + ") on node " + pi2.getNodeInst().describe(false);
                    this.addErrorLog(newCell, msg, new EPoint(((Point2D)loc1Unscaled).getX(), ((Point2D)loc1Unscaled).getY()), new EPoint(((Point2D)loc2Unscaled).getX(), ((Point2D)loc2Unscaled).getY()));
                    return true;
                }
            }
        }
        for (Layer layer : allLayers) {
            polyList = this.getMergePolys(merge, layer);
            for (PolyBase poly : polyList) {
                Point2D.Double loc2;
                Point2D.Double loc1;
                ArcProto ap;
                Rectangle2D bounds = poly.getBounds2D();
                Poly rectPoly = new Poly(bounds);
                if (!originalMerge.contains(layer, rectPoly) || (ap = this.findArcProtoForPoly(layer, poly, originalMerge)) == null) continue;
                double width = Math.min(bounds.getWidth(), bounds.getHeight());
                if (bounds.getWidth() > bounds.getHeight()) {
                    loc1 = new Point2D.Double((bounds.getMinX() + width / 2.0) / 400.0, bounds.getCenterY() / 400.0);
                    loc2 = new Point2D.Double((bounds.getMaxX() - width / 2.0) / 400.0, bounds.getCenterY() / 400.0);
                } else {
                    loc1 = new Point2D.Double(bounds.getCenterX() / 400.0, (bounds.getMinY() + width / 2.0) / 400.0);
                    loc2 = new Point2D.Double(bounds.getCenterX() / 400.0, (bounds.getMaxY() - width / 2.0) / 400.0);
                }
                pi1 = this.wantConnectingNodeAt(loc1, ap, width / 400.0, newCell);
                PortInst pi2 = this.wantConnectingNodeAt(loc2, ap, width / 400.0, newCell);
                this.realizeArc(ap, pi1, pi2, loc1, loc2, width / 400.0, false, false, merge);
            }
        }
        return false;
    }

    private ArcProto findArcProtoForPoly(Layer layer, PolyBase poly, PolyMerge originalMerge) {
        Layer.Function fun = layer.getFunction();
        if (fun.isPoly() || fun.isMetal()) {
            return this.arcsForLayer.get(layer);
        }
        if (!fun.isDiff()) {
            return null;
        }
        Layer wellP = null;
        Layer wellN = null;
        Layer selectP = null;
        Layer selectN = null;
        for (Layer l : originalMerge.getKeySet()) {
            if (l.getFunction() == Layer.Function.WELLP) {
                wellP = l;
            }
            if (l.getFunction() == Layer.Function.WELLN) {
                wellN = l;
            }
            if (l.getFunction() == Layer.Function.IMPLANTP) {
                selectP = l;
            }
            if (l.getFunction() != Layer.Function.IMPLANTN) continue;
            selectN = l;
        }
        ArcProto.Function neededFunction = null;
        if (originalMerge.intersects(selectP, poly)) {
            neededFunction = ArcProto.Function.DIFFP;
            if (wellP == null) {
                if (!originalMerge.intersects(wellN, poly)) {
                    neededFunction = ArcProto.Function.DIFFS;
                }
            } else if (originalMerge.intersects(wellP, poly)) {
                neededFunction = ArcProto.Function.DIFFS;
            }
        } else if (originalMerge.intersects(selectN, poly)) {
            neededFunction = ArcProto.Function.DIFFN;
            if (wellN == null) {
                if (!originalMerge.intersects(wellP, poly)) {
                    neededFunction = ArcProto.Function.DIFFW;
                }
            } else if (originalMerge.intersects(wellN, poly)) {
                neededFunction = ArcProto.Function.DIFFW;
            }
        }
        Iterator<ArcProto> aIt = this.tech.getArcs();
        while (aIt.hasNext()) {
            ArcProto ap = aIt.next();
            if (ap.getFunction() != neededFunction) continue;
            return ap;
        }
        return null;
    }

    private PortInst wantConnectingNodeAt(Point2D pt, ArcProto ap, double size, Cell newCell) {
        Rectangle2D.Double bounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
        Iterator<RTBounds> it = newCell.searchIterator(bounds);
        while (it.hasNext()) {
            RTBounds geom = it.next();
            if (!(geom instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)geom;
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                Poly poly;
                PortInst pi = pIt.next();
                PortProto pp = pi.getPortProto();
                if (!pp.connectsTo(ap) || !(poly = pi.getPoly()).contains(pt)) continue;
                return pi;
            }
        }
        NodeInst ni = this.createNode(ap.findPinProto(), pt, size, size, null, newCell);
        return ni.getOnlyPortInst();
    }

    private NodeInst wantNodeAt(Point2D pt, NodeProto pin, double size, Cell newCell) {
        Rectangle2D.Double bounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
        Iterator<RTBounds> it = newCell.searchIterator(bounds);
        while (it.hasNext()) {
            NodeInst ni;
            RTBounds geom = it.next();
            if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom).getProto() != pin || !ni.getAnchorCenter().equals(pt)) continue;
            return ni;
        }
        NodeInst ni = this.createNode(pin, pt, size, size, null, newCell);
        return ni;
    }

    private PortInst findPortInstClosestToPoly(NodeInst ni, PrimitivePort pp, Point2D pt) {
        PortInst touchingPi = ni.findPortInstFromProto(pp);
        PrimitiveNode pnp = (PrimitiveNode)ni.getProto();
        Poly touchingPoly = touchingPi.getPoly();
        double bestDist = pt.distance(new Point2D.Double(touchingPoly.getCenterX(), touchingPoly.getCenterY()));
        Iterator<PortProto> pIt = pnp.getPorts();
        while (pIt.hasNext()) {
            PortInst testPi;
            Poly testPoly;
            double dist;
            PrimitivePort prP = (PrimitivePort)pIt.next();
            if (prP.getTopology() != pp.getTopology() || !((dist = pt.distance(new Point2D.Double((testPoly = (testPi = ni.findPortInstFromProto(prP)).getPoly()).getCenterX(), testPoly.getCenterY()))) < bestDist)) continue;
            bestDist = dist;
            touchingPi = testPi;
        }
        return touchingPi;
    }

    private PortInst locatePortOnCenterline(Centerline cl, Point2D loc1, Layer layer, ArcProto ap, boolean startSide, Cell newCell) {
        PortInst piRet = null;
        boolean isHub = cl.endHub;
        EPoint startPoint = cl.endUnscaled;
        if (startSide) {
            isHub = cl.startHub;
            startPoint = cl.startUnscaled;
        }
        if (!isHub) {
            List<PortInst> possiblePorts = this.findPortInstsTouchingPoint(startPoint, layer, newCell, ap);
            for (PortInst pi : possiblePorts) {
                Poly portPoly = pi.getPoly();
                Point2D[] points = portPoly.getPoints();
                if (points.length == 1) {
                    Point2D iPt = GenMath.intersect(cl.startUnscaled, cl.angle, points[0], (cl.angle + 900) % 3600);
                    if (iPt == null) continue;
                    loc1.setLocation(iPt.getX(), iPt.getY());
                    piRet = pi;
                    break;
                }
                if (portPoly.contains(startPoint)) {
                    loc1.setLocation(startPoint);
                    piRet = pi;
                    break;
                }
                for (int i = 0; i < points.length; ++i) {
                    int last = i - 1;
                    if (last < 0) {
                        last = points.length - 1;
                    }
                    Point2D portLineFrom = points[last];
                    Point2D portLineTo = points[i];
                    Point2D interPt = null;
                    if (portLineFrom.equals(portLineTo)) {
                        interPt = GenMath.intersect(cl.startUnscaled, cl.angle, portLineFrom, (cl.angle + 900) % 3600);
                    } else {
                        int angPortLine = GenMath.figureAngle(portLineFrom, portLineTo);
                        interPt = GenMath.intersect(portLineFrom, angPortLine, cl.startUnscaled, cl.angle);
                        if (interPt != null && (interPt.getX() < Math.min(portLineFrom.getX(), portLineTo.getX()) || interPt.getX() > Math.max(portLineFrom.getX(), portLineTo.getX()) || interPt.getY() < Math.min(portLineFrom.getY(), portLineTo.getY()) || interPt.getY() > Math.max(portLineFrom.getY(), portLineTo.getY()))) {
                            interPt = null;
                        }
                    }
                    if (interPt == null) continue;
                    loc1.setLocation(interPt.getX(), interPt.getY());
                    if (!portPoly.contains(loc1)) continue;
                    piRet = pi;
                    break;
                }
                if (piRet == null) continue;
                break;
            }
        }
        if (piRet == null) {
            PrimitiveNode pin = ap.findPinProto();
            int ang = GenMath.figureAngle(cl.start, cl.end);
            double xOff = GenMath.cos(ang) * cl.width / 2.0;
            double yOff = GenMath.sin(ang) * cl.width / 2.0;
            if (startSide) {
                if (!isHub && cl.start.distance(cl.end) > cl.width) {
                    cl.setStart(cl.start.getX() + xOff, cl.start.getY() + yOff);
                }
                NodeInst ni = this.wantNodeAt(cl.startUnscaled, pin, cl.width / 400.0, newCell);
                loc1.setLocation(cl.startUnscaled.getX(), cl.startUnscaled.getY());
                piRet = ni.getOnlyPortInst();
            } else {
                if (!isHub && cl.start.distance(cl.end) > cl.width) {
                    cl.setEnd(cl.end.getX() - xOff, cl.end.getY() - yOff);
                }
                NodeInst ni = this.wantNodeAt(cl.endUnscaled, pin, cl.width / 400.0, newCell);
                loc1.setLocation(cl.endUnscaled.getX(), cl.endUnscaled.getY());
                piRet = ni.getOnlyPortInst();
            }
        }
        return piRet;
    }

    private List<PortInst> findPortInstsTouchingPoint(Point2D pt, Layer layer, Cell newCell, ArcProto ap) {
        PortInst pi;
        ArrayList<PortInst> touchingNodes = new ArrayList<PortInst>();
        boolean mightCreateExports = false;
        Rectangle2D.Double checkBounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
        Iterator<RTBounds> it = newCell.searchIterator(checkBounds);
        block0: while (it.hasNext()) {
            RTBounds geom = it.next();
            if (!(geom instanceof NodeInst)) continue;
            NodeInst ni = (NodeInst)geom;
            if (ni.isCellInstance()) {
                boolean found = false;
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi2 = pIt.next();
                    Poly portPoly = pi2.getPoly();
                    if (!portPoly.contains(pt)) continue;
                    touchingNodes.add(pi2);
                    found = true;
                    break;
                }
                if (found) continue;
                mightCreateExports = true;
                continue;
            }
            if (ni.getFunction() == PrimitiveNode.Function.PIN) {
                if (!ni.getOnlyPortInst().getPortProto().connectsTo(ap) || !ni.getAnchorCenter().equals(pt)) continue;
                touchingNodes.add(ni.getOnlyPortInst());
                continue;
            }
            Poly[] polys = this.tech.getShapeOfNode(ni, true, true, null);
            AffineTransform trans = ni.rotateOut();
            for (int i = 0; i < polys.length; ++i) {
                Poly oPoly = polys[i];
                Layer oLayer = this.geometricLayer(oPoly.getLayer());
                if (layer != oLayer) continue;
                oPoly.transform(trans);
                if (!oPoly.contains(pt)) continue;
                PortInst touchingPi = this.findPortInstClosestToPoly(ni, (PrimitivePort)oPoly.getPort(), pt);
                if (touchingPi == null) {
                    this.addErrorLog(newCell, "Can't find port for " + ni + " and " + oPoly.getPort(), new EPoint(pt.getX(), pt.getY()));
                    continue;
                }
                touchingNodes.add(touchingPi);
                continue block0;
            }
        }
        if (touchingNodes.size() == 0 && mightCreateExports && (pi = this.makePort(newCell, layer, pt)) != null) {
            touchingNodes.add(pi);
        }
        return touchingNodes;
    }

    private PortInst makePort(Cell cell, Layer layer, Point2D pt) {
        Rectangle2D.Double checkBounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
        Iterator<RTBounds> it = cell.searchIterator(checkBounds);
        while (it.hasNext()) {
            RTBounds geom = it.next();
            if (!(geom instanceof NodeInst)) continue;
            NodeInst subNi = (NodeInst)geom;
            PortInst foundPi = null;
            if (subNi.isCellInstance()) {
                AffineTransform transIn = subNi.rotateIn(subNi.translateIn());
                Point2D.Double inside = new Point2D.Double();
                transIn.transform(pt, inside);
                Cell subCell = (Cell)subNi.getProto();
                PortInst pi = this.makePort(subCell, layer, inside);
                if (pi == null) continue;
                Iterator<Export> eIt = pi.getNodeInst().getExports();
                while (eIt.hasNext()) {
                    Export e = eIt.next();
                    if (e.getOriginalPort() != pi) continue;
                    foundPi = subNi.findPortInstFromProto(e);
                    return foundPi;
                }
                if (foundPi != null) continue;
                Netlist nl = subCell.acquireUserNetlist();
                Network net = nl.getNetwork(pi);
                String exportName = null;
                Iterator<String> nIt = net.getExportedNames();
                while (nIt.hasNext()) {
                    String eName = nIt.next();
                    if (exportName != null && exportName.length() >= eName.length()) continue;
                    exportName = eName;
                }
                if (exportName == null) {
                    exportName = "E";
                }
                exportName = ElectricObject.uniqueObjectName(exportName, subCell, PortProto.class, true);
                Export e = Export.newInstance(subCell, pi, exportName);
                foundPi = subNi.findPortInstFromProto(e);
                return foundPi;
            }
            Technology tech = subNi.getProto().getTechnology();
            AffineTransform trans = subNi.rotateOut();
            Poly[] polyList = tech.getShapeOfNode(subNi, true, true, null);
            for (int i = 0; i < polyList.length; ++i) {
                Poly poly = polyList[i];
                if (poly.getPort() == null || this.geometricLayer(poly.getLayer()) != layer) continue;
                poly.transform(trans);
                if (!poly.contains(pt)) continue;
                foundPi = this.findPortInstClosestToPoly(subNi, (PrimitivePort)poly.getPort(), pt);
                return foundPi;
            }
        }
        return null;
    }

    private boolean extractVias(PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        int totalCuts = 0;
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Layer layer : this.allCutLayers.keySet()) {
            layers.add(layer);
            List<PolyBase> cutList = this.allCutLayers.get(layer);
            totalCuts += cutList.size();
        }
        ArrayList<NodeInst> contactNodes = new ArrayList<NodeInst>();
        int soFar = 0;
        for (Layer layer : layers) {
            List<PossibleVia> possibleVias = this.findPossibleVias(layer);
            HashSet<Layer> layersToExamine = new HashSet<Layer>();
            for (PossibleVia pv : possibleVias) {
                for (int i = 0; i < pv.layers.length; ++i) {
                    layersToExamine.add(pv.layers[i]);
                }
            }
            List<PolyBase> cutList = this.allCutLayers.get(layer);
            RTNode root = null;
            if (Extract.isApproximateCuts()) {
                root = RTNode.makeTopLevel();
                for (PolyBase cut : cutList) {
                    root = RTNode.linkGeom(null, root, new CutBound(cut));
                }
            }
            ArrayList<PolyBase> cutsNotExtracted = new ArrayList<PolyBase>();
            while (cutList.size() > 0) {
                Rectangle2D cutBox;
                PolyBase cut;
                cut = cutList.get(0);
                if (++soFar % 100 == 0) {
                    Job.getUserInterface().setProgressValue(soFar * 100 / totalCuts);
                }
                if ((cutBox = cut.getBox()) == null) {
                    cutBox = cut.getBounds2D();
                    double centerX = cutBox.getCenterX() / 400.0;
                    double centerY = cutBox.getCenterY() / 400.0;
                    String msg = "Cannot extract nonManhattan contact cut at (" + centerX + "," + centerY + ")";
                    this.addErrorLog(newCell, msg, new EPoint(centerX, centerY));
                    cutList.remove(cut);
                    cutsNotExtracted.add(cut);
                    continue;
                }
                Point2D.Double ctr = new Point2D.Double(cutBox.getCenterX(), cutBox.getCenterY());
                HashSet<Layer> layersPresent = new HashSet<Layer>();
                for (Layer l : layersToExamine) {
                    boolean layerAtPoint = originalMerge.contains(l, ctr);
                    if (!layerAtPoint) continue;
                    layersPresent.add(this.geometricLayer(l));
                }
                boolean ignorePWell = false;
                boolean ignoreNWell = false;
                if (this.pWellProcess) {
                    boolean foundNWell = false;
                    for (Layer l : layersPresent) {
                        if (l.getFunction() != Layer.Function.WELLN) continue;
                        foundNWell = true;
                        break;
                    }
                    if (!foundNWell) {
                        ignorePWell = true;
                    }
                }
                if (this.nWellProcess) {
                    boolean foundPWell = false;
                    for (Layer l : layersPresent) {
                        if (l.getFunction() != Layer.Function.WELLP) continue;
                        foundPWell = true;
                        break;
                    }
                    if (!foundPWell) {
                        ignoreNWell = true;
                    }
                }
                boolean foundCut = false;
                String reason = null;
                for (PossibleVia pv : possibleVias) {
                    Rectangle2D.Double contactLoc;
                    boolean someLayersMissing = false;
                    for (int i = 0; i < pv.layers.length; ++i) {
                        if (layersPresent.contains(pv.layers[i]) || ignorePWell && pv.layers[i].getFunction() == Layer.Function.WELLP || ignoreNWell && pv.layers[i].getFunction() == Layer.Function.WELLN) continue;
                        someLayersMissing = true;
                        break;
                    }
                    if (someLayersMissing) continue;
                    double trueWidth = pv.minWidth;
                    double trueHeight = pv.minHeight;
                    if (pv.rotation == 90 || pv.rotation == 270) {
                        trueWidth = pv.minHeight;
                        trueHeight = pv.minWidth;
                    }
                    boolean activeCut = false;
                    boolean polyCut = false;
                    Technology.NodeLayer[] primLayers = pv.pNp.getLayers();
                    for (int i = 0; i < primLayers.length; ++i) {
                        if (primLayers[i].getLayer().getFunction().isDiff()) {
                            activeCut = true;
                        }
                        if (!primLayers[i].getLayer().getFunction().isPoly()) continue;
                        polyCut = true;
                    }
                    if (activeCut && polyCut) {
                        polyCut = false;
                        activeCut = false;
                    }
                    Layer badLayer = null;
                    if (Extract.isApproximateCuts() && pv.cutNodeLayer.getRepresentation() == 3) {
                        HashSet<PolyBase> cutsInArea = new HashSet<PolyBase>();
                        cutsInArea.add(cut);
                        Rectangle2D.Double multiCutArea = new Rectangle2D.Double(cutBox.getCenterX(), cutBox.getCenterY(), 0.0, 0.0);
                        double cutLimit = Math.ceil(Math.max(pv.cutNodeLayer.getMulticutSep1D(), pv.cutNodeLayer.getMulticutSep2D()) + Math.max(pv.cutNodeLayer.getMulticutSizeX(), pv.cutNodeLayer.getMulticutSizeX()) + 2.0);
                        cutLimit *= 400.0;
                        boolean foundMore = true;
                        while (foundMore) {
                            foundMore = false;
                            Rectangle2D.Double searchArea = new Rectangle2D.Double(multiCutArea.getMinX() - cutLimit, multiCutArea.getMinY() - cutLimit, ((RectangularShape)multiCutArea).getWidth() + cutLimit * 2.0, ((RectangularShape)multiCutArea).getHeight() + cutLimit * 2.0);
                            RTNode.Search sea = new RTNode.Search(searchArea, root, true);
                            while (sea.hasNext()) {
                                Rectangle2D bound;
                                CutBound cBound = (CutBound)sea.next();
                                if (cutsInArea.contains(cBound.cut) || !searchArea.contains((bound = cBound.getBounds()).getCenterX(), bound.getCenterY())) continue;
                                cutsInArea.add(cBound.cut);
                                double lX = Math.min(multiCutArea.getMinX(), bound.getCenterX());
                                double hX = Math.max(multiCutArea.getMaxX(), bound.getCenterX());
                                double lY = Math.min(multiCutArea.getMinY(), bound.getCenterY());
                                double hY = Math.max(multiCutArea.getMaxY(), bound.getCenterY());
                                ((Rectangle2D)multiCutArea).setRect(lX, lY, hX - lX, hY - lY);
                                foundMore = true;
                            }
                        }
                        double lX = multiCutArea.getCenterX() - trueWidth / 2.0;
                        double hX = multiCutArea.getCenterX() + trueWidth / 2.0;
                        double lY = multiCutArea.getCenterY() - trueHeight / 2.0;
                        double hY = multiCutArea.getCenterY() + trueHeight / 2.0;
                        ((Rectangle2D)multiCutArea).setRect(lX, lY, hX - lX, hY - lY);
                        badLayer = this.doesNodeFit(pv, multiCutArea, originalMerge, ignorePWell, ignoreNWell);
                        if (badLayer == null) {
                            double mw = ((RectangularShape)multiCutArea).getWidth();
                            double mh = ((RectangularShape)multiCutArea).getHeight();
                            if (pv.rotation == 90 || pv.rotation == 270) {
                                mw = ((RectangularShape)multiCutArea).getHeight();
                                mh = ((RectangularShape)multiCutArea).getWidth();
                            }
                            this.realizeBiggestContact(pv.pNp, multiCutArea.getCenterX(), multiCutArea.getCenterY(), mw, mh, pv.rotation * 10, originalMerge, newCell, contactNodes, activeCut, polyCut);
                            for (PolyBase cutsFound : cutsInArea) {
                                cutList.remove(cutsFound);
                            }
                            soFar += cutsInArea.size() - 1;
                            foundCut = true;
                            break;
                        }
                    }
                    if ((badLayer = this.doesNodeFit(pv, contactLoc = new Rectangle2D.Double(cutBox.getCenterX() - trueWidth / 2.0, cutBox.getCenterY() - trueHeight / 2.0, trueWidth, trueHeight), originalMerge, ignorePWell, ignoreNWell)) == null) {
                        this.realizeNode(pv.pNp, contactLoc.getCenterX(), contactLoc.getCenterY(), pv.minWidth, pv.minHeight, pv.rotation * 10, null, originalMerge, newCell, contactNodes);
                        cutList.remove(cut);
                        foundCut = true;
                        break;
                    }
                    reason = "node " + pv.pNp.describe(false) + ", layer " + badLayer.getName() + " does not fit";
                    if (pv.rotation == 0) continue;
                    reason = reason + " (when rotated " + pv.rotation + ")";
                }
                if (foundCut) continue;
                double centerX = cutBox.getCenterX() / 400.0;
                double centerY = cutBox.getCenterY() / 400.0;
                String msg = "Did not extract contact " + cut.getLayer().getName() + " cut at (" + centerX + "," + centerY + ") in '" + newCell.getName() + "'";
                if (reason != null) {
                    msg = msg + " because " + reason;
                }
                this.addErrorLog(newCell, msg, new EPoint(centerX, centerY));
                cutList.remove(cut);
                cutsNotExtracted.add(cut);
            }
            if (cutsNotExtracted.size() <= 0) continue;
            this.allCutLayers.put(layer, cutsNotExtracted);
        }
        if (!this.startSection("Finish extracting " + contactNodes.size() + " vias...")) {
            return false;
        }
        RTNode root = RTNode.makeTopLevel();
        for (NodeInst ni : contactNodes) {
            root = RTNode.linkGeom(null, root, ni);
        }
        PolyMerge subtractMerge = new PolyMerge();
        this.extractContactNodes(root, merge, subtractMerge, 0, contactNodes.size());
        merge.subtractMerge(subtractMerge);
        return true;
    }

    private void realizeBiggestContact(PrimitiveNode pNp, double x, double y, double sX, double sY, int rot, PolyMerge merge, Cell newCell, List<NodeInst> contactNodes, boolean activeCut, boolean polyCut) {
        Orientation orient = Orientation.fromAngle(rot);
        EPoint ctr = new EPoint(x / 400.0, y / 400.0);
        double lowXInc = 0.0;
        double highXInc = 800.0;
        while (true) {
            NodeInst ni;
            if ((ni = NodeInst.makeDummyInstance(pNp, ctr, (sX + highXInc) / 400.0, sY / 400.0, orient)) == null) {
                return;
            }
            Poly error = this.dummyNodeFits(ni, merge, activeCut, polyCut);
            if (error != null) break;
            lowXInc = highXInc;
            highXInc *= 2.0;
        }
        while (!(highXInc - lowXInc <= 1.0)) {
            double medInc = (lowXInc + highXInc) / 2.0;
            NodeInst ni = NodeInst.makeDummyInstance(pNp, ctr, (sX + medInc) / 400.0, sY / 400.0, orient);
            if (ni == null) {
                return;
            }
            Poly error = this.dummyNodeFits(ni, merge, activeCut, polyCut);
            if (error == null) {
                lowXInc = medInc;
                continue;
            }
            highXInc = medInc;
        }
        double lowYInc = 0.0;
        double highYInc = 800.0;
        while (true) {
            NodeInst ni;
            if ((ni = NodeInst.makeDummyInstance(pNp, ctr, sX / 400.0, (sY + highYInc) / 400.0, orient)) == null) {
                return;
            }
            Poly error = this.dummyNodeFits(ni, merge, activeCut, polyCut);
            if (error != null) break;
            lowYInc = highYInc;
            highYInc *= 2.0;
        }
        while (!(highYInc - lowYInc <= 1.0)) {
            double medInc = (lowYInc + highYInc) / 2.0;
            NodeInst ni = NodeInst.makeDummyInstance(pNp, ctr, sX / 400.0, (sY + medInc) / 400.0, orient);
            if (ni == null) {
                return;
            }
            Poly error = this.dummyNodeFits(ni, merge, activeCut, polyCut);
            if (error == null) {
                lowYInc = medInc;
                continue;
            }
            highYInc = medInc;
        }
        this.realizeNode(pNp, x, y, sX += lowXInc, sY += lowYInc, rot, null, merge, newCell, contactNodes);
    }

    private Poly dummyNodeFits(NodeInst ni, PolyMerge merge, boolean activeCut, boolean polyCut) {
        AffineTransform trans = ni.rotateOut();
        Technology tech = ni.getProto().getTechnology();
        Poly[] polys = tech.getShapeOfNode(ni);
        double biggestArea = 0.0;
        Poly biggestPoly = null;
        for (Poly poly : polys) {
            Layer l = poly.getLayer();
            if (l == null) continue;
            l = this.geometricLayer(l);
            poly.setLayer(l);
            if (l.getFunction().isSubstrate() || l.getFunction().isContact()) continue;
            poly.transform(trans);
            double area = poly.getArea();
            if (area > biggestArea) {
                biggestArea = area;
                biggestPoly = poly;
            }
            Point2D[] points = poly.getPoints();
            for (int i = 0; i < points.length; ++i) {
                poly.setPoint(i, this.scaleUp(points[i].getX()), this.scaleUp(points[i].getY()));
            }
            if (merge.contains(l, poly)) continue;
            return poly;
        }
        if (activeCut && biggestPoly != null && merge.intersects(this.polyLayer, biggestPoly)) {
            return biggestPoly;
        }
        if (polyCut && biggestPoly != null) {
            if (this.pActiveLayer != null && merge.intersects(this.pActiveLayer, biggestPoly)) {
                return biggestPoly;
            }
            if (this.nActiveLayer != null && this.nActiveLayer != this.pActiveLayer && merge.intersects(this.nActiveLayer, biggestPoly)) {
                return biggestPoly;
            }
        }
        return null;
    }

    private int extractContactNodes(RTNode root, PolyMerge merge, PolyMerge subtractMerge, int soFar, int totalContacts) {
        for (int j = 0; j < root.getTotal(); ++j) {
            Object child = root.getChild(j);
            if (root.getFlag()) {
                if (++soFar % 100 == 0) {
                    Job.getUserInterface().setProgressValue(soFar * 100 / totalContacts);
                }
                NodeInst ni = (NodeInst)child;
                AffineTransform trans = ni.rotateOut();
                Poly[] polys = this.tech.getShapeOfNode(ni);
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    Layer layer = poly.getLayer();
                    if ((layer = this.geometricLayer(layer)).getFunction().isContact()) continue;
                    poly.transform(trans);
                    Point2D[] points = poly.getPoints();
                    for (int k = 0; k < points.length; ++k) {
                        poly.setPoint(k, this.scaleUp(points[k].getX()), this.scaleUp(points[k].getY()));
                    }
                    poly.roundPoints();
                    subtractMerge.add(layer, poly);
                }
                if (soFar % 500 != 0) continue;
                merge.subtractMerge(subtractMerge);
                ArrayList<Layer> allLayers = new ArrayList<Layer>();
                for (Layer lay : subtractMerge.getKeySet()) {
                    allLayers.add(lay);
                }
                for (Layer lay : allLayers) {
                    subtractMerge.deleteLayer(lay);
                }
                continue;
            }
            soFar = this.extractContactNodes((RTNode)child, merge, subtractMerge, soFar, totalContacts);
        }
        return soFar;
    }

    private List<PossibleVia> findPossibleVias(Layer lay) {
        ArrayList<PossibleVia> possibleVias = new ArrayList<PossibleVia>();
        Iterator<PrimitiveNode> nIt = this.tech.getNodes();
        while (nIt.hasNext()) {
            int i;
            PrimitiveNode pNp = nIt.next();
            PrimitiveNode.Function fun = pNp.getFunction();
            if (fun != PrimitiveNode.Function.CONTACT && fun != PrimitiveNode.Function.WELL && fun != PrimitiveNode.Function.SUBSTRATE) continue;
            boolean bogus = false;
            Technology.NodeLayer[] nLayers = pNp.getLayers();
            for (int i2 = 0; i2 < nLayers.length; ++i2) {
                Technology.NodeLayer nLay = nLayers[i2];
                Technology.TechPoint[] debugPoints = nLay.getPoints();
                if (debugPoints != null && debugPoints.length > 0) continue;
                bogus = true;
                break;
            }
            if (bogus) continue;
            Technology.NodeLayer cutNodeLayer = null;
            Technology.NodeLayer m1Layer = null;
            Technology.NodeLayer m2Layer = null;
            boolean hasPolyActive = false;
            ArrayList<Technology.NodeLayer> pvLayers = new ArrayList<Technology.NodeLayer>();
            for (int i3 = 0; i3 < nLayers.length; ++i3) {
                Technology.NodeLayer nLay = nLayers[i3];
                Layer nLayer = nLay.getLayer();
                Layer.Function lFun = nLayer.getFunction();
                if (lFun.isMetal()) {
                    if (m1Layer == null) {
                        m1Layer = nLay;
                    } else if (m2Layer == null) {
                        m2Layer = nLay;
                    }
                } else if (lFun.isDiff() || lFun.isPoly()) {
                    hasPolyActive = true;
                }
                if (this.ignoreActiveSelectWell && fun == PrimitiveNode.Function.CONTACT && (lFun.isImplant() || lFun.isSubstrate() || lFun.isWell())) continue;
                boolean cutLayer = false;
                if (nLayer == lay) {
                    cutLayer = true;
                } else if (nLayer.getFunction() == lay.getFunction()) {
                    cutLayer = true;
                }
                if (cutLayer) {
                    cutNodeLayer = nLay;
                    continue;
                }
                pvLayers.add(nLay);
            }
            if (cutNodeLayer == null) continue;
            if (!hasPolyActive && fun == PrimitiveNode.Function.CONTACT) {
                boolean badContact = false;
                if (m1Layer == null || m2Layer == null) {
                    badContact = true;
                } else {
                    int highMetal;
                    int lowMetal = m1Layer.getLayer().getFunction().getLevel();
                    if (lowMetal > (highMetal = m2Layer.getLayer().getFunction().getLevel())) {
                        int s = lowMetal;
                        lowMetal = highMetal;
                        highMetal = s;
                    }
                    if (lowMetal != highMetal - 1) {
                        badContact = true;
                    }
                }
                if (badContact) {
                    if (this.bogusContacts.contains(pNp)) continue;
                    this.bogusContacts.add(pNp);
                    System.out.println("Not extracting unusual via contact: " + pNp.describe(false));
                    continue;
                }
            }
            PossibleVia pv = new PossibleVia(pNp, pvLayers.size());
            pv.rotation = 0;
            pv.cutNodeLayer = cutNodeLayer;
            pv.minWidth = this.scaleUp(pNp.getDefWidth());
            pv.minHeight = this.scaleUp(pNp.getDefHeight());
            pv.largestShrink = 0.0;
            int fill = 0;
            for (Technology.NodeLayer nLay : pvLayers) {
                pv.layers[fill] = this.geometricLayer(nLay.getLayer());
                pv.shrinkL[fill] = this.scaleUp(pNp.getDefWidth() * (0.5 + nLay.getLeftEdge().getMultiplier()) + nLay.getLeftEdge().getAdder());
                pv.shrinkR[fill] = this.scaleUp(pNp.getDefWidth() * (0.5 - nLay.getRightEdge().getMultiplier()) - nLay.getRightEdge().getAdder());
                pv.shrinkT[fill] = this.scaleUp(pNp.getDefHeight() * (0.5 - nLay.getTopEdge().getMultiplier()) - nLay.getTopEdge().getAdder());
                pv.shrinkB[fill] = this.scaleUp(pNp.getDefHeight() * (0.5 + nLay.getBottomEdge().getMultiplier()) + nLay.getBottomEdge().getAdder());
                double ls = Math.max(Math.max(pv.shrinkL[fill], pv.shrinkR[fill]), Math.max(pv.shrinkT[fill], pv.shrinkB[fill]));
                if (fill == 0 || ls > pv.largestShrink) {
                    pv.largestShrink = ls;
                }
                ++fill;
            }
            possibleVias.add(pv);
            boolean hvSymmetry = true;
            boolean rotSymmetry = true;
            for (int i4 = 0; i4 < pv.layers.length; ++i4) {
                if (pv.shrinkL[i4] != pv.shrinkR[i4] || pv.shrinkT[i4] != pv.shrinkB[i4]) {
                    rotSymmetry = false;
                    break;
                }
                if (pv.shrinkL[i4] == pv.shrinkT[i4] && pNp.getDefWidth() == pNp.getDefHeight()) continue;
                hvSymmetry = false;
            }
            if (!hvSymmetry || !rotSymmetry) {
                PossibleVia newPV = new PossibleVia(pv.pNp, pv.layers.length);
                newPV.rotation = 90;
                newPV.cutNodeLayer = pv.cutNodeLayer;
                newPV.largestShrink = pv.largestShrink;
                newPV.minWidth = pv.minWidth;
                newPV.minHeight = pv.minHeight;
                for (i = 0; i < pv.layers.length; ++i) {
                    newPV.layers[i] = pv.layers[i];
                    newPV.shrinkL[i] = pv.shrinkT[i];
                    newPV.shrinkR[i] = pv.shrinkB[i];
                    newPV.shrinkT[i] = pv.shrinkR[i];
                    newPV.shrinkB[i] = pv.shrinkL[i];
                }
                possibleVias.add(newPV);
            }
            if (rotSymmetry) continue;
            PossibleVia newPV = new PossibleVia(pv.pNp, pv.layers.length);
            newPV.rotation = 180;
            newPV.cutNodeLayer = pv.cutNodeLayer;
            newPV.largestShrink = pv.largestShrink;
            newPV.minWidth = pv.minWidth;
            newPV.minHeight = pv.minHeight;
            for (i = 0; i < pv.layers.length; ++i) {
                newPV.layers[i] = pv.layers[i];
                newPV.shrinkL[i] = pv.shrinkR[i];
                newPV.shrinkR[i] = pv.shrinkL[i];
                newPV.shrinkT[i] = pv.shrinkB[i];
                newPV.shrinkB[i] = pv.shrinkT[i];
            }
            possibleVias.add(newPV);
            newPV = new PossibleVia(pv.pNp, pv.layers.length);
            newPV.rotation = 270;
            newPV.cutNodeLayer = pv.cutNodeLayer;
            newPV.largestShrink = pv.largestShrink;
            newPV.minWidth = pv.minWidth;
            newPV.minHeight = pv.minHeight;
            for (i = 0; i < pv.layers.length; ++i) {
                newPV.layers[i] = pv.layers[i];
                newPV.shrinkL[i] = pv.shrinkB[i];
                newPV.shrinkR[i] = pv.shrinkT[i];
                newPV.shrinkT[i] = pv.shrinkL[i];
                newPV.shrinkB[i] = pv.shrinkR[i];
            }
            possibleVias.add(newPV);
        }
        Collections.sort(possibleVias, new ViasBySize());
        return possibleVias;
    }

    private Layer doesNodeFit(PossibleVia pv, Rectangle2D cutBox, PolyMerge originalMerge, boolean ignorePWell, boolean ignoreNWell) {
        for (int i = 0; i < pv.layers.length; ++i) {
            double hY;
            double lY;
            double layerCY;
            double hX;
            double lX;
            double layerCX;
            PolyBase layerPoly;
            Layer l = pv.layers[i];
            if (ignorePWell && l.getFunction() == Layer.Function.WELLP || ignoreNWell && l.getFunction() == Layer.Function.WELLN || originalMerge.contains(l, layerPoly = new PolyBase(layerCX = ((lX = cutBox.getMinX() + pv.shrinkL[i]) + (hX = cutBox.getMaxX() - pv.shrinkR[i])) / 2.0, layerCY = ((lY = cutBox.getMinY() + pv.shrinkB[i]) + (hY = cutBox.getMaxY() - pv.shrinkT[i])) / 2.0, hX - lX, hY - lY))) continue;
            return l;
        }
        return null;
    }

    private void extractTransistors(PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        if (this.polyLayer == null || this.tempLayer1 == null) {
            return;
        }
        PrimitiveNode pTransistor = null;
        PrimitiveNode nTransistor = null;
        Iterator<PrimitiveNode> it = this.tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode pNp = it.next();
            if (pTransistor == null && pNp.getFunction().isPTypeTransistor()) {
                pTransistor = pNp;
            }
            if (nTransistor != null || !pNp.getFunction().isNTypeTransistor()) continue;
            nTransistor = pNp;
        }
        if (nTransistor != null) {
            this.findTransistors(nTransistor, this.nActiveLayer, merge, originalMerge, newCell);
        }
        if (pTransistor != null) {
            this.findTransistors(pTransistor, this.pActiveLayer, merge, originalMerge, newCell);
        }
    }

    private void findTransistors(PrimitiveNode transistor, Layer activeLayer, PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        originalMerge.intersectLayers(this.polyLayer, activeLayer, this.tempLayer1);
        Technology.NodeLayer[] layers = transistor.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            Layer.Function fun;
            Technology.NodeLayer lay = layers[i];
            Layer layer = this.geometricLayer(lay.getLayer());
            if (layer == this.polyLayer || layer == activeLayer || (fun = layer.getFunction()) == Layer.Function.WELLP && this.pWellProcess || fun == Layer.Function.WELLN && this.nWellProcess) continue;
            originalMerge.intersectLayers(layer, this.tempLayer1, this.tempLayer1);
        }
        NodeInst dni = NodeInst.makeDummyInstance(transistor);
        Poly[] polys = transistor.getTechnology().getShapeOfNode(dni);
        double widestPoly = 0.0;
        double widestActive = 0.0;
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            Rectangle2D bounds = poly.getBounds2D();
            if (poly.getLayer().getFunction().isPoly()) {
                widestPoly = Math.max(widestPoly, bounds.getWidth());
            }
            if (!poly.getLayer().getFunction().isDiff()) continue;
            widestActive = Math.max(widestActive, bounds.getWidth());
        }
        boolean polyVertical = widestPoly < widestActive;
        List<PolyBase> polyList = this.getMergePolys(originalMerge, this.tempLayer1);
        if (polyList == null) {
            return;
        }
        for (PolyBase poly : polyList) {
            Rectangle2D transBox = poly.getBox();
            if (transBox != null) {
                Point2D.Double left = new Point2D.Double(transBox.getMinX() - 1.0, transBox.getCenterY());
                Point2D.Double right = new Point2D.Double(transBox.getMaxX() + 1.0, transBox.getCenterY());
                Point2D.Double bottom = new Point2D.Double(transBox.getCenterX(), transBox.getMinY() - 1.0);
                Point2D.Double top = new Point2D.Double(transBox.getCenterX(), transBox.getMaxY() + 1.0);
                if (polyVertical) {
                    Point2D.Double swap = left;
                    left = top;
                    top = right;
                    right = bottom;
                    bottom = swap;
                }
                int angle = 0;
                double wid = transBox.getWidth();
                double hei = transBox.getHeight();
                if (!(originalMerge.contains(this.polyLayer, left) && originalMerge.contains(this.polyLayer, right) && originalMerge.contains(activeLayer, top) && originalMerge.contains(activeLayer, bottom))) {
                    if (originalMerge.contains(activeLayer, left) && originalMerge.contains(activeLayer, right) && originalMerge.contains(this.polyLayer, top) && originalMerge.contains(this.polyLayer, bottom)) {
                        angle = 900;
                        wid = transBox.getHeight();
                        hei = transBox.getWidth();
                    } else {
                        this.addErrorLog(newCell, "Transistor at (" + transBox.getCenterX() + "," + transBox.getCenterY() + ") doesn't have proper tabs...ignored", new EPoint(transBox.getCenterX(), transBox.getCenterY()));
                        continue;
                    }
                }
                SizeOffset so = transistor.getProtoSizeOffset();
                double width = wid + this.scaleUp(so.getLowXOffset() + so.getHighXOffset());
                double height = hei + this.scaleUp(so.getLowYOffset() + so.getHighYOffset());
                this.realizeNode(transistor, poly.getCenterX(), poly.getCenterY(), width, height, angle, null, merge, newCell, null);
                continue;
            }
            this.extractNonManhattanTransistor(poly, transistor, merge, originalMerge, newCell);
        }
        originalMerge.deleteLayer(this.tempLayer1);
    }

    private void extractNonManhattanTransistor(PolyBase poly, PrimitiveNode transistor, PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        SizeOffset so = transistor.getProtoSizeOffset();
        double minWidth = transistor.getDefHeight() - so.getLowYOffset() - so.getHighYOffset();
        List<Centerline> lines = this.findCenterlines(poly, this.tempLayer1, minWidth, merge, originalMerge);
        if (lines.size() == 0) {
            return;
        }
        if (lines.size() == 1) {
            Centerline cl = lines.get(0);
            double polySize = cl.start.distance(cl.end);
            double activeSize = cl.width;
            double cX = (cl.start.getX() + cl.end.getX()) / 2.0;
            double cY = (cl.start.getY() + cl.end.getY()) / 2.0;
            double sX = polySize + this.scaleUp(so.getLowXOffset() + so.getHighXOffset());
            double sY = activeSize + this.scaleUp(so.getLowYOffset() + so.getHighYOffset());
            this.realizeNode(transistor, cX, cY, sX, sY, cl.angle, null, merge, newCell, null);
            return;
        }
        Point2D[] points = new EPoint[lines.size() + 1];
        for (Centerline cl : lines) {
            cl.handled = false;
        }
        Centerline firstCL = lines.get(0);
        firstCL.handled = true;
        points[0] = new EPoint(firstCL.start.getX(), firstCL.start.getY());
        points[1] = new EPoint(firstCL.end.getX(), firstCL.end.getY());
        int pointsSeen = 2;
        while (pointsSeen < points.length) {
            boolean added = false;
            for (Centerline cl : lines) {
                int i;
                if (cl.handled) continue;
                EPoint start = new EPoint(cl.start.getX(), cl.start.getY());
                EPoint end = new EPoint(cl.end.getX(), cl.end.getY());
                if (start.equals(points[0])) {
                    for (i = pointsSeen; i > 0; --i) {
                        points[i] = points[i - 1];
                    }
                    points[0] = end;
                    ++pointsSeen;
                    cl.handled = true;
                    added = true;
                    break;
                }
                if (end.equals(points[0])) {
                    for (i = pointsSeen; i > 0; --i) {
                        points[i] = points[i - 1];
                    }
                    points[0] = start;
                    ++pointsSeen;
                    cl.handled = true;
                    added = true;
                    break;
                }
                if (start.equals(points[pointsSeen - 1])) {
                    points[pointsSeen++] = end;
                    cl.handled = true;
                    added = true;
                    break;
                }
                if (!end.equals(points[pointsSeen - 1])) continue;
                points[pointsSeen++] = start;
                cl.handled = true;
                added = true;
                break;
            }
            if (added) continue;
            break;
        }
        if (pointsSeen != points.length) {
            return;
        }
        double lX = points[0].getX();
        double hX = points[0].getX();
        double lY = points[0].getY();
        double hY = points[0].getY();
        for (int i = 1; i < points.length; ++i) {
            if (points[i].getX() < lX) {
                lX = points[i].getX();
            }
            if (points[i].getX() > hX) {
                hX = points[i].getX();
            }
            if (points[i].getY() < lY) {
                lY = points[i].getY();
            }
            if (!(points[i].getY() > hY)) continue;
            hY = points[i].getY();
        }
        double cX = (lX + hX) / 2.0;
        double cY = (lY + hY) / 2.0;
        for (int i = 0; i < points.length; ++i) {
            points[i] = new EPoint(points[i].getX() / 400.0, points[i].getY() / 400.0);
        }
        this.realizeNode(transistor, cX, cY, hX - lX, hY - lY, 0, points, merge, newCell, null);
    }

    private void extendGeometry(PolyMerge merge, PolyMerge originalMerge, Cell newCell, boolean justExtend) {
        ArrayList<Layer> extendableLayers = new ArrayList<Layer>();
        for (Layer layer : merge.getKeySet()) {
            ArcProto ap = this.arcsForLayer.get(layer);
            if (ap == null) continue;
            extendableLayers.add(layer);
        }
        int totExtensions = 0;
        HashMap<Layer, List<PolyBase>> geomToExtend = new HashMap<Layer, List<PolyBase>>();
        int soFar = 0;
        for (Layer layer : extendableLayers) {
            List<PolyBase> polyList = this.getMergePolys(merge, layer);
            geomToExtend.put(layer, polyList);
            totExtensions += polyList.size();
            Job.getUserInterface().setProgressValue(++soFar * 100 / extendableLayers.size());
        }
        Job.getUserInterface().setProgressValue(0L);
        Job.getUserInterface().setProgressNote("Extracting " + totExtensions + (justExtend ? " extensions..." : " connections..."));
        soFar = 0;
        for (Layer layer : extendableLayers) {
            ArcProto ap = this.arcsForLayer.get(layer);
            if (ap == null) continue;
            double wid = ap.getDefaultLambdaBaseWidth();
            double arcLayerWidth = 2.0 * (ap.getDefaultLambdaExtendOverMin() + ap.getLayerLambdaExtend(layer));
            List polyList = (List)geomToExtend.get(layer);
            for (PolyBase poly : polyList) {
                GenMath.MutableBoolean tailExtend;
                GenMath.MutableBoolean headExtend;
                Point2D.Double pt2;
                Point2D.Double pt1;
                PortInst pi;
                Job.getUserInterface().setProgressValue(++soFar * 100 / totExtensions);
                HashMap<Network, Object> netsThatTouch = this.getNetsThatTouch(poly, newCell, justExtend);
                if (netsThatTouch == null) continue;
                ArrayList<Object> objectsToConnect = new ArrayList<Object>();
                for (Network net : netsThatTouch.keySet()) {
                    Object entry = netsThatTouch.get(net);
                    if (entry == null) continue;
                    objectsToConnect.add(entry);
                }
                if (objectsToConnect.size() == 1) {
                    this.extendObject((ElectricObject)objectsToConnect.get(0), poly, layer, ap, merge, originalMerge, newCell);
                    continue;
                }
                if (justExtend || objectsToConnect.size() != 2) continue;
                ElectricObject obj1 = (ElectricObject)objectsToConnect.get(0);
                ElectricObject obj2 = (ElectricObject)objectsToConnect.get(1);
                if (obj1 instanceof ArcInst) {
                    pi = this.findArcEnd((ArcInst)obj1, poly);
                    if (pi == null) {
                        this.findArcEnd((ArcInst)obj1, poly);
                        continue;
                    }
                    obj1 = pi;
                }
                if (obj2 instanceof ArcInst) {
                    pi = this.findArcEnd((ArcInst)obj2, poly);
                    if (pi == null) {
                        this.findArcEnd((ArcInst)obj2, poly);
                        continue;
                    }
                    obj2 = pi;
                }
                PortInst pi1 = (PortInst)obj1;
                PortInst pi2 = (PortInst)obj2;
                Poly poly1 = pi1.getPoly();
                Poly poly2 = pi2.getPoly();
                Rectangle2D polyBounds1 = poly1.getBounds2D();
                Rectangle2D polyBounds2 = poly2.getBounds2D();
                if (polyBounds1.getMinX() <= polyBounds2.getMaxX() && polyBounds1.getMaxX() >= polyBounds2.getMinX()) {
                    double xpos = polyBounds1.getCenterX();
                    if (xpos < polyBounds2.getMinX()) {
                        xpos = polyBounds2.getMinX();
                    }
                    if (xpos > polyBounds2.getMaxX()) {
                        xpos = polyBounds2.getMaxX();
                    }
                    pt1 = new Point2D.Double(xpos, polyBounds1.getCenterY());
                    pt2 = new Point2D.Double(xpos, polyBounds2.getCenterY());
                    headExtend = new GenMath.MutableBoolean(true);
                    tailExtend = new GenMath.MutableBoolean(true);
                    originalMerge.arcPolyFits(layer, pt1, pt2, arcLayerWidth, headExtend, tailExtend);
                    this.realizeArc(ap, pi1, pi2, pt1, pt2, wid, !headExtend.booleanValue(), !tailExtend.booleanValue(), merge);
                    continue;
                }
                if (polyBounds1.getMinY() <= polyBounds2.getMaxY() && polyBounds1.getMaxY() >= polyBounds2.getMinY()) {
                    double ypos = polyBounds1.getCenterY();
                    if (ypos < polyBounds2.getMinY()) {
                        ypos = polyBounds2.getMinY();
                    }
                    if (ypos > polyBounds2.getMaxY()) {
                        ypos = polyBounds2.getMaxY();
                    }
                    pt1 = new Point2D.Double(polyBounds1.getCenterX(), ypos);
                    pt2 = new Point2D.Double(polyBounds2.getCenterX(), ypos);
                    headExtend = new GenMath.MutableBoolean(true);
                    tailExtend = new GenMath.MutableBoolean(true);
                    originalMerge.arcPolyFits(layer, pt1, pt2, arcLayerWidth, headExtend, tailExtend);
                    this.realizeArc(ap, pi1, pi2, pt1, pt2, wid, !headExtend.booleanValue(), !tailExtend.booleanValue(), merge);
                    continue;
                }
                Point2D.Double pt12 = new Point2D.Double(polyBounds1.getCenterX(), polyBounds1.getCenterY());
                Point2D.Double pt22 = new Point2D.Double(polyBounds2.getCenterX(), polyBounds2.getCenterY());
                Point2D.Double corner1 = new Point2D.Double(polyBounds1.getCenterX(), polyBounds2.getCenterY());
                Point2D.Double corner2 = new Point2D.Double(polyBounds2.getCenterX(), polyBounds1.getCenterY());
                Point2D.Double containsIt = null;
                if (poly.contains(corner1)) {
                    containsIt = corner1;
                } else if (poly.contains(corner2)) {
                    containsIt = corner2;
                }
                if (containsIt == null) continue;
                PrimitiveNode np = ap.findPinProto();
                NodeInst ni = this.createNode(np, containsIt, np.getDefWidth(), np.getDefHeight(), null, newCell);
                PortInst pi3 = ni.getOnlyPortInst();
                GenMath.MutableBoolean headExtend2 = new GenMath.MutableBoolean(true);
                GenMath.MutableBoolean tailExtend2 = new GenMath.MutableBoolean(true);
                originalMerge.arcPolyFits(layer, pt12, containsIt, arcLayerWidth, headExtend2, tailExtend2);
                this.realizeArc(ap, pi1, pi3, pt12, containsIt, wid, !headExtend2.booleanValue(), !tailExtend2.booleanValue(), merge);
                headExtend2.setValue(true);
                tailExtend2.setValue(true);
                originalMerge.arcPolyFits(layer, pt22, containsIt, arcLayerWidth, headExtend2, tailExtend2);
                this.realizeArc(ap, pi2, pi3, pt22, containsIt, wid, !headExtend2.booleanValue(), !tailExtend2.booleanValue(), merge);
            }
        }
    }

    private void extendObject(ElectricObject obj, PolyBase poly, Layer layer, ArcProto ap, PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        Rectangle2D totalBounds;
        Rectangle2D polyBounds = poly.getBox();
        if (polyBounds == null && originalMerge.contains(layer, totalBounds = poly.getBounds2D())) {
            polyBounds = totalBounds;
        }
        if (polyBounds == null) {
            return;
        }
        Point2D.Double polyCtr = new Point2D.Double(polyBounds.getCenterX(), polyBounds.getCenterY());
        if (obj instanceof ArcInst) {
            double tailDist;
            ArcInst ai = (ArcInst)obj;
            double headDist = polyCtr.distance(ai.getHeadLocation());
            obj = headDist < (tailDist = polyCtr.distance(ai.getTailLocation())) ? ai.getHeadPortInst() : ai.getTailPortInst();
        }
        PortInst pi = (PortInst)obj;
        Poly portPoly = pi.getPoly();
        Rectangle2D portRect = portPoly.getBounds2D();
        portRect.setRect(this.scaleUp(portRect.getMinX()), this.scaleUp(portRect.getMinY()), this.scaleUp(portRect.getWidth()), this.scaleUp(portRect.getHeight()));
        PrimitiveNode np = ap.findPinProto();
        if (((Point2D)polyCtr).getY() >= portRect.getMinY() && ((Point2D)polyCtr).getY() <= portRect.getMaxY() && ((Point2D)polyCtr).getX() >= portRect.getMinX() && ((Point2D)polyCtr).getX() <= portRect.getMaxX()) {
            if (polyBounds.getWidth() > polyBounds.getHeight()) {
                double endExtension = polyBounds.getHeight() / 2.0;
                Point2D.Double pinPt1 = new Point2D.Double((polyBounds.getMaxX() - endExtension) / 400.0, ((Point2D)polyCtr).getY() / 400.0);
                Point2D.Double pinPt2 = new Point2D.Double((polyBounds.getMinX() + endExtension) / 400.0, ((Point2D)polyCtr).getY() / 400.0);
                Point2D.Double objPt = new Point2D.Double(portRect.getCenterX() / 400.0, ((Point2D)polyCtr).getY() / 400.0);
                double size = Math.min(polyBounds.getWidth(), polyBounds.getHeight()) / 400.0;
                NodeInst ni1 = this.createNode(np, pinPt1, size, size, null, newCell);
                NodeInst ni2 = this.createNode(np, pinPt2, size, size, null, newCell);
                this.realizeArc(ap, ni1.getOnlyPortInst(), pi, pinPt1, objPt, polyBounds.getHeight() / 400.0, false, false, merge);
                this.realizeArc(ap, ni2.getOnlyPortInst(), pi, pinPt2, objPt, polyBounds.getHeight() / 400.0, false, false, merge);
            } else {
                double endExtension = polyBounds.getWidth() / 2.0;
                Point2D.Double pinPt1 = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, (polyBounds.getMaxY() - endExtension) / 400.0);
                Point2D.Double pinPt2 = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, (polyBounds.getMinY() + endExtension) / 400.0);
                Point2D.Double objPt = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, portRect.getCenterY() / 400.0);
                double size = Math.min(polyBounds.getWidth(), polyBounds.getHeight()) / 400.0;
                NodeInst ni1 = this.createNode(np, pinPt1, size, size, null, newCell);
                NodeInst ni2 = this.createNode(np, pinPt2, size, size, null, newCell);
                this.realizeArc(ap, ni1.getOnlyPortInst(), pi, pinPt1, objPt, polyBounds.getWidth() / 400.0, false, false, merge);
                this.realizeArc(ap, ni2.getOnlyPortInst(), pi, pinPt2, objPt, polyBounds.getWidth() / 400.0, false, false, merge);
            }
            return;
        }
        if (((Point2D)polyCtr).getX() >= portRect.getMinX() && ((Point2D)polyCtr).getX() <= portRect.getMaxX()) {
            Point2D.Double objPt = new Point2D.Double(((Point2D)polyCtr).getX(), portRect.getCenterY());
            Point2D.Double objPtNormal = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, portRect.getCenterY() / 400.0);
            Point2D.Double pinPt = null;
            Point2D.Double pinPtNormal = null;
            boolean endExtend = true;
            double endExtension = polyBounds.getWidth() / 2.0;
            if (polyBounds.getHeight() < polyBounds.getWidth()) {
                endExtend = false;
                endExtension = 0.0;
            }
            if (((Point2D)polyCtr).getY() > portRect.getCenterY()) {
                pinPt = new Point2D.Double(((Point2D)polyCtr).getX(), polyBounds.getMaxY() - endExtension);
                pinPtNormal = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, (polyBounds.getMaxY() - endExtension) / 400.0);
            } else {
                pinPt = new Point2D.Double(((Point2D)polyCtr).getX(), polyBounds.getMinY() + endExtension);
                pinPtNormal = new Point2D.Double(((Point2D)polyCtr).getX() / 400.0, (polyBounds.getMinY() + endExtension) / 400.0);
            }
            double size = Math.min(polyBounds.getWidth(), polyBounds.getHeight()) / 400.0;
            NodeInst ni1 = this.createNode(np, pinPtNormal, size, size, null, newCell);
            GenMath.MutableBoolean headExtend = new GenMath.MutableBoolean(endExtend);
            GenMath.MutableBoolean tailExtend = new GenMath.MutableBoolean(endExtend);
            double wid = polyBounds.getWidth();
            originalMerge.arcPolyFits(layer, pinPt, objPt, wid, headExtend, tailExtend);
            this.realizeArc(ap, ni1.getOnlyPortInst(), pi, pinPtNormal, objPtNormal, wid / 400.0, !headExtend.booleanValue(), !tailExtend.booleanValue(), merge);
            return;
        }
        if (((Point2D)polyCtr).getY() >= portRect.getMinY() && ((Point2D)polyCtr).getY() <= portRect.getMaxY()) {
            Point2D.Double objPt = new Point2D.Double(portRect.getCenterX(), ((Point2D)polyCtr).getY());
            Point2D.Double objPtNormal = new Point2D.Double(portRect.getCenterX() / 400.0, ((Point2D)polyCtr).getY() / 400.0);
            Point2D.Double pinPt = null;
            Point2D.Double pinPtNormal = null;
            boolean endExtend = true;
            double endExtension = polyBounds.getHeight() / 2.0;
            if (polyBounds.getWidth() < polyBounds.getHeight()) {
                endExtend = false;
                endExtension = 0.0;
            }
            if (((Point2D)polyCtr).getX() > portRect.getCenterX()) {
                pinPt = new Point2D.Double(polyBounds.getMaxX() - endExtension, ((Point2D)polyCtr).getY());
                pinPtNormal = new Point2D.Double((polyBounds.getMaxX() - endExtension) / 400.0, ((Point2D)polyCtr).getY() / 400.0);
            } else {
                pinPt = new Point2D.Double(polyBounds.getMinX() + endExtension, ((Point2D)polyCtr).getY());
                pinPtNormal = new Point2D.Double((polyBounds.getMinX() + endExtension) / 400.0, ((Point2D)polyCtr).getY() / 400.0);
            }
            double size = Math.min(polyBounds.getWidth(), polyBounds.getHeight()) / 400.0;
            NodeInst ni1 = this.createNode(np, pinPtNormal, size, size, null, newCell);
            GenMath.MutableBoolean headExtend = new GenMath.MutableBoolean(endExtend);
            GenMath.MutableBoolean tailExtend = new GenMath.MutableBoolean(endExtend);
            double wid = polyBounds.getHeight();
            originalMerge.arcPolyFits(layer, pinPt, objPt, wid, headExtend, tailExtend);
            this.realizeArc(ap, ni1.getOnlyPortInst(), pi, pinPtNormal, objPtNormal, wid / 400.0, !headExtend.booleanValue(), !tailExtend.booleanValue(), merge);
        }
    }

    private PortInst findArcEnd(ArcInst ai, PolyBase poly) {
        EPoint head = ai.getHeadLocation();
        EPoint tail = ai.getTailLocation();
        int ang = GenMath.figureAngle(tail, head);
        int angPlus = (ang + 900) % 3600;
        double width = ai.getLambdaBaseWidth() / 2.0;
        Point2D.Double headButFarther = new Point2D.Double(((Point2D)head).getX() + width * GenMath.cos(ang), ((Point2D)head).getY() + width * GenMath.sin(ang));
        if (poly.contains(headButFarther)) {
            return ai.getHeadPortInst();
        }
        Point2D.Double headOneSide = new Point2D.Double(((Point2D)head).getX() + width * GenMath.cos(angPlus), ((Point2D)head).getY() + width * GenMath.sin(angPlus));
        if (poly.contains(headOneSide)) {
            return ai.getHeadPortInst();
        }
        Point2D.Double headOtherSide = new Point2D.Double(((Point2D)head).getX() + width * GenMath.cos(angPlus), ((Point2D)head).getY() + width * GenMath.sin(angPlus));
        if (poly.contains(headOtherSide)) {
            return ai.getHeadPortInst();
        }
        Point2D.Double tailButFarther = new Point2D.Double(((Point2D)tail).getX() - width * GenMath.cos(ang), ((Point2D)tail).getY() - width * GenMath.sin(ang));
        if (poly.contains(tailButFarther)) {
            return ai.getTailPortInst();
        }
        Point2D.Double tailOneSide = new Point2D.Double(((Point2D)tail).getX() - width * GenMath.cos(angPlus), ((Point2D)tail).getY() - width * GenMath.sin(angPlus));
        if (poly.contains(tailOneSide)) {
            return ai.getTailPortInst();
        }
        Point2D.Double tailOtherSide = new Point2D.Double(((Point2D)tail).getX() - width * GenMath.cos(angPlus), ((Point2D)tail).getY() - width * GenMath.sin(angPlus));
        if (poly.contains(tailOtherSide)) {
            return ai.getTailPortInst();
        }
        return null;
    }

    private boolean polysTouch(PolyBase poly1, PolyBase poly2) {
        int i;
        Point2D[] points2;
        Point2D[] points1 = poly1.getPoints();
        if (points1.length > (points2 = poly2.getPoints()).length) {
            Point2D[] swapPts = points1;
            points1 = points2;
            points2 = swapPts;
            PolyBase swapPoly = poly1;
            poly1 = poly2;
            poly2 = swapPoly;
        }
        for (i = 0; i < points1.length; ++i) {
            if (!poly2.contains(points1[i])) continue;
            return true;
        }
        for (i = 0; i < points1.length; ++i) {
            Point2D.Double midPoint;
            int last = i - 1;
            if (last < 0) {
                last = points1.length - 1;
            }
            if (!poly2.contains(midPoint = new Point2D.Double((points1[last].getX() + points1[i].getX()) / 2.0, (points1[last].getY() + points1[i].getY()) / 2.0))) continue;
            return true;
        }
        return false;
    }

    private HashMap<Network, Object> getNetsThatTouch(PolyBase poly, Cell newCell, boolean justExtend) {
        RTBounds geom;
        Point2D[] points = poly.getPoints();
        Point2D[] newPoints = new Point2D[points.length];
        for (int i = 0; i < points.length; ++i) {
            newPoints[i] = new Point2D.Double(points[i].getX() / 400.0, points[i].getY() / 400.0);
        }
        PolyBase newPoly = new PolyBase(newPoints);
        Layer layer = poly.getLayer();
        HashMap<Network, Object> netsThatTouch = new HashMap<Network, Object>();
        Rectangle2D bounds = newPoly.getBounds2D();
        Point2D.Double centerPoint = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        Netlist nl = newCell.acquireUserNetlist();
        Iterator<RTBounds> it = newCell.searchIterator(bounds);
        block1: while (it.hasNext()) {
            NodeInst ni;
            geom = it.next();
            if (!(geom instanceof NodeInst) || (ni = (NodeInst)geom).isCellInstance()) continue;
            AffineTransform trans = ni.rotateOut();
            Technology tech = ni.getProto().getTechnology();
            Poly[] nodePolys = tech.getShapeOfNode(ni, true, true, null);
            for (int i = 0; i < nodePolys.length; ++i) {
                PortInst pi;
                Network net;
                PrimitivePort pp;
                Poly nodePoly = nodePolys[i];
                if (this.geometricLayer(nodePoly.getLayer()) != layer) continue;
                nodePoly.transform(trans);
                if (!this.polysTouch(nodePoly, newPoly) || (pp = (PrimitivePort)nodePoly.getPort()) == null || (net = nl.getNetwork(pi = this.findPortInstClosestToPoly(ni, pp, centerPoint))) == null) continue;
                netsThatTouch.put(net, pi);
                int numNets = netsThatTouch.size();
                if (numNets <= 2 && (numNets <= 1 || !justExtend)) continue block1;
                return null;
            }
        }
        it = newCell.searchIterator(bounds);
        block3: while (it.hasNext()) {
            geom = it.next();
            if (!(geom instanceof ArcInst)) continue;
            ArcInst ai = (ArcInst)geom;
            Technology tech = ai.getProto().getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            for (int i = 0; i < polys.length; ++i) {
                int numNets;
                Network net;
                Poly arcPoly = polys[i];
                if (this.geometricLayer(arcPoly.getLayer()) != layer || !this.polysTouch(arcPoly, newPoly) || (net = nl.getNetwork(ai, 0)) == null) continue;
                if (netsThatTouch.get(net) == null) {
                    netsThatTouch.put(net, ai);
                }
                if ((numNets = netsThatTouch.size()) <= 2 && (numNets <= 1 || !justExtend)) continue block3;
                return null;
            }
        }
        return netsThatTouch;
    }

    private List<Centerline> findCenterlines(PolyBase poly, Layer layer, double minWidth, PolyMerge merge, PolyMerge originalMerge) {
        ArrayList<Centerline> validCenterlines = new ArrayList<Centerline>();
        merge.deleteLayer(this.tempLayer1);
        merge.addPolygon(this.tempLayer1, poly);
        List<PolyBase> polysToAnalyze = new ArrayList<PolyBase>();
        polysToAnalyze.add(poly);
        int loop = 1;
        while (true) {
            boolean foundNew = false;
            block1: for (PolyBase aPoly : polysToAnalyze) {
                aPoly.setLayer(layer);
                List<Centerline> centerlines = this.gatherCenterlines(aPoly, merge, originalMerge);
                if (centerlines == null) {
                    merge.subtract(this.tempLayer1, aPoly);
                    continue;
                }
                double lastWidth = -1.0;
                boolean lastWidthNonManhattan = false;
                for (Centerline cl : centerlines) {
                    double smallest;
                    double len;
                    Poly clPoly;
                    double length;
                    if (cl.width < minWidth || (length = cl.start.distance(cl.end)) < DBMath.getEpsilon() || !merge.intersects(this.tempLayer1, clPoly = Poly.makeEndPointPoly(length, cl.width, cl.angle, cl.start, 0.0, cl.end, 0.0, Poly.Type.FILLED)) || validCenterlines.size() == 0 && cl.width > (len = cl.start.distance(cl.end))) continue;
                    boolean isNonManhattan = false;
                    if (cl.startUnscaled.getX() != cl.endUnscaled.getX() && cl.startUnscaled.getY() != cl.endUnscaled.getY()) {
                        boolean duplicate = false;
                        for (Centerline oCl : validCenterlines) {
                            if (cl.startUnscaled.equals(oCl.startUnscaled) && cl.endUnscaled.equals(oCl.endUnscaled)) {
                                duplicate = true;
                                break;
                            }
                            if (!cl.startUnscaled.equals(oCl.endUnscaled) || !cl.endUnscaled.equals(oCl.startUnscaled)) continue;
                            duplicate = true;
                            break;
                        }
                        if (duplicate) continue;
                        isNonManhattan = true;
                    }
                    if (lastWidth < 0.0) {
                        lastWidth = cl.width;
                        lastWidthNonManhattan = isNonManhattan;
                    }
                    if (Math.abs(cl.width - lastWidth) > 1.0 && (lastWidthNonManhattan != isNonManhattan || (smallest = Math.min(cl.width, lastWidth)) != 0.0 && Math.max(cl.width, lastWidth) / smallest > 1.2)) continue block1;
                    validCenterlines.add(cl);
                    merge.subtract(this.tempLayer1, clPoly);
                    foundNew = true;
                }
            }
            if (!foundNew || (polysToAnalyze = this.getMergePolys(merge, this.tempLayer1)) == null) break;
            ++loop;
        }
        merge.deleteLayer(this.tempLayer1);
        Centerline[] both = new Centerline[2];
        for (int i = 0; i < validCenterlines.size(); ++i) {
            Centerline cl = (Centerline)validCenterlines.get(i);
            double minCLX = Math.min(cl.start.getX(), cl.end.getX()) - cl.width;
            double maxCLX = Math.max(cl.start.getX(), cl.end.getX()) + cl.width;
            double minCLY = Math.min(cl.start.getY(), cl.end.getY()) - cl.width;
            double maxCLY = Math.max(cl.start.getY(), cl.end.getY()) + cl.width;
            for (int j = i + 1; j < validCenterlines.size(); ++j) {
                Point2D intersect;
                Centerline oCl = (Centerline)validCenterlines.get(j);
                double minOCLX = Math.min(oCl.start.getX(), oCl.end.getX()) - oCl.width;
                double maxOCLX = Math.max(oCl.start.getX(), oCl.end.getX()) + oCl.width;
                double minOCLY = Math.min(oCl.start.getY(), oCl.end.getY()) - oCl.width;
                double maxOCLY = Math.max(oCl.start.getY(), oCl.end.getY()) + oCl.width;
                if (minOCLX > maxCLX || maxOCLX < minCLX || minOCLY > maxCLY || maxOCLY < minCLY || (intersect = GenMath.intersect(cl.start, cl.angle, oCl.start, oCl.angle)) == null) continue;
                both[0] = cl;
                both[1] = oCl;
                for (int b = 0; b < 2; ++b) {
                    int minDistToEnd;
                    Point2D newStart = both[b].start;
                    Point2D newEnd = both[b].end;
                    double distToStart = newStart.distance(intersect);
                    double distToEnd = newEnd.distance(intersect);
                    boolean makeT = this.insideSegment(newStart, newEnd, intersect);
                    if (makeT && (double)(minDistToEnd = (int)Math.min(distToStart, distToEnd)) <= both[b].width / 2.0) {
                        makeT = false;
                    }
                    double extendStart = 0.0;
                    double extendEnd = 0.0;
                    double extendAltStart = 0.0;
                    double extendAltEnd = 0.0;
                    double betterExtension = 0.0;
                    Point2D.Double altNewStart = new Point2D.Double(0.0, 0.0);
                    Point2D.Double altNewEnd = new Point2D.Double(0.0, 0.0);
                    if (distToStart < distToEnd) {
                        betterExtension = newStart.distance(intersect);
                        altNewStart.setLocation(newStart);
                        altNewEnd.setLocation(intersect);
                        newStart = intersect;
                        extendAltEnd = extendStart = both[b].width / 2.0;
                    } else {
                        betterExtension = newEnd.distance(intersect);
                        altNewStart.setLocation(intersect);
                        altNewEnd.setLocation(newEnd);
                        newEnd = intersect;
                        extendAltStart = extendEnd = both[b].width / 2.0;
                    }
                    Poly extended = Poly.makeEndPointPoly(newStart.distance(newEnd), both[b].width, both[b].angle, newStart, extendStart, newEnd, extendEnd, Poly.Type.FILLED);
                    if (!originalMerge.contains(layer, extended)) {
                        if (extendStart > 0.0) {
                            extendStart = betterExtension;
                        }
                        if (extendEnd > 0.0) {
                            extendEnd = betterExtension;
                        }
                        extended = Poly.makeEndPointPoly(newStart.distance(newEnd), both[b].width, both[b].angle, newStart, extendStart, newEnd, extendEnd, Poly.Type.FILLED);
                    }
                    if (!originalMerge.contains(layer, extended)) continue;
                    both[b].setStart(newStart.getX(), newStart.getY());
                    both[b].setEnd(newEnd.getX(), newEnd.getY());
                    if (extendStart != 0.0) {
                        both[b].startHub = true;
                    }
                    if (extendEnd != 0.0) {
                        both[b].endHub = true;
                    }
                    if (!makeT) continue;
                    Centerline newCL = new Centerline(both[b].width, altNewStart, altNewEnd);
                    if (extendAltStart != 0.0) {
                        newCL.startHub = true;
                    }
                    if (extendAltEnd != 0.0) {
                        newCL.endHub = true;
                    }
                    validCenterlines.add(newCL);
                }
            }
        }
        return validCenterlines;
    }

    private boolean insideSegment(Point2D start, Point2D end, Point2D pt) {
        return !(pt.getX() < Math.min(start.getX(), end.getX()) || pt.getX() > Math.max(start.getX(), end.getX()) || pt.getY() < Math.min(start.getY(), end.getY())) && !(pt.getY() > Math.max(start.getY(), end.getY()));
    }

    private List<Centerline> gatherCenterlines(PolyBase poly, PolyMerge merge, PolyMerge originalMerge) {
        ArrayList<Centerline> centerlines = new ArrayList<Centerline>();
        Point2D[] points = poly.getPoints();
        HashMap<Integer, ArrayList<Integer>> linesAtAngle = new HashMap<Integer, ArrayList<Integer>>();
        for (int i = 0; i < points.length; ++i) {
            int angle;
            Point2D thisPt;
            Point2D lastPt;
            int lastI = i - 1;
            if (lastI < 0) {
                lastI = points.length - 1;
            }
            if ((lastPt = points[lastI]).equals(thisPt = points[i])) continue;
            for (angle = GenMath.figureAngle(thisPt, lastPt); angle < 0; angle += 1800) {
            }
            while (angle >= 1800) {
                angle -= 1800;
            }
            Integer iAngle = new Integer(angle);
            ArrayList<Integer> linesSoFar = (ArrayList<Integer>)linesAtAngle.get(iAngle);
            if (linesSoFar == null) {
                linesSoFar = new ArrayList<Integer>();
                linesAtAngle.put(iAngle, linesSoFar);
            }
            linesSoFar.add(new Integer(i));
        }
        int colinearSegs = 0;
        for (Integer iAangle : linesAtAngle.keySet()) {
            List linesAtThisAngle = (List)linesAtAngle.get(iAangle);
            if (linesAtThisAngle == null) continue;
            for (int ai = 0; ai < linesAtThisAngle.size(); ++ai) {
                int i = (Integer)linesAtThisAngle.get(ai);
                int lastI = i - 1;
                if (lastI < 0) {
                    lastI = points.length - 1;
                }
                Point2D lastPt = points[lastI];
                Point2D thisPt = points[i];
                for (int aj = ai + 2; aj < linesAtThisAngle.size() - 1; ++aj) {
                    int j = (Integer)linesAtThisAngle.get(aj);
                    if (!GenMath.isOnLine(lastPt, thisPt, points[j])) continue;
                    ++colinearSegs;
                }
            }
        }
        Point2D[] corners = new Point2D[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0), new Point2D.Double(0.0, 0.0)};
        Point2D[] possibleStart = new Point2D[4];
        Point2D[] possibleEnd = new Point2D[4];
        for (Integer iAangle : linesAtAngle.keySet()) {
            List linesAtThisAngle = (List)linesAtAngle.get(iAangle);
            if (linesAtThisAngle == null) continue;
            int angle = iAangle;
            for (int ai = 0; ai < linesAtThisAngle.size(); ++ai) {
                int i = (Integer)linesAtThisAngle.get(ai);
                int lastI = i - 1;
                if (lastI < 0) {
                    lastI = points.length - 1;
                }
                Point2D lastPt = points[lastI];
                Point2D thisPt = points[i];
                block8: for (int aj = ai + 1; aj < linesAtThisAngle.size(); ++aj) {
                    Point2D oFinish;
                    Point2D finish;
                    Point2D oStart;
                    Point2D start;
                    Point2D swapPt;
                    double swap;
                    int j = (Integer)linesAtThisAngle.get(aj);
                    Point2D oLastPt = points[j - 1];
                    Point2D oThisPt = points[j];
                    int perpAngle = angle + 900;
                    Point2D oneSide = thisPt;
                    Point2D otherSide = GenMath.intersect(thisPt, perpAngle, oThisPt, angle);
                    Point2D.Double centerPt = new Point2D.Double((oneSide.getX() + otherSide.getX()) / 2.0, (oneSide.getY() + otherSide.getY()) / 2.0);
                    Point2D lastPtCL = GenMath.intersect(lastPt, perpAngle, centerPt, angle);
                    Point2D thisPtCL = GenMath.intersect(thisPt, perpAngle, centerPt, angle);
                    Point2D oLastPtCL = GenMath.intersect(oLastPt, perpAngle, centerPt, angle);
                    Point2D oThisPtCL = GenMath.intersect(oThisPt, perpAngle, centerPt, angle);
                    double minX = Math.min(Math.min(lastPtCL.getX(), thisPtCL.getX()), Math.min(oLastPtCL.getX(), oThisPtCL.getX()));
                    double maxX = Math.max(Math.max(lastPtCL.getX(), thisPtCL.getX()), Math.max(oLastPtCL.getX(), oThisPtCL.getX()));
                    double minY = Math.min(Math.min(lastPtCL.getY(), thisPtCL.getY()), Math.min(oLastPtCL.getY(), oThisPtCL.getY()));
                    double maxY = Math.max(Math.max(lastPtCL.getY(), thisPtCL.getY()), Math.max(oLastPtCL.getY(), oThisPtCL.getY()));
                    corners[0].setLocation(minX, minY);
                    corners[1].setLocation(minX, maxY);
                    corners[2].setLocation(maxX, maxY);
                    corners[3].setLocation(maxX, minY);
                    Point2D aCorner = null;
                    for (int k = 0; k < 4; ++k) {
                        if (lastPtCL.equals(corners[k])) {
                            aCorner = lastPtCL;
                        }
                        if (thisPtCL.equals(corners[k])) {
                            aCorner = thisPtCL;
                        }
                        if (oLastPtCL.equals(corners[k])) {
                            aCorner = oLastPtCL;
                        }
                        if (!oThisPtCL.equals(corners[k])) continue;
                        aCorner = oThisPtCL;
                    }
                    double lastDist = aCorner.distance(lastPtCL);
                    double thisDist = aCorner.distance(thisPtCL);
                    double oLastDist = aCorner.distance(oLastPtCL);
                    double oThisDist = aCorner.distance(oThisPtCL);
                    if (Math.min(lastDist, thisDist) >= Math.max(oLastDist, oThisDist) || Math.min(oLastDist, oThisDist) >= Math.max(lastDist, thisDist)) continue;
                    if (lastDist > thisDist) {
                        swap = lastDist;
                        lastDist = thisDist;
                        thisDist = swap;
                        swapPt = lastPtCL;
                        lastPtCL = thisPtCL;
                        thisPtCL = swapPt;
                    }
                    if (oLastDist > oThisDist) {
                        swap = oLastDist;
                        oLastDist = oThisDist;
                        oThisDist = swap;
                        swapPt = oLastPtCL;
                        oLastPtCL = oThisPtCL;
                        oThisPtCL = swapPt;
                    }
                    if (lastDist < oLastDist) {
                        start = oLastPtCL;
                        oStart = lastPtCL;
                    } else {
                        start = lastPtCL;
                        oStart = oLastPtCL;
                    }
                    if (thisDist > oThisDist) {
                        finish = oThisPtCL;
                        oFinish = thisPtCL;
                    } else {
                        finish = thisPtCL;
                        oFinish = oThisPtCL;
                    }
                    possibleStart[0] = oStart;
                    possibleEnd[0] = oFinish;
                    if (start.distance(oStart) < finish.distance(oFinish)) {
                        possibleStart[1] = oStart;
                        possibleEnd[1] = finish;
                        possibleStart[2] = start;
                        possibleEnd[2] = oFinish;
                    } else {
                        possibleStart[1] = start;
                        possibleEnd[1] = oFinish;
                        possibleStart[2] = oStart;
                        possibleEnd[2] = finish;
                    }
                    possibleStart[3] = start;
                    possibleEnd[3] = finish;
                    double width = oneSide.distance(otherSide);
                    for (int p = 0; p < 4; ++p) {
                        double length = possibleStart[p].distance(possibleEnd[p]);
                        Poly clPoly = Poly.makeEndPointPoly(length, width, angle, possibleStart[p], 0.0, possibleEnd[p], 0.0, Poly.Type.FILLED);
                        if (!originalMerge.contains(poly.getLayer(), clPoly)) continue;
                        if (width > length * 2.0) {
                            Point2D[] pts = clPoly.getPoints();
                            Point2D[] edgeCtrs = new Point2D[pts.length];
                            double bestDist = Double.MAX_VALUE;
                            int bestPt = -1;
                            for (int e = 0; e < pts.length; ++e) {
                                Point2D last = e == 0 ? pts[pts.length - 1] : pts[e - 1];
                                edgeCtrs[e] = new Point2D.Double((pts[e].getX() + last.getX()) / 2.0, (pts[e].getY() + last.getY()) / 2.0);
                                double dist = edgeCtrs[e].distance(possibleStart[p]);
                                if (!(dist < bestDist)) continue;
                                bestDist = dist;
                                bestPt = e;
                            }
                            width = length;
                            int startPt = (bestPt + 1) % pts.length;
                            int endPt = (bestPt + 3) % pts.length;
                            possibleStart[p] = edgeCtrs[startPt];
                            possibleEnd[p] = edgeCtrs[endPt];
                            length = edgeCtrs[startPt].distance(edgeCtrs[endPt]);
                        }
                        Centerline newCL = new Centerline(width, possibleStart[p], possibleEnd[p]);
                        if (newCL.angle < 0) continue block8;
                        centerlines.add(newCL);
                        continue block8;
                    }
                }
            }
        }
        Collections.sort(centerlines, new ParallelWiresByLength());
        PolyMerge reCheck = new PolyMerge();
        for (int i = 0; i < centerlines.size(); ++i) {
            Centerline cl = (Centerline)centerlines.get(i);
            Poly clPoly = Poly.makeEndPointPoly(cl.start.distance(cl.end), cl.width, cl.angle, cl.start, 0.0, cl.end, 0.0, Poly.Type.FILLED);
            if (reCheck.contains(this.tempLayer1, clPoly)) {
                centerlines.remove(i);
                --i;
                continue;
            }
            reCheck.addPolygon(this.tempLayer1, clPoly);
        }
        Collections.sort(centerlines, new ParallelWiresByWidth());
        return centerlines;
    }

    private void convertAllGeometry(PolyMerge merge, PolyMerge originalMerge, Cell newCell) {
        for (Layer layer : merge.getKeySet()) {
            ArcProto ap = this.arcsForLayer.get(layer);
            List<PolyBase> polyList = this.getMergePolys(merge, layer);
            if (layer.getFunction().isSubstrate()) {
                ArrayList<Rectangle2D> rectangleList = new ArrayList<Rectangle2D>();
                for (int i = polyList.size() - 1; i >= 0; --i) {
                    PolyBase poly = polyList.get(i);
                    Rectangle2D polyBounds = poly.getBounds2D();
                    if (!originalMerge.contains(layer, polyBounds)) continue;
                    rectangleList.add(polyBounds);
                    polyList.remove(i);
                }
                block2: while (true) {
                    RectangularShape aggregateBounds = null;
                    ArrayList<Rectangle2D> aggregatedList = new ArrayList<Rectangle2D>();
                    for (Rectangle2D polyBounds : rectangleList) {
                        if (aggregateBounds == null) {
                            aggregateBounds = polyBounds;
                        } else {
                            Rectangle2D.Double unionBounds = new Rectangle2D.Double();
                            Rectangle2D.union((Rectangle2D)aggregateBounds, polyBounds, unionBounds);
                            if (!originalMerge.contains(layer, unionBounds)) continue;
                            aggregateBounds = unionBounds;
                        }
                        aggregatedList.add(polyBounds);
                    }
                    if (aggregateBounds == null) break;
                    PrimitiveNode pNp = layer.getPureLayerNode();
                    double centerX = aggregateBounds.getCenterX() / 400.0;
                    double centerY = aggregateBounds.getCenterY() / 400.0;
                    Point2D.Double center = new Point2D.Double(centerX, centerY);
                    this.createNode(pNp, center, aggregateBounds.getWidth() / 400.0, aggregateBounds.getHeight() / 400.0, null, newCell);
                    Iterator i$ = aggregatedList.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block2;
                        Rectangle2D polyBounds = (Rectangle2D)i$.next();
                        rectangleList.remove(polyBounds);
                    }
                    break;
                }
            }
            for (PolyBase poly : polyList) {
                NodeInst ni;
                if (ap != null) {
                    Rectangle2D totalBounds;
                    Rectangle2D polyBounds = poly.getBox();
                    if (polyBounds == null && originalMerge.contains(layer, totalBounds = poly.getBounds2D())) {
                        polyBounds = totalBounds;
                    }
                    if (polyBounds != null) {
                        double width = polyBounds.getWidth() / 400.0;
                        double height = polyBounds.getHeight() / 400.0;
                        double actualWidth = 0.0;
                        if (width >= actualWidth && height >= actualWidth) {
                            NodeInst ni2;
                            NodeInst ni1;
                            Point2D.Double end2;
                            Point2D.Double end1;
                            PrimitiveNode np = ap.findPinProto();
                            if (width > height) {
                                end1 = new Point2D.Double((polyBounds.getMinX() + height / 2.0) / 400.0, polyBounds.getCenterY() / 400.0);
                                end2 = new Point2D.Double((polyBounds.getMaxX() - height / 2.0) / 400.0, polyBounds.getCenterY() / 400.0);
                                ni1 = this.createNode(np, end1, height, height, null, newCell);
                                ni2 = this.createNode(np, end2, height, height, null, newCell);
                                this.realizeArc(ap, ni1.getOnlyPortInst(), ni2.getOnlyPortInst(), end1, end2, height, false, false, merge);
                                continue;
                            }
                            end1 = new Point2D.Double(polyBounds.getCenterX() / 400.0, (polyBounds.getMinY() + width / 2.0) / 400.0);
                            end2 = new Point2D.Double(polyBounds.getCenterX() / 400.0, (polyBounds.getMaxY() - width / 2.0) / 400.0);
                            ni1 = this.createNode(np, end1, width, width, null, newCell);
                            ni2 = this.createNode(np, end2, width, width, null, newCell);
                            this.realizeArc(ap, ni1.getOnlyPortInst(), ni2.getOnlyPortInst(), end1, end2, width, false, false, merge);
                            continue;
                        }
                    }
                }
                if ((ni = this.makePureLayerNodeFromPoly(poly, newCell)) == null || ap == null) continue;
                PortInst fPi = ni.getOnlyPortInst();
                Poly fPortPoly = fPi.getPoly();
                Rectangle2D polyBounds = poly.getBounds2D();
                Rectangle2D.Double searchBound = new Rectangle2D.Double(polyBounds.getMinX() / 400.0, polyBounds.getMinY() / 400.0, polyBounds.getWidth() / 400.0, polyBounds.getHeight() / 400.0);
                PortInst bestTPi = null;
                double bestLen = Double.MAX_VALUE;
                Point2D bestFLoc = null;
                Iterator<RTBounds> it = newCell.searchIterator(searchBound);
                while (it.hasNext()) {
                    NodeInst oNi;
                    RTBounds geom = it.next();
                    if (!(geom instanceof NodeInst) || (oNi = (NodeInst)geom) == ni || oNi.isCellInstance() || oNi.getProto().getTechnology() != this.tech) continue;
                    Iterator<PortInst> pIt = oNi.getPortInsts();
                    while (pIt.hasNext()) {
                        int angle;
                        PortInst tPi = pIt.next();
                        PortProto pp = tPi.getPortProto();
                        if (!pp.connectsTo(ap)) continue;
                        EPoint tLoc = tPi.getPoly().getCenter();
                        EPoint tLocScaled = new EPoint(this.scaleUp(tLoc.getX()), this.scaleUp(tLoc.getY()));
                        Point2D fLoc = fPortPoly.closestPoint(tLoc);
                        EPoint fLocScaled = new EPoint(this.scaleUp(fLoc.getX()), this.scaleUp(fLoc.getY()));
                        double len = this.scaleUp(fLoc.distance(tLoc));
                        Poly conPoly = Poly.makeEndPointPoly(len, 1.0, angle = GenMath.figureAngle(tLoc, fLoc), fLocScaled, 0.0, tLocScaled, 0.0, Poly.Type.FILLED);
                        if (!originalMerge.contains(layer, conPoly) || !(len < bestLen)) continue;
                        bestLen = len;
                        bestTPi = tPi;
                        bestFLoc = fLoc;
                    }
                }
                if (bestTPi != null) {
                    Poly tPortPoly = bestTPi.getPoly();
                    Point2D tLoc = tPortPoly.closestPoint(tPortPoly.getCenter());
                    ArcInst ai = this.realizeArc(ap, fPi, bestTPi, bestFLoc, tLoc, 0.0, false, false, merge);
                    if (ai == null) continue;
                    ai.setFixedAngle(false);
                    continue;
                }
                this.addErrorLog(newCell, "Unable to connect unextracted polygon", new EPoint(searchBound.getCenterX(), searchBound.getCenterY()));
            }
        }
        for (Layer layer : this.allCutLayers.keySet()) {
            List<PolyBase> cutList = this.allCutLayers.get(layer);
            for (PolyBase poly : cutList) {
                this.makePureLayerNodeFromPoly(poly, newCell);
            }
        }
    }

    private NodeInst makePureLayerNodeFromPoly(PolyBase poly, Cell cell) {
        PrimitiveNode pNp = poly.getLayer().getPureLayerNode();
        if (pNp == null) {
            System.out.println("CANNOT FIND PURE LAYER NODE FOR LAYER " + poly.getLayer().getName());
            return null;
        }
        Rectangle2D polyBounds = poly.getBounds2D();
        double centerX = polyBounds.getCenterX() / 400.0;
        double centerY = polyBounds.getCenterY() / 400.0;
        Point2D.Double center = new Point2D.Double(centerX, centerY);
        EPoint[] newPoints = null;
        if (poly.getBox() == null) {
            Point2D[] points = poly.getPoints();
            newPoints = new EPoint[points.length];
            for (int i = 0; i < points.length; ++i) {
                newPoints[i] = new EPoint(points[i].getX() / 400.0, points[i].getY() / 400.0);
            }
        }
        NodeInst ni = this.createNode(pNp, center, polyBounds.getWidth() / 400.0, polyBounds.getHeight() / 400.0, newPoints, cell);
        return ni;
    }

    private void restoreExports(Cell oldCell, Cell newCell) {
        for (Export e : this.exportsToRestore) {
            EPoint loc = e.getOriginalPort().getPoly().getCenter();
            boolean found = false;
            Rectangle2D.Double bounds = new Rectangle2D.Double(loc.getX(), loc.getY(), 0.0, 0.0);
            Iterator<RTBounds> it = newCell.searchIterator(bounds);
            block1: while (it.hasNext()) {
                RTBounds geom = it.next();
                if (!(geom instanceof NodeInst)) continue;
                NodeInst ni = (NodeInst)geom;
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    EPoint pLoc;
                    PortInst pi = pIt.next();
                    PortProto pp = pi.getPortProto();
                    if (!this.sameConnection(e, pp) || !loc.equals(pLoc = pi.getPoly().getCenter())) continue;
                    Export.newInstance(newCell, pi, e.getName());
                    found = true;
                    continue block1;
                }
            }
            if (found) continue;
            PrimitiveNode pnUse = null;
            Iterator<PrimitiveNode> it2 = this.tech.getNodes();
            while (it2.hasNext()) {
                PrimitiveNode pn = it2.next();
                if (pn.getFunction() != PrimitiveNode.Function.PIN || !this.sameConnection(e, pn.getPort(0))) continue;
                pnUse = pn;
                break;
            }
            if (pnUse == null) continue;
            NodeInst ni = NodeInst.makeInstance(pnUse, loc, pnUse.getDefWidth(), pnUse.getDefHeight(), newCell);
            Export.newInstance(newCell, ni.getOnlyPortInst(), e.getName());
        }
        for (ExportedPin ep : this.pinsForLater) {
            Iterator<Export> eIt = ep.ni.getExports();
            while (eIt.hasNext()) {
                Export found;
                Export e = eIt.next();
                ArcProto[] possibleCons = e.getBasePort().getConnections();
                ArcProto ap = possibleCons[0];
                Layer layer = ap.getLayer(0);
                PortInst pi = this.makePort(newCell, layer, ep.location);
                if (pi != null && (found = newCell.findExport(e.getName())) != null) continue;
                double sX = ep.ni.getXSize();
                double sY = ep.ni.getYSize();
                Point2D.Double instanceAnchor = new Point2D.Double(0.0, 0.0);
                ep.trans.transform(ep.ni.getAnchorCenter(), instanceAnchor);
                NodeInst newNi = NodeInst.makeInstance(ep.ni.getProto(), instanceAnchor, sX, sY, newCell);
                if (newNi == null) {
                    this.addErrorLog(newCell, "Problem creating new instance of " + ep.ni.getProto(), new EPoint(sX, sY));
                    return;
                }
                PortInst newPi = newNi.findPortInstFromProto(e.getOriginalPort().getPortProto());
                Export.newInstance(newCell, newPi, e.getName());
            }
        }
    }

    private boolean sameConnection(PortProto pp1, PortProto pp2) {
        ArcProto[] arcs2;
        ArcProto[] arcs1 = pp1.getBasePort().getConnections();
        if (arcs1 == (arcs2 = pp2.getBasePort().getConnections())) {
            return true;
        }
        boolean[] found = new boolean[arcs2.length];
        for (int i = 0; i < arcs1.length; ++i) {
            int j;
            if (arcs1[i].getTechnology() == Generic.tech()) continue;
            for (j = 0; j < arcs2.length; ++j) {
                if (arcs1[i] != arcs2[j]) continue;
                found[j] = true;
                break;
            }
            if (j < arcs2.length) continue;
            return false;
        }
        for (int j = 0; j < arcs2.length; ++j) {
            if (found[j] || arcs2[j].getTechnology() == Generic.tech()) continue;
            return false;
        }
        return true;
    }

    private NodeInst createNode(NodeProto np, Point2D loc, double wid, double hei, EPoint[] points, Cell cell) {
        NodeInst ni;
        if (np.getFunction() == PrimitiveNode.Function.PIN) {
            if (wid < np.getDefWidth()) {
                wid = np.getDefWidth();
            }
            if (hei < np.getDefHeight()) {
                hei = np.getDefHeight();
            }
        }
        if ((ni = NodeInst.makeInstance(np, loc, wid, hei, cell)) != null && points != null) {
            ni.setTrace(points);
        }
        return ni;
    }

    private void realizeNode(PrimitiveNode pNp, double centerX, double centerY, double width, double height, int angle, Point2D[] points, PolyMerge merge, Cell newCell, List<NodeInst> realizedNodes) {
        double cX = centerX / 400.0;
        double cY = centerY / 400.0;
        Orientation orient = Orientation.fromAngle(angle);
        NodeInst ni = NodeInst.makeInstance(pNp, new Point2D.Double(cX, cY), width / 400.0, height / 400.0, newCell, orient, null, 0);
        if (ni == null) {
            return;
        }
        if (points != null) {
            ni.setTrace(points);
        }
        if (realizedNodes != null) {
            realizedNodes.add(ni);
        } else {
            AffineTransform trans = ni.rotateOut();
            Poly[] polys = this.tech.getShapeOfNode(ni);
            for (int i = 0; i < polys.length; ++i) {
                Poly poly = polys[i];
                Layer layer = poly.getLayer();
                layer = this.geometricLayer(layer);
                poly.transform(trans);
                this.removePolyFromMerge(merge, layer, poly);
            }
        }
    }

    private ArcInst realizeArc(ArcProto ap, PortInst pi1, PortInst pi2, Point2D pt1, Point2D pt2, double width, boolean noHeadExtend, boolean noTailExtend, PolyMerge merge) {
        ArcInst ai = ArcInst.makeInstanceBase(ap, width, pi1, pi2, pt1, pt2, null);
        if (ai == null) {
            return null;
        }
        if (noHeadExtend) {
            ai.setHeadExtended(false);
        }
        if (noTailExtend) {
            ai.setTailExtended(false);
        }
        EPoint head = ai.getHeadLocation();
        EPoint tail = ai.getTailLocation();
        if (head.getX() != tail.getX() && head.getY() != tail.getY()) {
            ai.setFixedAngle(false);
        }
        Poly[] polys = this.tech.getShapeOfArc(ai);
        for (int i = 0; i < polys.length; ++i) {
            Poly poly = polys[i];
            Layer layer = poly.getLayer();
            layer = this.geometricLayer(layer);
            this.removePolyFromMerge(merge, layer, poly);
        }
        return ai;
    }

    private void removePolyFromMerge(PolyMerge merge, Layer layer, Poly poly) {
        Point2D[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            poly.setPoint(i, this.scaleUp(points[i].getX()), this.scaleUp(points[i].getY()));
        }
        poly.roundPoints();
        merge.subtract(layer, poly);
    }

    private double scaleUp(double v) {
        return DBMath.round(v) * 400.0;
    }

    private Layer geometricLayer(Layer layer) {
        Layer properLayer;
        Layer polyLayer;
        Layer.Function fun = layer.getFunction();
        if (fun == Layer.Function.GATE && (polyLayer = this.layerForFunction.get((Object)Layer.Function.POLY1)) != null) {
            return polyLayer;
        }
        if (this.unifyActive && (fun == Layer.Function.DIFFP || fun == Layer.Function.DIFFN)) {
            fun = Layer.Function.DIFF;
        }
        if ((properLayer = this.layerForFunction.get((Object)fun)) != null) {
            return properLayer;
        }
        return layer;
    }

    private List<PolyBase> getMergePolys(PolyMerge merge, Layer layer) {
        List<PolyBase> polyList = merge.getMergedPoints(layer, true);
        if (polyList == null) {
            return polyList;
        }
        ArrayList<PolyBase> properPolyList = new ArrayList<PolyBase>();
        for (PolyBase poly : polyList) {
            double area;
            int i;
            Point2D[] origPoints = poly.getPoints();
            Point2D[] points = new Point2D[origPoints.length];
            int len = origPoints.length;
            for (i = 0; i < len; ++i) {
                points[i] = origPoints[i];
            }
            for (i = 1; i < len; ++i) {
                if (!(points[i].distance(points[i - 1]) < 8.0)) continue;
                for (int j = i; j < len; ++j) {
                    points[j - 1] = points[j];
                }
                --len;
                --i;
            }
            if (len > 1 && points[0].distance(points[len - 1]) < 8.0) {
                --len;
            }
            if (len <= 2 || (area = poly.getArea()) < this.smallestPoly) continue;
            properPolyList.add(poly);
        }
        return properPolyList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ShowExtraction
    extends EDialog {
        private List<List<ERectangle>> addedBatchRectangles;
        private List<List<ERectangle>> addedBatchLines;
        private List<String> addedBatchNames;
        private int batchPosition;
        private JLabel comingUp;

        private ShowExtraction(Frame parent, List<List<ERectangle>> addedBatchRectangles, List<List<ERectangle>> addedBatchLines, List<String> addedBatchNames) {
            super(parent, false);
            this.addedBatchRectangles = addedBatchRectangles;
            this.addedBatchLines = addedBatchLines;
            this.addedBatchNames = addedBatchNames;
            this.getContentPane().setLayout(new GridBagLayout());
            this.setTitle("Extraction Progress");
            this.setName("");
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent evt) {
                    ShowExtraction.this.closeDialog();
                }
            });
            this.comingUp = new JLabel("Next step:");
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            this.getContentPane().add((Component)this.comingUp, gbc);
            JButton prev = new JButton("Prev");
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            prev.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ShowExtraction.this.advanceDisplay(false);
                }
            });
            this.getContentPane().add((Component)prev, gbc);
            JButton next = new JButton("Next");
            gbc = new GridBagConstraints();
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.anchor = 17;
            gbc.insets = new Insets(4, 4, 4, 4);
            next.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    ShowExtraction.this.advanceDisplay(true);
                }
            });
            this.getContentPane().add((Component)next, gbc);
            this.batchPosition = -1;
            this.advanceDisplay(true);
            this.getRootPane().setDefaultButton(next);
            this.finishInitialization();
        }

        @Override
        protected void escapePressed() {
            this.closeDialog();
        }

        private void advanceDisplay(boolean forward) {
            if (forward) {
                ++this.batchPosition;
                if (this.batchPosition >= this.addedBatchNames.size()) {
                    this.batchPosition = this.addedBatchNames.size() - 1;
                }
            } else {
                --this.batchPosition;
                if (this.batchPosition < 0) {
                    this.batchPosition = 0;
                }
            }
            this.comingUp.setText("Batch " + (this.batchPosition + 1) + ": " + this.addedBatchNames.get(this.batchPosition));
            this.pack();
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.getCurrentEditWindow_();
            wnd.clearHighlighting();
            Cell cell = wnd.getCell();
            List<ERectangle> rects = this.addedBatchRectangles.get(this.batchPosition);
            for (ERectangle er : rects) {
                wnd.addHighlightArea(er, cell);
            }
            List<ERectangle> lines = this.addedBatchLines.get(this.batchPosition);
            for (ERectangle er : lines) {
                wnd.addHighlightLine(new Point2D.Double(er.getMinX(), er.getMinY()), new Point2D.Double(er.getMaxX(), er.getMaxY()), cell, false);
            }
            wnd.finishedHighlighting();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParallelWiresByLength
    implements Comparator<Centerline> {
        private ParallelWiresByLength() {
        }

        @Override
        public int compare(Centerline cl1, Centerline cl2) {
            double cll2;
            double cll1 = cl1.start.distance(cl1.end);
            if (cll1 > (cll2 = cl2.start.distance(cl2.end))) {
                return -1;
            }
            if (cll1 < cll2) {
                return 1;
            }
            if (cl1.width < cl2.width) {
                return -1;
            }
            if (cl1.width > cl2.width) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ParallelWiresByWidth
    implements Comparator<Centerline> {
        private ParallelWiresByWidth() {
        }

        @Override
        public int compare(Centerline cl1, Centerline cl2) {
            double cll2;
            if (cl1.width < cl2.width) {
                return 1;
            }
            if (cl1.width > cl2.width) {
                return -1;
            }
            double cll1 = cl1.start.distance(cl1.end);
            if (cll1 > (cll2 = cl2.start.distance(cl2.end))) {
                return -1;
            }
            if (cll1 < cll2) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ViasBySize
    implements Comparator<PossibleVia> {
        private ViasBySize() {
        }

        @Override
        public int compare(PossibleVia pv1, PossibleVia pv2) {
            double area1 = 0.0;
            Technology.NodeLayer[] layers1 = pv1.pNp.getLayers();
            double wid = pv1.pNp.getDefWidth();
            double hei = pv1.pNp.getDefHeight();
            for (int i = 0; i < layers1.length; ++i) {
                Technology.NodeLayer nl = layers1[i];
                if (nl.getLayer().getFunction().isSubstrate()) continue;
                double lowX = nl.getLeftEdge().getMultiplier() * wid + nl.getLeftEdge().getAdder();
                double highX = nl.getRightEdge().getMultiplier() * wid + nl.getRightEdge().getAdder();
                double lowY = nl.getBottomEdge().getMultiplier() * hei + nl.getBottomEdge().getAdder();
                double highY = nl.getTopEdge().getMultiplier() * hei + nl.getTopEdge().getAdder();
                area1 += (highX - lowX) * (highY - lowY);
            }
            double area2 = 0.0;
            Technology.NodeLayer[] layers2 = pv2.pNp.getLayers();
            wid = pv2.pNp.getDefWidth();
            hei = pv2.pNp.getDefHeight();
            for (int i = 0; i < layers2.length; ++i) {
                Technology.NodeLayer nl = layers2[i];
                if (nl.getLayer().getFunction().isSubstrate()) continue;
                double lowX = nl.getLeftEdge().getMultiplier() * wid + nl.getLeftEdge().getAdder();
                double highX = nl.getRightEdge().getMultiplier() * wid + nl.getRightEdge().getAdder();
                double lowY = nl.getBottomEdge().getMultiplier() * hei + nl.getBottomEdge().getAdder();
                double highY = nl.getTopEdge().getMultiplier() * hei + nl.getTopEdge().getAdder();
                area2 += (highX - lowX) * (highY - lowY);
            }
            if (area1 == area2) {
                return 0;
            }
            if (area1 < area2) {
                return 1;
            }
            return -1;
        }
    }

    private static class CutBound
    implements RTBounds {
        private PolyBase cut;

        CutBound(PolyBase cut) {
            this.cut = cut;
        }

        public Rectangle2D getBounds() {
            return this.cut.getBounds2D();
        }
    }

    private static class PossibleVia {
        PrimitiveNode pNp;
        int rotation;
        double minWidth;
        double minHeight;
        double largestShrink;
        Technology.NodeLayer cutNodeLayer;
        Layer[] layers;
        double[] shrinkL;
        double[] shrinkR;
        double[] shrinkT;
        double[] shrinkB;

        PossibleVia(PrimitiveNode pNp, int numLayers) {
            this.pNp = pNp;
            this.layers = new Layer[numLayers];
            this.shrinkL = new double[numLayers];
            this.shrinkR = new double[numLayers];
            this.shrinkT = new double[numLayers];
            this.shrinkB = new double[numLayers];
        }
    }

    private static class Centerline {
        Point2D start;
        Point2D end;
        EPoint startUnscaled;
        EPoint endUnscaled;
        boolean startHub;
        boolean endHub;
        double width;
        boolean handled;
        int angle;

        Centerline(double width, Point2D start, Point2D end) {
            this.width = width;
            this.start = start;
            this.startUnscaled = new EPoint(start.getX() / 400.0, start.getY() / 400.0);
            this.endUnscaled = new EPoint(end.getX() / 400.0, end.getY() / 400.0);
            this.end = end;
            this.endHub = false;
            this.startHub = false;
            this.angle = start.equals(end) ? -1 : GenMath.figureAngle(end, start);
        }

        void setStart(double x, double y) {
            this.start.setLocation(x, y);
            this.startUnscaled = new EPoint(x / 400.0, y / 400.0);
        }

        void setEnd(double x, double y) {
            this.end.setLocation(x, y);
            this.endUnscaled = new EPoint(x / 400.0, y / 400.0);
        }

        public String toString() {
            return "CENTERLINE from (" + TextUtils.formatDouble(this.start.getX() / 400.0) + "," + TextUtils.formatDouble(this.start.getY() / 400.0) + ") to (" + TextUtils.formatDouble(this.end.getX() / 400.0) + "," + TextUtils.formatDouble(this.end.getY() / 400.0) + ") wid=" + TextUtils.formatDouble(this.width / 400.0) + ", len=" + TextUtils.formatDouble(this.start.distance(this.end) / 400.0);
        }
    }

    private static class ExportedPin {
        Point2D location;
        NodeInst ni;
        AffineTransform trans;

        ExportedPin(NodeInst ni, Point2D location, AffineTransform trans) {
            this.ni = ni;
            this.location = location;
            this.trans = trans;
        }
    }

    private static class ExtractJob
    extends Job {
        private Cell cell;
        private Cell newCell;
        private boolean recursive;
        private List<List<ERectangle>> addedBatchRectangles;
        private List<List<ERectangle>> addedBatchLines;
        private List<String> addedBatchNames;
        private ErrorLogger errorLogger;

        private ExtractJob(Cell cell, boolean recursive) {
            super("Extract Connectivity from " + cell, Extract.getExtractTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.recursive = recursive;
            this.errorLogger = ErrorLogger.newInstance("Extraction Tool on cell " + cell.getName());
            this.startJob();
        }

        public boolean doIt() throws JobException {
            Connectivity c = new Connectivity(this.cell, this, this.errorLogger);
            String expansionPattern = Extract.getCellExpandPattern().trim();
            Pattern pat = null;
            if (expansionPattern.length() > 0) {
                try {
                    pat = Pattern.compile(expansionPattern, 2);
                }
                catch (PatternSyntaxException e) {
                    System.out.println("Pattern syntax error on '" + expansionPattern + "': " + e.getMessage());
                }
            }
            Job.getUserInterface().startProgressDialog("Extracting", null);
            this.newCell = c.doExtract(this.cell, this.recursive, pat, true, this, this.addedBatchRectangles, this.addedBatchLines, this.addedBatchNames);
            Job.getUserInterface().stopProgressDialog();
            this.fieldVariableChanged("addedBatchRectangles");
            this.fieldVariableChanged("addedBatchLines");
            this.fieldVariableChanged("addedBatchNames");
            this.fieldVariableChanged("newCell");
            this.fieldVariableChanged("errorLogger");
            return true;
        }

        public void terminateOK() {
            UserInterface ui = Job.getUserInterface();
            EditWindow_ wnd = ui.displayCell(this.newCell);
            Job.getUserInterface().termLogging(this.errorLogger, false, false);
            if (this.newCell != null) {
                Iterator<NodeInst> it = this.newCell.getNodes();
                while (it.hasNext()) {
                    NodeInst ni = it.next();
                    PrimitiveNode.Function fun = ni.getFunction();
                    if (fun != PrimitiveNode.Function.NODE) continue;
                    wnd.addElectricObject(ni, this.newCell);
                }
            } else {
                System.out.println("Extraction job was aborted");
            }
        }
    }
}

