/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.tool.simulation.AnalogAnalysis;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.Waveform;
import java.awt.geom.Rectangle2D;

public class AnalogSignal
extends Signal {
    private final AnalogAnalysis an;
    private final int index;

    protected AnalogSignal(AnalogAnalysis an) {
        this.an = an;
        this.index = an.getSignals().size();
        an.addSignal(this);
    }

    public AnalogAnalysis getAnalysis() {
        return this.an;
    }

    public int getIndexInAnalysis() {
        return this.index;
    }

    public Waveform getWaveform(int sweep) {
        return this.an.getWaveform(this, sweep);
    }

    public int getNumSweeps() {
        return this.an.getNumSweeps();
    }

    protected void calcBounds() {
        double lowTime = 0.0;
        double highTime = 0.0;
        double lowValue = 0.0;
        double highValue = 0.0;
        boolean first = true;
        double[] result = new double[3];
        int numSweeps = this.getNumSweeps();
        for (int sweep = 0; sweep < numSweeps; ++sweep) {
            Waveform waveform = this.getWaveform(sweep);
            int numEvents = waveform.getNumEvents();
            for (int i = 0; i < numEvents; ++i) {
                waveform.getEvent(i, result);
                double time = result[0];
                if (sweep == 0) {
                    if (i == 0) {
                        this.leftEdge = time;
                    } else if (i == numEvents - 1) {
                        this.rightEdge = time;
                    }
                }
                double lowVal = result[1];
                double highVal = result[2];
                if (first) {
                    first = false;
                    lowTime = highTime = time;
                    lowValue = lowVal;
                    highValue = highVal;
                    continue;
                }
                if (time < lowTime) {
                    lowTime = time;
                }
                if (time > highTime) {
                    highTime = time;
                }
                if (lowVal < lowValue) {
                    lowValue = lowVal;
                }
                if (!(highVal > highValue)) continue;
                highValue = highVal;
            }
        }
        this.bounds = new Rectangle2D.Double(lowTime, lowValue, highTime - lowTime, highValue - lowValue);
    }
}

