/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.ExportId;
import com.sun.electric.database.IdMapper;
import com.sun.electric.database.ImmutableElectricObject;
import com.sun.electric.database.SnapshotReader;
import com.sun.electric.database.SnapshotWriter;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProtoId;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import java.io.IOException;

public class ImmutableExport
extends ImmutableElectricObject {
    public static final ImmutableExport[] NULL_ARRAY = new ImmutableExport[0];
    public static final ImmutableArrayList<ImmutableExport> EMPTY_LIST = new ImmutableArrayList<ImmutableExport>(NULL_ARRAY);
    private static final int PORTDRAWN = 0x4000000;
    private static final int BODYONLY = 0x8000000;
    private static final int STATEBITSSHIFTED = 30;
    private static final int STATEBITSSH = 27;
    public final ExportId exportId;
    public final Name name;
    public final TextDescriptor nameDescriptor;
    public final int originalNodeId;
    public final PortProtoId originalPortId;
    public final boolean alwaysDrawn;
    public final boolean bodyOnly;
    public final PortCharacteristic characteristic;

    ImmutableExport(ExportId exportId, Name name, TextDescriptor nameDescriptor, int originalNodeId, PortProtoId originalPortId, boolean alwaysDrawn, boolean bodyOnly, PortCharacteristic characteristic, Variable[] vars) {
        super(vars, 0);
        this.exportId = exportId;
        this.name = name;
        this.nameDescriptor = nameDescriptor;
        this.originalNodeId = originalNodeId;
        this.originalPortId = originalPortId;
        this.alwaysDrawn = alwaysDrawn;
        this.bodyOnly = bodyOnly;
        this.characteristic = characteristic;
    }

    public static ImmutableExport newInstance(ExportId exportId, Name name, TextDescriptor nameDescriptor, int originalNodeId, PortProtoId originalPortId, boolean alwaysDrawn, boolean bodyOnly, PortCharacteristic characteristic) {
        if (exportId == null) {
            throw new NullPointerException("exportId");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname()) {
            throw new IllegalArgumentException("name");
        }
        if (nameDescriptor != null) {
            nameDescriptor = nameDescriptor.withDisplayWithoutParamAndCode();
        }
        if (originalNodeId < 0) {
            throw new IllegalArgumentException("originalNodeId");
        }
        if (originalPortId == null) {
            throw new NullPointerException("orignalPortId");
        }
        if (characteristic == null) {
            characteristic = PortCharacteristic.UNKNOWN;
        }
        return new ImmutableExport(exportId, name, nameDescriptor, originalNodeId, originalPortId, alwaysDrawn, bodyOnly, characteristic, Variable.NULL_ARRAY);
    }

    public ImmutableExport withName(Name name) {
        if (this.name.toString().equals(name.toString())) {
            return this;
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!name.isValid() || name.hasEmptySubnames() || name.isTempname()) {
            throw new IllegalArgumentException("name");
        }
        return new ImmutableExport(this.exportId, name, this.nameDescriptor, this.originalNodeId, this.originalPortId, this.alwaysDrawn, this.bodyOnly, this.characteristic, this.getVars());
    }

    public ImmutableExport withNameDescriptor(TextDescriptor nameDescriptor) {
        if (nameDescriptor != null) {
            nameDescriptor = nameDescriptor.withDisplayWithoutParamAndCode();
        }
        if (this.nameDescriptor == nameDescriptor) {
            return this;
        }
        return new ImmutableExport(this.exportId, this.name, nameDescriptor, this.originalNodeId, this.originalPortId, this.alwaysDrawn, this.bodyOnly, this.characteristic, this.getVars());
    }

    public ImmutableExport withOriginalPort(int originalNodeId, PortProtoId originalPortId) {
        if (this.originalNodeId == originalNodeId && this.originalPortId == originalPortId) {
            return this;
        }
        if (originalPortId == null) {
            throw new NullPointerException("originalPortId");
        }
        return new ImmutableExport(this.exportId, this.name, this.nameDescriptor, originalNodeId, originalPortId, this.alwaysDrawn, this.bodyOnly, this.characteristic, this.getVars());
    }

    public ImmutableExport withAlwaysDrawn(boolean alwaysDrawn) {
        if (this.alwaysDrawn == alwaysDrawn) {
            return this;
        }
        return new ImmutableExport(this.exportId, this.name, this.nameDescriptor, this.originalNodeId, this.originalPortId, alwaysDrawn, this.bodyOnly, this.characteristic, this.getVars());
    }

    public ImmutableExport withBodyOnly(boolean bodyOnly) {
        if (this.bodyOnly == bodyOnly) {
            return this;
        }
        return new ImmutableExport(this.exportId, this.name, this.nameDescriptor, this.originalNodeId, this.originalPortId, this.alwaysDrawn, bodyOnly, this.characteristic, this.getVars());
    }

    public ImmutableExport withCharacteristic(PortCharacteristic characteristic) {
        if (characteristic == null) {
            characteristic = PortCharacteristic.UNKNOWN;
        }
        if (this.characteristic == characteristic) {
            return this;
        }
        return new ImmutableExport(this.exportId, this.name, this.nameDescriptor, this.originalNodeId, this.originalPortId, this.alwaysDrawn, this.bodyOnly, characteristic, this.getVars());
    }

    public ImmutableExport withVariable(Variable var) {
        Variable[] vars = this.arrayWithVariable(var.withParam(false));
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableExport(this.exportId, this.name, this.nameDescriptor, this.originalNodeId, this.originalPortId, this.alwaysDrawn, this.bodyOnly, this.characteristic, vars);
    }

    public ImmutableExport withoutVariable(Variable.Key key) {
        Variable[] vars = this.arrayWithoutVariable(key);
        if (this.getVars() == vars) {
            return this;
        }
        return new ImmutableExport(this.exportId, this.name, this.nameDescriptor, this.originalNodeId, this.originalPortId, this.alwaysDrawn, this.bodyOnly, this.characteristic, vars);
    }

    ImmutableExport withRenamedIds(IdMapper idMapper) {
        Variable[] vars = this.arrayWithRenamedIds(idMapper);
        ExportId exportId = idMapper.get(this.exportId);
        PortProtoId originalPortId = this.originalPortId;
        if (originalPortId instanceof ExportId) {
            originalPortId = idMapper.get((ExportId)originalPortId);
        }
        if (this.getVars() == vars && this.exportId == exportId && this.originalPortId == originalPortId) {
            return this;
        }
        return new ImmutableExport(exportId, this.name, this.nameDescriptor, this.originalNodeId, originalPortId, this.alwaysDrawn, this.bodyOnly, this.characteristic, vars);
    }

    @Override
    void write(SnapshotWriter writer) throws IOException {
        writer.writePortProtoId(this.exportId);
        writer.writeNameKey(this.name);
        writer.writeTextDescriptor(this.nameDescriptor);
        writer.writeNodeId(this.originalNodeId);
        writer.writePortProtoId(this.originalPortId);
        writer.writeBoolean(this.alwaysDrawn);
        writer.writeBoolean(this.bodyOnly);
        writer.writeInt(this.characteristic.getBits());
        super.write(writer);
    }

    static ImmutableExport read(SnapshotReader reader) throws IOException {
        ExportId exportId = (ExportId)reader.readPortProtoId();
        Name name = reader.readNameKey();
        TextDescriptor nameDescriptor = reader.readTextDescriptor();
        int originalNodeId = reader.readNodeId();
        PortProtoId originalPortId = reader.readPortProtoId();
        boolean alwaysDrawn = reader.readBoolean();
        boolean bodyOnly = reader.readBoolean();
        int bits = reader.readInt();
        PortCharacteristic characteristic = PortCharacteristic.findCharacteristic(bits);
        boolean hasVars = reader.readBoolean();
        Variable[] vars = hasVars ? ImmutableExport.readVars(reader) : Variable.NULL_ARRAY;
        return new ImmutableExport(exportId, name, nameDescriptor, originalNodeId, originalPortId, alwaysDrawn, bodyOnly, characteristic, vars);
    }

    public int getElibBits() {
        int userBits = this.characteristic.getBits() << 27;
        if (this.alwaysDrawn) {
            userBits |= 0x4000000;
        }
        if (this.bodyOnly) {
            userBits |= 0x8000000;
        }
        return userBits;
    }

    public static boolean alwaysDrawnFromElib(int elibBits) {
        return (elibBits & 0x4000000) != 0;
    }

    public static boolean bodyOnlyFromElib(int elibBits) {
        return (elibBits & 0x8000000) != 0;
    }

    public static PortCharacteristic portCharacteristicFromElib(int elibBits) {
        PortCharacteristic characteristic = PortCharacteristic.findCharacteristic(elibBits >> 27 & 0x1E);
        return characteristic != null ? characteristic : PortCharacteristic.UNKNOWN;
    }

    @Override
    public int hashCodeExceptVariables() {
        return this.exportId.hashCode();
    }

    @Override
    public boolean equalsExceptVariables(ImmutableElectricObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableExport)) {
            return false;
        }
        ImmutableExport that = (ImmutableExport)o;
        return this.exportId == that.exportId && this.name == that.name && this.nameDescriptor == that.nameDescriptor && this.originalNodeId == that.originalNodeId && this.originalPortId == that.originalPortId && this.alwaysDrawn == that.alwaysDrawn && this.bodyOnly == that.bodyOnly && this.characteristic == that.characteristic;
    }

    public static Name validExportName(String name) {
        if (name == null) {
            return null;
        }
        Name nameKey = Name.findName(name);
        return nameKey.isValid() && !nameKey.isTempname() && !nameKey.hasEmptySubnames() ? nameKey : null;
    }

    public void check() {
        this.check(false);
        assert (this.exportId != null);
        assert (this.name != null);
        assert (this.name.isValid() && !this.name.hasEmptySubnames() && !this.name.isTempname());
        if (this.nameDescriptor != null) assert (this.nameDescriptor.isDisplay() && !this.nameDescriptor.isCode() && !this.nameDescriptor.isParam());
        assert (this.originalNodeId >= 0);
        assert (this.originalPortId != null);
        assert (this.characteristic != null);
    }
}

