/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.prototype;

import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.FlagSet;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.technology.PrimitivePort;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class PortProto
extends ElectricObject {
    private static final int PORTANGLE = 511;
    private static final int PORTANGLESH = 0;
    private static final int PORTARANGE = 130560;
    private static final int PORTARANGESH = 9;
    private static final int PORTNET = 33423360;
    private static final int PORTNETSH = 17;
    private static final int PORTISOLATED = 0x2000000;
    private static final int PORTDRAWN = 0x4000000;
    private static final int BODYONLY = 0x8000000;
    private static final int STATEBITS = -268435456;
    private static final int STATEBITSSHIFTED = 30;
    private static final int STATEBITSSH = 27;
    private static final int CLKPORT = 2;
    private static final int C1PORT = 4;
    private static final int C2PORT = 6;
    private static final int C3PORT = 8;
    private static final int C4PORT = 10;
    private static final int C5PORT = 12;
    private static final int C6PORT = 14;
    private static final int INPORT = 16;
    private static final int OUTPORT = 18;
    private static final int BIDIRPORT = 20;
    private static final int PWRPORT = 22;
    private static final int GNDPORT = 24;
    private static final int REFOUTPORT = 26;
    private static final int REFINPORT = 28;
    private static final int REFBASEPORT = 30;
    private static FlagSet.Generator flagGenerator = new FlagSet.Generator("PortProto");
    private Name protoName;
    protected int userBits = 0;
    protected NodeProto parent = null;
    private int portIndex;
    private TextDescriptor descriptor = TextDescriptor.getExportTextDescriptor(this);
    private int tempInt;
    private Object tempObj = null;
    private int flagBits;

    protected PortProto() {
    }

    public void setParent(NodeProto parent) {
        this.parent = parent;
    }

    public void setProtoName(String protoName) {
        this.protoName = Name.findName(protoName);
    }

    void setPortIndex(int portIndex) {
        this.portIndex = portIndex;
    }

    public final int getPortIndex() {
        return this.portIndex;
    }

    public void kill() {
        this.parent.removePort(this);
    }

    public Name getNameKey() {
        return this.protoName;
    }

    public String getName() {
        return this.protoName.toString();
    }

    public String getShortName() {
        String name = this.protoName.toString();
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char ch = name.charAt(i);
            if (Character.isLetterOrDigit(ch)) continue;
            return name.substring(0, i);
        }
        return name;
    }

    public NodeProto getParent() {
        return this.parent;
    }

    public TextDescriptor getTextDescriptor() {
        return this.descriptor;
    }

    public void setTextDescriptor(TextDescriptor descriptor) {
        this.descriptor.copy(descriptor);
    }

    public Characteristic getCharacteristic() {
        Characteristic characteristic = Characteristic.findCharacteristic(this.userBits >> 27 & 0x1E);
        return characteristic;
    }

    public void setCharacteristic(Characteristic characteristic) {
        this.userBits = this.userBits & 0xFFFFFFF | characteristic.getBits() << 27;
    }

    public boolean isPower() {
        Characteristic ch = this.getCharacteristic();
        if (ch == Characteristic.PWR) {
            return true;
        }
        if (ch != Characteristic.UNKNOWN) {
            return false;
        }
        return this.isNamedPower();
    }

    public boolean isNamedPower() {
        String name = this.getName().toLowerCase();
        if (name.indexOf("vdd") >= 0) {
            return true;
        }
        if (name.indexOf("vcc") >= 0) {
            return true;
        }
        if (name.indexOf("pwr") >= 0) {
            return true;
        }
        return name.indexOf("power") >= 0;
    }

    public boolean isGround() {
        Characteristic ch = this.getCharacteristic();
        if (ch == Characteristic.GND) {
            return true;
        }
        if (ch != Characteristic.UNKNOWN) {
            return false;
        }
        return this.isNamedGround();
    }

    public boolean isNamedGround() {
        String name = this.getName().toLowerCase();
        if (name.indexOf("vss") >= 0) {
            return true;
        }
        if (name.indexOf("gnd") >= 0) {
            return true;
        }
        return name.indexOf("ground") >= 0;
    }

    public int getAngle() {
        return (this.userBits & 0x1FF) >> 0;
    }

    protected void setAngle(int angle) {
        this.userBits = this.userBits & 0xFFFFFE00 | angle << 0;
    }

    protected void setAngleRange(int angleRange) {
        this.userBits = this.userBits & 0xFFFE01FF | angleRange << 9;
    }

    protected void setTopology(int topologyIndex) {
        this.userBits = this.userBits & 0xFE01FFFF | topologyIndex << 17;
    }

    public int getTopology() {
        return (this.userBits & 0x1FE0000) >> 17;
    }

    public void setIsolated() {
        this.userBits |= 0x2000000;
    }

    public void clearIsolated() {
        this.userBits &= 0xFDFFFFFF;
    }

    public boolean isIsolated() {
        return (this.userBits & 0x2000000) != 0;
    }

    public void setAlwaysDrawn() {
        this.userBits |= 0x4000000;
    }

    public void clearAlwaysDrawn() {
        this.userBits &= 0xFBFFFFFF;
    }

    public boolean isAlwaysDrawn() {
        return (this.userBits & 0x4000000) != 0;
    }

    public void setBodyOnly() {
        this.userBits |= 0x8000000;
    }

    public void clearBodyOnly() {
        this.userBits &= 0xF7FFFFFF;
    }

    public boolean isBodyOnly() {
        return (this.userBits & 0x8000000) != 0;
    }

    public abstract PrimitivePort getBasePort();

    public boolean connectsTo(ArcProto arc) {
        return this.getBasePort().connectsTo(arc);
    }

    public Color colorOfPort() {
        return this.getBasePort().getPortColor();
    }

    public int lowLevelGetUserbits() {
        return this.userBits;
    }

    public void lowLevelSetUserbits(int userBits) {
        this.userBits = userBits;
    }

    public void setTempInt(int tempInt) {
        this.tempInt = tempInt;
    }

    public int getTempInt() {
        return this.tempInt;
    }

    public void setTempObj(Object tempObj) {
        this.tempObj = tempObj;
    }

    public Object getTempObj() {
        return this.tempObj;
    }

    public static FlagSet getFlagSet(int numBits) {
        return FlagSet.getFlagSet(flagGenerator, numBits);
    }

    public void setBit(FlagSet set) {
        this.flagBits |= set.getMask();
    }

    public void clearBit(FlagSet set) {
        this.flagBits &= set.getUnmask();
    }

    public boolean isBit(FlagSet set) {
        return (this.flagBits & set.getMask()) != 0;
    }

    public PortProto getEquivalent() {
        return this;
    }

    public String toString() {
        return "PortProto " + this.protoName;
    }

    public static class Characteristic {
        private final String name;
        private final String fullName;
        private final int bits;
        private final int order;
        private static int ordering = 0;
        private static HashMap characteristicList = new HashMap();
        public static final Characteristic UNKNOWN = new Characteristic("Unknown", "unknown", 0);
        public static final Characteristic IN = new Characteristic("Input", "input", 16);
        public static final Characteristic OUT = new Characteristic("Output", "output", 18);
        public static final Characteristic BIDIR = new Characteristic("Bidirectional", "bidirectional", 20);
        public static final Characteristic PWR = new Characteristic("Power", "power", 22);
        public static final Characteristic GND = new Characteristic("Ground", "ground", 24);
        public static final Characteristic CLK = new Characteristic("Clock", "clock", 2);
        public static final Characteristic C1 = new Characteristic("Clock Phase 1", "clock1", 4);
        public static final Characteristic C2 = new Characteristic("Clock Phase 2", "clock2", 6);
        public static final Characteristic C3 = new Characteristic("Clock Phase 3", "clock3", 8);
        public static final Characteristic C4 = new Characteristic("Clock Phase 4", "clock4", 10);
        public static final Characteristic C5 = new Characteristic("Clock Phase 5", "clock5", 12);
        public static final Characteristic C6 = new Characteristic("Clock Phase 6", "clock6", 14);
        public static final Characteristic REFOUT = new Characteristic("Reference Output", "refout", 26);
        public static final Characteristic REFIN = new Characteristic("Reference Input", "refin", 28);
        public static final Characteristic REFBASE = new Characteristic("Reference Base", "refbase", 30);

        private Characteristic(String fullName, String name, int bits) {
            this.fullName = fullName;
            this.name = name;
            this.bits = bits;
            this.order = ordering++;
            characteristicList.put(new Integer(bits), this);
        }

        public int getBits() {
            return this.bits;
        }

        public int getOrder() {
            return this.order;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getName() {
            return this.name;
        }

        public boolean isReference() {
            return this == REFIN || this == REFOUT || this == REFBASE;
        }

        public static Characteristic findCharacteristic(int bits) {
            Object obj = characteristicList.get(new Integer(bits));
            if (obj == null) {
                return null;
            }
            return (Characteristic)obj;
        }

        public static Characteristic findCharacteristic(String wantName) {
            Iterator it = characteristicList.values().iterator();
            while (it.hasNext()) {
                Characteristic ch = (Characteristic)it.next();
                if (!ch.name.equals(wantName)) continue;
                return ch;
            }
            return null;
        }

        public static List getOrderedCharacteristics() {
            ArrayList orderedList = new ArrayList();
            Iterator it = characteristicList.values().iterator();
            while (it.hasNext()) {
                orderedList.add(it.next());
            }
            Collections.sort(orderedList, new CharacteristicOrder());
            return orderedList;
        }

        public String toString() {
            return this.name;
        }

        static class CharacteristicOrder
        implements Comparator {
            CharacteristicOrder() {
            }

            public int compare(Object o1, Object o2) {
                Characteristic c1 = (Characteristic)o1;
                Characteristic c2 = (Characteristic)o2;
                return c1.order - c2.order;
            }
        }
    }
}

