#!/bin/sh
#
# This script converts BrOffice.org's spell checking dictionary to Aspell.
# (BrOffice.org is the Brazilian OpenOffice.org development community.)
#

WORKDIR="${HOME}/linux/dict/aspell6-pt_BR"
FILE=pt_BR-V.zip
URL="http://www.deso-se.com.br/downloads/broffice.org/${FILE}"

cd $WORKDIR
wget --timestamping "$URL" --directory-prefix=..
unzip -jo "../$FILE"
mv README_pt_BR.TXT doc/README_ooo.txt
mv pt_BR.aff pt_BR_affix.dat
sed -i -e "s/\r//g" pt_BR_affix.dat
mv pt_BR.dic pt_BR.wl
sed -i -e "s/\r//g" -e "1d" -e "/\./d" pt_BR.wl
./proc || exit 1
./configure || exit 1
LC_ALL=C LANG=C make dist
