/*
 * Decompiled with CFR 0.152.
 */
package wb;

import java.io.RandomAccessFile;
import wb.Blink;
import wb.Blk;
import wb.Blkio;
import wb.Ent;
import wb.Ents;
import wb.Han;
import wb.Handle;
import wb.Lck;
import wb.SchlepRT;
import wb.Seg;
import wb.Wbdefs;
import wb.Wbsys;

public class Segs {
    public static int segCntr = 4;
    public static Seg segChain = null;
    public static Lck segChainLck = Lck.makeLck(-3);
    public static byte[] dbVersionStr = SchlepRT.stringToBytes("wb-2b1");
    public static byte[] dbAuthorsStr = SchlepRT.stringToBytes("A. Jaffer, J. Finger, R. Zito-Wolf");

    public static Seg newSeg(String string, String string2) {
        if (SchlepRT.a2b(Ents.lckTab)) {
            Lck.lck(segChainLck);
            Seg seg = segChain;
            while (SchlepRT.a2b(seg)) {
                if (SchlepRT.a2b(Seg.seg_Str(seg)) && string.equals(Seg.seg_Str(seg))) {
                    System.err.print(">>>>ERROR<<<< " + string2 + ": segment already open to \"" + string + "\"\n");
                    Lck.unlck(segChainLck);
                    return null;
                }
                if (segChain == Seg.seg_Nxt(seg)) break;
                seg = Seg.seg_Nxt(seg);
            }
            Seg seg2 = Seg.newSegd(segCntr);
            Seg.seg_SetStr(seg2, string);
            if (SchlepRT.a2b(segChain)) {
                Seg seg3 = Seg.seg_Prv(segChain);
                Seg.seg_SetNxt(seg3, seg2);
                Seg.seg_SetPrv(seg2, seg3);
                Seg.seg_SetNxt(seg2, segChain);
                Seg.seg_SetPrv(segChain, seg2);
            } else {
                Seg.seg_SetNxt(seg2, seg2);
                Seg.seg_SetPrv(seg2, seg2);
            }
            Seg.seg_SetFlc(seg2, new int[10]);
            Seg.seg_SetFlcLen(seg2, 0);
            segCntr = 1 + segCntr;
            segChain = seg2;
            Lck.unlck(segChainLck);
            return seg2;
        }
        System.err.print(">>>>ERROR<<<< " + string2 + ": WB not initialized (need to call " + "initWb" + ")\n");
        return null;
    }

    public static void freeSeg(Seg seg) {
        if (!SchlepRT.a2b(segChain)) {
            System.err.print(">>>>ERROR<<<< freeSeg: segChain already empty!\n");
            return;
        }
        if (Seg.seg_Prv(seg) == seg) {
            if (seg != segChain) {
                System.err.print(">>>>ERROR<<<< freeSeg: corrupted segChain.\n");
            }
            segChain = null;
            return;
        }
        Seg seg2 = Seg.seg_Nxt(seg);
        Seg seg3 = Seg.seg_Prv(seg);
        Seg.seg_SetNxt(seg3, seg2);
        Seg.seg_SetPrv(seg2, seg3);
        if (seg == segChain) {
            segChain = segChain == seg2 ? null : seg2;
        }
    }

    public static boolean checkFile_P(String string) {
        RandomAccessFile randomAccessFile = Blkio.blkio_OpenReadOnlyFile(string, 128);
        byte[] byArray = new byte[128];
        if (SchlepRT.a2b(randomAccessFile)) {
            boolean bl = Blkio.blkio_Read(randomAccessFile, byArray, 128, 0) && 0 == Blink.str2long(byArray, 0) && 0 == Blink.str2long(byArray, 4) && 0 == Blink.str2long(byArray, 8) && 119 == (byArray[23] & 0xFF) && 98 == (byArray[24] & 0xFF);
            Blkio.blkio_FileClose(randomAccessFile, 128, false);
            return bl;
        }
        return false;
    }

    public static Seg openSeg(String string, boolean bl) {
        return Segs.openSegd(string, bl, false);
    }

    public static Seg openSegd(String string, boolean bl, boolean bl2) {
        String string2;
        Seg seg;
        int n;
        block16: {
            RandomAccessFile randomAccessFile;
            n = 384;
            if (n > Ents.blkSize) {
                System.err.print(">>>>ERROR<<<< unsupported bsiz " + n + " > " + Ents.blkSize + "\n");
                return null;
            }
            if (!Segs.checkFile_P(string)) {
                return null;
            }
            seg = Segs.newSeg(string, "openSeg");
            if (!SchlepRT.a2b(seg)) {
                return seg;
            }
            RandomAccessFile randomAccessFile2 = randomAccessFile = bl ? Blkio.blkio_OpenModifyFile(string, n) : Blkio.blkio_OpenReadOnlyFile(string, n);
            while (Blkio.blkio_PortOpen_P(randomAccessFile, bl)) {
                boolean bl3;
                Seg.seg_SetPort(seg, randomAccessFile);
                Seg.seg_SetBsiz(seg, n);
                Seg.seg_SetUsed(seg, 2);
                Seg.seg_SetFlcLen(seg, bl ? -1 : -2);
                Han han = Seg.seg_RtHan(seg);
                byte[] byArray = new byte[256];
                if (Wbdefs.err_P(Segs.btOpen(seg, 0, han, 3))) {
                    string2 = "bt-open 0";
                    break block16;
                }
                if (2 != Handle.btGet(han, Wbdefs.bsizByts, 4, byArray)) {
                    string2 = "BSIZ";
                    break block16;
                }
                if (n != Blink.str2short(byArray, 0)) {
                    Blkio.blkio_FileClose(randomAccessFile, n, bl);
                    n = Blink.str2short(byArray, 0);
                    if (n > Ents.blkSize) {
                        string2 = "BSIZ too big.";
                        break block16;
                    }
                    randomAccessFile = bl ? Blkio.blkio_OpenModifyFile(string, n) : Blkio.blkio_OpenReadOnlyFile(string, n);
                    continue;
                }
                boolean bl4 = bl3 = bl && Wbdefs.err_P(Handle.btRem(han, Wbdefs.clnByts, 3, byArray));
                if (bl3 && !bl2) {
                    string2 = "not cleanly saved; use wbcheck to repair.";
                    break block16;
                }
                if (bl3) {
                    System.err.print("WARNING: File \"" + string + "\" not cleanly saved.\n");
                }
                if (4 != Handle.btGet(han, Wbdefs.usedByts, 4, byArray)) {
                    string2 = "USED";
                    break block16;
                }
                Seg.seg_SetUsed(seg, Blink.str2long(byArray, 0));
                if (5 != Handle.btGet(han, Wbdefs.fldByts, 3, byArray)) {
                    string2 = "FLD";
                    break block16;
                }
                if (Wbdefs.err_P(Segs.btOpen(seg, Blink.str2long(byArray, 1), Seg.seg_FlHan(seg), 2))) {
                    string2 = "FLC";
                    break block16;
                }
                if (Han.han_Typ(Seg.seg_FlHan(seg)) != 70) {
                    System.err.print("Older type freelist - still supported.\n");
                }
                Han.han_SetWcb(Seg.seg_FlHan(seg), 2);
                return seg;
            }
            if (Blkio.blkio_PortOpen_P(randomAccessFile, bl)) {
                Blkio.blkio_FileClose(randomAccessFile, n, bl);
            }
            System.err.print(">>>>ERROR<<<< could not open file " + string + "\n");
            Segs.freeSeg(seg);
            return null;
        }
        System.err.print(">>>>ERROR<<<< File \"" + string + "\" " + string2 + "\n");
        if (SchlepRT.a2b(seg)) {
            Blkio.blkio_FileClose(Seg.seg_Port(seg), n, bl);
            Seg.seg_SetPort(seg, null);
            Seg.seg_SetStr(seg, null);
            Seg.seg_SetUsed(seg, 0);
            Segs.freeSeg(seg);
        }
        return null;
    }

    public static int closeSeg(Seg seg, boolean bl) {
        int n;
        if (!(SchlepRT.a2b(seg) && SchlepRT.a2b(Seg.seg_Port(seg)) && SchlepRT.a2b(Seg.seg_Str(seg)) && 0 != Seg.seg_Used(seg))) {
            return -1;
        }
        Ents.flushFlc(seg, 5);
        if (Seg.seg_FlcLen(seg) >= 0) {
            byte[] byArray = new byte[20];
            for (n = -1 + Seg.seg_FlcLen(seg); 0 <= n; n = -1 + n) {
                Blink.long2str(byArray, 4 * n, Seg.seg_Flc(seg)[n]);
            }
            Handle.btPut(Seg.seg_RtHan(seg), Wbdefs.flcByts, 3, byArray, 4 * Seg.seg_FlcLen(seg));
            Seg.seg_SetFlcLen(seg, -1);
        }
        boolean bl2 = Seg.seg_Mutable_P(seg);
        n = Ents.doSegBuffers(seg, Wbsys.getMethod("wb.Ents", "flushBuffer", new Class[]{Ent.class}));
        if (Wbdefs.success_P(n) || bl) {
            if (!Wbdefs.success_P(n)) {
                n = -1;
            }
            Ents.doSegBuffers(seg, Wbsys.getMethod("wb.Ents", "purgeBuffer", new Class[]{Ent.class}));
            if (bl2) {
                Blkio.blkio_FlushToFile(Seg.seg_Port(seg), false);
                if (Wbdefs.err_P(Handle.btWrite(Seg.seg_RtHan(seg), Wbdefs.clnByts, 3, Wbdefs.noByts, 0))) {
                    System.err.print("WARNING: mutable file \"" + Seg.seg_Str(seg) + "\" already clean?\n");
                }
            }
            Segs.btClose(Seg.seg_RtHan(seg));
            Segs.btClose(Seg.seg_FlHan(seg));
            Blkio.blkio_FileClose(Seg.seg_Port(seg), Seg.seg_Bsiz(seg), bl2);
            Seg.seg_SetPort(seg, null);
            Seg.seg_SetStr(seg, null);
            Seg.seg_SetFlc(seg, null);
            Seg.seg_SetFlcLen(seg, 0);
            Seg.seg_SetUsed(seg, 0);
            Segs.freeSeg(seg);
        }
        return n;
    }

    public static Seg makeSeg(String string, int n) {
        Seg seg = Segs.newSeg(string, "makeSeg");
        if (!SchlepRT.a2b(seg)) {
            return seg;
        }
        if (n > Ents.blkSize) {
            System.err.print(">>>>ERROR<<<< unsupported bsiz " + n + " > " + Ents.blkSize + "\n");
            Lck.unlck(Seg.seg_Lck(seg));
            return null;
        }
        RandomAccessFile randomAccessFile = Blkio.blkio_CreateFile(string, n);
        if (Blkio.blkio_PortOpen_P(randomAccessFile, true)) {
            Seg.seg_SetPort(seg, randomAccessFile);
            Seg.seg_SetBsiz(seg, n);
            Seg.seg_SetUsed(seg, 3);
            Seg.seg_SetStr(seg, string);
            Seg.seg_SetFlcLen(seg, -1);
            Han han = Seg.seg_RtHan(seg);
            Han han2 = Seg.seg_FlHan(seg);
            byte[] byArray = new byte[5];
            if (Segs.btOpenNew(seg, 0, han, 3, 68) && Segs.btOpenNew(seg, 1, han2, 1, 68) && Segs.btOpenNew(seg, 2, han2, 2, 70)) {
                Handle.btPut(han, Wbdefs.noByts, 0, dbVersionStr, dbVersionStr.length);
                Blink.long2str(byArray, 0, Seg.seg_Used(seg));
                Handle.btPut(han, Wbdefs.usedByts, 4, byArray, 4);
                Blink.short2str(byArray, 0, Seg.seg_Bsiz(seg));
                Handle.btPut(han, Wbdefs.bsizByts, 4, byArray, 2);
                byArray[0] = 4;
                Blink.long2str(byArray, 1, 1);
                Handle.btPut(han, Wbdefs.rootByts, 4, byArray, 5);
                Blink.long2str(byArray, 1, 2);
                Handle.btPut(han, Wbdefs.fldByts, 3, byArray, 5);
                Handle.btPut(han, Wbdefs.flcByts, 3, Wbdefs.noByts, 0);
                if (n > 128) {
                    Handle.btPut(han, Wbdefs.authorsByts, 7, dbAuthorsStr, dbAuthorsStr.length);
                }
                return seg;
            }
            System.err.print(">>>>ERROR<<<< couldn't allocate ents for file " + string + "\n");
            Lck.unlck(Seg.seg_Lck(seg));
            Segs.closeSeg(seg, true);
            return null;
        }
        System.err.print(">>>>ERROR<<<< couldn't create new file " + string + "\n");
        Lck.unlck(Seg.seg_Lck(seg));
        return null;
    }

    public static int btOpen(Seg seg, int n, Han han, int n2) {
        if (SchlepRT.a2b(seg) && SchlepRT.a2b(Seg.seg_Str(seg))) {
            Ent ent = Ents.getEnt(seg, n, 2);
            if (!SchlepRT.a2b(ent)) {
                return -15;
            }
            if (!Wbdefs.root_P(Ent.ent_Blk(ent))) {
                Ents.releaseEnt(ent, 2);
                System.err.print(">>>>ERROR<<<< btOpen: not a root " + Seg.seg_Id(seg) + ":" + n + "\n");
                return -15;
            }
            Segs.btOpenInitHan(han, ent, n2);
            Ents.releaseEnt(ent, 2);
            return Han.han_Typ(han);
        }
        return -15;
    }

    public static void btOpenInitHan(Han han, Ent ent, int n) {
        int n2 = Blk.blk_Typ(Ent.ent_Blk(ent));
        Seg seg = Ent.ent_Seg(ent);
        int n3 = Ent.ent_Id(ent);
        Han.han_SetSeg(han, seg);
        Han.han_SetNum(han, n3);
        Han.han_SetLast(han, n3);
        Han.han_SetTyp(han, n2);
        if (n2 == 68) {
            n |= 3;
        }
        Han.han_SetWcb(han, n);
    }

    public static boolean btOpenNew(Seg seg, int n, Han han, int n2, int n3) {
        if (0 > n) {
            System.err.print(">>>>ERROR<<<< negative block number " + n + "\n");
            return false;
        }
        Ent ent = Ents.tryGetFreeEnt(null, -1);
        while (!SchlepRT.a2b(ent)) {
            ent = Ents.tryGetFreeEnt(null, -1);
        }
        Blink.initLeafBlk(Ent.ent_Blk(ent), n, n3);
        Blk.blk_SetTime(Ent.ent_Blk(ent), (int)(System.currentTimeMillis() / 1000L));
        Ent.ent_SetNext(ent, Wbdefs.getBukWait(Seg.seg_Id(seg), n));
        Wbdefs.setBuk(Seg.seg_Id(seg), n, ent);
        Ent.ent_SetAcc(ent, 3);
        Ent.ent_SetSeg(ent, seg);
        Ent.ent_SetId(ent, n);
        Ent.ent_SetAge(ent, -127);
        Ent.ent_SetDty(ent, true);
        Ent.ent_SetPus(ent, 0);
        Ent.ent_SetRef(ent, 1);
        Wbdefs.relBuk(Seg.seg_Id(seg), n);
        Segs.btOpenInitHan(han, ent, n2);
        Ents.ents_EntWrite(ent);
        Ents.releaseEnt(ent, 3);
        return true;
    }

    public static int btCreate(Seg seg, int n, Han han, int n2) {
        if (SchlepRT.a2b(seg) && SchlepRT.a2b(han)) {
            Ent ent = Ents.createNewBlkEnt(seg);
            if (SchlepRT.a2b(ent)) {
                int n3 = Ent.ent_Id(ent);
                Blink.initLeafBlk(Ent.ent_Blk(ent), n3, n);
                Ent.ent_SetPus(ent, 0);
                Segs.btOpenInitHan(han, ent, n2);
                Ents.ents_EntWrite(ent);
                Ents.releaseEnt(ent, 3);
                return 0;
            }
            return -20;
        }
        return -15;
    }

    public static int btClose(Han han) {
        if (SchlepRT.a2b(han)) {
            Han.han_SetSeg(han, null);
            Han.han_SetNum(han, 0);
            Han.han_SetTyp(han, 0);
            Han.han_SetLast(han, 0);
            return 0;
        }
        return -15;
    }
}

