/* tests/test_mpri_2exp_atan_table.c -- C input file */
/*
 * MPRIA - GNU Multi-Precision Rational Interval Arithmetic Library
 * Copyright (C) 2009-2014  Jerome Benoit <jgmbenoit@rezozer.net>
 *
 * This file is part of the GNU MPRIA Library.
 *
 * The GNU MPRIA Library is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * The GNU MPRIA Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with the GNU MPRIA Library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

/*
 * generation date: 2014/01/30 04:22:22 UTC
 * generation place: NeN
 * generated with: test_mpri_2exp_atan_table.cg (GAP 4.6.5)
 * generated by: jgmb <jgmb@NeN>
 *
 * comment: not human readable
 *
 */

test_mpri_2exp_atan_tuple test_table[]={
	{0UL,"0","0",10,".0e0",".0e0"},
	{1UL,"0","0",10,".0e0",".0e0"},
	{2UL,"0","0",10,".0e0",".0e0"},
	{3UL,"0","0",10,".0e0",".0e0"},
	{4UL,"0","0",10,".0e0",".0e0"},
	{16UL,"0","0",10,".0e0",".0e0"},
	{0UL,"0","0",24,".0e0",".0e0"},
	{1UL,"0","0",24,".0e0",".0e0"},
	{2UL,"0","0",24,".0e0",".0e0"},
	{3UL,"0","0",24,".0e0",".0e0"},
	{4UL,"0","0",24,".0e0",".0e0"},
	{16UL,"0","0",24,".0e0",".0e0"},
	{0UL,"0","0",53,".0e0",".0e0"},
	{1UL,"0","0",53,".0e0",".0e0"},
	{2UL,"0","0",53,".0e0",".0e0"},
	{3UL,"0","0",53,".0e0",".0e0"},
	{4UL,"0","0",53,".0e0",".0e0"},
	{16UL,"0","0",53,".0e0",".0e0"},
	{0UL,"0","0",113,".0e0",".0e0"},
	{1UL,"0","0",113,".0e0",".0e0"},
	{2UL,"0","0",113,".0e0",".0e0"},
	{3UL,"0","0",113,".0e0",".0e0"},
	{4UL,"0","0",113,".0e0",".0e0"},
	{16UL,"0","0",113,".0e0",".0e0"},
	{0UL,"0","0",256,".0e0",".0e0"},
	{1UL,"0","0",256,".0e0",".0e0"},
	{2UL,"0","0",256,".0e0",".0e0"},
	{3UL,"0","0",256,".0e0",".0e0"},
	{4UL,"0","0",256,".0e0",".0e0"},
	{16UL,"0","0",256,".0e0",".0e0"},
	{0UL,"0","0",512,".0e0",".0e0"},
	{1UL,"0","0",512,".0e0",".0e0"},
	{2UL,"0","0",512,".0e0",".0e0"},
	{3UL,"0","0",512,".0e0",".0e0"},
	{4UL,"0","0",512,".0e0",".0e0"},
	{16UL,"0","0",512,".0e0",".0e0"},
	{0UL,"0","0",1024,".0e0",".0e0"},
	{1UL,"0","0",1024,".0e0",".0e0"},
	{2UL,"0","0",1024,".0e0",".0e0"},
	{3UL,"0","0",1024,".0e0",".0e0"},
	{4UL,"0","0",1024,".0e0",".0e0"},
	{16UL,"0","0",1024,".0e0",".0e0"},
	{0UL,"0","0",2048,".0e0",".0e0"},
	{1UL,"0","0",2048,".0e0",".0e0"},
	{2UL,"0","0",2048,".0e0",".0e0"},
	{3UL,"0","0",2048,".0e0",".0e0"},
	{4UL,"0","0",2048,".0e0",".0e0"},
	{16UL,"0","0",2048,".0e0",".0e0"},
	{0UL,"1","1",10,".78539816339753e0",".78539816339753e0"},
	{1UL,"1","1",10,".15707963267951e1",".15707963267951e1"},
	{2UL,"1","1",10,".31415926535901e1",".31415926535901e1"},
	{3UL,"1","1",10,".62831853071802e1",".62831853071802e1"},
	{4UL,"1","1",10,".1256637061436e2",".1256637061436e2"},
	{16UL,"1","1",10,".51471854036421e5",".51471854036421e5"},
	{0UL,"1","1",24,".785398163397448307e0",".785398163397448307e0"},
	{1UL,"1","1",24,".157079632679489661e1",".157079632679489661e1"},
	{2UL,"1","1",24,".314159265358979323e1",".314159265358979323e1"},
	{3UL,"1","1",24,".628318530717958645e1",".628318530717958645e1"},
	{4UL,"1","1",24,".125663706143591729e2",".125663706143591729e2"},
	{16UL,"1","1",24,".514718540364151722e5",".514718540364151722e5"},
	{0UL,"1","1",53,".785398163397448309615660838e0",".785398163397448309615660838e0"},
	{1UL,"1","1",53,".157079632679489661923132168e1",".157079632679489661923132168e1"},
	{2UL,"1","1",53,".314159265358979323846264335e1",".314159265358979323846264335e1"},
	{3UL,"1","1",53,".62831853071795864769252867e1",".62831853071795864769252867e1"},
	{4UL,"1","1",53,".125663706143591729538505734e2",".125663706143591729538505734e2"},
	{16UL,"1","1",53,".514718540364151724189719487e5",".514718540364151724189719487e5"},
	{0UL,"1","1",113,".785398163397448309615660845819875721049292359e0",".785398163397448309615660845819875721049292359e0"},
	{1UL,"1","1",113,".157079632679489661923132169163975144209858472e1",".157079632679489661923132169163975144209858472e1"},
	{2UL,"1","1",113,".314159265358979323846264338327950288419716943e1",".314159265358979323846264338327950288419716943e1"},
	{3UL,"1","1",113,".628318530717958647692528676655900576839433887e1",".628318530717958647692528676655900576839433887e1"},
	{4UL,"1","1",113,".125663706143591729538505735331180115367886777e2",".125663706143591729538505735331180115367886777e2"},
	{16UL,"1","1",113,".51471854036415172418971949191651375254686424e5",".51471854036415172418971949191651375254686424e5"},
	{0UL,"1","1",256,".7853981633974483096156608458198757210492923498437764552437361480769541015715522496570096e0",".7853981633974483096156608458198757210492923498437764552437361480769541015715522496570096e0"},
	{1UL,"1","1",256,".1570796326794896619231321691639751442098584699687552910487472296153908203143104499314019e1",".1570796326794896619231321691639751442098584699687552910487472296153908203143104499314019e1"},
	{2UL,"1","1",256,".3141592653589793238462643383279502884197169399375105820974944592307816406286208998628038e1",".3141592653589793238462643383279502884197169399375105820974944592307816406286208998628038e1"},
	{3UL,"1","1",256,".6283185307179586476925286766559005768394338798750211641949889184615632812572417997256077e1",".6283185307179586476925286766559005768394338798750211641949889184615632812572417997256077e1"},
	{4UL,"1","1",256,".1256637061435917295385057353311801153678867759750042328389977836923126562514483599451215e2",".1256637061435917295385057353311801153678867759750042328389977836923126562514483599451215e2"},
	{16UL,"1","1",256,".5147185403641517241897194919165137525468642343936173377085349220037126400059324823352178e5",".5147185403641517241897194919165137525468642343936173377085349220037126400059324823352178e5"},
	{0UL,"1","1",512,".785398163397448309615660845819875721049292349843776455243736148076954101571552249657008706335529266995537021628320576661773461152387645557931339852032120279362571019e0",".785398163397448309615660845819875721049292349843776455243736148076954101571552249657008706335529266995537021628320576661773461152387645557931339852032120279362571019e0"},
	{1UL,"1","1",512,".157079632679489661923132169163975144209858469968755291048747229615390820314310449931401741267105853399107404325664115332354692230477529111586267970406424055872514204e1",".157079632679489661923132169163975144209858469968755291048747229615390820314310449931401741267105853399107404325664115332354692230477529111586267970406424055872514204e1"},
	{2UL,"1","1",512,".314159265358979323846264338327950288419716939937510582097494459230781640628620899862803482534211706798214808651328230664709384460955058223172535940812848111745028408e1",".314159265358979323846264338327950288419716939937510582097494459230781640628620899862803482534211706798214808651328230664709384460955058223172535940812848111745028408e1"},
	{3UL,"1","1",512,".628318530717958647692528676655900576839433879875021164194988918461563281257241799725606965068423413596429617302656461329418768921910116446345071881625696223490056815e1",".628318530717958647692528676655900576839433879875021164194988918461563281257241799725606965068423413596429617302656461329418768921910116446345071881625696223490056815e1"},
	{4UL,"1","1",512,".125663706143591729538505735331180115367886775975004232838997783692312656251448359945121393013684682719285923460531292265883753784382023289269014376325139244698011363e2",".125663706143591729538505735331180115367886775975004232838997783692312656251448359945121393013684682719285923460531292265883753784382023289269014376325139244698011363e2"},
	{16UL,"1","1",512,".514718540364151724189719491916513752546864234393617337708534922003712640005932482335217225784052460418195142494336173121059855500828767392845882885427770346283054543e5",".514718540364151724189719491916513752546864234393617337708534922003712640005932482335217225784052460418195142494336173121059855500828767392845882885427770346283054543e5"},
	{0UL,"1","1",1024,".7853981633974483096156608458198757210492923498437764552437361480769541015715522496570087063355292669955370216283205766617734611523876455579313398520321202793625710256754846302763899111557372387325954911072027439164833615321189120584466957913178004772864121417308650871526135816620533484018150622853184311467516515788971e0",".7853981633974483096156608458198757210492923498437764552437361480769541015715522496570087063355292669955370216283205766617734611523876455579313398520321202793625710256754846302763899111557372387325954911072027439164833615321189120584466957913178004772864121417308650871526135816620533484018150622853184311467516515788971e0"},
	{1UL,"1","1",1024,".1570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533991074043256641153323546922304775291115862679704064240558725142051350969260552779822311474477465190982214405487832966723064237824116893391582635600954572824283461730174305227163324106696803630124570636862293503303157794e1",".1570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533991074043256641153323546922304775291115862679704064240558725142051350969260552779822311474477465190982214405487832966723064237824116893391582635600954572824283461730174305227163324106696803630124570636862293503303157794e1"},
	{2UL,"1","1",1024,".3141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117067982148086513282306647093844609550582231725359408128481117450284102701938521105559644622948954930381964428810975665933446128475648233786783165271201909145648566923460348610454326648213393607260249141273724587006606315588e1",".3141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117067982148086513282306647093844609550582231725359408128481117450284102701938521105559644622948954930381964428810975665933446128475648233786783165271201909145648566923460348610454326648213393607260249141273724587006606315588e1"},
	{3UL,"1","1",1024,".6283185307179586476925286766559005768394338798750211641949889184615632812572417997256069650684234135964296173026564613294187689219101164463450718816256962234900568205403877042211119289245897909860763928857621951331866892256951296467573566330542403818291297133846920697220908653296426787214520498282547449174013212631176e1",".6283185307179586476925286766559005768394338798750211641949889184615632812572417997256069650684234135964296173026564613294187689219101164463450718816256962234900568205403877042211119289245897909860763928857621951331866892256951296467573566330542403818291297133846920697220908653296426787214520498282547449174013212631176e1"},
	{4UL,"1","1",1024,".1256637061435917295385057353311801153678867759750042328389977836923126562514483599451213930136846827192859234605312922658837537843820232892690143763251392446980113641080775408442223857849179581972152785771524390266373378451390259293514713266108480763658259426769384139444181730659285357442904099656509489834802642526235e2",".1256637061435917295385057353311801153678867759750042328389977836923126562514483599451213930136846827192859234605312922658837537843820232892690143763251392446980113641080775408442223857849179581972152785771524390266373378451390259293514713266108480763658259426769384139444181730659285357442904099656509489834802642526235e2"},
	{16UL,"1","1",1024,".514718540364151724189719491916513752546864234393617337708534922003712640005932482335217225784052460418195142494336173121059855500828767392845882885427770346283054547386685607297934892175023956775793781052016390253106535813689450206623626553798033720794423061204739743516336836878043282408613519219306287036335162378746e5",".514718540364151724189719491916513752546864234393617337708534922003712640005932482335217225784052460418195142494336173121059855500828767392845882885427770346283054547386685607297934892175023956775793781052016390253106535813689450206623626553798033720794423061204739743516336836878043282408613519219306287036335162378746e5"},
	{0UL,"1","1",2048,".7853981633974483096156608458198757210492923498437764552437361480769541015715522496570087063355292669955370216283205766617734611523876455579313398520321202793625710256754846302763899111557372387325954911072027439164833615321189120584466957913178004772864121417308650871526135816620533484018150622853184311467516515788970437203802302407073135229288410919731475900028326326372051166303460367379853779023582643175914398979882730465293454831529482762796370186155949906873918379714381812228069845457529872824584183406101641607715053487365988061842976755449652359256926348042940732941880961687046169173512830001420317863158902069464403e0",".7853981633974483096156608458198757210492923498437764552437361480769541015715522496570087063355292669955370216283205766617734611523876455579313398520321202793625710256754846302763899111557372387325954911072027439164833615321189120584466957913178004772864121417308650871526135816620533484018150622853184311467516515788970437203802302407073135229288410919731475900028326326372051166303460367379853779023582643175914398979882730465293454831529482762796370186155949906873918379714381812228069845457529872824584183406101641607715053487365988061842976755449652359256926348042940732941880961687046169173512830001420317863158902069464403e0"},
	{1UL,"1","1",2048,".1570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533991074043256641153323546922304775291115862679704064240558725142051350969260552779822311474477465190982214405487832966723064237824116893391582635600954572824283461730174305227163324106696803630124570636862293503303157794087440760460481414627045857682183946295180005665265274410233260692073475970755804716528635182879795976546093058690966305896552559274037231189981374783675942876362445613969091505974564916836681220328321543010697473197612368595351089930471851385269608588146588376192337409233834702566000284063572631780413892881e1",".1570796326794896619231321691639751442098584699687552910487472296153908203143104499314017412671058533991074043256641153323546922304775291115862679704064240558725142051350969260552779822311474477465190982214405487832966723064237824116893391582635600954572824283461730174305227163324106696803630124570636862293503303157794087440760460481414627045857682183946295180005665265274410233260692073475970755804716528635182879795976546093058690966305896552559274037231189981374783675942876362445613969091505974564916836681220328321543010697473197612368595351089930471851385269608588146588376192337409233834702566000284063572631780413892881e1"},
	{2UL,"1","1",2048,".3141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117067982148086513282306647093844609550582231725359408128481117450284102701938521105559644622948954930381964428810975665933446128475648233786783165271201909145648566923460348610454326648213393607260249141273724587006606315588174881520920962829254091715364367892590360011330530548820466521384146951941511609433057270365759591953092186117381932611793105118548074462379962749567351885752724891227938183011949129833673362440656643086021394946395224737190702179860943702770539217176293176752384674818467669405132000568127145263560827785761e1",".3141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117067982148086513282306647093844609550582231725359408128481117450284102701938521105559644622948954930381964428810975665933446128475648233786783165271201909145648566923460348610454326648213393607260249141273724587006606315588174881520920962829254091715364367892590360011330530548820466521384146951941511609433057270365759591953092186117381932611793105118548074462379962749567351885752724891227938183011949129833673362440656643086021394946395224737190702179860943702770539217176293176752384674818467669405132000568127145263560827785761e1"},
	{3UL,"1","1",2048,".6283185307179586476925286766559005768394338798750211641949889184615632812572417997256069650684234135964296173026564613294187689219101164463450718816256962234900568205403877042211119289245897909860763928857621951331866892256951296467573566330542403818291297133846920697220908653296426787214520498282547449174013212631176349763041841925658508183430728735785180720022661061097640933042768293903883023218866114540731519183906184372234763865223586210237096148924759925499134703771505449782455876366023898259667346724881313286172042789892790449474381404359721887405541078434352586353504769349636935338810264001136254290527121655571523e1",".6283185307179586476925286766559005768394338798750211641949889184615632812572417997256069650684234135964296173026564613294187689219101164463450718816256962234900568205403877042211119289245897909860763928857621951331866892256951296467573566330542403818291297133846920697220908653296426787214520498282547449174013212631176349763041841925658508183430728735785180720022661061097640933042768293903883023218866114540731519183906184372234763865223586210237096148924759925499134703771505449782455876366023898259667346724881313286172042789892790449474381404359721887405541078434352586353504769349636935338810264001136254290527121655571523e1"},
	{4UL,"1","1",2048,".1256637061435917295385057353311801153678867759750042328389977836923126562514483599451213930136846827192859234605312922658837537843820232892690143763251392446980113641080775408442223857849179581972152785771524390266373378451390259293514713266108480763658259426769384139444181730659285357442904099656509489834802642526235269952608368385131701636686145747157036144004532212219528186608553658780776604643773222908146303836781236874446952773044717242047419229784951985099826940754301089956491175273204779651933469344976262657234408557978558089894876280871944377481108215686870517270700953869927387067762052800227250858105424331114305e2",".1256637061435917295385057353311801153678867759750042328389977836923126562514483599451213930136846827192859234605312922658837537843820232892690143763251392446980113641080775408442223857849179581972152785771524390266373378451390259293514713266108480763658259426769384139444181730659285357442904099656509489834802642526235269952608368385131701636686145747157036144004532212219528186608553658780776604643773222908146303836781236874446952773044717242047419229784951985099826940754301089956491175273204779651933469344976262657234408557978558089894876280871944377481108215686870517270700953869927387067762052800227250858105424331114305e2"},
	{16UL,"1","1",2048,".5147185403641517241897194919165137525468642343936173377085349220037126400059324823352172257840524604181951424943361731210598555008287673928458828854277703462830545473866856072979348921750239567757937810520163902531065358136894502066236265537980337207944230612047397435163368368780432824086135192193062870363351623787459665725883876905499449903866452980355220045842563941251187452348635786366060972620895121031767260515455946237734718558391161823426229165199163330968891149329617264461787853919046777454319490437022771844032137453480173936209413246451484170162619251453421638740791107051222577429553368269730819514799818060244191e5",".5147185403641517241897194919165137525468642343936173377085349220037126400059324823352172257840524604181951424943361731210598555008287673928458828854277703462830545473866856072979348921750239567757937810520163902531065358136894502066236265537980337207944230612047397435163368368780432824086135192193062870363351623787459665725883876905499449903866452980355220045842563941251187452348635786366060972620895121031767260515455946237734718558391161823426229165199163330968891149329617264461787853919046777454319490437022771844032137453480173936209413246451484170162619251453421638740791107051222577429553368269730819514799818060244191e5"},
	{0UL,"124145519261541/51422757785981","124145519261543/51422757785981",10,".11780972450961e1",".11780972450961e1"},
	{1UL,"124145519261541/51422757785981","124145519261543/51422757785981",10,".23561944901921e1",".23561944901921e1"},
	{2UL,"124145519261541/51422757785981","124145519261543/51422757785981",10,".47123889803843e1",".47123889803843e1"},
	{3UL,"124145519261541/51422757785981","124145519261543/51422757785981",10,".94247779607686e1",".94247779607686e1"},
	{4UL,"124145519261541/51422757785981","124145519261543/51422757785981",10,".18849555921537e2",".18849555921537e2"},
	{16UL,"124145519261541/51422757785981","124145519261543/51422757785981",10,".77207781054616e5",".77207781054616e5"},
	{0UL,"124145519261541/51422757785981","124145519261543/51422757785981",24,".117809724509616962e1",".117809724509617531e1"},
	{1UL,"124145519261541/51422757785981","124145519261543/51422757785981",24,".235619449019233923e1",".235619449019235061e1"},
	{2UL,"124145519261541/51422757785981","124145519261543/51422757785981",24,".471238898038467846e1",".471238898038470122e1"},
	{3UL,"124145519261541/51422757785981","124145519261543/51422757785981",24,".942477796076935692e1",".942477796076940244e1"},
	{4UL,"124145519261541/51422757785981","124145519261543/51422757785981",24,".188495559215387138e2",".188495559215388049e2"},
	{16UL,"124145519261541/51422757785981","124145519261543/51422757785981",24,".772077810546225719e5",".772077810546229448e5"},
	{0UL,"124145519261541/51422757785981","124145519261543/51422757785981",53,".117809724509616961652859583e1",".117809724509617531231838668e1"},
	{1UL,"124145519261541/51422757785981","124145519261543/51422757785981",53,".235619449019233923305719167e1",".235619449019235062463677336e1"},
	{2UL,"124145519261541/51422757785981","124145519261543/51422757785981",53,".471238898038467846611438334e1",".471238898038470124927354672e1"},
	{3UL,"124145519261541/51422757785981","124145519261543/51422757785981",53,".942477796076935693222876667e1",".942477796076940249854709343e1"},
	{4UL,"124145519261541/51422757785981","124145519261543/51422757785981",53,".188495559215387138644575333e2",".188495559215388049970941869e2"},
	{16UL,"124145519261541/51422757785981","124145519261543/51422757785981",53,".772077810546225719888180566e5",".772077810546229452680977894e5"},
	{0UL,"124145519261541/51422757785981","124145519261543/51422757785981",113,".117809724509616961652859585623814624127830872e1",".117809724509617531231838668114315895395668843e1"},
	{1UL,"124145519261541/51422757785981","124145519261543/51422757785981",113,".235619449019233923305719171247629248255661744e1",".235619449019235062463677336228631790791337686e1"},
	{2UL,"124145519261541/51422757785981","124145519261543/51422757785981",113,".471238898038467846611438342495258496511323488e1",".471238898038470124927354672457263581582675372e1"},
	{3UL,"124145519261541/51422757785981","124145519261543/51422757785981",113,".942477796076935693222876684990516993022646977e1",".942477796076940249854709344914527163165350744e1"},
	{4UL,"124145519261541/51422757785981","124145519261543/51422757785981",113,".188495559215387138644575336998103398604529395e2",".188495559215388049970941868982905432633070149e2"},
	{16UL,"124145519261541/51422757785981","124145519261543/51422757785981",113,".772077810546225719888180580344231520684152404e5",".77207781054622945268097789535398065206505533e5"},
	{0UL,"124145519261541/51422757785981","124145519261543/51422757785981",256,".1178097245096169616528595856238146241278308734700377375117571281779792377117235412679743e1",".1178097245096175312318386681143158953956688444523282918811548716408676880106963558849646e1"},
	{1UL,"124145519261541/51422757785981","124145519261543/51422757785981",256,".2356194490192339233057191712476292482556617469400754750235142563559584754234470825359486e1",".2356194490192350624636773362286317907913376889046565837623097432817353760213927117699291e1"},
	{2UL,"124145519261541/51422757785981","124145519261543/51422757785981",256,".4712388980384678466114383424952584965113234938801509500470285127119169508468941650718971e1",".4712388980384701249273546724572635815826753778093131675246194865634707520427854235398583e1"},
	{3UL,"124145519261541/51422757785981","124145519261543/51422757785981",256,".9424777960769356932228766849905169930226469877603019000940570254238339016937883301437943e1",".9424777960769402498547093449145271631653507556186263350492389731269415040855708470797166e1"},
	{4UL,"124145519261541/51422757785981","124145519261543/51422757785981",256,".1884955592153871386445753369981033986045293975520603800188114050847667803387576660287589e2",".1884955592153880499709418689829054326330701511237252670098477946253883008171141694159433e2"},
	{16UL,"124145519261541/51422757785981","124145519261543/51422757785981",256,".7720778105462257198881805803442315206841524123732393165570515152272047322675514000537963e5",".7720778105462294526809778953539806520650553390027786936723365667855904801468996379277038e5"},
	{0UL,"124145519261541/51422757785981","124145519261543/51422757785981",512,".117809724509616961652859585623814624127830873470037737511757128177979237711723541267974488664660666223001712875939752906295884153774754808556825702501860187459732898e1",".117809724509617531231838668114315895395668844452328291881154871640867688010696355884964401051686718841877569466117445606032234260347648494107734622834198585820465981e1"},
	{1UL,"124145519261541/51422757785981","124145519261543/51422757785981",512,".235619449019233923305719171247629248255661746940075475023514256355958475423447082535948977329321332446003425751879505812591768307549509617113651405003720374919465796e1",".235619449019235062463677336228631790791337688904656583762309743281735376021392711769928802103373437683755138932234891212064468520695296988215469245668397171640931962e1"},
	{2UL,"124145519261541/51422757785981","124145519261543/51422757785981",512,".471238898038467846611438342495258496511323493880150950047028512711916950846894165071897954658642664892006851503759011625183536615099019234227302810007440749838931592e1",".471238898038470124927354672457263581582675377809313167524619486563470752042785423539857604206746875367510277864469782424128937041390593976430938491336794343281863924e1"},
	{3UL,"124145519261541/51422757785981","124145519261543/51422757785981",512,".942477796076935693222876684990516993022646987760301900094057025423833901693788330143795909317285329784013703007518023250367073230198038468454605620014881499677863184e1",".942477796076940249854709344914527163165350755618626335049238973126941504085570847079715208413493750735020555728939564848257874082781187952861876982673588686563727847e1"},
	{4UL,"124145519261541/51422757785981","124145519261543/51422757785981",512,".188495559215387138644575336998103398604529397552060380018811405084766780338757666028759181863457065956802740601503604650073414646039607693690921124002976299935572637e2",".188495559215388049970941868982905432633070151123725267009847794625388300817114169415943041682698750147004111145787912969651574816556237590572375396534717737312745569e2"},
	{16UL,"124145519261541/51422757785981","124145519261543/51422757785981",512,".772077810546225719888180580344231520684152412373239316557051515227204732267551400053797608912720142159064025503758764646700706390178233113358012923916190924536105521e5",".772077810546229452680977895353980652065055339002778693672336566785590480146899637927702698732334080602128839253147291523692850448614349170984449624206203852033005853e5"},
	{0UL,"124145519261541/51422757785981","124145519261543/51422757785981",1024,".117809724509616961652859585623814624127830873470037737511757128177979237711723541267974488664660666223001712875939752906295884153774754808556825702501860187459732898151391005449876113602818951383856853611265898750586883737722345221227573081103628030857554670819463701027178498454418839885250054463078136799451126847875e1",".1178097245096175312318386681143158953956688444523282918811548716408676880106963558849644010516867188418775694661174456060322342603476484941077346228341985858204659796662670249398996699038165379644808713466045351682649759769542962221736400547370354536114534163016356794725067817495758311835160108577365462457749991254827e1"},
	{1UL,"124145519261541/51422757785981","124145519261543/51422757785981",1024,".23561944901923392330571917124762924825566174694007547502351425635595847542344708253594897732932133244600342575187950581259176830754950961711365140500372037491946579630278201089975222720563790276771370722253179750117376747544469044245514616220725606171510934163892740205435699690883767977050010892615627359890225369575e1",".2356194490192350624636773362286317907913376889046565837623097432817353760213927117699288021033734376837551389322348912120644685206952969882154692456683971716409319593325340498797993398076330759289617426932090703365299519539085924443472801094740709072229068326032713589450135634991516623670320217154730924915499982509654e1"},
	{2UL,"124145519261541/51422757785981","124145519261543/51422757785981",1024,".4712388980384678466114383424952584965113234938801509500470285127119169508468941650718979546586426648920068515037590116251835366150990192342273028100074407498389315926055640217995044544112758055354274144450635950023475349508893808849102923244145121234302186832778548041087139938176753595410002178523125471978045073915e1",".4712388980384701249273546724572635815826753778093131675246194865634707520427854235398576042067468753675102778644697824241289370413905939764309384913367943432818639186650680997595986796152661518579234853864181406730599039078171848886945602189481418144458136652065427178900271269983033247340640434309461849830999965019308e1"},
	{3UL,"124145519261541/51422757785981","124145519261543/51422757785981",1024,".9424777960769356932228766849905169930226469877603019000940570254238339016937883301437959093172853297840137030075180232503670732301980384684546056200148814996778631852111280435990089088225516110708548288901271900046950699017787617698205846488290242468604373665557096082174279876353507190820004357046250943956090147829999e1",".9424777960769402498547093449145271631653507556186263350492389731269415040855708470797152084134937507350205557289395648482578740827811879528618769826735886865637278373301361995191973592305323037158469707728362813461198078156343697773891204378962836288916273304130854357800542539966066494681280868618923699661999930038615e1"},
	{4UL,"124145519261541/51422757785981","124145519261543/51422757785981",1024,".1884955592153871386445753369981033986045293975520603800188114050847667803387576660287591818634570659568027406015036046500734146460396076936909211240029762999355726370422256087198017817645103222141709657780254380009390139803557523539641169297658048493720874733111419216434855975270701438164000871409250188791218029566e2",".1884955592153880499709418689829054326330701511237252670098477946253883008171141694159430416826987501470041111457879129696515748165562375905723753965347177373127455674660272399038394718461064607431693941545672562692239615631268739554778240875792567257783254660826170871560108507993213298936256173723784739932399986007723e2"},
	{16UL,"124145519261541/51422757785981","124145519261543/51422757785981",1024,".7720778105462257198881805803442315206841524123732393165570515152272047322675514000537976089127201421590640255037587646467007063901782331133580129239161909245361055213249560933163080981074342797892442758267921940518462012635371616418370229443207366630280702906824373110517170074708793090719747569292288773288829049102335e5",".7720778105462294526809778953539806520650553390027786936723365667855904801468996379277026987323340806021288392531472915236928504486143491709844496242062038520330058443408475746461264766816520632040218384571074816787413465625676757216371674627246355487880211090743995889910204448740201672442905287572622294763110342687633e5"},
	{0UL,"124145519261541/51422757785981","124145519261543/51422757785981",2048,".1178097245096169616528595856238146241278308734700377375117571281779792377117235412679744886646606662230017128759397529062958841537747548085568257025018601874597328981513910054498761136028189513838568536112658987505868837377223452212275730811036280308575546708194637010271784984544188398852500544630781367994511268478749102147063241715417624940081008884444969622805533582381974111164688256435031289649713815465922213225702387885770230416928642484103392638612214062052524727165413975693372694122001435014959576157666693351033730789578432957670280216245565922393876050386733198232062492786012904822767607047489898799346941053433625e1",".1178097245096175312318386681143158953956688444523282918811548716408676880106963558849644010516867188418775694661174456060322342603476484941077346228341985858204659796662670249398996699038165379644808713466045351682649759769542962221736400547370354536114534163016356794725067817495758311835160108577365462457749991254827254163196835725214966923834623450148147941110157090821988440055140842778867730530211745187570773842892160606969212620479376561963668562658027501708594626221044042807152039397420080675254528756722537822645134728780443292846966980205910589604535460598375500631571725266233360952112581727218585962251949172341647e1"},
	{1UL,"124145519261541/51422757785981","124145519261543/51422757785981",2048,".235619449019233923305719171247629248255661746940075475023514256355958475423447082535948977329321332446003425751879505812591768307549509617113651405003720374919465796302782010899752227205637902767713707222531797501173767475444690442455146162207256061715109341638927402054356996908837679770500108926156273598902253695749820429412648343083524988016201776888993924561106716476394822232937651287006257929942763093184442645140477577154046083385728496820678527722442812410504945433082795138674538824400287002991915231533338670206746157915686591534056043249113184478775210077346639646412498557202580964553521409497979759869388210686725e1",".2356194490192350624636773362286317907913376889046565837623097432817353760213927117699288021033734376837551389322348912120644685206952969882154692456683971716409319593325340498797993398076330759289617426932090703365299519539085924443472801094740709072229068326032713589450135634991516623670320217154730924915499982509654508326393671450429933847669246900296295882220314181643976880110281685557735461060423490375141547685784321213938425240958753123927337125316055003417189252442088085614304078794840161350509057513445075645290269457560886585693933960411821179209070921196751001263143450532466721904225163454437171924503898344683294e1"},
	{2UL,"124145519261541/51422757785981","124145519261543/51422757785981",2048,".47123889803846784661143834249525849651132349388015095004702851271191695084689416507189795465864266489200685150375901162518353661509901923422730281000744074983893159260556402179950445441127580553542741444506359500234753495088938088491029232441451212343021868327785480410871399381767535954100021785231254719780450739149964085882529668616704997603240355377798784912221343295278964446587530257401251585988552618636888529028095515430809216677145699364135705544488562482100989086616559027734907764880057400598383046306667734041349231583137318306811208649822636895755042015469327929282499711440516192910704281899595951973877642137345e1",".4712388980384701249273546724572635815826753778093131675246194865634707520427854235398576042067468753675102778644697824241289370413905939764309384913367943432818639186650680997595986796152661518579234853864181406730599039078171848886945602189481418144458136652065427178900271269983033247340640434309461849830999965019309016652787342900859867695338493800592591764440628363287953760220563371115470922120846980750283095371568642427876850481917506247854674250632110006834378504884176171228608157589680322701018115026890151290580538915121773171387867920823642358418141842393502002526286901064933443808450326908874343849007796689366587e1"},
	{3UL,"124145519261541/51422757785981","124145519261543/51422757785981",2048,".9424777960769356932228766849905169930226469877603019000940570254238339016937883301437959093172853297840137030075180232503670732301980384684546056200148814996778631852111280435990089088225516110708548288901271900046950699017787617698205846488290242468604373665557096082174279876353507190820004357046250943956090147829992817176505933723340999520648071075559756982444268659055792889317506051480250317197710523727377705805619103086161843335429139872827141108897712496420197817323311805546981552976011480119676609261333546808269846316627463661362241729964527379151008403093865585856499942288103238582140856379919190394775528427469001e1",".9424777960769402498547093449145271631653507556186263350492389731269415040855708470797152084134937507350205557289395648482578740827811879528618769826735886865637278373301361995191973592305323037158469707728362813461198078156343697773891204378962836288916273304130854357800542539966066494681280868618923699661999930038618033305574685801719735390676987601185183528881256726575907520441126742230941844241693961500566190743137284855753700963835012495709348501264220013668757009768352342457216315179360645402036230053780302581161077830243546342775735841647284716836283684787004005052573802129866887616900653817748687698015593378733174e1"},
	{4UL,"124145519261541/51422757785981","124145519261543/51422757785981",2048,".18849555921538713864457533699810339860452939755206038001881140508476678033875766602875918186345706595680274060150360465007341464603960769369092112400297629993557263704222560871980178176451032221417096577802543800093901398035575235396411692976580484937208747331114192164348559752707014381640008714092501887912180295659985634353011867446681999041296142151119513964888537318111585778635012102960500634395421047454755411611238206172323686670858279745654282217795424992840395634646623611093963105952022960239353218522667093616539692633254927322724483459929054758302016806187731171712999884576206477164281712759838380789551056854938e2",".1884955592153880499709418689829054326330701511237252670098477946253883008171141694159430416826987501470041111457879129696515748165562375905723753965347177373127455674660272399038394718461064607431693941545672562692239615631268739554778240875792567257783254660826170871560108507993213298936256173723784739932399986007723606661114937160343947078135397520237036705776251345315181504088225348446188368848338792300113238148627456971150740192767002499141869700252844002733751401953670468491443263035872129080407246010756060516232215566048709268555147168329456943367256736957400801010514760425973377523380130763549737539603118675746635e2"},
	{16UL,"124145519261541/51422757785981","124145519261543/51422757785981",2048,".7720778105462257198881805803442315206841524123732393165570515152272047322675514000537976089127201421590640255037587646467007063901782331133580129239161909245361055213249560933163080981074342797892442758267921940518462012635371616418370229443207366630280702906824373110517170074708793090719747569292288773288829049102330115830993660906160946807314899825098552920018344885498505534928900957372621059848364461037467816595963169248183782060383551383819993996409006077067426051951257031104087288197948604514039078306884441545334658102581218231387948425186940829000506083814494687933644752722414173046489789546429800771400112887782605e5",".7720778105462294526809778953539806520650553390027786936723365667855904801468996379277026987323340806021288392531472915236928504486143491709844496242062038520330058443408475746461264766816520632040218384571074816787413465625676757216371674627246355487880211090743995889910204448740201672442905287572622294763110342687635892883926782608768807232042588242890902346859525510410983440745371027235587558802795693261263823456778063753833431829573642236485098292235649035197445742402234238940951605394932240713348079660056823874487154958535513164001882801477455640032283594577513680939068458704786954335765015607499724962214374095858216e5"},
	{0UL,"-124145519261541/51422757785981","124145519261543/51422757785981",10,"-.11780972450961e1",".11780972450961e1"},
	{1UL,"-124145519261541/51422757785981","124145519261543/51422757785981",10,"-.23561944901921e1",".23561944901921e1"},
	{2UL,"-124145519261541/51422757785981","124145519261543/51422757785981",10,"-.47123889803843e1",".47123889803843e1"},
	{3UL,"-124145519261541/51422757785981","124145519261543/51422757785981",10,"-.94247779607686e1",".94247779607686e1"},
	{4UL,"-124145519261541/51422757785981","124145519261543/51422757785981",10,"-.18849555921537e2",".18849555921537e2"},
	{16UL,"-124145519261541/51422757785981","124145519261543/51422757785981",10,"-.77207781054616e5",".77207781054616e5"},
	{0UL,"-124145519261541/51422757785981","124145519261543/51422757785981",24,"-.117809724509616962e1",".117809724509617531e1"},
	{1UL,"-124145519261541/51422757785981","124145519261543/51422757785981",24,"-.235619449019233923e1",".235619449019235061e1"},
	{2UL,"-124145519261541/51422757785981","124145519261543/51422757785981",24,"-.471238898038467846e1",".471238898038470122e1"},
	{3UL,"-124145519261541/51422757785981","124145519261543/51422757785981",24,"-.942477796076935692e1",".942477796076940244e1"},
	{4UL,"-124145519261541/51422757785981","124145519261543/51422757785981",24,"-.188495559215387138e2",".188495559215388049e2"},
	{16UL,"-124145519261541/51422757785981","124145519261543/51422757785981",24,"-.772077810546225719e5",".772077810546229448e5"},
	{0UL,"-124145519261541/51422757785981","124145519261543/51422757785981",53,"-.117809724509616961652859583e1",".117809724509617531231838668e1"},
	{1UL,"-124145519261541/51422757785981","124145519261543/51422757785981",53,"-.235619449019233923305719167e1",".235619449019235062463677336e1"},
	{2UL,"-124145519261541/51422757785981","124145519261543/51422757785981",53,"-.471238898038467846611438334e1",".471238898038470124927354672e1"},
	{3UL,"-124145519261541/51422757785981","124145519261543/51422757785981",53,"-.942477796076935693222876667e1",".942477796076940249854709343e1"},
	{4UL,"-124145519261541/51422757785981","124145519261543/51422757785981",53,"-.188495559215387138644575333e2",".188495559215388049970941869e2"},
	{16UL,"-124145519261541/51422757785981","124145519261543/51422757785981",53,"-.772077810546225719888180566e5",".772077810546229452680977894e5"},
	{0UL,"-124145519261541/51422757785981","124145519261543/51422757785981",113,"-.117809724509616961652859585623814624127830872e1",".117809724509617531231838668114315895395668843e1"},
	{1UL,"-124145519261541/51422757785981","124145519261543/51422757785981",113,"-.235619449019233923305719171247629248255661744e1",".235619449019235062463677336228631790791337686e1"},
	{2UL,"-124145519261541/51422757785981","124145519261543/51422757785981",113,"-.471238898038467846611438342495258496511323488e1",".471238898038470124927354672457263581582675372e1"},
	{3UL,"-124145519261541/51422757785981","124145519261543/51422757785981",113,"-.942477796076935693222876684990516993022646977e1",".942477796076940249854709344914527163165350744e1"},
	{4UL,"-124145519261541/51422757785981","124145519261543/51422757785981",113,"-.188495559215387138644575336998103398604529395e2",".188495559215388049970941868982905432633070149e2"},
	{16UL,"-124145519261541/51422757785981","124145519261543/51422757785981",113,"-.772077810546225719888180580344231520684152404e5",".77207781054622945268097789535398065206505533e5"},
	{0UL,"-124145519261541/51422757785981","124145519261543/51422757785981",256,"-.1178097245096169616528595856238146241278308734700377375117571281779792377117235412679743e1",".1178097245096175312318386681143158953956688444523282918811548716408676880106963558849646e1"},
	{1UL,"-124145519261541/51422757785981","124145519261543/51422757785981",256,"-.2356194490192339233057191712476292482556617469400754750235142563559584754234470825359486e1",".2356194490192350624636773362286317907913376889046565837623097432817353760213927117699291e1"},
	{2UL,"-124145519261541/51422757785981","124145519261543/51422757785981",256,"-.4712388980384678466114383424952584965113234938801509500470285127119169508468941650718971e1",".4712388980384701249273546724572635815826753778093131675246194865634707520427854235398583e1"},
	{3UL,"-124145519261541/51422757785981","124145519261543/51422757785981",256,"-.9424777960769356932228766849905169930226469877603019000940570254238339016937883301437943e1",".9424777960769402498547093449145271631653507556186263350492389731269415040855708470797166e1"},
	{4UL,"-124145519261541/51422757785981","124145519261543/51422757785981",256,"-.1884955592153871386445753369981033986045293975520603800188114050847667803387576660287589e2",".1884955592153880499709418689829054326330701511237252670098477946253883008171141694159433e2"},
	{16UL,"-124145519261541/51422757785981","124145519261543/51422757785981",256,"-.7720778105462257198881805803442315206841524123732393165570515152272047322675514000537963e5",".7720778105462294526809778953539806520650553390027786936723365667855904801468996379277038e5"},
	{0UL,"-124145519261541/51422757785981","124145519261543/51422757785981",512,"-.117809724509616961652859585623814624127830873470037737511757128177979237711723541267974488664660666223001712875939752906295884153774754808556825702501860187459732898e1",".117809724509617531231838668114315895395668844452328291881154871640867688010696355884964401051686718841877569466117445606032234260347648494107734622834198585820465981e1"},
	{1UL,"-124145519261541/51422757785981","124145519261543/51422757785981",512,"-.235619449019233923305719171247629248255661746940075475023514256355958475423447082535948977329321332446003425751879505812591768307549509617113651405003720374919465796e1",".235619449019235062463677336228631790791337688904656583762309743281735376021392711769928802103373437683755138932234891212064468520695296988215469245668397171640931962e1"},
	{2UL,"-124145519261541/51422757785981","124145519261543/51422757785981",512,"-.471238898038467846611438342495258496511323493880150950047028512711916950846894165071897954658642664892006851503759011625183536615099019234227302810007440749838931592e1",".471238898038470124927354672457263581582675377809313167524619486563470752042785423539857604206746875367510277864469782424128937041390593976430938491336794343281863924e1"},
	{3UL,"-124145519261541/51422757785981","124145519261543/51422757785981",512,"-.942477796076935693222876684990516993022646987760301900094057025423833901693788330143795909317285329784013703007518023250367073230198038468454605620014881499677863184e1",".942477796076940249854709344914527163165350755618626335049238973126941504085570847079715208413493750735020555728939564848257874082781187952861876982673588686563727847e1"},
	{4UL,"-124145519261541/51422757785981","124145519261543/51422757785981",512,"-.188495559215387138644575336998103398604529397552060380018811405084766780338757666028759181863457065956802740601503604650073414646039607693690921124002976299935572637e2",".188495559215388049970941868982905432633070151123725267009847794625388300817114169415943041682698750147004111145787912969651574816556237590572375396534717737312745569e2"},
	{16UL,"-124145519261541/51422757785981","124145519261543/51422757785981",512,"-.772077810546225719888180580344231520684152412373239316557051515227204732267551400053797608912720142159064025503758764646700706390178233113358012923916190924536105521e5",".772077810546229452680977895353980652065055339002778693672336566785590480146899637927702698732334080602128839253147291523692850448614349170984449624206203852033005853e5"},
	{0UL,"-124145519261541/51422757785981","124145519261543/51422757785981",1024,"-.117809724509616961652859585623814624127830873470037737511757128177979237711723541267974488664660666223001712875939752906295884153774754808556825702501860187459732898151391005449876113602818951383856853611265898750586883737722345221227573081103628030857554670819463701027178498454418839885250054463078136799451126847875e1",".1178097245096175312318386681143158953956688444523282918811548716408676880106963558849644010516867188418775694661174456060322342603476484941077346228341985858204659796662670249398996699038165379644808713466045351682649759769542962221736400547370354536114534163016356794725067817495758311835160108577365462457749991254827e1"},
	{1UL,"-124145519261541/51422757785981","124145519261543/51422757785981",1024,"-.23561944901923392330571917124762924825566174694007547502351425635595847542344708253594897732932133244600342575187950581259176830754950961711365140500372037491946579630278201089975222720563790276771370722253179750117376747544469044245514616220725606171510934163892740205435699690883767977050010892615627359890225369575e1",".2356194490192350624636773362286317907913376889046565837623097432817353760213927117699288021033734376837551389322348912120644685206952969882154692456683971716409319593325340498797993398076330759289617426932090703365299519539085924443472801094740709072229068326032713589450135634991516623670320217154730924915499982509654e1"},
	{2UL,"-124145519261541/51422757785981","124145519261543/51422757785981",1024,"-.4712388980384678466114383424952584965113234938801509500470285127119169508468941650718979546586426648920068515037590116251835366150990192342273028100074407498389315926055640217995044544112758055354274144450635950023475349508893808849102923244145121234302186832778548041087139938176753595410002178523125471978045073915e1",".4712388980384701249273546724572635815826753778093131675246194865634707520427854235398576042067468753675102778644697824241289370413905939764309384913367943432818639186650680997595986796152661518579234853864181406730599039078171848886945602189481418144458136652065427178900271269983033247340640434309461849830999965019308e1"},
	{3UL,"-124145519261541/51422757785981","124145519261543/51422757785981",1024,"-.9424777960769356932228766849905169930226469877603019000940570254238339016937883301437959093172853297840137030075180232503670732301980384684546056200148814996778631852111280435990089088225516110708548288901271900046950699017787617698205846488290242468604373665557096082174279876353507190820004357046250943956090147829999e1",".9424777960769402498547093449145271631653507556186263350492389731269415040855708470797152084134937507350205557289395648482578740827811879528618769826735886865637278373301361995191973592305323037158469707728362813461198078156343697773891204378962836288916273304130854357800542539966066494681280868618923699661999930038615e1"},
	{4UL,"-124145519261541/51422757785981","124145519261543/51422757785981",1024,"-.1884955592153871386445753369981033986045293975520603800188114050847667803387576660287591818634570659568027406015036046500734146460396076936909211240029762999355726370422256087198017817645103222141709657780254380009390139803557523539641169297658048493720874733111419216434855975270701438164000871409250188791218029566e2",".1884955592153880499709418689829054326330701511237252670098477946253883008171141694159430416826987501470041111457879129696515748165562375905723753965347177373127455674660272399038394718461064607431693941545672562692239615631268739554778240875792567257783254660826170871560108507993213298936256173723784739932399986007723e2"},
	{16UL,"-124145519261541/51422757785981","124145519261543/51422757785981",1024,"-.7720778105462257198881805803442315206841524123732393165570515152272047322675514000537976089127201421590640255037587646467007063901782331133580129239161909245361055213249560933163080981074342797892442758267921940518462012635371616418370229443207366630280702906824373110517170074708793090719747569292288773288829049102335e5",".7720778105462294526809778953539806520650553390027786936723365667855904801468996379277026987323340806021288392531472915236928504486143491709844496242062038520330058443408475746461264766816520632040218384571074816787413465625676757216371674627246355487880211090743995889910204448740201672442905287572622294763110342687633e5"},
	{0UL,"-124145519261541/51422757785981","124145519261543/51422757785981",2048,"-.1178097245096169616528595856238146241278308734700377375117571281779792377117235412679744886646606662230017128759397529062958841537747548085568257025018601874597328981513910054498761136028189513838568536112658987505868837377223452212275730811036280308575546708194637010271784984544188398852500544630781367994511268478749102147063241715417624940081008884444969622805533582381974111164688256435031289649713815465922213225702387885770230416928642484103392638612214062052524727165413975693372694122001435014959576157666693351033730789578432957670280216245565922393876050386733198232062492786012904822767607047489898799346941053433625e1",".1178097245096175312318386681143158953956688444523282918811548716408676880106963558849644010516867188418775694661174456060322342603476484941077346228341985858204659796662670249398996699038165379644808713466045351682649759769542962221736400547370354536114534163016356794725067817495758311835160108577365462457749991254827254163196835725214966923834623450148147941110157090821988440055140842778867730530211745187570773842892160606969212620479376561963668562658027501708594626221044042807152039397420080675254528756722537822645134728780443292846966980205910589604535460598375500631571725266233360952112581727218585962251949172341647e1"},
	{1UL,"-124145519261541/51422757785981","124145519261543/51422757785981",2048,"-.235619449019233923305719171247629248255661746940075475023514256355958475423447082535948977329321332446003425751879505812591768307549509617113651405003720374919465796302782010899752227205637902767713707222531797501173767475444690442455146162207256061715109341638927402054356996908837679770500108926156273598902253695749820429412648343083524988016201776888993924561106716476394822232937651287006257929942763093184442645140477577154046083385728496820678527722442812410504945433082795138674538824400287002991915231533338670206746157915686591534056043249113184478775210077346639646412498557202580964553521409497979759869388210686725e1",".2356194490192350624636773362286317907913376889046565837623097432817353760213927117699288021033734376837551389322348912120644685206952969882154692456683971716409319593325340498797993398076330759289617426932090703365299519539085924443472801094740709072229068326032713589450135634991516623670320217154730924915499982509654508326393671450429933847669246900296295882220314181643976880110281685557735461060423490375141547685784321213938425240958753123927337125316055003417189252442088085614304078794840161350509057513445075645290269457560886585693933960411821179209070921196751001263143450532466721904225163454437171924503898344683294e1"},
	{2UL,"-124145519261541/51422757785981","124145519261543/51422757785981",2048,"-.47123889803846784661143834249525849651132349388015095004702851271191695084689416507189795465864266489200685150375901162518353661509901923422730281000744074983893159260556402179950445441127580553542741444506359500234753495088938088491029232441451212343021868327785480410871399381767535954100021785231254719780450739149964085882529668616704997603240355377798784912221343295278964446587530257401251585988552618636888529028095515430809216677145699364135705544488562482100989086616559027734907764880057400598383046306667734041349231583137318306811208649822636895755042015469327929282499711440516192910704281899595951973877642137345e1",".4712388980384701249273546724572635815826753778093131675246194865634707520427854235398576042067468753675102778644697824241289370413905939764309384913367943432818639186650680997595986796152661518579234853864181406730599039078171848886945602189481418144458136652065427178900271269983033247340640434309461849830999965019309016652787342900859867695338493800592591764440628363287953760220563371115470922120846980750283095371568642427876850481917506247854674250632110006834378504884176171228608157589680322701018115026890151290580538915121773171387867920823642358418141842393502002526286901064933443808450326908874343849007796689366587e1"},
	{3UL,"-124145519261541/51422757785981","124145519261543/51422757785981",2048,"-.9424777960769356932228766849905169930226469877603019000940570254238339016937883301437959093172853297840137030075180232503670732301980384684546056200148814996778631852111280435990089088225516110708548288901271900046950699017787617698205846488290242468604373665557096082174279876353507190820004357046250943956090147829992817176505933723340999520648071075559756982444268659055792889317506051480250317197710523727377705805619103086161843335429139872827141108897712496420197817323311805546981552976011480119676609261333546808269846316627463661362241729964527379151008403093865585856499942288103238582140856379919190394775528427469001e1",".9424777960769402498547093449145271631653507556186263350492389731269415040855708470797152084134937507350205557289395648482578740827811879528618769826735886865637278373301361995191973592305323037158469707728362813461198078156343697773891204378962836288916273304130854357800542539966066494681280868618923699661999930038618033305574685801719735390676987601185183528881256726575907520441126742230941844241693961500566190743137284855753700963835012495709348501264220013668757009768352342457216315179360645402036230053780302581161077830243546342775735841647284716836283684787004005052573802129866887616900653817748687698015593378733174e1"},
	{4UL,"-124145519261541/51422757785981","124145519261543/51422757785981",2048,"-.18849555921538713864457533699810339860452939755206038001881140508476678033875766602875918186345706595680274060150360465007341464603960769369092112400297629993557263704222560871980178176451032221417096577802543800093901398035575235396411692976580484937208747331114192164348559752707014381640008714092501887912180295659985634353011867446681999041296142151119513964888537318111585778635012102960500634395421047454755411611238206172323686670858279745654282217795424992840395634646623611093963105952022960239353218522667093616539692633254927322724483459929054758302016806187731171712999884576206477164281712759838380789551056854938e2",".1884955592153880499709418689829054326330701511237252670098477946253883008171141694159430416826987501470041111457879129696515748165562375905723753965347177373127455674660272399038394718461064607431693941545672562692239615631268739554778240875792567257783254660826170871560108507993213298936256173723784739932399986007723606661114937160343947078135397520237036705776251345315181504088225348446188368848338792300113238148627456971150740192767002499141869700252844002733751401953670468491443263035872129080407246010756060516232215566048709268555147168329456943367256736957400801010514760425973377523380130763549737539603118675746635e2"},
	{16UL,"-124145519261541/51422757785981","124145519261543/51422757785981",2048,"-.7720778105462257198881805803442315206841524123732393165570515152272047322675514000537976089127201421590640255037587646467007063901782331133580129239161909245361055213249560933163080981074342797892442758267921940518462012635371616418370229443207366630280702906824373110517170074708793090719747569292288773288829049102330115830993660906160946807314899825098552920018344885498505534928900957372621059848364461037467816595963169248183782060383551383819993996409006077067426051951257031104087288197948604514039078306884441545334658102581218231387948425186940829000506083814494687933644752722414173046489789546429800771400112887782605e5",".7720778105462294526809778953539806520650553390027786936723365667855904801468996379277026987323340806021288392531472915236928504486143491709844496242062038520330058443408475746461264766816520632040218384571074816787413465625676757216371674627246355487880211090743995889910204448740201672442905287572622294763110342687635892883926782608768807232042588242890902346859525510410983440745371027235587558802795693261263823456778063753833431829573642236485098292235649035197445742402234238940951605394932240713348079660056823874487154958535513164001882801477455640032283594577513680939068458704786954335765015607499724962214374095858216e5"},
	{0UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",10,"-.11780972450961e1","-.11780972450961e1"},
	{1UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",10,"-.23561944901921e1","-.23561944901921e1"},
	{2UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",10,"-.47123889803843e1","-.47123889803843e1"},
	{3UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",10,"-.94247779607686e1","-.94247779607686e1"},
	{4UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",10,"-.18849555921537e2","-.18849555921537e2"},
	{16UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",10,"-.77207781054616e5","-.77207781054616e5"},
	{0UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",24,"-.117809724509617531e1","-.117809724509616962e1"},
	{1UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",24,"-.235619449019235061e1","-.235619449019233923e1"},
	{2UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",24,"-.471238898038470122e1","-.471238898038467846e1"},
	{3UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",24,"-.942477796076940244e1","-.942477796076935692e1"},
	{4UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",24,"-.188495559215388049e2","-.188495559215387138e2"},
	{16UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",24,"-.772077810546229448e5","-.772077810546225719e5"},
	{0UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",53,"-.117809724509617531231838668e1","-.117809724509616961652859583e1"},
	{1UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",53,"-.235619449019235062463677336e1","-.235619449019233923305719167e1"},
	{2UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",53,"-.471238898038470124927354672e1","-.471238898038467846611438334e1"},
	{3UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",53,"-.942477796076940249854709343e1","-.942477796076935693222876667e1"},
	{4UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",53,"-.188495559215388049970941869e2","-.188495559215387138644575333e2"},
	{16UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",53,"-.772077810546229452680977894e5","-.772077810546225719888180566e5"},
	{0UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",113,"-.117809724509617531231838668114315895395668843e1","-.117809724509616961652859585623814624127830872e1"},
	{1UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",113,"-.235619449019235062463677336228631790791337686e1","-.235619449019233923305719171247629248255661744e1"},
	{2UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",113,"-.471238898038470124927354672457263581582675372e1","-.471238898038467846611438342495258496511323488e1"},
	{3UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",113,"-.942477796076940249854709344914527163165350744e1","-.942477796076935693222876684990516993022646977e1"},
	{4UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",113,"-.188495559215388049970941868982905432633070149e2","-.188495559215387138644575336998103398604529395e2"},
	{16UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",113,"-.77207781054622945268097789535398065206505533e5","-.772077810546225719888180580344231520684152404e5"},
	{0UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",256,"-.1178097245096175312318386681143158953956688444523282918811548716408676880106963558849646e1","-.1178097245096169616528595856238146241278308734700377375117571281779792377117235412679743e1"},
	{1UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",256,"-.2356194490192350624636773362286317907913376889046565837623097432817353760213927117699291e1","-.2356194490192339233057191712476292482556617469400754750235142563559584754234470825359486e1"},
	{2UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",256,"-.4712388980384701249273546724572635815826753778093131675246194865634707520427854235398583e1","-.4712388980384678466114383424952584965113234938801509500470285127119169508468941650718971e1"},
	{3UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",256,"-.9424777960769402498547093449145271631653507556186263350492389731269415040855708470797166e1","-.9424777960769356932228766849905169930226469877603019000940570254238339016937883301437943e1"},
	{4UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",256,"-.1884955592153880499709418689829054326330701511237252670098477946253883008171141694159433e2","-.1884955592153871386445753369981033986045293975520603800188114050847667803387576660287589e2"},
	{16UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",256,"-.7720778105462294526809778953539806520650553390027786936723365667855904801468996379277038e5","-.7720778105462257198881805803442315206841524123732393165570515152272047322675514000537963e5"},
	{0UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",512,"-.117809724509617531231838668114315895395668844452328291881154871640867688010696355884964401051686718841877569466117445606032234260347648494107734622834198585820465981e1","-.117809724509616961652859585623814624127830873470037737511757128177979237711723541267974488664660666223001712875939752906295884153774754808556825702501860187459732898e1"},
	{1UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",512,"-.235619449019235062463677336228631790791337688904656583762309743281735376021392711769928802103373437683755138932234891212064468520695296988215469245668397171640931962e1","-.235619449019233923305719171247629248255661746940075475023514256355958475423447082535948977329321332446003425751879505812591768307549509617113651405003720374919465796e1"},
	{2UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",512,"-.471238898038470124927354672457263581582675377809313167524619486563470752042785423539857604206746875367510277864469782424128937041390593976430938491336794343281863924e1","-.471238898038467846611438342495258496511323493880150950047028512711916950846894165071897954658642664892006851503759011625183536615099019234227302810007440749838931592e1"},
	{3UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",512,"-.942477796076940249854709344914527163165350755618626335049238973126941504085570847079715208413493750735020555728939564848257874082781187952861876982673588686563727847e1","-.942477796076935693222876684990516993022646987760301900094057025423833901693788330143795909317285329784013703007518023250367073230198038468454605620014881499677863184e1"},
	{4UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",512,"-.188495559215388049970941868982905432633070151123725267009847794625388300817114169415943041682698750147004111145787912969651574816556237590572375396534717737312745569e2","-.188495559215387138644575336998103398604529397552060380018811405084766780338757666028759181863457065956802740601503604650073414646039607693690921124002976299935572637e2"},
	{16UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",512,"-.772077810546229452680977895353980652065055339002778693672336566785590480146899637927702698732334080602128839253147291523692850448614349170984449624206203852033005853e5","-.772077810546225719888180580344231520684152412373239316557051515227204732267551400053797608912720142159064025503758764646700706390178233113358012923916190924536105521e5"},
	{0UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",1024,"-.1178097245096175312318386681143158953956688444523282918811548716408676880106963558849644010516867188418775694661174456060322342603476484941077346228341985858204659796662670249398996699038165379644808713466045351682649759769542962221736400547370354536114534163016356794725067817495758311835160108577365462457749991254827e1","-.117809724509616961652859585623814624127830873470037737511757128177979237711723541267974488664660666223001712875939752906295884153774754808556825702501860187459732898151391005449876113602818951383856853611265898750586883737722345221227573081103628030857554670819463701027178498454418839885250054463078136799451126847875e1"},
	{1UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",1024,"-.2356194490192350624636773362286317907913376889046565837623097432817353760213927117699288021033734376837551389322348912120644685206952969882154692456683971716409319593325340498797993398076330759289617426932090703365299519539085924443472801094740709072229068326032713589450135634991516623670320217154730924915499982509654e1","-.23561944901923392330571917124762924825566174694007547502351425635595847542344708253594897732932133244600342575187950581259176830754950961711365140500372037491946579630278201089975222720563790276771370722253179750117376747544469044245514616220725606171510934163892740205435699690883767977050010892615627359890225369575e1"},
	{2UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",1024,"-.4712388980384701249273546724572635815826753778093131675246194865634707520427854235398576042067468753675102778644697824241289370413905939764309384913367943432818639186650680997595986796152661518579234853864181406730599039078171848886945602189481418144458136652065427178900271269983033247340640434309461849830999965019308e1","-.4712388980384678466114383424952584965113234938801509500470285127119169508468941650718979546586426648920068515037590116251835366150990192342273028100074407498389315926055640217995044544112758055354274144450635950023475349508893808849102923244145121234302186832778548041087139938176753595410002178523125471978045073915e1"},
	{3UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",1024,"-.9424777960769402498547093449145271631653507556186263350492389731269415040855708470797152084134937507350205557289395648482578740827811879528618769826735886865637278373301361995191973592305323037158469707728362813461198078156343697773891204378962836288916273304130854357800542539966066494681280868618923699661999930038615e1","-.9424777960769356932228766849905169930226469877603019000940570254238339016937883301437959093172853297840137030075180232503670732301980384684546056200148814996778631852111280435990089088225516110708548288901271900046950699017787617698205846488290242468604373665557096082174279876353507190820004357046250943956090147829999e1"},
	{4UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",1024,"-.1884955592153880499709418689829054326330701511237252670098477946253883008171141694159430416826987501470041111457879129696515748165562375905723753965347177373127455674660272399038394718461064607431693941545672562692239615631268739554778240875792567257783254660826170871560108507993213298936256173723784739932399986007723e2","-.1884955592153871386445753369981033986045293975520603800188114050847667803387576660287591818634570659568027406015036046500734146460396076936909211240029762999355726370422256087198017817645103222141709657780254380009390139803557523539641169297658048493720874733111419216434855975270701438164000871409250188791218029566e2"},
	{16UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",1024,"-.7720778105462294526809778953539806520650553390027786936723365667855904801468996379277026987323340806021288392531472915236928504486143491709844496242062038520330058443408475746461264766816520632040218384571074816787413465625676757216371674627246355487880211090743995889910204448740201672442905287572622294763110342687633e5","-.7720778105462257198881805803442315206841524123732393165570515152272047322675514000537976089127201421590640255037587646467007063901782331133580129239161909245361055213249560933163080981074342797892442758267921940518462012635371616418370229443207366630280702906824373110517170074708793090719747569292288773288829049102335e5"},
	{0UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",2048,"-.1178097245096175312318386681143158953956688444523282918811548716408676880106963558849644010516867188418775694661174456060322342603476484941077346228341985858204659796662670249398996699038165379644808713466045351682649759769542962221736400547370354536114534163016356794725067817495758311835160108577365462457749991254827254163196835725214966923834623450148147941110157090821988440055140842778867730530211745187570773842892160606969212620479376561963668562658027501708594626221044042807152039397420080675254528756722537822645134728780443292846966980205910589604535460598375500631571725266233360952112581727218585962251949172341647e1","-.1178097245096169616528595856238146241278308734700377375117571281779792377117235412679744886646606662230017128759397529062958841537747548085568257025018601874597328981513910054498761136028189513838568536112658987505868837377223452212275730811036280308575546708194637010271784984544188398852500544630781367994511268478749102147063241715417624940081008884444969622805533582381974111164688256435031289649713815465922213225702387885770230416928642484103392638612214062052524727165413975693372694122001435014959576157666693351033730789578432957670280216245565922393876050386733198232062492786012904822767607047489898799346941053433625e1"},
	{1UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",2048,"-.2356194490192350624636773362286317907913376889046565837623097432817353760213927117699288021033734376837551389322348912120644685206952969882154692456683971716409319593325340498797993398076330759289617426932090703365299519539085924443472801094740709072229068326032713589450135634991516623670320217154730924915499982509654508326393671450429933847669246900296295882220314181643976880110281685557735461060423490375141547685784321213938425240958753123927337125316055003417189252442088085614304078794840161350509057513445075645290269457560886585693933960411821179209070921196751001263143450532466721904225163454437171924503898344683294e1","-.235619449019233923305719171247629248255661746940075475023514256355958475423447082535948977329321332446003425751879505812591768307549509617113651405003720374919465796302782010899752227205637902767713707222531797501173767475444690442455146162207256061715109341638927402054356996908837679770500108926156273598902253695749820429412648343083524988016201776888993924561106716476394822232937651287006257929942763093184442645140477577154046083385728496820678527722442812410504945433082795138674538824400287002991915231533338670206746157915686591534056043249113184478775210077346639646412498557202580964553521409497979759869388210686725e1"},
	{2UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",2048,"-.4712388980384701249273546724572635815826753778093131675246194865634707520427854235398576042067468753675102778644697824241289370413905939764309384913367943432818639186650680997595986796152661518579234853864181406730599039078171848886945602189481418144458136652065427178900271269983033247340640434309461849830999965019309016652787342900859867695338493800592591764440628363287953760220563371115470922120846980750283095371568642427876850481917506247854674250632110006834378504884176171228608157589680322701018115026890151290580538915121773171387867920823642358418141842393502002526286901064933443808450326908874343849007796689366587e1","-.47123889803846784661143834249525849651132349388015095004702851271191695084689416507189795465864266489200685150375901162518353661509901923422730281000744074983893159260556402179950445441127580553542741444506359500234753495088938088491029232441451212343021868327785480410871399381767535954100021785231254719780450739149964085882529668616704997603240355377798784912221343295278964446587530257401251585988552618636888529028095515430809216677145699364135705544488562482100989086616559027734907764880057400598383046306667734041349231583137318306811208649822636895755042015469327929282499711440516192910704281899595951973877642137345e1"},
	{3UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",2048,"-.9424777960769402498547093449145271631653507556186263350492389731269415040855708470797152084134937507350205557289395648482578740827811879528618769826735886865637278373301361995191973592305323037158469707728362813461198078156343697773891204378962836288916273304130854357800542539966066494681280868618923699661999930038618033305574685801719735390676987601185183528881256726575907520441126742230941844241693961500566190743137284855753700963835012495709348501264220013668757009768352342457216315179360645402036230053780302581161077830243546342775735841647284716836283684787004005052573802129866887616900653817748687698015593378733174e1","-.9424777960769356932228766849905169930226469877603019000940570254238339016937883301437959093172853297840137030075180232503670732301980384684546056200148814996778631852111280435990089088225516110708548288901271900046950699017787617698205846488290242468604373665557096082174279876353507190820004357046250943956090147829992817176505933723340999520648071075559756982444268659055792889317506051480250317197710523727377705805619103086161843335429139872827141108897712496420197817323311805546981552976011480119676609261333546808269846316627463661362241729964527379151008403093865585856499942288103238582140856379919190394775528427469001e1"},
	{4UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",2048,"-.1884955592153880499709418689829054326330701511237252670098477946253883008171141694159430416826987501470041111457879129696515748165562375905723753965347177373127455674660272399038394718461064607431693941545672562692239615631268739554778240875792567257783254660826170871560108507993213298936256173723784739932399986007723606661114937160343947078135397520237036705776251345315181504088225348446188368848338792300113238148627456971150740192767002499141869700252844002733751401953670468491443263035872129080407246010756060516232215566048709268555147168329456943367256736957400801010514760425973377523380130763549737539603118675746635e2","-.18849555921538713864457533699810339860452939755206038001881140508476678033875766602875918186345706595680274060150360465007341464603960769369092112400297629993557263704222560871980178176451032221417096577802543800093901398035575235396411692976580484937208747331114192164348559752707014381640008714092501887912180295659985634353011867446681999041296142151119513964888537318111585778635012102960500634395421047454755411611238206172323686670858279745654282217795424992840395634646623611093963105952022960239353218522667093616539692633254927322724483459929054758302016806187731171712999884576206477164281712759838380789551056854938e2"},
	{16UL,"-124145519261543/51422757785981","-124145519261541/51422757785981",2048,"-.7720778105462294526809778953539806520650553390027786936723365667855904801468996379277026987323340806021288392531472915236928504486143491709844496242062038520330058443408475746461264766816520632040218384571074816787413465625676757216371674627246355487880211090743995889910204448740201672442905287572622294763110342687635892883926782608768807232042588242890902346859525510410983440745371027235587558802795693261263823456778063753833431829573642236485098292235649035197445742402234238940951605394932240713348079660056823874487154958535513164001882801477455640032283594577513680939068458704786954335765015607499724962214374095858216e5","-.7720778105462257198881805803442315206841524123732393165570515152272047322675514000537976089127201421590640255037587646467007063901782331133580129239161909245361055213249560933163080981074342797892442758267921940518462012635371616418370229443207366630280702906824373110517170074708793090719747569292288773288829049102330115830993660906160946807314899825098552920018344885498505534928900957372621059848364461037467816595963169248183782060383551383819993996409006077067426051951257031104087288197948604514039078306884441545334658102581218231387948425186940829000506083814494687933644752722414173046489789546429800771400112887782605e5"},
	{0UL,"494124578282428/98287489646633","494124578282429/98287489646633",10,".13744467859456e1",".13744467859456e1"},
	{1UL,"494124578282428/98287489646633","494124578282429/98287489646633",10,".27488935718911e1",".27488935718911e1"},
	{2UL,"494124578282428/98287489646633","494124578282429/98287489646633",10,".54977871437823e1",".54977871437823e1"},
	{3UL,"494124578282428/98287489646633","494124578282429/98287489646633",10,".10995574287565e2",".10995574287565e2"},
	{4UL,"494124578282428/98287489646633","494124578282429/98287489646633",10,".21991148575129e2",".21991148575129e2"},
	{16UL,"494124578282428/98287489646633","494124578282429/98287489646633",10,".90075744563729e5",".90075744563729e5"},
	{0UL,"494124578282428/98287489646633","494124578282429/98287489646633",24,".137444678594553435e1",".137444678594553474e1"},
	{1UL,"494124578282428/98287489646633","494124578282429/98287489646633",24,".27488935718910687e1",".274889357189106948e1"},
	{2UL,"494124578282428/98287489646633","494124578282429/98287489646633",24,".54977871437821374e1",".549778714378213895e1"},
	{3UL,"494124578282428/98287489646633","494124578282429/98287489646633",24,".109955742875642748e2",".109955742875642779e2"},
	{4UL,"494124578282428/98287489646633","494124578282429/98287489646633",24,".219911485751285496e2",".219911485751285558e2"},
	{16UL,"494124578282428/98287489646633","494124578282429/98287489646633",24,".900757445637265391e5",".900757445637265646e5"},
	{0UL,"494124578282428/98287489646633","494124578282429/98287489646633",53,".137444678594553434821052869e1",".137444678594553473544428429e1"},
	{1UL,"494124578282428/98287489646633","494124578282429/98287489646633",53,".274889357189106869642105738e1",".274889357189106947088856859e1"},
	{2UL,"494124578282428/98287489646633","494124578282429/98287489646633",53,".549778714378213739284211476e1",".549778714378213894177713717e1"},
	{3UL,"494124578282428/98287489646633","494124578282429/98287489646633",53,".109955742875642747856842295e2",".109955742875642778835542743e2"},
	{4UL,"494124578282428/98287489646633","494124578282429/98287489646633",53,".21991148575128549571368459e2",".219911485751285557671085487e2"},
	{16UL,"494124578282428/98287489646633","494124578282429/98287489646633",53,".900757445637265390443252082e5",".900757445637265644220766154e5"},
	{0UL,"494124578282428/98287489646633","494124578282429/98287489646633",113,".137444678594553434821052868021126889476996939e1",".137444678594553473544428428015844885627819837e1"},
	{1UL,"494124578282428/98287489646633","494124578282429/98287489646633",113,".274889357189106869642105736042253778953993877e1",".274889357189106947088856856031689771255639673e1"},
	{2UL,"494124578282428/98287489646633","494124578282429/98287489646633",113,".549778714378213739284211472084507557907987755e1",".549778714378213894177713712063379542511279347e1"},
	{3UL,"494124578282428/98287489646633","494124578282429/98287489646633",113,".109955742875642747856842294416901511581597551e2",".109955742875642778835542742412675908502255869e2"},
	{4UL,"494124578282428/98287489646633","494124578282429/98287489646633",113,".219911485751285495713684588833803023163195102e2",".219911485751285557671085484825351817004511739e2"},
	{16UL,"494124578282428/98287489646633","494124578282429/98287489646633",113,".900757445637265390443252075863257182876447137e5",".900757445637265644220766145844641042450480082e5"},
	{0UL,"494124578282428/98287489646633","494124578282429/98287489646633",256,".1374446785945534348210528680211268894769969382223417946455609036855835528059503874527435e1",".1374446785945534735444284280158448856278198384697441056960540293214538523831852164439919e1"},
	{1UL,"494124578282428/98287489646633","494124578282429/98287489646633",256,".2748893571891068696421057360422537789539938764446835892911218073711671056119007749054869e1",".2748893571891069470888568560316897712556396769394882113921080586429077047663704328879839e1"},
	{2UL,"494124578282428/98287489646633","494124578282429/98287489646633",256,".5497787143782137392842114720845075579079877528893671785822436147423342112238015498109739e1",".5497787143782138941777137120633795425112793538789764227842161172858154095327408657759678e1"},
	{3UL,"494124578282428/98287489646633","494124578282429/98287489646633",256,".1099557428756427478568422944169015115815975505778734357164487229484668422447603099621948e2",".1099557428756427788355427424126759085022558707757952845568432234571630819065481731551936e2"},
	{4UL,"494124578282428/98287489646633","494124578282429/98287489646633",256,".2199114857512854957136845888338030231631951011557468714328974458969336844895206199243896e2",".2199114857512855576710854848253518170045117415515905691136864469143261638130963463103871e2"},
	{16UL,"494124578282428/98287489646633","494124578282429/98287489646633",256,".9007574456372653904432520758632571828764471343339391853891479383938403716690764592102996e5",".9007574456372656442207661458446410424504800933953149710896596865610799669784426344873456e5"},
	{0UL,"494124578282428/98287489646633","494124578282429/98287489646633",512,".137444678594553434821052868021126889476996938222341794645560903685583552805950387452743523133959473513619115353030182065823892347928440697702323546338816963266484054e1",".137444678594553473544428428015844885627819838469744105696054029321453852383185216443992107330074995349130650282828373586242529722704894327524501655468894792072355498e1"},
	{1UL,"494124578282428/98287489646633","494124578282429/98287489646633",512,".274889357189106869642105736042253778953993876444683589291121807371167105611900774905487046267918947027238230706060364131647784695856881395404647092677633926532968109e1",".274889357189106947088856856031689771255639676939488211392108058642907704766370432887984214660149990698261300565656747172485059445409788655049003310937789584144710996e1"},
	{2UL,"494124578282428/98287489646633","494124578282429/98287489646633",512,".549778714378213739284211472084507557907987752889367178582243614742334211223801549810974092535837894054476461412120728263295569391713762790809294185355267853065936218e1",".549778714378213894177713712063379542511279353878976422784216117285815409532740865775968429320299981396522601131313494344970118890819577310098006621875579168289421992e1"},
	{3UL,"494124578282428/98287489646633","494124578282429/98287489646633",512,".109955742875642747856842294416901511581597550577873435716448722948466842244760309962194818507167578810895292282424145652659113878342752558161858837071053570613187244e2",".109955742875642778835542742412675908502255870775795284556843223457163081906548173155193685864059996279304520226262698868994023778163915462019601324375115833657884398e2"},
	{4UL,"494124578282428/98287489646633","494124578282429/98287489646633",512,".219911485751285495713684588833803023163195101155746871432897445896933684489520619924389637014335157621790584564848291305318227756685505116323717674142107141226374487e2",".219911485751285557671085484825351817004511741551590569113686446914326163813096346310387371728119992558609040452525397737988047556327830924039202648750231667315768797e2"},
	{16UL,"494124578282428/98287489646633","494124578282429/98287489646633",512,".9007574456372653904432520758632571828764471343339391853891479383938403716690764592102999532107168056188542343776186011865834608913838289564619475932860708504632299e5",".900757445637265644220766145844641042450480093395314971089659686561079966978442634487346674598379489520062629693544029134799042790718795464864574049280948909325388991e5"},
	{0UL,"494124578282428/98287489646633","494124578282429/98287489646633",1024,".1374446785945534348210528680211268894769969382223417946455609036855835528059503874527435231339594735136191153530301820658238923479284406977023235463388169632664840543885436816562132974121536367376075988408234475630208896797015599627151348925186970913657107879442359007158701930163567835304926526840638948451877260877508e1",".137444678594553473544428428015844885627819838469744105696054029321453852383185216443992107330074995349130650282828373586242529722704894327524501655468894792072355497676622760355611483225692465029181968494797630951484524855587542383381375001483028956964409362308551985070050712384524035341367495986602622708537435018624e1"},
	{1UL,"494124578282428/98287489646633","494124578282429/98287489646633",1024,".2748893571891068696421057360422537789539938764446835892911218073711671056119007749054870462679189470272382307060603641316477846958568813954046470926776339265329681087770873633124265948243072734752151976816468951260417793594031199254302697850373941827314215758884718014317403860327135670609853053681277896903754521755016e1",".2748893571891069470888568560316897712556396769394882113921080586429077047663704328879842146601499906982613005656567471724850594454097886550490033109377895841447109953532455207112229664513849300583639369895952619029690497111750847667627500029660579139288187246171039701401014247690480706827349919732052454170748700372481e1"},
	{2UL,"494124578282428/98287489646633","494124578282429/98287489646633",1024,".5497787143782137392842114720845075579079877528893671785822436147423342112238015498109740925358378940544764614121207282632955693917137627908092941853552678530659362175541747266248531896486145469504303953632937902520835587188062398508605395700747883654628431517769436028634807720654271341219706107362555793807509043510032e1",".5497787143782138941777137120633795425112793538789764227842161172858154095327408657759684293202999813965226011313134943449701188908195773100980066218755791682894219907064910414224459329027698601167278739791905238059380994223501695335255000059321158278576374492342079402802028495380961413654699839464104908341497400744962e1"},
	{3UL,"494124578282428/98287489646633","494124578282429/98287489646633",1024,".1099557428756427478568422944169015115815975505778734357164487229484668422447603099621948185071675788108952922824241456526591138783427525581618588370710535706131872435108349453249706379297229093900860790726587580504167117437612479701721079140149576730925686303553887205726961544130854268243941221472511158761501808702006e2",".1099557428756427788355427424126759085022558707757952845568432234571630819065481731551936858640599962793045202262626988689940237781639154620196013243751158336578843981412982082844891865805539720233455747958381047611876198844700339067051000011864231655715274898468415880560405699076192282730939967892820981668299480148992e2"},
	{4UL,"494124578282428/98287489646633","494124578282429/98287489646633",1024,".2199114857512854957136845888338030231631951011557468714328974458969336844895206199243896370143351576217905845648482913053182277566855051163237176741421071412263744870216698906499412758594458187801721581453175161008334234875224959403442158280299153461851372607107774411453923088261708536487882442945022317523003617404013e2",".2199114857512855576710854848253518170045117415515905691136864469143261638130963463103873717281199925586090404525253977379880475563278309240392026487502316673157687962825964165689783731611079440466911495916762095223752397689400678134102000023728463311430549796936831761120811398152384565461879935785641963336598960297985e2"},
	{16UL,"494124578282428/98287489646633","494124578282429/98287489646633",1024,".9007574456372653904432520758632571828764471343339391853891479383938403716690764592102999532107168056188542343776186011865834608913838289564619475932860708504632298988407598721021594659202900737235851597632205459490137026048921433716499080316105332579743222198713443989315268969519958165454366486302811412574222816886836e5",".9007574456372656442207661458446410424504800933953149710896596865610799669784426344873466745983794895200626296935440291347990427907187954648645740492809489093253889895735149222665354164678981388152469487275057542036489820935785177637281792097191785723619531968253262893550843486832167180131860216977989481826709341380546e5"},
	{0UL,"494124578282428/98287489646633","494124578282429/98287489646633",2048,".1374446785945534348210528680211268894769969382223417946455609036855835528059503874527435231339594735136191153530301820658238923479284406977023235463388169632664840543885436816562132974121536367376075988408234475630208896797015599627151348925186970913657107879442359007158701930163567835304926526840638948451877260877508308252854104395753123117151708582736183842920632002677983859346149446033338961703349878067204202393842307758856094065293884893301758419227322177506461159093443502017310336249361164219951225562238218655290961007527558887054783055751102493315888352200928728681781785805255330608986090932171409851590304580097825e1",".1374446785945534735444284280158448856278198384697441056960540293214538523831852164439921073300749953491306502828283735862425297227048943275245016554688947920723554976766227603556114832256924650291819684947976309514845248555875423833813750014830289569644093623085519850700507123845240353413674959866026227085374350186241273729531396537696129296906160021896137964593728646561697883998780051303961950969650713771505298512685635382246899237710229133225941022102984024215424188351861012166789643281318255109788243191012423576331214580153324540124260226770416858513450427637520122646779886685519221705795827395415228501849848585373328e1"},
	{1UL,"494124578282428/98287489646633","494124578282429/98287489646633",2048,".2748893571891068696421057360422537789539938764446835892911218073711671056119007749054870462679189470272382307060603641316477846958568813954046470926776339265329681087770873633124265948243072734752151976816468951260417793594031199254302697850373941827314215758884718014317403860327135670609853053681277896903754521755016616505708208791506246234303417165472367685841264005355967718692298892066677923406699756134408404787684615517712188130587769786603516838454644355012922318186887004034620672498722328439902451124476437310581922015055117774109566111502204986631776704401857457363563571610510661217972181864342819703180609160195649e1",".2748893571891069470888568560316897712556396769394882113921080586429077047663704328879842146601499906982613005656567471724850594454097886550490033109377895841447109953532455207112229664513849300583639369895952619029690497111750847667627500029660579139288187246171039701401014247690480706827349919732052454170748700372482547459062793075392258593812320043792275929187457293123395767997560102607923901939301427543010597025371270764493798475420458266451882044205968048430848376703722024333579286562636510219576486382024847152662429160306649080248520453540833717026900855275040245293559773371038443411591654790830457003699697170746656e1"},
	{2UL,"494124578282428/98287489646633","494124578282429/98287489646633",2048,".5497787143782137392842114720845075579079877528893671785822436147423342112238015498109740925358378940544764614121207282632955693917137627908092941853552678530659362175541747266248531896486145469504303953632937902520835587188062398508605395700747883654628431517769436028634807720654271341219706107362555793807509043510033233011416417583012492468606834330944735371682528010711935437384597784133355846813399512268816809575369231035424376261175539573207033676909288710025844636373774008069241344997444656879804902248952874621163844030110235548219132223004409973263553408803714914727127143221021322435944363728685639406361218320391299e1",".5497787143782138941777137120633795425112793538789764227842161172858154095327408657759684293202999813965226011313134943449701188908195773100980066218755791682894219907064910414224459329027698601167278739791905238059380994223501695335255000059321158278576374492342079402802028495380961413654699839464104908341497400744965094918125586150784517187624640087584551858374914586246791535995120205215847803878602855086021194050742541528987596950840916532903764088411936096861696753407444048667158573125273020439152972764049694305324858320613298160497040907081667434053801710550080490587119546742076886823183309581660914007399394341493312e1"},
	{3UL,"494124578282428/98287489646633","494124578282429/98287489646633",2048,".109955742875642747856842294416901511581597550577873435716448722948466842244760309962194818507167578810895292282424145652659113878342752558161858837071053570613187243510834945324970637929722909390086079072658758050416711743761247970172107914014957673092568630355388720572696154413085426824394122147251115876150180870200664660228328351660249849372136686618894707433650560214238708747691955682667116936267990245376336191507384620708487525223510791464140673538185774200516892727475480161384826899948893137596098044979057492423276880602204710964382644460088199465271068176074298294542542864420426448718887274573712788127224366407826e2",".1099557428756427788355427424126759085022558707757952845568432234571630819065481731551936858640599962793045202262626988689940237781639154620196013243751158336578843981412982082844891865805539720233455747958381047611876198844700339067051000011864231655715274898468415880560405699076192282730939967892820981668299480148993018983625117230156903437524928017516910371674982917249358307199024041043169560775720571017204238810148508305797519390168183306580752817682387219372339350681488809733431714625054604087830594552809938861064971664122659632099408181416333486810760342110016098117423909348415377364636661916332182801479878868298662e2"},
	{4UL,"494124578282428/98287489646633","494124578282429/98287489646633",2048,".2199114857512854957136845888338030231631951011557468714328974458969336844895206199243896370143351576217905845648482913053182277566855051163237176741421071412263744870216698906499412758594458187801721581453175161008334234875224959403442158280299153461851372607107774411453923088261708536487882442945022317523003617404013293204566567033204996987442733732377894148673011204284774174953839113653342338725359804907526723830147692414169750504470215829282813470763715484010337854549509603227696537998977862751921960899581149848465537612044094219287652889201763989305421363521485965890850857288408528974377745491474255762544487328156519e2",".2199114857512855576710854848253518170045117415515905691136864469143261638130963463103873717281199925586090404525253977379880475563278309240392026487502316673157687962825964165689783731611079440466911495916762095223752397689400678134102000023728463311430549796936831761120811398152384565461879935785641963336598960297986037967250234460313806875049856035033820743349965834498716614398048082086339121551441142034408477620297016611595038780336366613161505635364774438744678701362977619466863429250109208175661189105619877722129943328245319264198816362832666973621520684220032196234847818696830754729273323832664365602959757736597325e2"},
	{16UL,"494124578282428/98287489646633","494124578282429/98287489646633",2048,".9007574456372653904432520758632571828764471343339391853891479383938403716690764592102999532107168056188542343776186011865834608913838289564619475932860708504632298988407598721021594659202900737235851597632205459490137026048921433716499080316105332579743222198713443989315268969519958165454366486302811412574222816886838448965904658568007667660565437367819854432964653892750435020610925009524090219419073760901229460808284948128439298066310004036742403976248178622506343852234791334820645019643813325831872351844684389779314842058932609922202226234170425300195005904984006516288925111453321334679051245533078551603382220096129104e5",".9007574456372656442207661458446410424504800933953149710896596865610799669784426344873466745983794895200626296935440291347990427907187954648645740492809489093253889895735149222665354164678981388152469487275057542036489820935785177637281792097191785723619531968253262893550843486832167180131860216977989481826709341380550811513856960349445352960204210319498529764761460058106743252574404944225645041874702917772937124332736580041093278844257757647509527082454116101098203960782756329336272606208447316687508230576619019149844247872492827706158351822162603923953748722565251875777936665382218771371103534418593241509723167689102642e5"},
	{0UL,"-494124578282428/98287489646633","494124578282429/98287489646633",10,"-.13744467859456e1",".13744467859456e1"},
	{1UL,"-494124578282428/98287489646633","494124578282429/98287489646633",10,"-.27488935718911e1",".27488935718911e1"},
	{2UL,"-494124578282428/98287489646633","494124578282429/98287489646633",10,"-.54977871437823e1",".54977871437823e1"},
	{3UL,"-494124578282428/98287489646633","494124578282429/98287489646633",10,"-.10995574287565e2",".10995574287565e2"},
	{4UL,"-494124578282428/98287489646633","494124578282429/98287489646633",10,"-.21991148575129e2",".21991148575129e2"},
	{16UL,"-494124578282428/98287489646633","494124578282429/98287489646633",10,"-.90075744563729e5",".90075744563729e5"},
	{0UL,"-494124578282428/98287489646633","494124578282429/98287489646633",24,"-.137444678594553435e1",".137444678594553474e1"},
	{1UL,"-494124578282428/98287489646633","494124578282429/98287489646633",24,"-.27488935718910687e1",".274889357189106948e1"},
	{2UL,"-494124578282428/98287489646633","494124578282429/98287489646633",24,"-.54977871437821374e1",".549778714378213895e1"},
	{3UL,"-494124578282428/98287489646633","494124578282429/98287489646633",24,"-.109955742875642748e2",".109955742875642779e2"},
	{4UL,"-494124578282428/98287489646633","494124578282429/98287489646633",24,"-.219911485751285496e2",".219911485751285558e2"},
	{16UL,"-494124578282428/98287489646633","494124578282429/98287489646633",24,"-.900757445637265391e5",".900757445637265646e5"},
	{0UL,"-494124578282428/98287489646633","494124578282429/98287489646633",53,"-.137444678594553434821052869e1",".137444678594553473544428429e1"},
	{1UL,"-494124578282428/98287489646633","494124578282429/98287489646633",53,"-.274889357189106869642105738e1",".274889357189106947088856859e1"},
	{2UL,"-494124578282428/98287489646633","494124578282429/98287489646633",53,"-.549778714378213739284211476e1",".549778714378213894177713717e1"},
	{3UL,"-494124578282428/98287489646633","494124578282429/98287489646633",53,"-.109955742875642747856842295e2",".109955742875642778835542743e2"},
	{4UL,"-494124578282428/98287489646633","494124578282429/98287489646633",53,"-.21991148575128549571368459e2",".219911485751285557671085487e2"},
	{16UL,"-494124578282428/98287489646633","494124578282429/98287489646633",53,"-.900757445637265390443252082e5",".900757445637265644220766154e5"},
	{0UL,"-494124578282428/98287489646633","494124578282429/98287489646633",113,"-.137444678594553434821052868021126889476996939e1",".137444678594553473544428428015844885627819837e1"},
	{1UL,"-494124578282428/98287489646633","494124578282429/98287489646633",113,"-.274889357189106869642105736042253778953993877e1",".274889357189106947088856856031689771255639673e1"},
	{2UL,"-494124578282428/98287489646633","494124578282429/98287489646633",113,"-.549778714378213739284211472084507557907987755e1",".549778714378213894177713712063379542511279347e1"},
	{3UL,"-494124578282428/98287489646633","494124578282429/98287489646633",113,"-.109955742875642747856842294416901511581597551e2",".109955742875642778835542742412675908502255869e2"},
	{4UL,"-494124578282428/98287489646633","494124578282429/98287489646633",113,"-.219911485751285495713684588833803023163195102e2",".219911485751285557671085484825351817004511739e2"},
	{16UL,"-494124578282428/98287489646633","494124578282429/98287489646633",113,"-.900757445637265390443252075863257182876447137e5",".900757445637265644220766145844641042450480082e5"},
	{0UL,"-494124578282428/98287489646633","494124578282429/98287489646633",256,"-.1374446785945534348210528680211268894769969382223417946455609036855835528059503874527435e1",".1374446785945534735444284280158448856278198384697441056960540293214538523831852164439919e1"},
	{1UL,"-494124578282428/98287489646633","494124578282429/98287489646633",256,"-.2748893571891068696421057360422537789539938764446835892911218073711671056119007749054869e1",".2748893571891069470888568560316897712556396769394882113921080586429077047663704328879839e1"},
	{2UL,"-494124578282428/98287489646633","494124578282429/98287489646633",256,"-.5497787143782137392842114720845075579079877528893671785822436147423342112238015498109739e1",".5497787143782138941777137120633795425112793538789764227842161172858154095327408657759678e1"},
	{3UL,"-494124578282428/98287489646633","494124578282429/98287489646633",256,"-.1099557428756427478568422944169015115815975505778734357164487229484668422447603099621948e2",".1099557428756427788355427424126759085022558707757952845568432234571630819065481731551936e2"},
	{4UL,"-494124578282428/98287489646633","494124578282429/98287489646633",256,"-.2199114857512854957136845888338030231631951011557468714328974458969336844895206199243896e2",".2199114857512855576710854848253518170045117415515905691136864469143261638130963463103871e2"},
	{16UL,"-494124578282428/98287489646633","494124578282429/98287489646633",256,"-.9007574456372653904432520758632571828764471343339391853891479383938403716690764592102996e5",".9007574456372656442207661458446410424504800933953149710896596865610799669784426344873456e5"},
	{0UL,"-494124578282428/98287489646633","494124578282429/98287489646633",512,"-.137444678594553434821052868021126889476996938222341794645560903685583552805950387452743523133959473513619115353030182065823892347928440697702323546338816963266484054e1",".137444678594553473544428428015844885627819838469744105696054029321453852383185216443992107330074995349130650282828373586242529722704894327524501655468894792072355498e1"},
	{1UL,"-494124578282428/98287489646633","494124578282429/98287489646633",512,"-.274889357189106869642105736042253778953993876444683589291121807371167105611900774905487046267918947027238230706060364131647784695856881395404647092677633926532968109e1",".274889357189106947088856856031689771255639676939488211392108058642907704766370432887984214660149990698261300565656747172485059445409788655049003310937789584144710996e1"},
	{2UL,"-494124578282428/98287489646633","494124578282429/98287489646633",512,"-.549778714378213739284211472084507557907987752889367178582243614742334211223801549810974092535837894054476461412120728263295569391713762790809294185355267853065936218e1",".549778714378213894177713712063379542511279353878976422784216117285815409532740865775968429320299981396522601131313494344970118890819577310098006621875579168289421992e1"},
	{3UL,"-494124578282428/98287489646633","494124578282429/98287489646633",512,"-.109955742875642747856842294416901511581597550577873435716448722948466842244760309962194818507167578810895292282424145652659113878342752558161858837071053570613187244e2",".109955742875642778835542742412675908502255870775795284556843223457163081906548173155193685864059996279304520226262698868994023778163915462019601324375115833657884398e2"},
	{4UL,"-494124578282428/98287489646633","494124578282429/98287489646633",512,"-.219911485751285495713684588833803023163195101155746871432897445896933684489520619924389637014335157621790584564848291305318227756685505116323717674142107141226374487e2",".219911485751285557671085484825351817004511741551590569113686446914326163813096346310387371728119992558609040452525397737988047556327830924039202648750231667315768797e2"},
	{16UL,"-494124578282428/98287489646633","494124578282429/98287489646633",512,"-.9007574456372653904432520758632571828764471343339391853891479383938403716690764592102999532107168056188542343776186011865834608913838289564619475932860708504632299e5",".900757445637265644220766145844641042450480093395314971089659686561079966978442634487346674598379489520062629693544029134799042790718795464864574049280948909325388991e5"},
	{0UL,"-494124578282428/98287489646633","494124578282429/98287489646633",1024,"-.1374446785945534348210528680211268894769969382223417946455609036855835528059503874527435231339594735136191153530301820658238923479284406977023235463388169632664840543885436816562132974121536367376075988408234475630208896797015599627151348925186970913657107879442359007158701930163567835304926526840638948451877260877508e1",".137444678594553473544428428015844885627819838469744105696054029321453852383185216443992107330074995349130650282828373586242529722704894327524501655468894792072355497676622760355611483225692465029181968494797630951484524855587542383381375001483028956964409362308551985070050712384524035341367495986602622708537435018624e1"},
	{1UL,"-494124578282428/98287489646633","494124578282429/98287489646633",1024,"-.2748893571891068696421057360422537789539938764446835892911218073711671056119007749054870462679189470272382307060603641316477846958568813954046470926776339265329681087770873633124265948243072734752151976816468951260417793594031199254302697850373941827314215758884718014317403860327135670609853053681277896903754521755016e1",".2748893571891069470888568560316897712556396769394882113921080586429077047663704328879842146601499906982613005656567471724850594454097886550490033109377895841447109953532455207112229664513849300583639369895952619029690497111750847667627500029660579139288187246171039701401014247690480706827349919732052454170748700372481e1"},
	{2UL,"-494124578282428/98287489646633","494124578282429/98287489646633",1024,"-.5497787143782137392842114720845075579079877528893671785822436147423342112238015498109740925358378940544764614121207282632955693917137627908092941853552678530659362175541747266248531896486145469504303953632937902520835587188062398508605395700747883654628431517769436028634807720654271341219706107362555793807509043510032e1",".5497787143782138941777137120633795425112793538789764227842161172858154095327408657759684293202999813965226011313134943449701188908195773100980066218755791682894219907064910414224459329027698601167278739791905238059380994223501695335255000059321158278576374492342079402802028495380961413654699839464104908341497400744962e1"},
	{3UL,"-494124578282428/98287489646633","494124578282429/98287489646633",1024,"-.1099557428756427478568422944169015115815975505778734357164487229484668422447603099621948185071675788108952922824241456526591138783427525581618588370710535706131872435108349453249706379297229093900860790726587580504167117437612479701721079140149576730925686303553887205726961544130854268243941221472511158761501808702006e2",".1099557428756427788355427424126759085022558707757952845568432234571630819065481731551936858640599962793045202262626988689940237781639154620196013243751158336578843981412982082844891865805539720233455747958381047611876198844700339067051000011864231655715274898468415880560405699076192282730939967892820981668299480148992e2"},
	{4UL,"-494124578282428/98287489646633","494124578282429/98287489646633",1024,"-.2199114857512854957136845888338030231631951011557468714328974458969336844895206199243896370143351576217905845648482913053182277566855051163237176741421071412263744870216698906499412758594458187801721581453175161008334234875224959403442158280299153461851372607107774411453923088261708536487882442945022317523003617404013e2",".2199114857512855576710854848253518170045117415515905691136864469143261638130963463103873717281199925586090404525253977379880475563278309240392026487502316673157687962825964165689783731611079440466911495916762095223752397689400678134102000023728463311430549796936831761120811398152384565461879935785641963336598960297985e2"},
	{16UL,"-494124578282428/98287489646633","494124578282429/98287489646633",1024,"-.9007574456372653904432520758632571828764471343339391853891479383938403716690764592102999532107168056188542343776186011865834608913838289564619475932860708504632298988407598721021594659202900737235851597632205459490137026048921433716499080316105332579743222198713443989315268969519958165454366486302811412574222816886836e5",".9007574456372656442207661458446410424504800933953149710896596865610799669784426344873466745983794895200626296935440291347990427907187954648645740492809489093253889895735149222665354164678981388152469487275057542036489820935785177637281792097191785723619531968253262893550843486832167180131860216977989481826709341380546e5"},
	{0UL,"-494124578282428/98287489646633","494124578282429/98287489646633",2048,"-.1374446785945534348210528680211268894769969382223417946455609036855835528059503874527435231339594735136191153530301820658238923479284406977023235463388169632664840543885436816562132974121536367376075988408234475630208896797015599627151348925186970913657107879442359007158701930163567835304926526840638948451877260877508308252854104395753123117151708582736183842920632002677983859346149446033338961703349878067204202393842307758856094065293884893301758419227322177506461159093443502017310336249361164219951225562238218655290961007527558887054783055751102493315888352200928728681781785805255330608986090932171409851590304580097825e1",".1374446785945534735444284280158448856278198384697441056960540293214538523831852164439921073300749953491306502828283735862425297227048943275245016554688947920723554976766227603556114832256924650291819684947976309514845248555875423833813750014830289569644093623085519850700507123845240353413674959866026227085374350186241273729531396537696129296906160021896137964593728646561697883998780051303961950969650713771505298512685635382246899237710229133225941022102984024215424188351861012166789643281318255109788243191012423576331214580153324540124260226770416858513450427637520122646779886685519221705795827395415228501849848585373328e1"},
	{1UL,"-494124578282428/98287489646633","494124578282429/98287489646633",2048,"-.2748893571891068696421057360422537789539938764446835892911218073711671056119007749054870462679189470272382307060603641316477846958568813954046470926776339265329681087770873633124265948243072734752151976816468951260417793594031199254302697850373941827314215758884718014317403860327135670609853053681277896903754521755016616505708208791506246234303417165472367685841264005355967718692298892066677923406699756134408404787684615517712188130587769786603516838454644355012922318186887004034620672498722328439902451124476437310581922015055117774109566111502204986631776704401857457363563571610510661217972181864342819703180609160195649e1",".2748893571891069470888568560316897712556396769394882113921080586429077047663704328879842146601499906982613005656567471724850594454097886550490033109377895841447109953532455207112229664513849300583639369895952619029690497111750847667627500029660579139288187246171039701401014247690480706827349919732052454170748700372482547459062793075392258593812320043792275929187457293123395767997560102607923901939301427543010597025371270764493798475420458266451882044205968048430848376703722024333579286562636510219576486382024847152662429160306649080248520453540833717026900855275040245293559773371038443411591654790830457003699697170746656e1"},
	{2UL,"-494124578282428/98287489646633","494124578282429/98287489646633",2048,"-.5497787143782137392842114720845075579079877528893671785822436147423342112238015498109740925358378940544764614121207282632955693917137627908092941853552678530659362175541747266248531896486145469504303953632937902520835587188062398508605395700747883654628431517769436028634807720654271341219706107362555793807509043510033233011416417583012492468606834330944735371682528010711935437384597784133355846813399512268816809575369231035424376261175539573207033676909288710025844636373774008069241344997444656879804902248952874621163844030110235548219132223004409973263553408803714914727127143221021322435944363728685639406361218320391299e1",".5497787143782138941777137120633795425112793538789764227842161172858154095327408657759684293202999813965226011313134943449701188908195773100980066218755791682894219907064910414224459329027698601167278739791905238059380994223501695335255000059321158278576374492342079402802028495380961413654699839464104908341497400744965094918125586150784517187624640087584551858374914586246791535995120205215847803878602855086021194050742541528987596950840916532903764088411936096861696753407444048667158573125273020439152972764049694305324858320613298160497040907081667434053801710550080490587119546742076886823183309581660914007399394341493312e1"},
	{3UL,"-494124578282428/98287489646633","494124578282429/98287489646633",2048,"-.109955742875642747856842294416901511581597550577873435716448722948466842244760309962194818507167578810895292282424145652659113878342752558161858837071053570613187243510834945324970637929722909390086079072658758050416711743761247970172107914014957673092568630355388720572696154413085426824394122147251115876150180870200664660228328351660249849372136686618894707433650560214238708747691955682667116936267990245376336191507384620708487525223510791464140673538185774200516892727475480161384826899948893137596098044979057492423276880602204710964382644460088199465271068176074298294542542864420426448718887274573712788127224366407826e2",".1099557428756427788355427424126759085022558707757952845568432234571630819065481731551936858640599962793045202262626988689940237781639154620196013243751158336578843981412982082844891865805539720233455747958381047611876198844700339067051000011864231655715274898468415880560405699076192282730939967892820981668299480148993018983625117230156903437524928017516910371674982917249358307199024041043169560775720571017204238810148508305797519390168183306580752817682387219372339350681488809733431714625054604087830594552809938861064971664122659632099408181416333486810760342110016098117423909348415377364636661916332182801479878868298662e2"},
	{4UL,"-494124578282428/98287489646633","494124578282429/98287489646633",2048,"-.2199114857512854957136845888338030231631951011557468714328974458969336844895206199243896370143351576217905845648482913053182277566855051163237176741421071412263744870216698906499412758594458187801721581453175161008334234875224959403442158280299153461851372607107774411453923088261708536487882442945022317523003617404013293204566567033204996987442733732377894148673011204284774174953839113653342338725359804907526723830147692414169750504470215829282813470763715484010337854549509603227696537998977862751921960899581149848465537612044094219287652889201763989305421363521485965890850857288408528974377745491474255762544487328156519e2",".2199114857512855576710854848253518170045117415515905691136864469143261638130963463103873717281199925586090404525253977379880475563278309240392026487502316673157687962825964165689783731611079440466911495916762095223752397689400678134102000023728463311430549796936831761120811398152384565461879935785641963336598960297986037967250234460313806875049856035033820743349965834498716614398048082086339121551441142034408477620297016611595038780336366613161505635364774438744678701362977619466863429250109208175661189105619877722129943328245319264198816362832666973621520684220032196234847818696830754729273323832664365602959757736597325e2"},
	{16UL,"-494124578282428/98287489646633","494124578282429/98287489646633",2048,"-.9007574456372653904432520758632571828764471343339391853891479383938403716690764592102999532107168056188542343776186011865834608913838289564619475932860708504632298988407598721021594659202900737235851597632205459490137026048921433716499080316105332579743222198713443989315268969519958165454366486302811412574222816886838448965904658568007667660565437367819854432964653892750435020610925009524090219419073760901229460808284948128439298066310004036742403976248178622506343852234791334820645019643813325831872351844684389779314842058932609922202226234170425300195005904984006516288925111453321334679051245533078551603382220096129104e5",".9007574456372656442207661458446410424504800933953149710896596865610799669784426344873466745983794895200626296935440291347990427907187954648645740492809489093253889895735149222665354164678981388152469487275057542036489820935785177637281792097191785723619531968253262893550843486832167180131860216977989481826709341380550811513856960349445352960204210319498529764761460058106743252574404944225645041874702917772937124332736580041093278844257757647509527082454116101098203960782756329336272606208447316687508230576619019149844247872492827706158351822162603923953748722565251875777936665382218771371103534418593241509723167689102642e5"},
	{0UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",10,"-.13744467859456e1","-.13744467859456e1"},
	{1UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",10,"-.27488935718911e1","-.27488935718911e1"},
	{2UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",10,"-.54977871437823e1","-.54977871437823e1"},
	{3UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",10,"-.10995574287565e2","-.10995574287565e2"},
	{4UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",10,"-.21991148575129e2","-.21991148575129e2"},
	{16UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",10,"-.90075744563729e5","-.90075744563729e5"},
	{0UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",24,"-.137444678594553474e1","-.137444678594553435e1"},
	{1UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",24,"-.274889357189106948e1","-.27488935718910687e1"},
	{2UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",24,"-.549778714378213895e1","-.54977871437821374e1"},
	{3UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",24,"-.109955742875642779e2","-.109955742875642748e2"},
	{4UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",24,"-.219911485751285558e2","-.219911485751285496e2"},
	{16UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",24,"-.900757445637265646e5","-.900757445637265391e5"},
	{0UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",53,"-.137444678594553473544428429e1","-.137444678594553434821052869e1"},
	{1UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",53,"-.274889357189106947088856859e1","-.274889357189106869642105738e1"},
	{2UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",53,"-.549778714378213894177713717e1","-.549778714378213739284211476e1"},
	{3UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",53,"-.109955742875642778835542743e2","-.109955742875642747856842295e2"},
	{4UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",53,"-.219911485751285557671085487e2","-.21991148575128549571368459e2"},
	{16UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",53,"-.900757445637265644220766154e5","-.900757445637265390443252082e5"},
	{0UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",113,"-.137444678594553473544428428015844885627819837e1","-.137444678594553434821052868021126889476996939e1"},
	{1UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",113,"-.274889357189106947088856856031689771255639673e1","-.274889357189106869642105736042253778953993877e1"},
	{2UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",113,"-.549778714378213894177713712063379542511279347e1","-.549778714378213739284211472084507557907987755e1"},
	{3UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",113,"-.109955742875642778835542742412675908502255869e2","-.109955742875642747856842294416901511581597551e2"},
	{4UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",113,"-.219911485751285557671085484825351817004511739e2","-.219911485751285495713684588833803023163195102e2"},
	{16UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",113,"-.900757445637265644220766145844641042450480082e5","-.900757445637265390443252075863257182876447137e5"},
	{0UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",256,"-.1374446785945534735444284280158448856278198384697441056960540293214538523831852164439919e1","-.1374446785945534348210528680211268894769969382223417946455609036855835528059503874527435e1"},
	{1UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",256,"-.2748893571891069470888568560316897712556396769394882113921080586429077047663704328879839e1","-.2748893571891068696421057360422537789539938764446835892911218073711671056119007749054869e1"},
	{2UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",256,"-.5497787143782138941777137120633795425112793538789764227842161172858154095327408657759678e1","-.5497787143782137392842114720845075579079877528893671785822436147423342112238015498109739e1"},
	{3UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",256,"-.1099557428756427788355427424126759085022558707757952845568432234571630819065481731551936e2","-.1099557428756427478568422944169015115815975505778734357164487229484668422447603099621948e2"},
	{4UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",256,"-.2199114857512855576710854848253518170045117415515905691136864469143261638130963463103871e2","-.2199114857512854957136845888338030231631951011557468714328974458969336844895206199243896e2"},
	{16UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",256,"-.9007574456372656442207661458446410424504800933953149710896596865610799669784426344873456e5","-.9007574456372653904432520758632571828764471343339391853891479383938403716690764592102996e5"},
	{0UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",512,"-.137444678594553473544428428015844885627819838469744105696054029321453852383185216443992107330074995349130650282828373586242529722704894327524501655468894792072355498e1","-.137444678594553434821052868021126889476996938222341794645560903685583552805950387452743523133959473513619115353030182065823892347928440697702323546338816963266484054e1"},
	{1UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",512,"-.274889357189106947088856856031689771255639676939488211392108058642907704766370432887984214660149990698261300565656747172485059445409788655049003310937789584144710996e1","-.274889357189106869642105736042253778953993876444683589291121807371167105611900774905487046267918947027238230706060364131647784695856881395404647092677633926532968109e1"},
	{2UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",512,"-.549778714378213894177713712063379542511279353878976422784216117285815409532740865775968429320299981396522601131313494344970118890819577310098006621875579168289421992e1","-.549778714378213739284211472084507557907987752889367178582243614742334211223801549810974092535837894054476461412120728263295569391713762790809294185355267853065936218e1"},
	{3UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",512,"-.109955742875642778835542742412675908502255870775795284556843223457163081906548173155193685864059996279304520226262698868994023778163915462019601324375115833657884398e2","-.109955742875642747856842294416901511581597550577873435716448722948466842244760309962194818507167578810895292282424145652659113878342752558161858837071053570613187244e2"},
	{4UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",512,"-.219911485751285557671085484825351817004511741551590569113686446914326163813096346310387371728119992558609040452525397737988047556327830924039202648750231667315768797e2","-.219911485751285495713684588833803023163195101155746871432897445896933684489520619924389637014335157621790584564848291305318227756685505116323717674142107141226374487e2"},
	{16UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",512,"-.900757445637265644220766145844641042450480093395314971089659686561079966978442634487346674598379489520062629693544029134799042790718795464864574049280948909325388991e5","-.9007574456372653904432520758632571828764471343339391853891479383938403716690764592102999532107168056188542343776186011865834608913838289564619475932860708504632299e5"},
	{0UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",1024,"-.137444678594553473544428428015844885627819838469744105696054029321453852383185216443992107330074995349130650282828373586242529722704894327524501655468894792072355497676622760355611483225692465029181968494797630951484524855587542383381375001483028956964409362308551985070050712384524035341367495986602622708537435018624e1","-.1374446785945534348210528680211268894769969382223417946455609036855835528059503874527435231339594735136191153530301820658238923479284406977023235463388169632664840543885436816562132974121536367376075988408234475630208896797015599627151348925186970913657107879442359007158701930163567835304926526840638948451877260877508e1"},
	{1UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",1024,"-.2748893571891069470888568560316897712556396769394882113921080586429077047663704328879842146601499906982613005656567471724850594454097886550490033109377895841447109953532455207112229664513849300583639369895952619029690497111750847667627500029660579139288187246171039701401014247690480706827349919732052454170748700372481e1","-.2748893571891068696421057360422537789539938764446835892911218073711671056119007749054870462679189470272382307060603641316477846958568813954046470926776339265329681087770873633124265948243072734752151976816468951260417793594031199254302697850373941827314215758884718014317403860327135670609853053681277896903754521755016e1"},
	{2UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",1024,"-.5497787143782138941777137120633795425112793538789764227842161172858154095327408657759684293202999813965226011313134943449701188908195773100980066218755791682894219907064910414224459329027698601167278739791905238059380994223501695335255000059321158278576374492342079402802028495380961413654699839464104908341497400744962e1","-.5497787143782137392842114720845075579079877528893671785822436147423342112238015498109740925358378940544764614121207282632955693917137627908092941853552678530659362175541747266248531896486145469504303953632937902520835587188062398508605395700747883654628431517769436028634807720654271341219706107362555793807509043510032e1"},
	{3UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",1024,"-.1099557428756427788355427424126759085022558707757952845568432234571630819065481731551936858640599962793045202262626988689940237781639154620196013243751158336578843981412982082844891865805539720233455747958381047611876198844700339067051000011864231655715274898468415880560405699076192282730939967892820981668299480148992e2","-.1099557428756427478568422944169015115815975505778734357164487229484668422447603099621948185071675788108952922824241456526591138783427525581618588370710535706131872435108349453249706379297229093900860790726587580504167117437612479701721079140149576730925686303553887205726961544130854268243941221472511158761501808702006e2"},
	{4UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",1024,"-.2199114857512855576710854848253518170045117415515905691136864469143261638130963463103873717281199925586090404525253977379880475563278309240392026487502316673157687962825964165689783731611079440466911495916762095223752397689400678134102000023728463311430549796936831761120811398152384565461879935785641963336598960297985e2","-.2199114857512854957136845888338030231631951011557468714328974458969336844895206199243896370143351576217905845648482913053182277566855051163237176741421071412263744870216698906499412758594458187801721581453175161008334234875224959403442158280299153461851372607107774411453923088261708536487882442945022317523003617404013e2"},
	{16UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",1024,"-.9007574456372656442207661458446410424504800933953149710896596865610799669784426344873466745983794895200626296935440291347990427907187954648645740492809489093253889895735149222665354164678981388152469487275057542036489820935785177637281792097191785723619531968253262893550843486832167180131860216977989481826709341380546e5","-.9007574456372653904432520758632571828764471343339391853891479383938403716690764592102999532107168056188542343776186011865834608913838289564619475932860708504632298988407598721021594659202900737235851597632205459490137026048921433716499080316105332579743222198713443989315268969519958165454366486302811412574222816886836e5"},
	{0UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",2048,"-.1374446785945534735444284280158448856278198384697441056960540293214538523831852164439921073300749953491306502828283735862425297227048943275245016554688947920723554976766227603556114832256924650291819684947976309514845248555875423833813750014830289569644093623085519850700507123845240353413674959866026227085374350186241273729531396537696129296906160021896137964593728646561697883998780051303961950969650713771505298512685635382246899237710229133225941022102984024215424188351861012166789643281318255109788243191012423576331214580153324540124260226770416858513450427637520122646779886685519221705795827395415228501849848585373328e1","-.1374446785945534348210528680211268894769969382223417946455609036855835528059503874527435231339594735136191153530301820658238923479284406977023235463388169632664840543885436816562132974121536367376075988408234475630208896797015599627151348925186970913657107879442359007158701930163567835304926526840638948451877260877508308252854104395753123117151708582736183842920632002677983859346149446033338961703349878067204202393842307758856094065293884893301758419227322177506461159093443502017310336249361164219951225562238218655290961007527558887054783055751102493315888352200928728681781785805255330608986090932171409851590304580097825e1"},
	{1UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",2048,"-.2748893571891069470888568560316897712556396769394882113921080586429077047663704328879842146601499906982613005656567471724850594454097886550490033109377895841447109953532455207112229664513849300583639369895952619029690497111750847667627500029660579139288187246171039701401014247690480706827349919732052454170748700372482547459062793075392258593812320043792275929187457293123395767997560102607923901939301427543010597025371270764493798475420458266451882044205968048430848376703722024333579286562636510219576486382024847152662429160306649080248520453540833717026900855275040245293559773371038443411591654790830457003699697170746656e1","-.2748893571891068696421057360422537789539938764446835892911218073711671056119007749054870462679189470272382307060603641316477846958568813954046470926776339265329681087770873633124265948243072734752151976816468951260417793594031199254302697850373941827314215758884718014317403860327135670609853053681277896903754521755016616505708208791506246234303417165472367685841264005355967718692298892066677923406699756134408404787684615517712188130587769786603516838454644355012922318186887004034620672498722328439902451124476437310581922015055117774109566111502204986631776704401857457363563571610510661217972181864342819703180609160195649e1"},
	{2UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",2048,"-.5497787143782138941777137120633795425112793538789764227842161172858154095327408657759684293202999813965226011313134943449701188908195773100980066218755791682894219907064910414224459329027698601167278739791905238059380994223501695335255000059321158278576374492342079402802028495380961413654699839464104908341497400744965094918125586150784517187624640087584551858374914586246791535995120205215847803878602855086021194050742541528987596950840916532903764088411936096861696753407444048667158573125273020439152972764049694305324858320613298160497040907081667434053801710550080490587119546742076886823183309581660914007399394341493312e1","-.5497787143782137392842114720845075579079877528893671785822436147423342112238015498109740925358378940544764614121207282632955693917137627908092941853552678530659362175541747266248531896486145469504303953632937902520835587188062398508605395700747883654628431517769436028634807720654271341219706107362555793807509043510033233011416417583012492468606834330944735371682528010711935437384597784133355846813399512268816809575369231035424376261175539573207033676909288710025844636373774008069241344997444656879804902248952874621163844030110235548219132223004409973263553408803714914727127143221021322435944363728685639406361218320391299e1"},
	{3UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",2048,"-.1099557428756427788355427424126759085022558707757952845568432234571630819065481731551936858640599962793045202262626988689940237781639154620196013243751158336578843981412982082844891865805539720233455747958381047611876198844700339067051000011864231655715274898468415880560405699076192282730939967892820981668299480148993018983625117230156903437524928017516910371674982917249358307199024041043169560775720571017204238810148508305797519390168183306580752817682387219372339350681488809733431714625054604087830594552809938861064971664122659632099408181416333486810760342110016098117423909348415377364636661916332182801479878868298662e2","-.109955742875642747856842294416901511581597550577873435716448722948466842244760309962194818507167578810895292282424145652659113878342752558161858837071053570613187243510834945324970637929722909390086079072658758050416711743761247970172107914014957673092568630355388720572696154413085426824394122147251115876150180870200664660228328351660249849372136686618894707433650560214238708747691955682667116936267990245376336191507384620708487525223510791464140673538185774200516892727475480161384826899948893137596098044979057492423276880602204710964382644460088199465271068176074298294542542864420426448718887274573712788127224366407826e2"},
	{4UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",2048,"-.2199114857512855576710854848253518170045117415515905691136864469143261638130963463103873717281199925586090404525253977379880475563278309240392026487502316673157687962825964165689783731611079440466911495916762095223752397689400678134102000023728463311430549796936831761120811398152384565461879935785641963336598960297986037967250234460313806875049856035033820743349965834498716614398048082086339121551441142034408477620297016611595038780336366613161505635364774438744678701362977619466863429250109208175661189105619877722129943328245319264198816362832666973621520684220032196234847818696830754729273323832664365602959757736597325e2","-.2199114857512854957136845888338030231631951011557468714328974458969336844895206199243896370143351576217905845648482913053182277566855051163237176741421071412263744870216698906499412758594458187801721581453175161008334234875224959403442158280299153461851372607107774411453923088261708536487882442945022317523003617404013293204566567033204996987442733732377894148673011204284774174953839113653342338725359804907526723830147692414169750504470215829282813470763715484010337854549509603227696537998977862751921960899581149848465537612044094219287652889201763989305421363521485965890850857288408528974377745491474255762544487328156519e2"},
	{16UL,"-494124578282429/98287489646633","-494124578282428/98287489646633",2048,"-.9007574456372656442207661458446410424504800933953149710896596865610799669784426344873466745983794895200626296935440291347990427907187954648645740492809489093253889895735149222665354164678981388152469487275057542036489820935785177637281792097191785723619531968253262893550843486832167180131860216977989481826709341380550811513856960349445352960204210319498529764761460058106743252574404944225645041874702917772937124332736580041093278844257757647509527082454116101098203960782756329336272606208447316687508230576619019149844247872492827706158351822162603923953748722565251875777936665382218771371103534418593241509723167689102642e5","-.9007574456372653904432520758632571828764471343339391853891479383938403716690764592102999532107168056188542343776186011865834608913838289564619475932860708504632298988407598721021594659202900737235851597632205459490137026048921433716499080316105332579743222198713443989315268969519958165454366486302811412574222816886838448965904658568007667660565437367819854432964653892750435020610925009524090219419073760901229460808284948128439298066310004036742403976248178622506343852234791334820645019643813325831872351844684389779314842058932609922202226234170425300195005904984006516288925111453321334679051245533078551603382220096129104e5"},
	{0UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",10,".15462526341889e1",".15462526341889e1"},
	{1UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",10,".30925052683779e1",".30925052683779e1"},
	{2UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",10,".61850105367557e1",".61850105367557e1"},
	{3UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",10,".12370021073511e2",".12370021073511e2"},
	{4UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",10,".24740042147023e2",".24740042147023e2"},
	{16UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",10,".10133521263421e6",".10133521263421e6"},
	{0UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",24,".154625263418872635e1",".154625263418872635e1"},
	{1UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",24,".309250526837745271e1",".309250526837745271e1"},
	{2UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",24,".618501053675490542e1",".618501053675490542e1"},
	{3UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",24,".123700210735098108e2",".123700210735098108e2"},
	{4UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",24,".247400421470196217e2",".247400421470196217e2"},
	{16UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",24,".10133521263419237e6",".10133521263419237e6"},
	{0UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",53,".154625263418872635955583228e1",".154625263418872635955583228e1"},
	{1UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",53,".309250526837745271911166457e1",".309250526837745271911166457e1"},
	{2UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",53,".618501053675490543822332913e1",".618501053675490543822332913e1"},
	{3UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",53,".123700210735098108764466583e2",".123700210735098108764466583e2"},
	{4UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",53,".247400421470196217528933165e2",".247400421470196217528933165e2"},
	{16UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",53,".101335212634192370699851025e6",".101335212634192370699851025e6"},
	{0UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",113,".154625263418872635955583229020788032571387353e1",".15462526341887263595558322902078803259177151e1"},
	{1UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",113,".309250526837745271911166458041576065142774705e1",".30925052683774527191116645804157606518354302e1"},
	{2UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",113,".61850105367549054382233291608315213028554941e1",".61850105367549054382233291608315213036708604e1"},
	{3UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",113,".123700210735098108764466583216630426057109882e2",".123700210735098108764466583216630426073417208e2"},
	{4UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",113,".247400421470196217528933166433260852114219764e2",".247400421470196217528933166433260852146834416e2"},
	{16UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",113,".101335212634192370699851024971063645025984415e6",".101335212634192370699851024971063645039343377e6"},
	{0UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",256,".1546252634188726359555832290207880325713873522971347547103102494817665908766219561287933e1",".1546252634188726359555832290207880325917715104538522245419108588235340840184841988035589e1"},
	{1UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",256,".3092505268377452719111664580415760651427747045942695094206204989635331817532439122575866e1",".3092505268377452719111664580415760651835430209077044490838217176470681680369683976071179e1"},
	{2UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",256,".6185010536754905438223329160831521302855494091885390188412409979270663635064878245151731e1",".6185010536754905438223329160831521303670860418154088981676434352941363360739367952142358e1"},
	{3UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",256,".1237002107350981087644665832166304260571098818377078037682481995854132727012975649030346e2",".1237002107350981087644665832166304260734172083630817796335286870588272672147873590428472e2"},
	{4UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",256,".2474004214701962175289331664332608521142197636754156075364963991708265454025951298060692e2",".2474004214701962175289331664332608521468344167261635592670573741176545344295747180856943e2"},
	{16UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",256,".101335212634192370699851024971063645025984415201450232846948925100370552996902965168566e6",".1013352126341923706998510249710636450393433770910365938757867004385912973023538045279004e6"},
	{0UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",512,".15462526341887263595558322902078803257138735229713475471031024948176659087662195612879325393801840175083691240279349836057062807321996846013625879457284416123887309e1",".15462526341887263595558322902078803259177151045385222454191085882353408401848419880355906631092162117790986593546934374855005709829865319091931845353293794864678144e1"},
	{1UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",512,".309250526837745271911166458041576065142774704594269509420620498963533181753243912257586507876036803501673824805586996721141256146439936920272517589145688322477746179e1",".309250526837745271911166458041576065183543020907704449083821717647068168036968397607118132621843242355819731870938687497100114196597306381838636907065875897293562879e1"},
	{2UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",512,".618501053675490543822332916083152130285549409188539018841240997927066363506487824515173015752073607003347649611173993442282512292879873840545035178291376644955492358e1",".618501053675490543822332916083152130367086041815408898167643435294136336073936795214236265243686484711639463741877374994200228393194612763677273814131751794587125758e1"},
	{3UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",512,".123700210735098108764466583216630426057109881837707803768248199585413272701297564903034603150414721400669529922234798688456502458575974768109007035658275328991098472e2",".123700210735098108764466583216630426073417208363081779633528687058827267214787359042847253048737296942327892748375474998840045678638922552735454762826350358917425152e2"},
	{4UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",512,".247400421470196217528933166433260852114219763675415607536496399170826545402595129806069206300829442801339059844469597376913004917151949536218014071316550657982196943e2",".247400421470196217528933166433260852146834416726163559267057374117654534429574718085694506097474593884655785496750949997680091357277845105470909525652700717834850303e2"},
	{16UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",512,".101335212634192370699851024971063645025984415201450232846948925100370552996902965168565946900819739771428478912294747085583566814065438530034898563611259149509507868e6",".101335212634192370699851024971063645039343377091036593875786700438591297302353804527900469697525593655155009739469189119049765419941005355200884541707346214025154684e6"},
	{0UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",1024,".1546252634188726359555832290207880325713873522971347547103102494817665908766219561287932539380184017508369124027934983605706280732199684601362587945728441612388730889528873760611652553000357671910320564256500696068415436688277149092903655266795145523097944837328486081910580865974107187053025227828097227062369862707102e1",".1546252634188726359555832290207880325917715104538522245419108588235340840184841988035590663109216211779098659354693437485500570982986531909193184535329379486467814407061113516015357426704528011810863833051153261572608432097277466091116735728193753660525895353308164269869736204543798807877967748133236988119388360281328e1"},
	{1UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",1024,".3092505268377452719111664580415760651427747045942695094206204989635331817532439122575865078760368035016738248055869967211412561464399369202725175891456883224777461779057747521223305106000715343820641128513001392136830873376554298185807310533590291046195889674656972163821161731948214374106050455656194454124739725414204e1",".3092505268377452719111664580415760651835430209077044490838217176470681680369683976071181326218432423558197318709386874971001141965973063818386369070658758972935628814122227032030714853409056023621727666102306523145216864194554932182233471456387507321051790706616328539739472409087597615755935496266473976238776720562657e1"},
	{2UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",1024,".6185010536754905438223329160831521302855494091885390188412409979270663635064878245151730157520736070033476496111739934422825122928798738405450351782913766449554923558115495042446610212001430687641282257026002784273661746753108596371614621067180582092391779349313944327642323463896428748212100911312388908249479450828408e1",".6185010536754905438223329160831521303670860418154088981676434352941363360739367952142362652436864847116394637418773749942002283931946127636772738141317517945871257628244454064061429706818112047243455332204613046290433728389109864364466942912775014642103581413232657079478944818175195231511870992532947952477553441125314e1"},
	{3UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",1024,".1237002107350981087644665832166304260571098818377078037682481995854132727012975649030346031504147214006695299222347986884565024585759747681090070356582753289910984711623099008489322042400286137528256451405200556854732349350621719274322924213436116418478355869862788865528464692779285749642420182262477781649895890165682e2",".1237002107350981087644665832166304260734172083630817796335286870588272672147873590428472530487372969423278927483754749988400456786389225527354547628263503589174251525648890812812285941363622409448691066440922609258086745677821972872893388582555002928420716282646531415895788963635039046302374198506589590495510688225063e2"},
	{4UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",1024,".2474004214701962175289331664332608521142197636754156075364963991708265454025951298060692063008294428013390598444695973769130049171519495362180140713165506579821969423246198016978644084800572275056512902810401113709464698701243438548645848426872232836956711739725577731056929385558571499284840364524955563299791780331363e2",".2474004214701962175289331664332608521468344167261635592670573741176545344295747180856945060974745938846557854967509499976800913572778451054709095256527007178348503051297781625624571882727244818897382132881845218516173491355643945745786777165110005856841432565293062831791577927270078092604748397013179180991021376450126e2"},
	{16UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",1024,".1013352126341923706998510249710636450259844152014502328469489251003705529969029651685659469008197397714284789122947470855835668140654385300348985636112591495095078675761642707754452617134314403863147684991140296175396740588029312429525339515646866570017469128591596638640918276324790886107070613309421798727594713223726e6",".1013352126341923706998510249710636450393433770910365938757867004385912973023538045279004696975255936551550097394691891190497654199410053552008845417073462140251546849811571353855824643165079477820367721628403801504224662059271760177474263926829058398962250778744038535901830319009823986730904943416598192533922355793971e6"},
	{0UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",2048,".1546252634188726359555832290207880325713873522971347547103102494817665908766219561287932539380184017508369124027934983605706280732199684601362587945728441612388730889528873760611652553000357671910320564256500696068415436688277149092903655266795145523097944837328486081910580865974107187053025227828097227062369862707103284477967077275634476453944560165252309084983395401808068751448301850897251930390683138377301353212180043355147462803968736326889226836690170199893163386521557791623507224446266029963237607543592381054359228977429872741880102799836266134917524731402700085274623250532036645747291225647114810169759569046009551e1",".154625263418872635955583229020788032591771510453852224541910858823534084018484198803559066310921621177909865935469343748550057098298653190919318453532937948646781440706111351601535742670452801181086383305115326157260843209727746609111673572819375366052589535330816426986973620454379880787796774813323698811938836028132889847368535213431759495565615715909631182737968997395152359643614699935295277189111815134442686390959837383853138478144747322613874573430155435913043767716473455008586204856546207543538763765558793295157797915895668791466400440837012328600510299312055234540966003587110673379146867723529158484679573301283382e1"},
	{1UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",2048,".3092505268377452719111664580415760651427747045942695094206204989635331817532439122575865078760368035016738248055869967211412561464399369202725175891456883224777461779057747521223305106000715343820641128513001392136830873376554298185807310533590291046195889674656972163821161731948214374106050455656194454124739725414206568955934154551268952907889120330504618169966790803616137502896603701794503860781366276754602706424360086710294925607937472653778453673380340399786326773043115583247014448892532059926475215087184762108718457954859745483760205599672532269835049462805400170549246501064073291494582451294229620339519138092019103e1",".3092505268377452719111664580415760651835430209077044490838217176470681680369683976071181326218432423558197318709386874971001141965973063818386369070658758972935628814122227032030714853409056023621727666102306523145216864194554932182233471456387507321051790706616328539739472409087597615755935496266473976238776720562657796947370704268635189911312314318192623654759379947903047192872293998705905543782236302688853727819196747677062769562894946452277491468603108718260875354329469100171724097130924150870775275311175865903155958317913375829328008816740246572010205986241104690819320071742213467582937354470583169693591466025667641e1"},
	{2UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",2048,".6185010536754905438223329160831521302855494091885390188412409979270663635064878245151730157520736070033476496111739934422825122928798738405450351782913766449554923558115495042446610212001430687641282257026002784273661746753108596371614621067180582092391779349313944327642323463896428748212100911312388908249479450828413137911868309102537905815778240661009236339933581607232275005793207403589007721562732553509205412848720173420589851215874945307556907346760680799572653546086231166494028897785064119852950430174369524217436915909719490967520411199345064539670098925610800341098493002128146582989164902588459240679038276184038205e1",".6185010536754905438223329160831521303670860418154088981676434352941363360739367952142362652436864847116394637418773749942002283931946127636772738141317517945871257628244454064061429706818112047243455332204613046290433728389109864364466942912775014642103581413232657079478944818175195231511870992532947952477553441125315593894741408537270379822624628636385247309518759895806094385744587997411811087564472605377707455638393495354125539125789892904554982937206217436521750708658938200343448194261848301741550550622351731806311916635826751658656017633480493144020411972482209381638640143484426935165874708941166339387182932051335281e1"},
	{3UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",2048,".1237002107350981087644665832166304260571098818377078037682481995854132727012975649030346031504147214006695299222347986884565024585759747681090070356582753289910984711623099008489322042400286137528256451405200556854732349350621719274322924213436116418478355869862788865528464692779285749642420182262477781649895890165682627582373661820507581163155648132201847267986716321446455001158641480717801544312546510701841082569744034684117970243174989061511381469352136159914530709217246233298805779557012823970590086034873904843487383181943898193504082239869012907934019785122160068219698600425629316597832980517691848135807655236807641e2",".1237002107350981087644665832166304260734172083630817796335286870588272672147873590428472530487372969423278927483754749988400456786389225527354547628263503589174251525648890812812285941363622409448691066440922609258086745677821972872893388582555002928420716282646531415895788963635039046302374198506589590495510688225063118778948281707454075964524925727277049461903751979161218877148917599482362217512894521075541491127678699070825107825157978580910996587441243487304350141731787640068689638852369660348310110124470346361262383327165350331731203526696098628804082394496441876327728028696885387033174941788233267877436586410267056e2"},
	{4UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",2048,".2474004214701962175289331664332608521142197636754156075364963991708265454025951298060692063008294428013390598444695973769130049171519495362180140713165506579821969423246198016978644084800572275056512902810401113709464698701243438548645848426872232836956711739725577731056929385558571499284840364524955563299791780331365255164747323641015162326311296264403694535973432642892910002317282961435603088625093021403682165139488069368235940486349978123022762938704272319829061418434492466597611559114025647941180172069747809686974766363887796387008164479738025815868039570244320136439397200851258633195665961035383696271615310473615282e2",".2474004214701962175289331664332608521468344167261635592670573741176545344295747180856945060974745938846557854967509499976800913572778451054709095256527007178348503051297781625624571882727244818897382132881845218516173491355643945745786777165110005856841432565293062831791577927270078092604748397013179180991021376450126237557896563414908151929049851454554098923807503958322437754297835198964724435025789042151082982255357398141650215650315957161821993174882486974608700283463575280137379277704739320696620220248940692722524766654330700663462407053392197257608164788992883752655456057393770774066349883576466535754873172820534112e2"},
	{16UL,"240714745000386851292848972172591645/5909215311060847167846167476692359","240714745000386851292848972172591647/5909215311060847167846167476692359",2048,".101335212634192370699851024971063645025984415201450232846948925100370552996902965168565946900819739771428478912294747085583566814065438530034898563611259149509507867576164270775445261713431440386314768499114029617539674058802931242952533951564686657001746912859159663864091827632479088610707061330942179872759471322372720851548050376335981048885710694989975328193471801052893593694915910100402302510083810156694821484113431321322944122320895103919012369969326994220198355699076811431838169461310490539670739847976870284778486430264844140011854417090069537417954900797207352788557709346867553615694477764009316199285363116999282e6",".1013352126341923706998510249710636450393433770910365938757867004385912973023538045279004696975255936551550097394691891190497654199410053552008845417073462140251546849811571353855824643165079477820367721628403801504224662059271760177474263926829058398962250778744038535901830319009823986730904943416598192533922355793971706903714432374746379030138819155785358919191553621328870504160393297495951128586563191665083589531794390278819928330369416053482288404431866664799723636106680434744270552147861225757335642213966107739146144421613854991754201929069443996716304297571485185087674801108488509057576912312920693045196051587290772e6"},
	{0UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",10,"-.15462526341889e1","-.15462526341889e1"},
	{1UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",10,"-.30925052683779e1","-.30925052683779e1"},
	{2UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",10,"-.61850105367557e1","-.61850105367557e1"},
	{3UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",10,"-.12370021073511e2","-.12370021073511e2"},
	{4UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",10,"-.24740042147023e2","-.24740042147023e2"},
	{16UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",10,"-.10133521263421e6","-.10133521263421e6"},
	{0UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",24,"-.154625263418872635e1","-.154625263418872635e1"},
	{1UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",24,"-.309250526837745271e1","-.309250526837745271e1"},
	{2UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",24,"-.618501053675490542e1","-.618501053675490542e1"},
	{3UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",24,"-.123700210735098108e2","-.123700210735098108e2"},
	{4UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",24,"-.247400421470196217e2","-.247400421470196217e2"},
	{16UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",24,"-.10133521263419237e6","-.10133521263419237e6"},
	{0UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",53,"-.154625263418872635955583228e1","-.154625263418872635955583228e1"},
	{1UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",53,"-.309250526837745271911166457e1","-.309250526837745271911166457e1"},
	{2UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",53,"-.618501053675490543822332913e1","-.618501053675490543822332913e1"},
	{3UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",53,"-.123700210735098108764466583e2","-.123700210735098108764466583e2"},
	{4UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",53,"-.247400421470196217528933165e2","-.247400421470196217528933165e2"},
	{16UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",53,"-.101335212634192370699851025e6","-.101335212634192370699851025e6"},
	{0UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",113,"-.15462526341887263595558322902078803259177151e1","-.154625263418872635955583229020788032571387353e1"},
	{1UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",113,"-.30925052683774527191116645804157606518354302e1","-.309250526837745271911166458041576065142774705e1"},
	{2UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",113,"-.61850105367549054382233291608315213036708604e1","-.61850105367549054382233291608315213028554941e1"},
	{3UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",113,"-.123700210735098108764466583216630426073417208e2","-.123700210735098108764466583216630426057109882e2"},
	{4UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",113,"-.247400421470196217528933166433260852146834416e2","-.247400421470196217528933166433260852114219764e2"},
	{16UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",113,"-.101335212634192370699851024971063645039343377e6","-.101335212634192370699851024971063645025984415e6"},
	{0UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",256,"-.1546252634188726359555832290207880325917715104538522245419108588235340840184841988035589e1","-.1546252634188726359555832290207880325713873522971347547103102494817665908766219561287933e1"},
	{1UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",256,"-.3092505268377452719111664580415760651835430209077044490838217176470681680369683976071179e1","-.3092505268377452719111664580415760651427747045942695094206204989635331817532439122575866e1"},
	{2UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",256,"-.6185010536754905438223329160831521303670860418154088981676434352941363360739367952142358e1","-.6185010536754905438223329160831521302855494091885390188412409979270663635064878245151731e1"},
	{3UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",256,"-.1237002107350981087644665832166304260734172083630817796335286870588272672147873590428472e2","-.1237002107350981087644665832166304260571098818377078037682481995854132727012975649030346e2"},
	{4UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",256,"-.2474004214701962175289331664332608521468344167261635592670573741176545344295747180856943e2","-.2474004214701962175289331664332608521142197636754156075364963991708265454025951298060692e2"},
	{16UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",256,"-.1013352126341923706998510249710636450393433770910365938757867004385912973023538045279004e6","-.101335212634192370699851024971063645025984415201450232846948925100370552996902965168566e6"},
	{0UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",512,"-.15462526341887263595558322902078803259177151045385222454191085882353408401848419880355906631092162117790986593546934374855005709829865319091931845353293794864678144e1","-.15462526341887263595558322902078803257138735229713475471031024948176659087662195612879325393801840175083691240279349836057062807321996846013625879457284416123887309e1"},
	{1UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",512,"-.309250526837745271911166458041576065183543020907704449083821717647068168036968397607118132621843242355819731870938687497100114196597306381838636907065875897293562879e1","-.309250526837745271911166458041576065142774704594269509420620498963533181753243912257586507876036803501673824805586996721141256146439936920272517589145688322477746179e1"},
	{2UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",512,"-.618501053675490543822332916083152130367086041815408898167643435294136336073936795214236265243686484711639463741877374994200228393194612763677273814131751794587125758e1","-.618501053675490543822332916083152130285549409188539018841240997927066363506487824515173015752073607003347649611173993442282512292879873840545035178291376644955492358e1"},
	{3UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",512,"-.123700210735098108764466583216630426073417208363081779633528687058827267214787359042847253048737296942327892748375474998840045678638922552735454762826350358917425152e2","-.123700210735098108764466583216630426057109881837707803768248199585413272701297564903034603150414721400669529922234798688456502458575974768109007035658275328991098472e2"},
	{4UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",512,"-.247400421470196217528933166433260852146834416726163559267057374117654534429574718085694506097474593884655785496750949997680091357277845105470909525652700717834850303e2","-.247400421470196217528933166433260852114219763675415607536496399170826545402595129806069206300829442801339059844469597376913004917151949536218014071316550657982196943e2"},
	{16UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",512,"-.101335212634192370699851024971063645039343377091036593875786700438591297302353804527900469697525593655155009739469189119049765419941005355200884541707346214025154684e6","-.101335212634192370699851024971063645025984415201450232846948925100370552996902965168565946900819739771428478912294747085583566814065438530034898563611259149509507868e6"},
	{0UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",1024,"-.1546252634188726359555832290207880325917715104538522245419108588235340840184841988035590663109216211779098659354693437485500570982986531909193184535329379486467814407061113516015357426704528011810863833051153261572608432097277466091116735728193753660525895353308164269869736204543798807877967748133236988119388360281328e1","-.1546252634188726359555832290207880325713873522971347547103102494817665908766219561287932539380184017508369124027934983605706280732199684601362587945728441612388730889528873760611652553000357671910320564256500696068415436688277149092903655266795145523097944837328486081910580865974107187053025227828097227062369862707102e1"},
	{1UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",1024,"-.3092505268377452719111664580415760651835430209077044490838217176470681680369683976071181326218432423558197318709386874971001141965973063818386369070658758972935628814122227032030714853409056023621727666102306523145216864194554932182233471456387507321051790706616328539739472409087597615755935496266473976238776720562657e1","-.3092505268377452719111664580415760651427747045942695094206204989635331817532439122575865078760368035016738248055869967211412561464399369202725175891456883224777461779057747521223305106000715343820641128513001392136830873376554298185807310533590291046195889674656972163821161731948214374106050455656194454124739725414204e1"},
	{2UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",1024,"-.6185010536754905438223329160831521303670860418154088981676434352941363360739367952142362652436864847116394637418773749942002283931946127636772738141317517945871257628244454064061429706818112047243455332204613046290433728389109864364466942912775014642103581413232657079478944818175195231511870992532947952477553441125314e1","-.6185010536754905438223329160831521302855494091885390188412409979270663635064878245151730157520736070033476496111739934422825122928798738405450351782913766449554923558115495042446610212001430687641282257026002784273661746753108596371614621067180582092391779349313944327642323463896428748212100911312388908249479450828408e1"},
	{3UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",1024,"-.1237002107350981087644665832166304260734172083630817796335286870588272672147873590428472530487372969423278927483754749988400456786389225527354547628263503589174251525648890812812285941363622409448691066440922609258086745677821972872893388582555002928420716282646531415895788963635039046302374198506589590495510688225063e2","-.1237002107350981087644665832166304260571098818377078037682481995854132727012975649030346031504147214006695299222347986884565024585759747681090070356582753289910984711623099008489322042400286137528256451405200556854732349350621719274322924213436116418478355869862788865528464692779285749642420182262477781649895890165682e2"},
	{4UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",1024,"-.2474004214701962175289331664332608521468344167261635592670573741176545344295747180856945060974745938846557854967509499976800913572778451054709095256527007178348503051297781625624571882727244818897382132881845218516173491355643945745786777165110005856841432565293062831791577927270078092604748397013179180991021376450126e2","-.2474004214701962175289331664332608521142197636754156075364963991708265454025951298060692063008294428013390598444695973769130049171519495362180140713165506579821969423246198016978644084800572275056512902810401113709464698701243438548645848426872232836956711739725577731056929385558571499284840364524955563299791780331363e2"},
	{16UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",1024,"-.1013352126341923706998510249710636450393433770910365938757867004385912973023538045279004696975255936551550097394691891190497654199410053552008845417073462140251546849811571353855824643165079477820367721628403801504224662059271760177474263926829058398962250778744038535901830319009823986730904943416598192533922355793971e6","-.1013352126341923706998510249710636450259844152014502328469489251003705529969029651685659469008197397714284789122947470855835668140654385300348985636112591495095078675761642707754452617134314403863147684991140296175396740588029312429525339515646866570017469128591596638640918276324790886107070613309421798727594713223726e6"},
	{0UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",2048,"-.154625263418872635955583229020788032591771510453852224541910858823534084018484198803559066310921621177909865935469343748550057098298653190919318453532937948646781440706111351601535742670452801181086383305115326157260843209727746609111673572819375366052589535330816426986973620454379880787796774813323698811938836028132889847368535213431759495565615715909631182737968997395152359643614699935295277189111815134442686390959837383853138478144747322613874573430155435913043767716473455008586204856546207543538763765558793295157797915895668791466400440837012328600510299312055234540966003587110673379146867723529158484679573301283382e1","-.1546252634188726359555832290207880325713873522971347547103102494817665908766219561287932539380184017508369124027934983605706280732199684601362587945728441612388730889528873760611652553000357671910320564256500696068415436688277149092903655266795145523097944837328486081910580865974107187053025227828097227062369862707103284477967077275634476453944560165252309084983395401808068751448301850897251930390683138377301353212180043355147462803968736326889226836690170199893163386521557791623507224446266029963237607543592381054359228977429872741880102799836266134917524731402700085274623250532036645747291225647114810169759569046009551e1"},
	{1UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",2048,"-.3092505268377452719111664580415760651835430209077044490838217176470681680369683976071181326218432423558197318709386874971001141965973063818386369070658758972935628814122227032030714853409056023621727666102306523145216864194554932182233471456387507321051790706616328539739472409087597615755935496266473976238776720562657796947370704268635189911312314318192623654759379947903047192872293998705905543782236302688853727819196747677062769562894946452277491468603108718260875354329469100171724097130924150870775275311175865903155958317913375829328008816740246572010205986241104690819320071742213467582937354470583169693591466025667641e1","-.3092505268377452719111664580415760651427747045942695094206204989635331817532439122575865078760368035016738248055869967211412561464399369202725175891456883224777461779057747521223305106000715343820641128513001392136830873376554298185807310533590291046195889674656972163821161731948214374106050455656194454124739725414206568955934154551268952907889120330504618169966790803616137502896603701794503860781366276754602706424360086710294925607937472653778453673380340399786326773043115583247014448892532059926475215087184762108718457954859745483760205599672532269835049462805400170549246501064073291494582451294229620339519138092019103e1"},
	{2UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",2048,"-.6185010536754905438223329160831521303670860418154088981676434352941363360739367952142362652436864847116394637418773749942002283931946127636772738141317517945871257628244454064061429706818112047243455332204613046290433728389109864364466942912775014642103581413232657079478944818175195231511870992532947952477553441125315593894741408537270379822624628636385247309518759895806094385744587997411811087564472605377707455638393495354125539125789892904554982937206217436521750708658938200343448194261848301741550550622351731806311916635826751658656017633480493144020411972482209381638640143484426935165874708941166339387182932051335281e1","-.6185010536754905438223329160831521302855494091885390188412409979270663635064878245151730157520736070033476496111739934422825122928798738405450351782913766449554923558115495042446610212001430687641282257026002784273661746753108596371614621067180582092391779349313944327642323463896428748212100911312388908249479450828413137911868309102537905815778240661009236339933581607232275005793207403589007721562732553509205412848720173420589851215874945307556907346760680799572653546086231166494028897785064119852950430174369524217436915909719490967520411199345064539670098925610800341098493002128146582989164902588459240679038276184038205e1"},
	{3UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",2048,"-.1237002107350981087644665832166304260734172083630817796335286870588272672147873590428472530487372969423278927483754749988400456786389225527354547628263503589174251525648890812812285941363622409448691066440922609258086745677821972872893388582555002928420716282646531415895788963635039046302374198506589590495510688225063118778948281707454075964524925727277049461903751979161218877148917599482362217512894521075541491127678699070825107825157978580910996587441243487304350141731787640068689638852369660348310110124470346361262383327165350331731203526696098628804082394496441876327728028696885387033174941788233267877436586410267056e2","-.1237002107350981087644665832166304260571098818377078037682481995854132727012975649030346031504147214006695299222347986884565024585759747681090070356582753289910984711623099008489322042400286137528256451405200556854732349350621719274322924213436116418478355869862788865528464692779285749642420182262477781649895890165682627582373661820507581163155648132201847267986716321446455001158641480717801544312546510701841082569744034684117970243174989061511381469352136159914530709217246233298805779557012823970590086034873904843487383181943898193504082239869012907934019785122160068219698600425629316597832980517691848135807655236807641e2"},
	{4UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",2048,"-.2474004214701962175289331664332608521468344167261635592670573741176545344295747180856945060974745938846557854967509499976800913572778451054709095256527007178348503051297781625624571882727244818897382132881845218516173491355643945745786777165110005856841432565293062831791577927270078092604748397013179180991021376450126237557896563414908151929049851454554098923807503958322437754297835198964724435025789042151082982255357398141650215650315957161821993174882486974608700283463575280137379277704739320696620220248940692722524766654330700663462407053392197257608164788992883752655456057393770774066349883576466535754873172820534112e2","-.2474004214701962175289331664332608521142197636754156075364963991708265454025951298060692063008294428013390598444695973769130049171519495362180140713165506579821969423246198016978644084800572275056512902810401113709464698701243438548645848426872232836956711739725577731056929385558571499284840364524955563299791780331365255164747323641015162326311296264403694535973432642892910002317282961435603088625093021403682165139488069368235940486349978123022762938704272319829061418434492466597611559114025647941180172069747809686974766363887796387008164479738025815868039570244320136439397200851258633195665961035383696271615310473615282e2"},
	{16UL,"-240714745000386851292848972172591647/5909215311060847167846167476692359","-240714745000386851292848972172591645/5909215311060847167846167476692359",2048,"-.1013352126341923706998510249710636450393433770910365938757867004385912973023538045279004696975255936551550097394691891190497654199410053552008845417073462140251546849811571353855824643165079477820367721628403801504224662059271760177474263926829058398962250778744038535901830319009823986730904943416598192533922355793971706903714432374746379030138819155785358919191553621328870504160393297495951128586563191665083589531794390278819928330369416053482288404431866664799723636106680434744270552147861225757335642213966107739146144421613854991754201929069443996716304297571485185087674801108488509057576912312920693045196051587290772e6","-.101335212634192370699851024971063645025984415201450232846948925100370552996902965168565946900819739771428478912294747085583566814065438530034898563611259149509507867576164270775445261713431440386314768499114029617539674058802931242952533951564686657001746912859159663864091827632479088610707061330942179872759471322372720851548050376335981048885710694989975328193471801052893593694915910100402302510083810156694821484113431321322944122320895103919012369969326994220198355699076811431838169461310490539670739847976870284778486430264844140011854417090069537417954900797207352788557709346867553615694477764009316199285363116999282e6"},
	{0UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",10,".24543692606173e-1",".24543692606173e-1"},
	{1UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",10,".49087385212346e-1",".49087385212346e-1"},
	{2UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",10,".98174770424691e-1",".98174770424691e-1"},
	{3UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",10,".19634954084938e0",".19634954084938e0"},
	{4UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",10,".39269908169877e0",".39269908169877e0"},
	{16UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",10,".16084954386381e4",".16084954386381e4"},
	{0UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",24,".245436926061702596e-1",".245436926061702596e-1"},
	{1UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",24,".490873852123405192e-1",".490873852123405192e-1"},
	{2UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",24,".981747704246810383e-1",".981747704246810383e-1"},
	{3UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",24,".196349540849362077e0",".196349540849362077e0"},
	{4UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",24,".392699081698724153e0",".392699081698724153e0"},
	{16UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",24,".160849543863797413e4",".160849543863797413e4"},
	{0UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",53,".24543692606170259675489402e-1",".24543692606170259675489402e-1"},
	{1UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",53,".49087385212340519350978804e-1",".49087385212340519350978804e-1"},
	{2UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",53,".981747704246810387019576079e-1",".981747704246810387019576079e-1"},
	{3UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",53,".196349540849362077403915216e0",".196349540849362077403915216e0"},
	{4UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",53,".392699081698724154807830432e0",".392699081698724154807830432e0"},
	{16UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",53,".160849543863797413809287345e4",".160849543863797413809287345e4"},
	{0UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",113,".245436926061702596754894014318702258683434666e-1",".245436926061702596754894014318720066972373051e-1"},
	{1UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",113,".490873852123405193509788028637404517366869333e-1",".490873852123405193509788028637440133944746101e-1"},
	{2UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",113,".981747704246810387019576057274809034733738666e-1",".981747704246810387019576057274880267889492203e-1"},
	{3UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",113,".196349540849362077403915211454961806946747733e0",".196349540849362077403915211454976053577898441e0"},
	{4UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",113,".392699081698724154807830422909923613893495466e0",".392699081698724154807830422909952107155796881e0"},
	{16UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",113,".160849543863797413809287341223904712250775743e4",".160849543863797413809287341223916383091014402e4"},
	{0UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",256,".2454369260617025967548940143187022586834346700172981590748924614604351290846676263257539e-1",".2454369260617025967548940143187200669723730486350621254524426310900094668521148555208468e-1"},
	{1UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",256,".4908738521234051935097880286374045173668693400345963181497849229208702581693352526515079e-1",".4908738521234051935097880286374401339447460972701242509048852621800189337042297110416937e-1"},
	{2UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",256,".9817477042468103870195760572748090347337386800691926362995698458417405163386705053030158e-1",".9817477042468103870195760572748802678894921945402485018097705243600378674084594220833874e-1"},
	{3UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",256,".1963495408493620774039152114549618069467477360138385272599139691683481032677341010606032e0",".1963495408493620774039152114549760535778984389080497003619541048720075734816918844166775e0"},
	{4UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",256,".3926990816987241548078304229099236138934954720276770545198279383366962065354682021212063e0",".3926990816987241548078304229099521071557968778160994007239082097440151469633837688333549e0"},
	{16UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",256,".1608495438637974138092873412239047122507757453425365215313215235427107661969277755888461e4",".1608495438637974138092873412239163830910144011534743145365128027111486041962019917141422e4"},
	{0UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",512,".245436926061702596754894014318702258683434670017298159074892461460435129084667626325754128609344481725120919853932952061375706201729683218880812771998466505545933715e-1",".245436926061702596754894014318720066972373048635062125452442631090009466852114855520846702206745015710817766530928303096048810224016754968459576548107415515255687997e-1"},
	{1UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",512,".49087385212340519350978802863740451736686934003459631814978492292087025816933525265150825721868896345024183970786590412275141240345936643776162554399693301109186743e-1",".490873852123405193509788028637440133944746097270124250904885262180018933704229711041693404413490031421635533061856606192097620448033509936919153096214831030511375994e-1"},
	{2UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",512,".98174770424681038701957605727480903473373868006919263629956984584174051633867050530301651443737792690048367941573180824550282480691873287552325108799386602218373486e-1",".981747704246810387019576057274880267889492194540248501809770524360037867408459422083386808826980062843271066123713212384195240896067019873838306192429662061022751988e-1"},
	{3UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",512,".196349540849362077403915211454961806946747736013838527259913969168348103267734101060603302887475585380096735883146361649100564961383746575104650217598773204436746972e0",".196349540849362077403915211454976053577898438908049700361954104872007573481691884416677361765396012568654213224742642476839048179213403974767661238485932412204550398e0"},
	{4UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",512,".392699081698724154807830422909923613893495472027677054519827938336696206535468202121206605774951170760193471766292723298201129922767493150209300435197546408873493944e0",".392699081698724154807830422909952107155796877816099400723908209744015146963383768833354723530792025137308426449485284953678096358426807949535322476971864824409100795e0"},
	{16UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",512,".160849543863797413809287341223904712250775745342536521531321523542710766196927775588846225725419999543375246035473499462943182816365565194325729458256915009074583119e4",".160849543863797413809287341223916383091014401153474314536512802711148604196201991714142094758212413496241531473709172717026548268411620536129668086567675832077967686e4"},
	{0UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",1024,".2454369260617025967548940143187022586834346700172981590748924614604351290846676263257541286093444817251209198539329520613757062017296832188808127719984665055459337155912841784634594910908134344593762059812687431668379419493245142340652469049893633475941129922687879414470954515900481797198808689776004304972270920407591e-1",".2454369260617025967548940143187200669723730486350621254524426310900094668521148555208467022067450157108177665309283030960488102240167549684595765481074155152556880011545881346910686910435818343817378422826677652017675148665755593235232206513632982914049099715366475372523416021368234025476799283267666042367275067285051e-1"},
	{1UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",1024,".4908738521234051935097880286374045173668693400345963181497849229208702581693352526515082572186889634502418397078659041227514124034593664377616255439969330110918674311825683569269189821816268689187524119625374863336758838986490284681304938099787266951882259845375758828941909031800963594397617379552008609944541840815181e-1",".4908738521234051935097880286374401339447460972701242509048852621800189337042297110416934044134900314216355330618566061920976204480335099369191530962148310305113760023091762693821373820871636687634756845653355304035350297331511186470464413027265965828098199430732950745046832042736468050953598566535332084734550134570102e-1"},
	{2UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",1024,".9817477042468103870195760572748090347337386800691926362995698458417405163386705053030165144373779269004836794157318082455028248069187328755232510879938660221837348623651367138538379643632537378375048239250749726673517677972980569362609876199574533903764519690751517657883818063601927188795234759104017219889083681630363e-1",".9817477042468103870195760572748802678894921945402485018097705243600378674084594220833868088269800628432710661237132123841952408960670198738383061924296620610227520046183525387642747641743273375269513691306710608070700594663022372940928826054531931656196398861465901490093664085472936101907197133070664169469100269140203e-1"},
	{3UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",1024,".1963495408493620774039152114549618069467477360138385272599139691683481032677341010606033028874755853800967358831463616491005649613837465751046502175987732044367469724730273427707675928726507475675009647850149945334703535594596113872521975239914906780752903938150303531576763612720385437759046951820803443977816736326073e0",".1963495408493620774039152114549760535778984389080497003619541048720075734816918844166773617653960125686542132247426424768390481792134039747676612384859324122045504009236705077528549528348654675053902738261342121614140118932604474588185765210906386331239279772293180298018732817094587220381439426614132833893820053828041e0"},
	{4UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",1024,".3926990816987241548078304229099236138934954720276770545198279383366962065354682021212066057749511707601934717662927232982011299227674931502093004351975464088734939449460546855415351857453014951350019295700299890669407071189192227745043950479829813561505807876300607063153527225440770875518093903641606887955633472652145e0",".3926990816987241548078304229099521071557968778160994007239082097440151469633837688333547235307920251373084264494852849536780963584268079495353224769718648244091008018473410155057099056697309350107805476522684243228280237865208949176371530421812772662478559544586360596037465634189174440762878853228265667787640107656081e0"},
	{16UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",1024,".1608495438637974138092873412239047122507757453425365215313215235427107661969277755888462257254199995433752460354734994629431828163655651943257294582569150090745831198499039991978128120812754924072967903518842835218189136359093136484370002116538291634792778906132728653067684751540539750612211262931602181306627470398319e4",".1608495438637974138092873412239163830910144011534743145365128027111486041962019917141420947582124134962415314737091727170265482684116205361296680865676758320779676884366708799511387773623217909804157123183691466026303585429589585582641778860774511682551217989462573300136945923763885850936475178282297617525817388095931e4"},
	{0UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",2048,".2454369260617025967548940143187022586834346700172981590748924614604351290846676263257541286093444817251209198539329520613757062017296832188808127719984665055459337155912841784634594910908134344593762059812687431668379419493245142340652469049893633475941129922687879414470954515900481797198808689776004304972270920407588850470408737328786256141527491150832553876991503665179977305654723889678735621534285967528461881964725551562550914747483428720916271853407723834274068364585283545526877768906767493943103168571365863280756660579842524126695415353435449112108209972676882160586187360511413242188101018094603323250762007485497809e-1",".245436926061702596754894014318720066972373048635062125452442631090009466852114855520846702206745015710817766530928303096048810224016754968459576548107415515255688001154588134691068691043581834381737842282667765201767514866575559323523220651363298291404909971536647537252341602136823402547679928326766604236727506728504836362639743511718657520269741760504802936469684087189412070933789281486643141695466035800954207885114161604044537209650405697518819545482670871543409933015649985730657517411770908928710855063910859475220045280002336190036266014373305191655394615022501341545640775867585235131205469639565895153968207834753492e-1"},
	{1UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",2048,".4908738521234051935097880286374045173668693400345963181497849229208702581693352526515082572186889634502418397078659041227514124034593664377616255439969330110918674311825683569269189821816268689187524119625374863336758838986490284681304938099787266951882259845375758828941909031800963594397617379552008609944541840815177700940817474657572512283054982301665107753983007330359954611309447779357471243068571935056923763929451103125101829494966857441832543706815447668548136729170567091053755537813534987886206337142731726561513321159685048253390830706870898224216419945353764321172374721022826484376202036189206646501524014970995617e-1",".490873852123405193509788028637440133944746097270124250904885262180018933704229711041693404413490031421635533061856606192097620448033509936919153096214831030511376002309176269382137382087163668763475684565335530403535029733151118647046441302726596582809819943073295074504683204273646805095359856653533208473455013457009672725279487023437315040539483521009605872939368174378824141867578562973286283390932071601908415770228323208089074419300811395037639090965341743086819866031299971461315034823541817857421710127821718950440090560004672380072532028746610383310789230045002683091281551735170470262410939279131790307936415669506984e-1"},
	{2UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",2048,".9817477042468103870195760572748090347337386800691926362995698458417405163386705053030165144373779269004836794157318082455028248069187328755232510879938660221837348623651367138538379643632537378375048239250749726673517677972980569362609876199574533903764519690751517657883818063601927188795234759104017219889083681630355401881634949315145024566109964603330215507966014660719909222618895558714942486137143870113847527858902206250203658989933714883665087413630895337096273458341134182107511075627069975772412674285463453123026642319370096506781661413741796448432839890707528642344749442045652968752404072378413293003048029941991235e-1",".9817477042468103870195760572748802678894921945402485018097705243600378674084594220833868088269800628432710661237132123841952408960670198738383061924296620610227520046183525387642747641743273375269513691306710608070700594663022372940928826054531931656196398861465901490093664085472936101907197133070664169469100269140193454505589740468746300810789670420192117458787363487576482837351571259465725667818641432038168315404566464161781488386016227900752781819306834861736397320625999429226300696470836357148434202556434379008801811200093447601450640574932207666215784600900053661825631034703409405248218785582635806158728313390139679e-1"},
	{3UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",2048,".1963495408493620774039152114549618069467477360138385272599139691683481032677341010606033028874755853800967358831463616491005649613837465751046502175987732044367469724730273427707675928726507475675009647850149945334703535594596113872521975239914906780752903938150303531576763612720385437759046951820803443977816736326071080376326989863029004913221992920666043101593202932143981844523779111742988497227428774022769505571780441250040731797986742976733017482726179067419254691668226836421502215125413995154482534857092690624605328463874019301356332282748359289686567978141505728468949888409130593750480814475682658600609605988398247e0",".1963495408493620774039152114549760535778984389080497003619541048720075734816918844166773617653960125686542132247426424768390481792134039747676612384859324122045504009236705077528549528348654675053902738261342121614140118932604474588185765210906386331239279772293180298018732817094587220381439426614132833893820053828038690901117948093749260162157934084038423491757472697515296567470314251893145133563728286407633663080913292832356297677203245580150556363861366972347279464125199885845260139294167271429686840511286875801760362240018689520290128114986441533243156920180010732365126206940681881049643757116527161231745662678027936e0"},
	{4UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",2048,".3926990816987241548078304229099236138934954720276770545198279383366962065354682021212066057749511707601934717662927232982011299227674931502093004351975464088734939449460546855415351857453014951350019295700299890669407071189192227745043950479829813561505807876300607063153527225440770875518093903641606887955633472652142160752653979726058009826443985841332086203186405864287963689047558223485976994454857548045539011143560882500081463595973485953466034965452358134838509383336453672843004430250827990308965069714185381249210656927748038602712664565496718579373135956283011456937899776818261187500961628951365317201219211976796494e0",".3926990816987241548078304229099521071557968778160994007239082097440151469633837688333547235307920251373084264494852849536780963584268079495353224769718648244091008018473410155057099056697309350107805476522684243228280237865208949176371530421812772662478559544586360596037465634189174440762878853228265667787640107656077381802235896187498520324315868168076846983514945395030593134940628503786290267127456572815267326161826585664712595354406491160301112727722733944694558928250399771690520278588334542859373681022573751603520724480037379040580256229972883066486313840360021464730252413881363762099287514233054322463491325356055872e0"},
	{16UL,"27553278418384340226321974940487/1122396128635116197295347909107229","27553278418384340226321974940489/1122396128635116197295347909107229",2048,".1608495438637974138092873412239047122507757453425365215313215235427107661969277755888462257254199995433752460354734994629431828163655651943257294582569150090745831198499039991978128120812754924072967903518842835218189136359093136484370002116538291634792778906132728653067684751540539750612211262931602181306627470398317429044287070095793360824911456600609622508825151842012349927033879848339856176928709651679452778964402537472033367488910739846539687921849285892029853443414611424396494614630739144830552092554930332159676685077605596611671107406027455930111236487693521492761763748584759782400393883218479233925619389225695844e4",".1608495438637974138092873412239163830910144011534743145365128027111486041962019917141420947582124134962415314737091727170265482684116205361296680865676758320779676884366708799511387773623217909804157123183691466026303585429589585582641778860774511682551217989462573300136945923763885850936475178282297617525817388095929295586195823078399393924839779601644276524447721633804530948071681435150864493415406212225133496795884169488266279057164898779259335773275231823746891337011363746484437106109781828755199459746846208656802088747023310455021672951796892904032794149011464791953511388725806596955868165829859050481046046865840485e4"},
	{0UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",10,".30679615757707e-2",".30679615757707e-2"},
	{1UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",10,".61359231515414e-2",".61359231515414e-2"},
	{2UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",10,".12271846303083e-1",".12271846303083e-1"},
	{3UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",10,".24543692606166e-1",".24543692606166e-1"},
	{4UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",10,".49087385212331e-1",".49087385212331e-1"},
	{16UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",10,".20106192982971e3",".20106192982971e3"},
	{0UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",24,".306796157577128245e-2",".306796157577128245e-2"},
	{1UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",24,".61359231515425649e-2",".61359231515425649e-2"},
	{2UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",24,".122718463030851298e-1",".122718463030851298e-1"},
	{3UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",24,".245436926061702596e-1",".245436926061702596e-1"},
	{4UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",24,".490873852123405192e-1",".490873852123405192e-1"},
	{16UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",24,".201061929829746767e3",".201061929829746767e3"},
	{0UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",53,".306796157577128245943617525e-2",".306796157577128245943617525e-2"},
	{1UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",53,".61359231515425649188723505e-2",".61359231515425649188723505e-2"},
	{2UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",53,".12271846303085129837744701e-1",".12271846303085129837744701e-1"},
	{3UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",53,".24543692606170259675489402e-1",".24543692606170259675489402e-1"},
	{4UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",53,".49087385212340519350978804e-1",".49087385212340519350978804e-1"},
	{16UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",53,".201061929829746767261609181e3",".201061929829746767261609181e3"},
	{0UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",113,".306796157577128245943617517898388953534310279e-2",".306796157577128245943617517898388953535449368e-2"},
	{1UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",113,".613592315154256491887235035796777907068620557e-2",".613592315154256491887235035796777907070898736e-2"},
	{2UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",113,".122718463030851298377447007159355581413724111e-1",".122718463030851298377447007159355581414179747e-1"},
	{3UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",113,".245436926061702596754894014318711162827448223e-1",".245436926061702596754894014318711162828359494e-1"},
	{4UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",113,".490873852123405193509788028637422325654896446e-1",".490873852123405193509788028637422325656718989e-1"},
	{16UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",113,".201061929829746767261609176529888184588245584e3",".201061929829746767261609176529888184588992098e3"},
	{0UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",256,".3067961575771282459436175178983889535343102804591375123225590271401295406615848700531029e-2",".3067961575771282459436175178983889535354493678563128433366098385449908511911903227191083e-2"},
	{1UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",256,".6135923151542564918872350357967779070686205609182750246451180542802590813231697401062059e-2",".6135923151542564918872350357967779070708987357126256866732196770899817023823806454382167e-2"},
	{2UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",256,".1227184630308512983774470071593555814137241121836550049290236108560518162646339480212412e-1",".1227184630308512983774470071593555814141797471425251373346439354179963404764761290876433e-1"},
	{3UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",256,".2454369260617025967548940143187111628274482243673100098580472217121036325292678960424823e-1",".2454369260617025967548940143187111628283594942850502746692878708359926809529522581752867e-1"},
	{4UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",256,".4908738521234051935097880286374223256548964487346200197160944434242072650585357920849647e-1",".4908738521234051935097880286374223256567189885701005493385757416719853619059045163505734e-1"},
	{16UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",256,".2010619298297467672616091765298881845882455854017003600757122840265552957679762604380015e3",".2010619298297467672616091765298881845889920977183131850090806237888452042366584898971948e3"},
	{0UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",512,".306796157577128245943617517898388953534310280459137512322559027140129540661584870053102858263437605134183057781286955890147665905812861067392420752582075093150750533e-2",".306796157577128245943617517898388953535449367856312843336609838544990851191190322719108555636350178096064501731805381902480348401576035113216674139663156947313172665e-2"},
	{1UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",512,".613592315154256491887235035796777907068620560918275024645118054280259081323169740106205716526875210268366115562573911780295331811625722134784841505164150186301501067e-2",".61359231515425649188723503579677790707089873571262568667321967708998170238238064543821711127270035619212900346361076380496069680315207022643334827932631389462634533e-2"},
	{2UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",512,".122718463030851298377447007159355581413724112183655004929023610856051816264633948021241143305375042053673223112514782356059066362325144426956968301032830037260300213e-1",".122718463030851298377447007159355581414179747142525137334643935417996340476476129087643422254540071238425800692722152760992139360630414045286669655865262778925269066e-1"},
	{3UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",512,".245436926061702596754894014318711162827448224367310009858047221712103632529267896042482286610750084107346446225029564712118132724650288853913936602065660074520600427e-1",".245436926061702596754894014318711162828359494285050274669287870835992680952952258175286844509080142476851601385444305521984278721260828090573339311730525557850538132e-1"},
	{4UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",512,".490873852123405193509788028637422325654896448734620019716094443424207265058535792084964573221500168214692892450059129424236265449300577707827873204131320149041200854e-1",".490873852123405193509788028637422325656718988570100549338575741671985361905904516350573689018160284953703202770888611043968557442521656181146678623461051115701076264e-1"},
	{16UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",512,".20106192982974676726160917652988818458824558540170036007571228402655529576797626043800148919152646890073820874754421941216717432803351662912629686441218873304727587e3",".201061929829746767261609176529888184588992097718313185009080623788845204236658489897194983021838452717036831854955975083609521128456870371797679564169646536991160838e3"},
	{0UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",1024,".3067961575771282459436175178983889535343102804591375123225590271401295406615848700531028582634376051341830577812869558901476659058128610673924207525820750931507505329250367573559316786753881373646911981900985612030707151877644650006375826195055845402338632219435953983815390987524707591626977593152656438848094500756715e-2",".3067961575771282459436175178983889535354493678563128433366098385449908511911903227191085556363501780960645017318053819024803484015760351132166741396631569473131726653034814091061628977918650642897244393541241546328959030526187364225557133100115580691421541043552309642636271573809716065671898535483540525846710753377573e-2"},
	{1UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",1024,".613592315154256491887235035796777907068620560918275024645118054280259081323169740106205716526875210268366115562573911780295331811625722134784841505164150186301501065850073514711863357350776274729382396380197122406141430375528930001275165239011169080467726443887190796763078197504941518325395518630531287769618900151343e-2",".6135923151542564918872350357967779070708987357126256866732196770899817023823806454382171112727003561921290034636107638049606968031520702264333482793263138946263453306069628182123257955837301285794488787082483092657918061052374728451114266200231161382843082087104619285272543147619432131343797070967081051693421506755146e-2"},
	{2UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",1024,".1227184630308512983774470071593555814137241121836550049290236108560518162646339480212411433053750420536732231125147823560590663623251444269569683010328300372603002131700147029423726714701552549458764792760394244812282860751057860002550330478022338160935452887774381593526156395009883036650791037261062575539237800302686e-1",".1227184630308512983774470071593555814141797471425251373346439354179963404764761290876434222545400712384258006927221527609921393606304140452866696558652627789252690661213925636424651591167460257158897757416496618531583612210474945690222853240046232276568616417420923857054508629523886426268759414193416210338684301351029e-1"},
	{3UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",1024,".2454369260617025967548940143187111628274482243673100098580472217121036325292678960424822866107500841073464462250295647121181327246502888539139366020656600745206004263400294058847453429403105098917529585520788489624565721502115720005100660956044676321870905775548763187052312790019766073301582074522125151078475600605372e-1",".2454369260617025967548940143187111628283594942850502746692878708359926809529522581752868445090801424768516013854443055219842787212608280905733393117305255578505381322427851272849303182334920514317795514832993237063167224420949891380445706480092464553137232834841847714109017259047772852537518828386832420677368602702058e-1"},
	{4UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",1024,".4908738521234051935097880286374223256548964487346200197160944434242072650585357920849645732215001682146928924500591294242362654493005777078278732041313201490412008526800588117694906858806210197835059171041576979249131443004231440010201321912089352643741811551097526374104625580039532146603164149044250302156951201210744e-1",".4908738521234051935097880286374223256567189885701005493385757416719853619059045163505736890181602849537032027708886110439685574425216561811466786234610511157010762644855702545698606364669841028635591029665986474126334448841899782760891412960184929106274465669683695428218034518095545705075037656773664841354737205404117e-1"},
	{16UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",1024,".2010619298297467672616091765298881845882455854017003600757122840265552957679762604380014891915264689007382087475442194121671743280335166291262968644121887330472758692577520893007833849367023697033240236458629930700444239054533197828178461455191798842876646011329546802833254637584192367248656035448524923763487212015921e3",".2010619298297467672616091765298881845889920977183131850090806237888452042366584898971949830218384527170368318549559750836095211284568703717976795641696465369911608379332895762718149166968766885329138085751188059802146590245642151018861122748491746961930021138302441647398106938611935520798735424214493119018900359333526e3"},
	{0UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",2048,".3067961575771282459436175178983889535343102804591375123225590271401295406615848700531028582634376051341830577812869558901476659058128610673924207525820750931507505329250367573559316786753881373646911981900985612030707151877644650006375826195055845402338632219435953983815390987524707591626977593152656438848094500756717076652097324643482849221029229503318438295358756198767502537770850947608897149389166777310097239497539950790504614459396797804380195509139687290066969088599524345991096494364570306554735999068564626535675989022511193366831765240619827490826031200655919719992241905314921032127047091588272219915255128489228853e-2",".3067961575771282459436175178983889535354493678563128433366098385449908511911903227191085556363501780960645017318053819024803484015760351132166741396631569473131726653034814091061628977918650642897244393541241546328959030526187364225557133100115580691421541043552309642636271573809716065671898535483540525846710753377573924173111213396860957120378964592627523190640225574981129285677001821850097624050862277681460576619376183077575107190675044204735577422046249343888553495652788949461554568285865660234173184002833436826977409539310086699580440459634265207300961282840649694105696873597597803174180160423248066035193683017417769e-2"},
	{1UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",2048,".6135923151542564918872350357967779070686205609182750246451180542802590813231697401062057165268752102683661155625739117802953318116257221347848415051641501863015010658500735147118633573507762747293823963801971224061414303755289300012751652390111690804677264438871907967630781975049415183253955186305312877696189001513434153304194649286965698442058459006636876590717512397535005075541701895217794298778333554620194478995079901581009228918793595608760391018279374580133938177199048691982192988729140613109471998137129253071351978045022386733663530481239654981652062401311839439984483810629842064254094183176544439830510256978457707e-2",".6135923151542564918872350357967779070708987357126256866732196770899817023823806454382171112727003561921290034636107638049606968031520702264333482793263138946263453306069628182123257955837301285794488787082483092657918061052374728451114266200231161382843082087104619285272543147619432131343797070967081051693421506755147848346222426793721914240757929185255046381280451149962258571354003643700195248101724555362921153238752366155150214381350088409471154844092498687777106991305577898923109136571731320468346368005666873653954819078620173399160880919268530414601922565681299388211393747195195606348360320846496132070387366034835539e-2"},
	{2UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",2048,".1227184630308512983774470071593555814137241121836550049290236108560518162646339480212411433053750420536732231125147823560590663623251444269569683010328300372603002131700147029423726714701552549458764792760394244812282860751057860002550330478022338160935452887774381593526156395009883036650791037261062575539237800302686830660838929857393139688411691801327375318143502479507001015108340379043558859755666710924038895799015980316201845783758719121752078203655874916026787635439809738396438597745828122621894399627425850614270395609004477346732706096247930996330412480262367887996896762125968412850818836635308887966102051395691541e-1",".1227184630308512983774470071593555814141797471425251373346439354179963404764761290876434222545400712384258006927221527609921393606304140452866696558652627789252690661213925636424651591167460257158897757416496618531583612210474945690222853240046232276568616417420923857054508629523886426268759414193416210338684301351029569669244485358744382848151585837051009276256090229992451714270800728740039049620344911072584230647750473231030042876270017681894230968818499737555421398261115579784621827314346264093669273601133374730790963815724034679832176183853706082920384513136259877642278749439039121269672064169299226414077473206967108e-1"},
	{3UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",2048,".2454369260617025967548940143187111628274482243673100098580472217121036325292678960424822866107500841073464462250295647121181327246502888539139366020656600745206004263400294058847453429403105098917529585520788489624565721502115720005100660956044676321870905775548763187052312790019766073301582074522125151078475600605373661321677859714786279376823383602654750636287004959014002030216680758087117719511333421848077791598031960632403691567517438243504156407311749832053575270879619476792877195491656245243788799254851701228540791218008954693465412192495861992660824960524735775993793524251936825701637673270617775932204102791383083e-1",".2454369260617025967548940143187111628283594942850502746692878708359926809529522581752868445090801424768516013854443055219842787212608280905733393117305255578505381322427851272849303182334920514317795514832993237063167224420949891380445706480092464553137232834841847714109017259047772852537518828386832420677368602702059139338488970717488765696303171674102018552512180459984903428541601457480078099240689822145168461295500946462060085752540035363788461937636999475110842796522231159569243654628692528187338547202266749461581927631448069359664352367707412165840769026272519755284557498878078242539344128338598452828154946413934216e-1"},
	{4UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",2048,".4908738521234051935097880286374223256548964487346200197160944434242072650585357920849645732215001682146928924500591294242362654493005777078278732041313201490412008526800588117694906858806210197835059171041576979249131443004231440010201321912089352643741811551097526374104625580039532146603164149044250302156951201210747322643355719429572558753646767205309501272574009918028004060433361516174235439022666843696155583196063921264807383135034876487008312814623499664107150541759238953585754390983312490487577598509703402457081582436017909386930824384991723985321649921049471551987587048503873651403275346541235551864408205582766165e-1",".4908738521234051935097880286374223256567189885701005493385757416719853619059045163505736890181602849537032027708886110439685574425216561811466786234610511157010762644855702545698606364669841028635591029665986474126334448841899782760891412960184929106274465669683695428218034518095545705075037656773664841354737205404118278676977941434977531392606343348204037105024360919969806857083202914960156198481379644290336922591001892924120171505080070727576923875273998950221685593044462319138487309257385056374677094404533498923163855262896138719328704735414824331681538052545039510569114997756156485078688256677196905656309892827868431e-1"},
	{16UL,"538666713754363972482835453879479448676/175577500044516718622238907027050738735611","538666713754363972482835453879479448678/175577500044516718622238907027050738735611",2048,".2010619298297467672616091765298881845882455854017003600757122840265552957679762604380014891915264689007382087475442194121671743280335166291262968644121887330472758692577520893007833849367023697033240236458629930700444239054533197828178461455191798842876646011329546802833254637584192367248656035448524923763487212015922103354718502678352920065493715847294771721246314462424270463153504877024966835823684339177945326877107782150065104132110285409078604928869785462418288861904584275388724998546764796103711784349574513646420616165792935684886865668092610144387747807661863547694115655067186647614781581943290082043661601006701021e3",".2010619298297467672616091765298881845889920977183131850090806237888452042366584898971949830218384527170368318549559750836095211284568703717976795641696465369911608379332895762718149166968766885329138085751188059802146590245642151018861122748491746961930021138302441647398106938611935520798735424214493119018900359333526846946090164811766796858411558235424373598217978232819632888661279913967679978897973102301322003493274375341719622248480796970015508019312229970010802418911011765919124401871824919091067737868096921158927915115682258419437037459625912046256757986322448183529109503080921696288230709934979852556824532102294909e3"},
	{0UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",10,".47936899621417e-4",".47936899621417e-4"},
	{1UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",10,".95873799242835e-4",".95873799242835e-4"},
	{2UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",10,".19174759848567e-3",".19174759848567e-3"},
	{3UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",10,".38349519697134e-3",".38349519697134e-3"},
	{4UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",10,".76699039394268e-3",".76699039394268e-3"},
	{16UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",10,".31415926535892e1",".31415926535892e1"},
	{0UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",24,".479368996214262874e-4",".479368996214262874e-4"},
	{1UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",24,".958737992428525748e-4",".958737992428525748e-4"},
	{2UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",24,".19174759848570515e-3",".19174759848570515e-3"},
	{3UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",24,".383495196971410299e-3",".383495196971410299e-3"},
	{4UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",24,".766990393942820599e-3",".766990393942820599e-3"},
	{16UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",24,".314159265358979317e1",".314159265358979317e1"},
	{0UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",53,".479368996214262884286902382e-4",".479368996214262884286902382e-4"},
	{1UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",53,".958737992428525768573804765e-4",".958737992428525768573804765e-4"},
	{2UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",53,".191747598485705153714760953e-3",".191747598485705153714760953e-3"},
	{3UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",53,".383495196971410307429521906e-3",".383495196971410307429521906e-3"},
	{4UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",53,".766990393942820614859043812e-3",".766990393942820614859043812e-3"},
	{16UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",53,".314159265358979323846264345e1",".314159265358979323846264345e1"},
	{0UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",113,".479368996214262884286902371716222987411122087e-4",".479368996214262884286902371716242492385377361e-4"},
	{1UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",113,".958737992428525768573804743432445974822244174e-4",".958737992428525768573804743432484984770754721e-4"},
	{2UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",113,".191747598485705153714760948686489194964448835e-3",".191747598485705153714760948686496996954150944e-3"},
	{3UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",113,".383495196971410307429521897372978389928897669e-3",".383495196971410307429521897372993993908301889e-3"},
	{4UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",113,".766990393942820614859043794745956779857795339e-3",".766990393942820614859043794745987987816603777e-3"},
	{16UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",113,".314159265358979323846264338327943897029752971e1",".314159265358979323846264338327956679809680907e1"},
	{0UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",256,".4793689962142628842869023717162229874111220898473825865811903330902603764019377321977443e-4",".4793689962142628842869023717162424923853773606455085941362610195427374824487092769292438e-4"},
	{1UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",256,".9587379924285257685738047434324459748222441796947651731623806661805207528038754643954886e-4",".9587379924285257685738047434324849847707547212910171882725220390854749648974185538584877e-4"},
	{2UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",256,".1917475984857051537147609486864891949644488359389530346324761332361041505607750928790977e-3",".1917475984857051537147609486864969969541509442582034376545044078170949929794837107716975e-3"},
	{3UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",256,".3834951969714103074295218973729783899288976718779060692649522664722083011215501857581954e-3",".3834951969714103074295218973729939939083018885164068753090088156341899859589674215433951e-3"},
	{4UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",256,".7669903939428206148590437947459567798577953437558121385299045329444166022431003715163909e-3",".7669903939428206148590437947459879878166037770328137506180176312683799719179348430867902e-3"},
	{16UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",256,".3141592653589793238462643383279438970297529728023806519418488966940330402787739121731137e1",".3141592653589793238462643383279566798096809070726405122531400217675284364975861117283492e1"},
	{0UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",512,".479368996214262884286902371716222987411122089847382586581190333090260376401937732197744555884201475652361276552596827904843987012202068282228117182875702349694478949e-4",".479368996214262884286902371716242492385377360645508594136261019542737482448709276929243719735263509485273277013947143451383901637444972276788961014477890365328096486e-4"},
	{1UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",512,".958737992428525768573804743432445974822244179694765173162380666180520752803875464395489111768402951304722553105193655809687974024404136564456234365751404699388957899e-4",".958737992428525768573804743432484984770754721291017188272522039085474964897418553858487439470527018970546554027894286902767803274889944553577922028955780730656192971e-4"},
	{2UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",512,".19174759848570515371476094868648919496444883593895303463247613323610415056077509287909782235368059026094451062103873116193759480488082731289124687315028093987779158e-3",".191747598485705153714760948686496996954150944258203437654504407817094992979483710771697487894105403794109310805578857380553560654977988910715584405791156146131238594e-3"},
	{3UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",512,".383495196971410307429521897372978389928897671877906069264952266472208301121550185758195644707361180521889021242077462323875189609761654625782493746300561879755583159e-3",".383495196971410307429521897372993993908301888516406875309008815634189985958967421543394975788210807588218621611157714761107121309955977821431168811582312292262477189e-3"},
	{4UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",512,".766990393942820614859043794745956779857795343755812138529904532944416602243100371516391289414722361043778042484154924647750379219523309251564987492601123759511166319e-3",".766990393942820614859043794745987987816603777032813750618017631268379971917934843086789951576421615176437243222315429522214242619911955642862337623164624584524954377e-3"},
	{16UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",512,".314159265358979323846264338327943897029752972802380651941848896694033040278773912173113872144270279083531486201509857135718555328316747469441018876969420291895773724e1",".314159265358979323846264338327956679809680907072640512253140021767528436497586111728349164165702293576268694823860399932298953777115937031316413490448230229821421313e1"},
	{0UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",1024,".47936899621426288428690237171622298741112208984738258658119033309026037640193773219774455588420147565236127655259682790484398701220206828222811718287570234969447895209981130572044105807543692299887555456264837646021865710740883060737158676318843853503300498860371929946074279809368308716768668517093338779052321650985e-4",".4793689962142628842869023717162424923853773606455085941362610195427374824487092769292437197352635094852732770139471434513839016374449722767889610144778903653280964827456960280551341253235653267425761071345972672908396142445383833375039596861540951788216796911648836332951170795308787910119095001636940914287990239603233e-4"},
	{1UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",1024,".9587379924285257685738047434324459748222441796947651731623806661805207528038754643954891117684029513047225531051936558096879740244041365644562343657514046993889579041996226114408821161508738459977511091252967529204373142148176612147431735263768770700660099772074385989214855961873661743353733703418667755810464330197e-4",".9587379924285257685738047434324849847707547212910171882725220390854749648974185538584874394705270189705465540278942869027678032748899445535779220289557807306561929654913920561102682506471306534851522142691945345816792284890767666750079193723081903576433593823297672665902341590617575820238190003273881828575980479206466e-4"},
	{2UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",1024,".19174759848570515371476094868648919496444883593895303463247613323610415056077509287909782235368059026094451062103873116193759480488082731289124687315028093987779158083992452228817642323017476919955022182505935058408746284296353224294863470527537541401320199544148771978429711923747323486707467406837335511620928660394e-3",".1917475984857051537147609486864969969541509442582034376545044078170949929794837107716974878941054037941093108055788573805535606549779889107155844057911561461312385930982784112220536501294261306970304428538389069163358456978153533350015838744616380715286718764659534533180468318123515164047638000654776365715196095841293e-3"},
	{3UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",1024,".38349519697141030742952189737297838992889767187790606926495226647220830112155018575819564470736118052188902124207746232387518960976165462578249374630056187975558316167984904457635284646034953839910044365011870116817492568592706448589726941055075082802640399088297543956859423847494646973414934813674671023241857320788e-3",".3834951969714103074295218973729939939083018885164068753090088156341899859589674215433949757882108075882186216111577147611071213099559778214311688115823122922624771861965568224441073002588522613940608857076778138326716913956307066700031677489232761430573437529319069066360936636247030328095276001309552731430392191682586e-3"},
	{4UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",1024,".76699039394282061485904379474595677985779534375581213852990453294441660224310037151639128941472236104377804248415492464775037921952330925156498749260112375951116632335969808915270569292069907679820088730023740233634985137185412897179453882110150165605280798176595087913718847694989293946829869627349342046483714641576e-3",".7669903939428206148590437947459879878166037770328137506180176312683799719179348430867899515764216151764372432223154295222142426199119556428623376231646245845249543723931136448882146005177045227881217714153556276653433827912614133400063354978465522861146875058638138132721873272494060656190552002619105462860784383365173e-3"},
	{16UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",1024,".3141592653589793238462643383279438970297529728023806519418488966940330402787739121731138721442702790835314862015098571357185553283167474694410188769694202918957737260481323373169482518203183418565430834381772399969688991219114512268470431011231750783192301493313334800945924001586761480062151459936229050223972951718953e1",".3141592653589793238462643383279566798096809070726405122531400217675284364975861117283491641657022935762686948238603999322989537771159370313164134904482302298214213109322193489462127003720517725340146775717296650917246495913006749040665950199179478163925760024018181379162879292413567244775650100272785597587777283426375e1"},
	{0UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",2048,".4793689962142628842869023717162229874111220898473825865811903330902603764019377321977445558842014756523612765525968279048439870122020682822281171828757023496944789520998113057204410580754369229988755545626483764602186571074088306073715867631884385350330049886037192994607427980936830871676866851709333877905232165098497921747489589807943896430096081343687228256664828309656845896577064066872726337705170442801888210708069494824970189563554654829062252784032887313225002730646685686651655632619949895745307010876685076570296509237913338146203252976249329081970991253346704162069926461121227808851695427335830562659963826707798583e-4",".4793689962142628842869023717162424923853773606455085941362610195427374824487092769292437197352635094852732770139471434513839016374449722767889610144778903653280964827456960280551341253235653267425761071345972672908396142445383833375039596861540951788216796911648836332951170795308787910119095001636940914287990239603237894817153495529226029200878591403388699589688448322319034094331341542260120058444260441294954253722387525556764920707069824578727411790799487809238966041165501152561371871574454550212096909858745446502302269625615966232259899986845192366051138936841205200834637012278519444187395008428449950498574275375683467e-4"},
	{1UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",2048,".9587379924285257685738047434324459748222441796947651731623806661805207528038754643954891117684029513047225531051936558096879740244041365644562343657514046993889579041996226114408821161508738459977511091252967529204373142148176612147431735263768770700660099772074385989214855961873661743353733703418667755810464330196995843494979179615887792860192162687374456513329656619313691793154128133745452675410340885603776421416138989649940379127109309658124505568065774626450005461293371373303311265239899791490614021753370153140593018475826676292406505952498658163941982506693408324139852922242455617703390854671661125319927653415597167e-4",".9587379924285257685738047434324849847707547212910171882725220390854749648974185538584874394705270189705465540278942869027678032748899445535779220289557807306561929654913920561102682506471306534851522142691945345816792284890767666750079193723081903576433593823297672665902341590617575820238190003273881828575980479206475789634306991058452058401757182806777399179376896644638068188662683084520240116888520882589908507444775051113529841414139649157454823581598975618477932082331002305122743743148909100424193819717490893004604539251231932464519799973690384732102277873682410401669274024557038888374790016856899900997148550751366934e-4"},
	{2UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",2048,".1917475984857051537147609486864891949644488359389530346324761332361041505607750928790978223536805902609445106210387311619375948048808273128912468731502809398777915808399245222881764232301747691995502218250593505840874628429635322429486347052753754140132019954414877197842971192374732348670746740683733551162092866039399168698995835923177558572038432537474891302665931323862738358630825626749090535082068177120755284283227797929988075825421861931624901113613154925290001092258674274660662253047979958298122804350674030628118603695165335258481301190499731632788396501338681664827970584448491123540678170934332225063985530683119433e-3",".1917475984857051537147609486864969969541509442582034376545044078170949929794837107716974878941054037941093108055788573805535606549779889107155844057911561461312385930982784112220536501294261306970304428538389069163358456978153533350015838744616380715286718764659534533180468318123515164047638000654776365715196095841295157926861398211690411680351436561355479835875379328927613637732536616904048023377704176517981701488955010222705968282827929831490964716319795123695586416466200461024548748629781820084838763943498178600920907850246386492903959994738076946420455574736482080333854804911407777674958003371379980199429710150273387e-3"},
	{3UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",2048,".3834951969714103074295218973729783899288976718779060692649522664722083011215501857581956447073611805218890212420774623238751896097616546257824937463005618797555831616798490445763528464603495383991004436501187011681749256859270644858972694105507508280264039908829754395685942384749464697341493481367467102324185732078798337397991671846355117144076865074949782605331862647725476717261651253498181070164136354241510568566455595859976151650843723863249802227226309850580002184517348549321324506095959916596245608701348061256237207390330670516962602380999463265576793002677363329655941168896982247081356341868664450127971061366238867e-3",".3834951969714103074295218973729939939083018885164068753090088156341899859589674215433949757882108075882186216111577147611071213099559778214311688115823122922624771861965568224441073002588522613940608857076778138326716913956307066700031677489232761430573437529319069066360936636247030328095276001309552731430392191682590315853722796423380823360702873122710959671750758657855227275465073233808096046755408353035963402977910020445411936565655859662981929432639590247391172832932400922049097497259563640169677527886996357201841815700492772985807919989476153892840911149472964160667709609822815555349916006742759960398859420300546774e-3"},
	{4UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",2048,".7669903939428206148590437947459567798577953437558121385299045329444166022431003715163912894147223610437780424841549246477503792195233092515649874926011237595111663233596980891527056929206990767982008873002374023363498513718541289717945388211015016560528079817659508791371884769498929394682986962734934204648371464157596674795983343692710234288153730149899565210663725295450953434523302506996362140328272708483021137132911191719952303301687447726499604454452619701160004369034697098642649012191919833192491217402696122512474414780661341033925204761998926531153586005354726659311882337793964494162712683737328900255942122732477733e-3",".7669903939428206148590437947459879878166037770328137506180176312683799719179348430867899515764216151764372432223154295222142426199119556428623376231646245845249543723931136448882146005177045227881217714153556276653433827912614133400063354978465522861146875058638138132721873272494060656190552002619105462860784383365180631707445592846761646721405746245421919343501517315710454550930146467616192093510816706071926805955820040890823873131311719325963858865279180494782345665864801844098194994519127280339355055773992714403683631400985545971615839978952307785681822298945928321335419219645631110699832013485519920797718840601093547e-3"},
	{16UL,"49153512248327896072972053795471/1025379459223664701674086403506278231","49153512248327896072972053795473/1025379459223664701674086403506278231",2048,".314159265358979323846264338327943897029752972802380651941848896694033040278773912173113872144270279083531486201509857135718555328316747469441018876969420291895773726048132337316948251820318341856543083438177239996968899121911451226847043101123175078319230149331333480094592400158676148006215145993622905022397295171895159799643477757653411196442776786939886191028786188101671052678074470686570993267846050139464545776964042412849246343237117858877423798454379302959513778955661193160402903539381036367564440264814433178110952029415888528749576387051476030716050882779329603965414700556040785680904711525880991754483389347122288e1",".3141592653589793238462643383279566798096809070726405122531400217675284364975861117283491641657022935762686948238603999322989537771159370313164134904482302298214213109322193489462127003720517725340146775717296650917246495913006749040665950199179478163925760024018181379162879292413567244775650100272785597587777283426377986747369714830033570497087793662124818163098221492515002184060987993135592281502030522807061219719503888748881458434585280235914796591218352330662848784738222835342620669755034534026999830845027415819748815421843679629973848055378865269015274413648252240418987712366850502942651192723668959558745637110207917e1"},
	{ULONG_MAX,NULL,NULL,0,NULL,NULL}}; /* test_table */

/* End of file tests/test_mpri_2exp_atan_table.c */
