;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2012, 2013, 2014, 2015 Ludovic Courtès <ludo@gnu.org>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (guix config)
  #:export (%guix-package-name
            %guix-version
            %guix-bug-report-address
            %guix-home-page-url
            %store-directory
            %state-directory
            %config-directory
            %guix-register-program
            %system
            %libgcrypt
            %nix-instantiate
            %gzip
            %bzip2
            %xz))

;;; Commentary:
;;;
;;; Compile-time configuration of Guix.
;;;
;;; Code:

(define %guix-package-name
  "GNU Guix")

(define %guix-version
  "0.9.0")

(define %guix-bug-report-address
  "bug-guix@gnu.org")

(define %guix-home-page-url
  "http://www.gnu.org/software/guix/")

(define %store-directory
  (or (and=> (getenv "NIX_STORE_DIR") canonicalize-path)
      "/gnu/store"))

(define %state-directory
  ;; This must match `NIX_STATE_DIR' as defined in `daemon.am'.
  (or (getenv "NIX_STATE_DIR") "/var/guix"))

(define %config-directory
  ;; This must match `NIX_CONF_DIR' as defined in `daemon.am'.
  (or (getenv "NIX_CONF_DIR") "/etc/guix"))

(define %guix-register-program
  ;; The 'guix-register' program.
  (or (getenv "GUIX_REGISTER") "/gnu/store/632msbms2yaldfnlrb5lbnlnmn9yjisw-guix-0.9.0/sbin/guix-register"))

(define %system
  "x86_64-linux")

(define %libgcrypt
  "/gnu/store/768cgiv2b8lhbx814d8yvsryq39bwjbb-libgcrypt-1.6.3/lib/libgcrypt")

(define %nix-instantiate
  "nix-instantiate")

(define %gzip
  "/gnu/store/8m7mgixi5539vqrr1vd1nrvh96vjl66j-gzip-1.6/bin/gzip")

(define %bzip2
  "/gnu/store/yq9vkx7f4zw17gs6b09bg4arcgmmjgxn-bzip2-1.0.6/bin/bzip2")

(define %xz
  "/gnu/store/hk31a1xlgf6n3yi1yzbdyd2bnjmxc60m-xz-5.0.4/bin/xz")

;;; config.scm ends here
