;;; auth.scm -- API for SSH user authentication.

;; Copyright (C) 2013, 2014 Artyom V. Poptsov <poptsov.artyom@gmail.com>
;;
;; This file is a part of Guile-SSH.
;;
;; Guile-SSH is free software: you can redistribute it and/or
;; modify it under the terms of the GNU General Public License as
;; published by the Free Software Foundation, either version 3 of the
;; License, or (at your option) any later version.
;;
;; Guile-SSH is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;; General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with Guile-SSH.  If not, see <http://www.gnu.org/licenses/>.


;;; Commentary:

;; This module contains API that is used for SSH user authentication.
;;
;; These methods are exported:
;;
;;   userauth-public-key!
;;   userauth-public-key/auto!
;;   userauth-public-key/try
;;   userauth-agent!
;;   userauth-password!
;;   userauth-none!
;;   userauth-get-list


;;; Code:

(define-module (ssh auth)
  #:use-module (ssh log)
  #:use-module (ssh session)
  #:export (userauth-public-key!
            userauth-public-key/auto!
            userauth-public-key/try
            userauth-agent!
            userauth-password!
            userauth-none!
            userauth-get-list))

(load-extension "/gnu/store/d2dy1w5z26bbiqc7cjdbyvinjqv6zqq1-guile-ssh-0.11.2/lib/libguile-ssh" "init_auth_func")

;;; auth.scm ends here.
