@echo off
echo Configuring GNU Sh-utils for DJGPP v2.x...

Rem The SmallEnv tests protect against fixed and too small size
Rem of the environment in stock DOS shell.

Rem Find out where the sources are
set XSRC=.
if not "%XSRC%" == "." goto SmallEnv
if "%1" == "" goto InPlace
set XSRC=%1
if not "%XSRC%" == "%1" goto SmallEnv
redir -e /dev/null update %XSRC%/configure.orig ./configure
if not exist configure update %XSRC%/configure ./configure

:InPlace
Rem Update configuration files
echo Updating configuration scripts...
if not exist configure.orig update configure configure.orig
sed -f %XSRC%/djgpp/config.sed configure.orig > configure
if errorlevel 1 goto SedError

Rem Make sure they have a config.site file
set CONFIG_SITE=%XSRC%/djgpp/config.site
if not "%CONFIG_SITE%" == "%XSRC%/djgpp/config.site" goto SmallEnv

Rem This is required because DOS/Windows are case-insensitive
Rem to file names, and "make install" will do nothing if Make
Rem finds a file called `install'.
if exist INSTALL ren INSTALL INSTALL.txt

Rem Set HOSTNAME so it shows in config.status
if not "%HOSTNAME%" == "" goto hostdone
if "%windir%" == "" goto msdos
set OS=MS-Windows
if not "%OS%" == "MS-Windows" goto SmallEnv
goto haveos
:msdos
set OS=MS-DOS
if not "%OS%" == "MS-DOS" goto SmallEnv
:haveos
if not "%USERNAME%" == "" goto haveuname
if not "%USER%" == "" goto haveuser
echo No USERNAME and no USER found in the environment, using default values
set HOSTNAME=Unknown PC
if not "%HOSTNAME%" == "Unknown PC" goto SmallEnv
:haveuser
set HOSTNAME=%USER%'s PC
if not "%HOSTNAME%" == "%USER%'s PC" goto SmallEnv
goto userdone
:haveuname
set HOSTNAME=%USERNAME%'s PC
if not "%HOSTNAME%" == "%USERNAME%'s PC" goto SmallEnv
:userdone
set HOSTNAME=%HOSTNAME%, %OS%
if not "%HOSTNAME%" == "%HOSTNAME%, %OS%" goto SmallEnv
:hostdone
set OS=

Rem install-sh is required by the configure script but clashes with the
Rem various Makefile install-foo targets, so we MUST have it before the
Rem script runs and rename it afterwards
if not exist install-sh if exist install-sh.sh ren install-sh.sh install-sh
echo Running the ./configure script...
sh ./configure --src=%XSRC% --disable-nls --config-cache
if errorlevel 1 goto CfgError
if not exist install-sh.sh if exist install-sh ren install-sh install-sh.sh
if "%XSRC%" == "." call djgpp\edtests
Rem edit the various Makefiles.
rem
echo    intl/Makefile...
if not exist intl\Makefile.orig mv -f intl/Makefile intl/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed intl/Makefile.orig > intl\Makefile
rem
echo    lib/Makefile...
if not exist lib\Makefile.orig mv -f lib/Makefile lib/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed lib/Makefile.orig > lib\Makefile.temp
sed -e "s/\.sed/.se/g" lib/Makefile.temp > lib\Makefile
rem
echo    src/Makefile...
if not exist src\Makefile.orig mv -f src/Makefile src/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed src/Makefile.orig > src\Makefile
rem
echo    po/Makefile...
if not exist po\Makefile.orig mv -f po/Makefile po/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed po/Makefile.orig > po\Makefile
rem
echo    m4/Makefile...
if not exist m4\Makefile.orig mv -f m4/Makefile m4/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed m4/Makefile.orig > m4\Makefile
rem
echo    doc/Makefile...
if not exist doc\Makefile.orig mv -f doc/Makefile doc/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed doc/Makefile.orig > doc\Makefile
rem
echo    man/Makefile...
if not exist man\Makefile.orig mv -f man/Makefile man/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed man/Makefile.orig > man\Makefile.temp
sed -e "s/^MANS *=.*/MANS = /g" man/Makefile.temp > man\Makefile
rem
echo    tests/Makefile...
if not exist tests\Makefile.orig mv -f tests/Makefile tests/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed tests/Makefile.orig > tests\Makefile.temp
sed -e "s/^\( *SUBDIRS *=.*\)stty */\1/" tests/Makefile.temp > tests\Makefile
rem
echo    tests/basename/Makefile...
if not exist tests\basename\Makefile.orig mv -f tests/basename/Makefile tests/basename/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed tests/basename/Makefile.orig > tests\basename\Makefile
rem
echo    tests/date/Makefile...
if not exist tests\date\Makefile.orig mv -f tests/date/Makefile tests/date/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed tests/date/Makefile.orig > tests\date\Makefile
rem
echo    tests/factor/Makefile...
if not exist tests\factor\Makefile.orig mv -f tests/factor/Makefile tests/factor/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed tests/factor/Makefile.orig > tests\factor\Makefile
rem
echo    tests/seq/Makefile...
if not exist tests\seq\Makefile.orig mv -f tests/seq/Makefile tests/seq/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed tests/seq/Makefile.orig > tests\seq\Makefile
rem
echo    tests/stty/Makefile...
if not exist tests\stty\Makefile.orig mv -f tests/stty/Makefile tests/stty/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed tests/stty/Makefile.orig > tests\stty\Makefile
rem
echo    tests/test/Makefile...
if not exist tests\test\Makefile.orig mv -f tests/test/Makefile tests/test/Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed tests/test/Makefile.orig > tests\test\Makefile
rem
echo    Makefile.maint...
if not exist Makemaint.orig mv -f Makefile.maint Makemaint.orig
sed -f %XSRC%/djgpp/tscript.sed Makemaint.orig > Makefile.maint
rem
echo    Makefile...
if not exist Makefile.orig mv -f Makefile Makefile.orig
sed -f %XSRC%/djgpp/tscript.sed Makefile.orig > Makefile
Rem workaround for bug in ported BASH.
cp -f lib/Makefile lib/Makefile.temp
sed -e "s|\`test -f .*\`||g" lib/Makefile.temp > lib\Makefile
cp -f src/Makefile src/Makefile.temp
sed -e "s|\`test -f .*\`||g" src/Makefile.temp > src\Makefile
echo Done.
goto End

:SedError
echo ./configure script editing failed!
goto End

:CfgError
echo ./configure script exited abnormally!
goto End

:SmallEnv
echo Your environment size is too small.  Enlarge it and run me again.
echo Configuration NOT done!
:End
set XSRC=
set CONFIG_SITE=
