/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;

public class RSAEncryptOutput {
    private final ByteBuffer cipherText;

    protected RSAEncryptOutput(BuilderImpl builder) {
        this.cipherText = builder.cipherText();
    }

    public ByteBuffer cipherText() {
        return this.cipherText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer cipherText;

        protected BuilderImpl() {
        }

        protected BuilderImpl(RSAEncryptOutput model) {
            this.cipherText = model.cipherText();
        }

        @Override
        public Builder cipherText(ByteBuffer cipherText) {
            this.cipherText = cipherText;
            return this;
        }

        @Override
        public ByteBuffer cipherText() {
            return this.cipherText;
        }

        @Override
        public RSAEncryptOutput build() {
            if (Objects.isNull(this.cipherText())) {
                throw new IllegalArgumentException("Missing value for required field `cipherText`");
            }
            return new RSAEncryptOutput(this);
        }
    }

    public static interface Builder {
        public Builder cipherText(ByteBuffer var1);

        public ByteBuffer cipherText();

        public RSAEncryptOutput build();
    }
}

